# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanLaunchSpecArgs', 'OceanLaunchSpec']

@pulumi.input_type
class OceanLaunchSpecArgs:
    def __init__(__self__, *,
                 ocean_id: pulumi.Input[builtins.str],
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 autoscale_downs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]] = None,
                 create_options: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']] = None,
                 delete_options: Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']] = None,
                 elastic_ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]] = None,
                 ephemeral_storages: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']] = None,
                 instance_store_policy: Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_types_filters: Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_od_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_spot_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]] = None,
                 restrict_scale_down: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduling_shutdown_hours: Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OceanLaunchSpec resource.
        :param pulumi.Input[builtins.str] ocean_id: The ID of the Ocean cluster.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]] autoscale_downs: Auto Scaling scale down operations.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]] autoscale_headrooms: Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]] elastic_ip_pools: Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        :param pulumi.Input[builtins.str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]] images: Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
               For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        :param pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs'] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        :param pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs'] instance_types_filters: The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
               The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]] labels: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Node Group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_od_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_spot_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[builtins.bool] restrict_scale_down: Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[builtins.int] root_volume_size: Set root volume size (in GB).
        :param pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs'] scheduling_shutdown_hours: Used to specify times that the nodes in the virtual node group will be taken down.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: Optionally adds security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]] taints: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        """
        pulumi.set(__self__, "ocean_id", ocean_id)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if autoscale_downs is not None:
            pulumi.set(__self__, "autoscale_downs", autoscale_downs)
        if autoscale_headrooms is not None:
            pulumi.set(__self__, "autoscale_headrooms", autoscale_headrooms)
        if autoscale_headrooms_automatics is not None:
            pulumi.set(__self__, "autoscale_headrooms_automatics", autoscale_headrooms_automatics)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if create_options is not None:
            pulumi.set(__self__, "create_options", create_options)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if elastic_ip_pools is not None:
            pulumi.set(__self__, "elastic_ip_pools", elastic_ip_pools)
        if ephemeral_storages is not None:
            pulumi.set(__self__, "ephemeral_storages", ephemeral_storages)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_store_policy is not None:
            pulumi.set(__self__, "instance_store_policy", instance_store_policy)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if instance_types_filters is not None:
            pulumi.set(__self__, "instance_types_filters", instance_types_filters)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preferred_od_types is not None:
            pulumi.set(__self__, "preferred_od_types", preferred_od_types)
        if preferred_spot_types is not None:
            pulumi.set(__self__, "preferred_spot_types", preferred_spot_types)
        if reserved_enis is not None:
            pulumi.set(__self__, "reserved_enis", reserved_enis)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if restrict_scale_down is not None:
            pulumi.set(__self__, "restrict_scale_down", restrict_scale_down)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if scheduling_shutdown_hours is not None:
            pulumi.set(__self__, "scheduling_shutdown_hours", scheduling_shutdown_hours)
        if scheduling_tasks is not None:
            pulumi.set(__self__, "scheduling_tasks", scheduling_tasks)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if startup_taints is not None:
            pulumi.set(__self__, "startup_taints", startup_taints)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Ocean cluster.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ocean_id", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="autoscaleDowns")
    def autoscale_downs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]]:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "autoscale_downs")

    @autoscale_downs.setter
    def autoscale_downs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]]):
        pulumi.set(self, "autoscale_downs", value)

    @property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]:
        """
        Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @autoscale_headrooms.setter
    def autoscale_headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]):
        pulumi.set(self, "autoscale_headrooms", value)

    @property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @autoscale_headrooms_automatics.setter
    def autoscale_headrooms_automatics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]):
        pulumi.set(self, "autoscale_headrooms_automatics", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]:
        return pulumi.get(self, "create_options")

    @create_options.setter
    def create_options(self, value: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]):
        pulumi.set(self, "create_options", value)

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']]:
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']]):
        pulumi.set(self, "delete_options", value)

    @property
    @pulumi.getter(name="elasticIpPools")
    def elastic_ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]]:
        """
        Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        """
        return pulumi.get(self, "elastic_ip_pools")

    @elastic_ip_pools.setter
    def elastic_ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]]):
        pulumi.set(self, "elastic_ip_pools", value)

    @property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]]:
        return pulumi.get(self, "ephemeral_storages")

    @ephemeral_storages.setter
    def ephemeral_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]]):
        pulumi.set(self, "ephemeral_storages", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]]:
        """
        Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
        For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @instance_store_policy.setter
    def instance_store_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']]):
        pulumi.set(self, "instance_store_policy", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="instanceTypesFilters")
    def instance_types_filters(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']]:
        """
        The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
        The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        """
        return pulumi.get(self, "instance_types_filters")

    @instance_types_filters.setter
    def instance_types_filters(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']]):
        pulumi.set(self, "instance_types_filters", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Virtual Node Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="preferredOdTypes")
    def preferred_od_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_od_types")

    @preferred_od_types.setter
    def preferred_od_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preferred_od_types", value)

    @property
    @pulumi.getter(name="preferredSpotTypes")
    def preferred_spot_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_spot_types")

    @preferred_spot_types.setter
    def preferred_spot_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preferred_spot_types", value)

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @reserved_enis.setter
    def reserved_enis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_enis", value)

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]]:
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]]):
        pulumi.set(self, "resource_limits", value)

    @property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @restrict_scale_down.setter
    def restrict_scale_down(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restrict_scale_down", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="schedulingShutdownHours")
    def scheduling_shutdown_hours(self) -> Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']]:
        """
        Used to specify times that the nodes in the virtual node group will be taken down.
        """
        return pulumi.get(self, "scheduling_shutdown_hours")

    @scheduling_shutdown_hours.setter
    def scheduling_shutdown_hours(self, value: Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']]):
        pulumi.set(self, "scheduling_shutdown_hours", value)

    @property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @scheduling_tasks.setter
    def scheduling_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]):
        pulumi.set(self, "scheduling_tasks", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optionally adds security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @startup_taints.setter
    def startup_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]]):
        pulumi.set(self, "startup_taints", value)

    @property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]:
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of subnet IDs.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _OceanLaunchSpecState:
    def __init__(__self__, *,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 autoscale_downs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]] = None,
                 create_options: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']] = None,
                 delete_options: Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']] = None,
                 elastic_ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]] = None,
                 ephemeral_storages: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']] = None,
                 instance_store_policy: Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_types_filters: Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_od_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_spot_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]] = None,
                 restrict_scale_down: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduling_shutdown_hours: Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OceanLaunchSpec resources.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]] autoscale_downs: Auto Scaling scale down operations.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]] autoscale_headrooms: Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]] elastic_ip_pools: Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        :param pulumi.Input[builtins.str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]] images: Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
               For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        :param pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs'] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        :param pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs'] instance_types_filters: The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
               The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]] labels: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Node Group.
        :param pulumi.Input[builtins.str] ocean_id: The ID of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_od_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_spot_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[builtins.bool] restrict_scale_down: Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[builtins.int] root_volume_size: Set root volume size (in GB).
        :param pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs'] scheduling_shutdown_hours: Used to specify times that the nodes in the virtual node group will be taken down.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: Optionally adds security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]] taints: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        """
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if autoscale_downs is not None:
            pulumi.set(__self__, "autoscale_downs", autoscale_downs)
        if autoscale_headrooms is not None:
            pulumi.set(__self__, "autoscale_headrooms", autoscale_headrooms)
        if autoscale_headrooms_automatics is not None:
            pulumi.set(__self__, "autoscale_headrooms_automatics", autoscale_headrooms_automatics)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if create_options is not None:
            pulumi.set(__self__, "create_options", create_options)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if elastic_ip_pools is not None:
            pulumi.set(__self__, "elastic_ip_pools", elastic_ip_pools)
        if ephemeral_storages is not None:
            pulumi.set(__self__, "ephemeral_storages", ephemeral_storages)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if instance_store_policy is not None:
            pulumi.set(__self__, "instance_store_policy", instance_store_policy)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if instance_types_filters is not None:
            pulumi.set(__self__, "instance_types_filters", instance_types_filters)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocean_id is not None:
            pulumi.set(__self__, "ocean_id", ocean_id)
        if preferred_od_types is not None:
            pulumi.set(__self__, "preferred_od_types", preferred_od_types)
        if preferred_spot_types is not None:
            pulumi.set(__self__, "preferred_spot_types", preferred_spot_types)
        if reserved_enis is not None:
            pulumi.set(__self__, "reserved_enis", reserved_enis)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if restrict_scale_down is not None:
            pulumi.set(__self__, "restrict_scale_down", restrict_scale_down)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if scheduling_shutdown_hours is not None:
            pulumi.set(__self__, "scheduling_shutdown_hours", scheduling_shutdown_hours)
        if scheduling_tasks is not None:
            pulumi.set(__self__, "scheduling_tasks", scheduling_tasks)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if startup_taints is not None:
            pulumi.set(__self__, "startup_taints", startup_taints)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="autoscaleDowns")
    def autoscale_downs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]]:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "autoscale_downs")

    @autoscale_downs.setter
    def autoscale_downs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleDownArgs']]]]):
        pulumi.set(self, "autoscale_downs", value)

    @property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]:
        """
        Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @autoscale_headrooms.setter
    def autoscale_headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]):
        pulumi.set(self, "autoscale_headrooms", value)

    @property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @autoscale_headrooms_automatics.setter
    def autoscale_headrooms_automatics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]):
        pulumi.set(self, "autoscale_headrooms_automatics", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]:
        return pulumi.get(self, "create_options")

    @create_options.setter
    def create_options(self, value: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]):
        pulumi.set(self, "create_options", value)

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']]:
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input['OceanLaunchSpecDeleteOptionsArgs']]):
        pulumi.set(self, "delete_options", value)

    @property
    @pulumi.getter(name="elasticIpPools")
    def elastic_ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]]:
        """
        Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        """
        return pulumi.get(self, "elastic_ip_pools")

    @elastic_ip_pools.setter
    def elastic_ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecElasticIpPoolArgs']]]]):
        pulumi.set(self, "elastic_ip_pools", value)

    @property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]]:
        return pulumi.get(self, "ephemeral_storages")

    @ephemeral_storages.setter
    def ephemeral_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecEphemeralStorageArgs']]]]):
        pulumi.set(self, "ephemeral_storages", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]]:
        """
        Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
        For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @instance_store_policy.setter
    def instance_store_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceStorePolicyArgs']]):
        pulumi.set(self, "instance_store_policy", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="instanceTypesFilters")
    def instance_types_filters(self) -> Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']]:
        """
        The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
        The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        """
        return pulumi.get(self, "instance_types_filters")

    @instance_types_filters.setter
    def instance_types_filters(self, value: Optional[pulumi.Input['OceanLaunchSpecInstanceTypesFiltersArgs']]):
        pulumi.set(self, "instance_types_filters", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Virtual Node Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Ocean cluster.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocean_id", value)

    @property
    @pulumi.getter(name="preferredOdTypes")
    def preferred_od_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_od_types")

    @preferred_od_types.setter
    def preferred_od_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preferred_od_types", value)

    @property
    @pulumi.getter(name="preferredSpotTypes")
    def preferred_spot_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_spot_types")

    @preferred_spot_types.setter
    def preferred_spot_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preferred_spot_types", value)

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @reserved_enis.setter
    def reserved_enis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_enis", value)

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]]:
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecResourceLimitArgs']]]]):
        pulumi.set(self, "resource_limits", value)

    @property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @restrict_scale_down.setter
    def restrict_scale_down(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restrict_scale_down", value)

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @property
    @pulumi.getter(name="schedulingShutdownHours")
    def scheduling_shutdown_hours(self) -> Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']]:
        """
        Used to specify times that the nodes in the virtual node group will be taken down.
        """
        return pulumi.get(self, "scheduling_shutdown_hours")

    @scheduling_shutdown_hours.setter
    def scheduling_shutdown_hours(self, value: Optional[pulumi.Input['OceanLaunchSpecSchedulingShutdownHoursArgs']]):
        pulumi.set(self, "scheduling_shutdown_hours", value)

    @property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @scheduling_tasks.setter
    def scheduling_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]):
        pulumi.set(self, "scheduling_tasks", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optionally adds security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @startup_taints.setter
    def startup_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStartupTaintArgs']]]]):
        pulumi.set(self, "startup_taints", value)

    @property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]:
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of subnet IDs.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("spotinst:aws/oceanLaunchSpec:OceanLaunchSpec")
class OceanLaunchSpec(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 autoscale_downs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleDownArgs', 'OceanLaunchSpecAutoscaleDownArgsDict']]]]] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecBlockDeviceMappingArgs', 'OceanLaunchSpecBlockDeviceMappingArgsDict']]]]] = None,
                 create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
                 delete_options: Optional[pulumi.Input[Union['OceanLaunchSpecDeleteOptionsArgs', 'OceanLaunchSpecDeleteOptionsArgsDict']]] = None,
                 elastic_ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecElasticIpPoolArgs', 'OceanLaunchSpecElasticIpPoolArgsDict']]]]] = None,
                 ephemeral_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecEphemeralStorageArgs', 'OceanLaunchSpecEphemeralStorageArgsDict']]]]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecImageArgs', 'OceanLaunchSpecImageArgsDict']]]]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceMetadataOptionsArgs', 'OceanLaunchSpecInstanceMetadataOptionsArgsDict']]] = None,
                 instance_store_policy: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceStorePolicyArgs', 'OceanLaunchSpecInstanceStorePolicyArgsDict']]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_types_filters: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceTypesFiltersArgs', 'OceanLaunchSpecInstanceTypesFiltersArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_od_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_spot_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecResourceLimitArgs', 'OceanLaunchSpecResourceLimitArgsDict']]]]] = None,
                 restrict_scale_down: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduling_shutdown_hours: Optional[pulumi.Input[Union['OceanLaunchSpecSchedulingShutdownHoursArgs', 'OceanLaunchSpecSchedulingShutdownHoursArgsDict']]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStartupTaintArgs', 'OceanLaunchSpecStartupTaintArgsDict']]]]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTagArgs', 'OceanLaunchSpecTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spotinst Ocean AWS [Virtual Node Group](https://docs.spot.io/ocean/features/launch-specifications) resource.

        ## Import

        Launch_Specs can be imported using the Launch_Spec `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:aws/oceanLaunchSpec:OceanLaunchSpec nameOfTheResource ols-1a2b576
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleDownArgs', 'OceanLaunchSpecAutoscaleDownArgsDict']]]] autoscale_downs: Auto Scaling scale down operations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]] autoscale_headrooms: Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecBlockDeviceMappingArgs', 'OceanLaunchSpecBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecElasticIpPoolArgs', 'OceanLaunchSpecElasticIpPoolArgsDict']]]] elastic_ip_pools: Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        :param pulumi.Input[builtins.str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecImageArgs', 'OceanLaunchSpecImageArgsDict']]]] images: Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
               For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceMetadataOptionsArgs', 'OceanLaunchSpecInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceStorePolicyArgs', 'OceanLaunchSpecInstanceStorePolicyArgsDict']] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceTypesFiltersArgs', 'OceanLaunchSpecInstanceTypesFiltersArgsDict']] instance_types_filters: The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
               The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]] labels: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Node Group.
        :param pulumi.Input[builtins.str] ocean_id: The ID of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_od_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_spot_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[builtins.bool] restrict_scale_down: Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[builtins.int] root_volume_size: Set root volume size (in GB).
        :param pulumi.Input[Union['OceanLaunchSpecSchedulingShutdownHoursArgs', 'OceanLaunchSpecSchedulingShutdownHoursArgsDict']] scheduling_shutdown_hours: Used to specify times that the nodes in the virtual node group will be taken down.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: Optionally adds security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStartupTaintArgs', 'OceanLaunchSpecStartupTaintArgsDict']]]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTagArgs', 'OceanLaunchSpecTagArgsDict']]]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]] taints: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanLaunchSpecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spotinst Ocean AWS [Virtual Node Group](https://docs.spot.io/ocean/features/launch-specifications) resource.

        ## Import

        Launch_Specs can be imported using the Launch_Spec `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:aws/oceanLaunchSpec:OceanLaunchSpec nameOfTheResource ols-1a2b576
        ```

        :param str resource_name: The name of the resource.
        :param OceanLaunchSpecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanLaunchSpecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 autoscale_downs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleDownArgs', 'OceanLaunchSpecAutoscaleDownArgsDict']]]]] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecBlockDeviceMappingArgs', 'OceanLaunchSpecBlockDeviceMappingArgsDict']]]]] = None,
                 create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
                 delete_options: Optional[pulumi.Input[Union['OceanLaunchSpecDeleteOptionsArgs', 'OceanLaunchSpecDeleteOptionsArgsDict']]] = None,
                 elastic_ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecElasticIpPoolArgs', 'OceanLaunchSpecElasticIpPoolArgsDict']]]]] = None,
                 ephemeral_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecEphemeralStorageArgs', 'OceanLaunchSpecEphemeralStorageArgsDict']]]]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecImageArgs', 'OceanLaunchSpecImageArgsDict']]]]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceMetadataOptionsArgs', 'OceanLaunchSpecInstanceMetadataOptionsArgsDict']]] = None,
                 instance_store_policy: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceStorePolicyArgs', 'OceanLaunchSpecInstanceStorePolicyArgsDict']]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_types_filters: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceTypesFiltersArgs', 'OceanLaunchSpecInstanceTypesFiltersArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_od_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preferred_spot_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
                 resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecResourceLimitArgs', 'OceanLaunchSpecResourceLimitArgsDict']]]]] = None,
                 restrict_scale_down: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 scheduling_shutdown_hours: Optional[pulumi.Input[Union['OceanLaunchSpecSchedulingShutdownHoursArgs', 'OceanLaunchSpecSchedulingShutdownHoursArgsDict']]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStartupTaintArgs', 'OceanLaunchSpecStartupTaintArgsDict']]]]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTagArgs', 'OceanLaunchSpecTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanLaunchSpecArgs.__new__(OceanLaunchSpecArgs)

            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["autoscale_downs"] = autoscale_downs
            __props__.__dict__["autoscale_headrooms"] = autoscale_headrooms
            __props__.__dict__["autoscale_headrooms_automatics"] = autoscale_headrooms_automatics
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            __props__.__dict__["create_options"] = create_options
            __props__.__dict__["delete_options"] = delete_options
            __props__.__dict__["elastic_ip_pools"] = elastic_ip_pools
            __props__.__dict__["ephemeral_storages"] = ephemeral_storages
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["images"] = images
            __props__.__dict__["instance_metadata_options"] = instance_metadata_options
            __props__.__dict__["instance_store_policy"] = instance_store_policy
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["instance_types_filters"] = instance_types_filters
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if ocean_id is None and not opts.urn:
                raise TypeError("Missing required property 'ocean_id'")
            __props__.__dict__["ocean_id"] = ocean_id
            __props__.__dict__["preferred_od_types"] = preferred_od_types
            __props__.__dict__["preferred_spot_types"] = preferred_spot_types
            __props__.__dict__["reserved_enis"] = reserved_enis
            __props__.__dict__["resource_limits"] = resource_limits
            __props__.__dict__["restrict_scale_down"] = restrict_scale_down
            __props__.__dict__["root_volume_size"] = root_volume_size
            __props__.__dict__["scheduling_shutdown_hours"] = scheduling_shutdown_hours
            __props__.__dict__["scheduling_tasks"] = scheduling_tasks
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["startup_taints"] = startup_taints
            __props__.__dict__["strategies"] = strategies
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["user_data"] = user_data
        super(OceanLaunchSpec, __self__).__init__(
            'spotinst:aws/oceanLaunchSpec:OceanLaunchSpec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
            autoscale_downs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleDownArgs', 'OceanLaunchSpecAutoscaleDownArgsDict']]]]] = None,
            autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
            autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
            block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecBlockDeviceMappingArgs', 'OceanLaunchSpecBlockDeviceMappingArgsDict']]]]] = None,
            create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
            delete_options: Optional[pulumi.Input[Union['OceanLaunchSpecDeleteOptionsArgs', 'OceanLaunchSpecDeleteOptionsArgsDict']]] = None,
            elastic_ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecElasticIpPoolArgs', 'OceanLaunchSpecElasticIpPoolArgsDict']]]]] = None,
            ephemeral_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecEphemeralStorageArgs', 'OceanLaunchSpecEphemeralStorageArgsDict']]]]] = None,
            iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
            image_id: Optional[pulumi.Input[builtins.str]] = None,
            images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecImageArgs', 'OceanLaunchSpecImageArgsDict']]]]] = None,
            instance_metadata_options: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceMetadataOptionsArgs', 'OceanLaunchSpecInstanceMetadataOptionsArgsDict']]] = None,
            instance_store_policy: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceStorePolicyArgs', 'OceanLaunchSpecInstanceStorePolicyArgsDict']]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            instance_types_filters: Optional[pulumi.Input[Union['OceanLaunchSpecInstanceTypesFiltersArgs', 'OceanLaunchSpecInstanceTypesFiltersArgsDict']]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocean_id: Optional[pulumi.Input[builtins.str]] = None,
            preferred_od_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            preferred_spot_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            reserved_enis: Optional[pulumi.Input[builtins.int]] = None,
            resource_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecResourceLimitArgs', 'OceanLaunchSpecResourceLimitArgsDict']]]]] = None,
            restrict_scale_down: Optional[pulumi.Input[builtins.bool]] = None,
            root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
            scheduling_shutdown_hours: Optional[pulumi.Input[Union['OceanLaunchSpecSchedulingShutdownHoursArgs', 'OceanLaunchSpecSchedulingShutdownHoursArgsDict']]] = None,
            scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            startup_taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStartupTaintArgs', 'OceanLaunchSpecStartupTaintArgsDict']]]]] = None,
            strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTagArgs', 'OceanLaunchSpecTagArgsDict']]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None,
            user_data: Optional[pulumi.Input[builtins.str]] = None) -> 'OceanLaunchSpec':
        """
        Get an existing OceanLaunchSpec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleDownArgs', 'OceanLaunchSpecAutoscaleDownArgsDict']]]] autoscale_downs: Auto Scaling scale down operations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]] autoscale_headrooms: Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecBlockDeviceMappingArgs', 'OceanLaunchSpecBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecElasticIpPoolArgs', 'OceanLaunchSpecElasticIpPoolArgsDict']]]] elastic_ip_pools: Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        :param pulumi.Input[builtins.str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecImageArgs', 'OceanLaunchSpecImageArgsDict']]]] images: Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
               For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceMetadataOptionsArgs', 'OceanLaunchSpecInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceStorePolicyArgs', 'OceanLaunchSpecInstanceStorePolicyArgsDict']] instance_store_policy: Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        :param pulumi.Input[Union['OceanLaunchSpecInstanceTypesFiltersArgs', 'OceanLaunchSpecInstanceTypesFiltersArgsDict']] instance_types_filters: The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
               The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]] labels: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] name: The name of the Virtual Node Group.
        :param pulumi.Input[builtins.str] ocean_id: The ID of the Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_od_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preferred_spot_types: A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        :param pulumi.Input[builtins.int] reserved_enis: Specifies the count of ENIs to reserve per instance type for scaling purposes.
        :param pulumi.Input[builtins.bool] restrict_scale_down: Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[builtins.int] root_volume_size: Set root volume size (in GB).
        :param pulumi.Input[Union['OceanLaunchSpecSchedulingShutdownHoursArgs', 'OceanLaunchSpecSchedulingShutdownHoursArgsDict']] scheduling_shutdown_hours: Used to specify times that the nodes in the virtual node group will be taken down.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: Optionally adds security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStartupTaintArgs', 'OceanLaunchSpecStartupTaintArgsDict']]]] startup_taints: Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTagArgs', 'OceanLaunchSpecTagArgsDict']]]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]] taints: Optionally adds labels to instances launched in the cluster.
        :param pulumi.Input[builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanLaunchSpecState.__new__(_OceanLaunchSpecState)

        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["autoscale_downs"] = autoscale_downs
        __props__.__dict__["autoscale_headrooms"] = autoscale_headrooms
        __props__.__dict__["autoscale_headrooms_automatics"] = autoscale_headrooms_automatics
        __props__.__dict__["block_device_mappings"] = block_device_mappings
        __props__.__dict__["create_options"] = create_options
        __props__.__dict__["delete_options"] = delete_options
        __props__.__dict__["elastic_ip_pools"] = elastic_ip_pools
        __props__.__dict__["ephemeral_storages"] = ephemeral_storages
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["images"] = images
        __props__.__dict__["instance_metadata_options"] = instance_metadata_options
        __props__.__dict__["instance_store_policy"] = instance_store_policy
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["instance_types_filters"] = instance_types_filters
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["ocean_id"] = ocean_id
        __props__.__dict__["preferred_od_types"] = preferred_od_types
        __props__.__dict__["preferred_spot_types"] = preferred_spot_types
        __props__.__dict__["reserved_enis"] = reserved_enis
        __props__.__dict__["resource_limits"] = resource_limits
        __props__.__dict__["restrict_scale_down"] = restrict_scale_down
        __props__.__dict__["root_volume_size"] = root_volume_size
        __props__.__dict__["scheduling_shutdown_hours"] = scheduling_shutdown_hours
        __props__.__dict__["scheduling_tasks"] = scheduling_tasks
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["startup_taints"] = startup_taints
        __props__.__dict__["strategies"] = strategies
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["user_data"] = user_data
        return OceanLaunchSpec(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="autoscaleDowns")
    def autoscale_downs(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecAutoscaleDown']]]:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "autoscale_downs")

    @property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecAutoscaleHeadroom']]]:
        """
        Set custom headroom per Virtual Node Group. Provide a list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecAutoscaleHeadroomsAutomatic']]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecBlockDeviceMapping']]]:
        """
        Object. Array list of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecCreateOptions']]:
        return pulumi.get(self, "create_options")

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecDeleteOptions']]:
        return pulumi.get(self, "delete_options")

    @property
    @pulumi.getter(name="elasticIpPools")
    def elastic_ip_pools(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecElasticIpPool']]]:
        """
        Assign an Elastic IP to the instances spun by the Virtual Node Group. Can be null.
        """
        return pulumi.get(self, "elastic_ip_pools")

    @property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecEphemeralStorage']]]:
        return pulumi.get(self, "ephemeral_storages")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def images(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecImage']]]:
        """
        Array of objects (Image object, containing the id of the image used to launch instances.) You can configure VNG with either the imageId or images objects, but not both simultaneously.
        For each architecture type (amd64, arm64) only one AMI is allowed. Valid values: null, or an array with at least one element.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecInstanceMetadataOptions']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @property
    @pulumi.getter(name="instanceStorePolicy")
    def instance_store_policy(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecInstanceStorePolicy']]:
        """
        Determines the utilization of instance store volumes. If not defined, instance store volumes will not be used.
        """
        return pulumi.get(self, "instance_store_policy")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of instance types allowed to be provisioned for pods pending under the specified launch specification. The list overrides the list defined for the cluster.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="instanceTypesFilters")
    def instance_types_filters(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecInstanceTypesFilters']]:
        """
        The instance types that match with all filters compose the Virtual Node Group's instanceTypes parameter.
        The architectures that come from the Virtual Node Group's images will be taken into account when using this parameter. Cannot be configured together with Virtual Node Group's instanceTypes and with the Cluster's whitelist/blacklist/filters.
        """
        return pulumi.get(self, "instance_types_filters")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecLabel']]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Virtual Node Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Ocean cluster.
        """
        return pulumi.get(self, "ocean_id")

    @property
    @pulumi.getter(name="preferredOdTypes")
    def preferred_od_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_od_types")

    @property
    @pulumi.getter(name="preferredSpotTypes")
    def preferred_spot_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of instance types. Takes the preferred types into consideration while maintaining a variety of machine types running for optimized distribution.
        """
        return pulumi.get(self, "preferred_spot_types")

    @property
    @pulumi.getter(name="reservedEnis")
    def reserved_enis(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the count of ENIs to reserve per instance type for scaling purposes.
        """
        return pulumi.get(self, "reserved_enis")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecResourceLimit']]]:
        return pulumi.get(self, "resource_limits")

    @property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean. When set to `true`, nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @property
    @pulumi.getter(name="schedulingShutdownHours")
    def scheduling_shutdown_hours(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecSchedulingShutdownHours']]:
        """
        Used to specify times that the nodes in the virtual node group will be taken down.
        """
        return pulumi.get(self, "scheduling_shutdown_hours")

    @property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecSchedulingTask']]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Optionally adds security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="startupTaints")
    def startup_taints(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecStartupTaint']]]:
        """
        Temporary taints applied to a node during its initialization phase. For a startup taint to work, it must also be set as a regular taint in the userData for the cluster.
        """
        return pulumi.get(self, "startup_taints")

    @property
    @pulumi.getter
    def strategies(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecStrategy']]]:
        return pulumi.get(self, "strategies")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of subnet IDs.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecTag']]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecTaint']]]:
        """
        Optionally adds labels to instances launched in the cluster.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

