# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OceanAutoscaler',
    'OceanAutoscalerDown',
    'OceanAutoscalerHeadroom',
    'OceanAutoscalerResourceLimits',
    'OceanBlockDeviceMapping',
    'OceanBlockDeviceMappingEbs',
    'OceanBlockDeviceMappingEbsDynamicVolumeSize',
    'OceanClusterOrientation',
    'OceanFilters',
    'OceanInstanceMetadataOptions',
    'OceanLaunchSpecAttribute',
    'OceanLaunchSpecAutoscaleHeadroom',
    'OceanLaunchSpecBlockDeviceMapping',
    'OceanLaunchSpecBlockDeviceMappingEbs',
    'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize',
    'OceanLaunchSpecImage',
    'OceanLaunchSpecInstanceMetadataOptions',
    'OceanLaunchSpecSchedulingTask',
    'OceanLaunchSpecSchedulingTaskTaskHeadroom',
    'OceanLaunchSpecStrategy',
    'OceanLaunchSpecTag',
    'OceanLogging',
    'OceanLoggingExport',
    'OceanLoggingExportS3',
    'OceanOptimizeImages',
    'OceanScheduledTask',
    'OceanScheduledTaskShutdownHours',
    'OceanScheduledTaskTask',
    'OceanTag',
    'OceanUpdatePolicy',
    'OceanUpdatePolicyRollConfig',
]

@pulumi.output_type
class OceanAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoHeadroomPercentage":
            suggest = "auto_headroom_percentage"
        elif key == "enableAutomaticAndManualHeadroom":
            suggest = "enable_automatic_and_manual_headroom"
        elif key == "isAutoConfig":
            suggest = "is_auto_config"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resourceLimits":
            suggest = "resource_limits"
        elif key == "shouldScaleDownNonServiceTasks":
            suggest = "should_scale_down_non_service_tasks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_headroom_percentage: Optional[builtins.int] = None,
                 cooldown: Optional[builtins.int] = None,
                 down: Optional['outputs.OceanAutoscalerDown'] = None,
                 enable_automatic_and_manual_headroom: Optional[builtins.bool] = None,
                 headroom: Optional['outputs.OceanAutoscalerHeadroom'] = None,
                 is_auto_config: Optional[builtins.bool] = None,
                 is_enabled: Optional[builtins.bool] = None,
                 resource_limits: Optional['outputs.OceanAutoscalerResourceLimits'] = None,
                 should_scale_down_non_service_tasks: Optional[builtins.bool] = None):
        """
        :param builtins.int auto_headroom_percentage: The auto-headroom percentage. Set a number between 0-200 to control the headroom % of the cluster. Relevant when `isAutoConfig`= true.
        :param builtins.int cooldown: Cooldown period between scaling actions.
        :param 'OceanAutoscalerDownArgs' down: Auto Scaling scale down operations.
        :param builtins.bool enable_automatic_and_manual_headroom: When set to true, both automatic and per custom launch specification manual headroom to be saved concurrently and independently in the cluster. prerequisite: isAutoConfig must be true
        :param 'OceanAutoscalerHeadroomArgs' headroom: Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        :param builtins.bool is_auto_config: Automatically configure and optimize headroom resources.
        :param builtins.bool is_enabled: Enable the Ocean ECS autoscaler.
        :param 'OceanAutoscalerResourceLimitsArgs' resource_limits: Optionally set upper and lower bounds on the resource usage of the cluster.
        :param builtins.bool should_scale_down_non_service_tasks: Option to scale down non-service tasks. If not set, Ocean does not scale down standalone tasks.
        """
        if auto_headroom_percentage is not None:
            pulumi.set(__self__, "auto_headroom_percentage", auto_headroom_percentage)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if down is not None:
            pulumi.set(__self__, "down", down)
        if enable_automatic_and_manual_headroom is not None:
            pulumi.set(__self__, "enable_automatic_and_manual_headroom", enable_automatic_and_manual_headroom)
        if headroom is not None:
            pulumi.set(__self__, "headroom", headroom)
        if is_auto_config is not None:
            pulumi.set(__self__, "is_auto_config", is_auto_config)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if should_scale_down_non_service_tasks is not None:
            pulumi.set(__self__, "should_scale_down_non_service_tasks", should_scale_down_non_service_tasks)

    @property
    @pulumi.getter(name="autoHeadroomPercentage")
    def auto_headroom_percentage(self) -> Optional[builtins.int]:
        """
        The auto-headroom percentage. Set a number between 0-200 to control the headroom % of the cluster. Relevant when `isAutoConfig`= true.
        """
        return pulumi.get(self, "auto_headroom_percentage")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[builtins.int]:
        """
        Cooldown period between scaling actions.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def down(self) -> Optional['outputs.OceanAutoscalerDown']:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "down")

    @property
    @pulumi.getter(name="enableAutomaticAndManualHeadroom")
    def enable_automatic_and_manual_headroom(self) -> Optional[builtins.bool]:
        """
        When set to true, both automatic and per custom launch specification manual headroom to be saved concurrently and independently in the cluster. prerequisite: isAutoConfig must be true
        """
        return pulumi.get(self, "enable_automatic_and_manual_headroom")

    @property
    @pulumi.getter
    def headroom(self) -> Optional['outputs.OceanAutoscalerHeadroom']:
        """
        Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        """
        return pulumi.get(self, "headroom")

    @property
    @pulumi.getter(name="isAutoConfig")
    def is_auto_config(self) -> Optional[builtins.bool]:
        """
        Automatically configure and optimize headroom resources.
        """
        return pulumi.get(self, "is_auto_config")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        Enable the Ocean ECS autoscaler.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional['outputs.OceanAutoscalerResourceLimits']:
        """
        Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        return pulumi.get(self, "resource_limits")

    @property
    @pulumi.getter(name="shouldScaleDownNonServiceTasks")
    def should_scale_down_non_service_tasks(self) -> Optional[builtins.bool]:
        """
        Option to scale down non-service tasks. If not set, Ocean does not scale down standalone tasks.
        """
        return pulumi.get(self, "should_scale_down_non_service_tasks")


@pulumi.output_type
class OceanAutoscalerDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scale_down_percentage: Optional[builtins.float] = None):
        """
        :param builtins.float max_scale_down_percentage: Would represent the maximum % to scale-down. Number between 1-100.
        """
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[builtins.float]:
        """
        Would represent the maximum % to scale-down. Number between 1-100.
        """
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class OceanAutoscalerHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[builtins.int] = None,
                 memory_per_unit: Optional[builtins.int] = None,
                 num_of_units: Optional[builtins.int] = None):
        """
        :param builtins.int cpu_per_unit: Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param builtins.int memory_per_unit: Optionally configure the amount of memory (MB) to allocate the headroom.
        :param builtins.int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the amount of memory (MB) to allocate the headroom.
        """
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[builtins.int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class OceanAutoscalerResourceLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxVcpu":
            suggest = "max_vcpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerResourceLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerResourceLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerResourceLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_memory_gib: Optional[builtins.int] = None,
                 max_vcpu: Optional[builtins.int] = None):
        """
        :param builtins.int max_memory_gib: The maximum memory in GiB units that can be allocated to the cluster.
        :param builtins.int max_vcpu: The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[builtins.int]:
        """
        The maximum memory in GiB units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[builtins.int]:
        """
        The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_vcpu")


@pulumi.output_type
class OceanBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: builtins.str,
                 ebs: Optional['outputs.OceanBlockDeviceMappingEbs'] = None,
                 no_device: Optional[builtins.str] = None,
                 virtual_name: Optional[builtins.str] = None):
        """
        :param builtins.str device_name: String. Set device name. Example: `/dev/xvda1`.
        :param 'OceanBlockDeviceMappingEbsArgs' ebs: Object. Set Elastic Block Store properties.
        :param builtins.str no_device: String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> builtins.str:
        """
        String. Set device name. Example: `/dev/xvda1`.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.OceanBlockDeviceMappingEbs']:
        """
        Object. Set Elastic Block Store properties.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[builtins.str]:
        """
        String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class OceanBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "dynamicVolumeSize":
            suggest = "dynamic_volume_size"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[builtins.bool] = None,
                 dynamic_volume_size: Optional['outputs.OceanBlockDeviceMappingEbsDynamicVolumeSize'] = None,
                 encrypted: Optional[builtins.bool] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.bool delete_on_termination: Boolean. Toggles EBS deletion upon instance termination.
        :param 'OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs' dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param builtins.bool encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param builtins.int iops: Int. The number of I/O operations per second (IOPS) that the volume supports.
        :param builtins.str kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param builtins.str snapshot_id: (Optional) String. The snapshot ID to mount by.
        :param builtins.int throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        :param builtins.int volume_size: Int. The size (in GB) of the volume.
        :param builtins.str volume_type: String. The type of the volume. Example: `gp2`.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Boolean. Toggles EBS deletion upon instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional['outputs.OceanBlockDeviceMappingEbsDynamicVolumeSize']:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        (Optional) String. The snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        Int. The size (in GB) of the volume.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        String. The type of the volume. Example: `gp2`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class OceanBlockDeviceMappingEbsDynamicVolumeSize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMappingEbsDynamicVolumeSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: builtins.int,
                 resource: builtins.str,
                 size_per_resource_unit: builtins.int):
        """
        :param builtins.int base_size: Int. Initial size for volume. Example: `50`.
        :param builtins.str resource: String. Resource type to increase volume size dynamically by. Valid values: `CPU`.
        :param builtins.int size_per_resource_unit: Int. Additional size (in GB) per resource unit. Example: When the `baseSize=50`, `sizePerResourceUnit=20`, and instance with two CPUs is launched, its total disk size will be: 90GB.
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> builtins.int:
        """
        Int. Initial size for volume. Example: `50`.
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        String. Resource type to increase volume size dynamically by. Valid values: `CPU`.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> builtins.int:
        """
        Int. Additional size (in GB) per resource unit. Example: When the `baseSize=50`, `sizePerResourceUnit=20`, and instance with two CPUs is launched, its total disk size will be: 90GB.
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class OceanClusterOrientation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityVsCost":
            suggest = "availability_vs_cost"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanClusterOrientation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanClusterOrientation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanClusterOrientation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_vs_cost: Optional[builtins.str] = None):
        """
        :param builtins.str availability_vs_cost: You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        if availability_vs_cost is not None:
            pulumi.set(__self__, "availability_vs_cost", availability_vs_cost)

    @property
    @pulumi.getter(name="availabilityVsCost")
    def availability_vs_cost(self) -> Optional[builtins.str]:
        """
        You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        return pulumi.get(self, "availability_vs_cost")


@pulumi.output_type
class OceanFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskTypes":
            suggest = "disk_types"
        elif key == "excludeFamilies":
            suggest = "exclude_families"
        elif key == "excludeMetal":
            suggest = "exclude_metal"
        elif key == "includeFamilies":
            suggest = "include_families"
        elif key == "isEnaSupported":
            suggest = "is_ena_supported"
        elif key == "maxGpu":
            suggest = "max_gpu"
        elif key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxNetworkPerformance":
            suggest = "max_network_performance"
        elif key == "maxVcpu":
            suggest = "max_vcpu"
        elif key == "minEnis":
            suggest = "min_enis"
        elif key == "minGpu":
            suggest = "min_gpu"
        elif key == "minMemoryGib":
            suggest = "min_memory_gib"
        elif key == "minNetworkPerformance":
            suggest = "min_network_performance"
        elif key == "minVcpu":
            suggest = "min_vcpu"
        elif key == "rootDeviceTypes":
            suggest = "root_device_types"
        elif key == "virtualizationTypes":
            suggest = "virtualization_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architectures: Optional[Sequence[builtins.str]] = None,
                 categories: Optional[Sequence[builtins.str]] = None,
                 disk_types: Optional[Sequence[builtins.str]] = None,
                 exclude_families: Optional[Sequence[builtins.str]] = None,
                 exclude_metal: Optional[builtins.bool] = None,
                 hypervisors: Optional[Sequence[builtins.str]] = None,
                 include_families: Optional[Sequence[builtins.str]] = None,
                 is_ena_supported: Optional[builtins.str] = None,
                 max_gpu: Optional[builtins.int] = None,
                 max_memory_gib: Optional[builtins.float] = None,
                 max_network_performance: Optional[builtins.int] = None,
                 max_vcpu: Optional[builtins.int] = None,
                 min_enis: Optional[builtins.int] = None,
                 min_gpu: Optional[builtins.int] = None,
                 min_memory_gib: Optional[builtins.float] = None,
                 min_network_performance: Optional[builtins.int] = None,
                 min_vcpu: Optional[builtins.int] = None,
                 root_device_types: Optional[Sequence[builtins.str]] = None,
                 virtualization_types: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] architectures: The filtered instance types will support at least one of the architectures from this list.
        :param Sequence[builtins.str] categories: The filtered instance types will belong to one of the categories types from this list.
        :param Sequence[builtins.str] disk_types: The filtered instance types will have one of the disk type from this list.
        :param Sequence[builtins.str] exclude_families: Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        :param builtins.bool exclude_metal: In case excludeMetal is set to true, metal types will not be available for scaling.
        :param Sequence[builtins.str] hypervisors: The filtered instance types will have a hypervisor type from this list.
        :param Sequence[builtins.str] include_families: Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        :param builtins.str is_ena_supported: Ena is supported or not.
        :param builtins.int max_gpu: Maximum total number of GPUs.
        :param builtins.int max_network_performance: Maximum Bandwidth in Gib/s of network performance.
        :param builtins.int min_enis: Minimum number of network interfaces (ENIs).
        :param builtins.int min_gpu: Minimum total number of GPUs.
        :param builtins.float min_memory_gib: Minimum amount of Memory (GiB).
        :param builtins.int min_network_performance: Minimum Bandwidth in Gib/s of network performance.
        :param builtins.int min_vcpu: Minimum number of vcpus available.
        :param Sequence[builtins.str] root_device_types: The filtered instance types will have a root device types from this list.
        :param Sequence[builtins.str] virtualization_types: The filtered instance types will support at least one of the virtualization types from this list.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)
        if exclude_families is not None:
            pulumi.set(__self__, "exclude_families", exclude_families)
        if exclude_metal is not None:
            pulumi.set(__self__, "exclude_metal", exclude_metal)
        if hypervisors is not None:
            pulumi.set(__self__, "hypervisors", hypervisors)
        if include_families is not None:
            pulumi.set(__self__, "include_families", include_families)
        if is_ena_supported is not None:
            pulumi.set(__self__, "is_ena_supported", is_ena_supported)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_network_performance is not None:
            pulumi.set(__self__, "max_network_performance", max_network_performance)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_enis is not None:
            pulumi.set(__self__, "min_enis", min_enis)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_network_performance is not None:
            pulumi.set(__self__, "min_network_performance", min_network_performance)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if root_device_types is not None:
            pulumi.set(__self__, "root_device_types", root_device_types)
        if virtualization_types is not None:
            pulumi.set(__self__, "virtualization_types", virtualization_types)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will support at least one of the architectures from this list.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will belong to one of the categories types from this list.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will have one of the disk type from this list.
        """
        return pulumi.get(self, "disk_types")

    @property
    @pulumi.getter(name="excludeFamilies")
    def exclude_families(self) -> Optional[Sequence[builtins.str]]:
        """
        Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "exclude_families")

    @property
    @pulumi.getter(name="excludeMetal")
    def exclude_metal(self) -> Optional[builtins.bool]:
        """
        In case excludeMetal is set to true, metal types will not be available for scaling.
        """
        return pulumi.get(self, "exclude_metal")

    @property
    @pulumi.getter
    def hypervisors(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will have a hypervisor type from this list.
        """
        return pulumi.get(self, "hypervisors")

    @property
    @pulumi.getter(name="includeFamilies")
    def include_families(self) -> Optional[Sequence[builtins.str]]:
        """
        Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "include_families")

    @property
    @pulumi.getter(name="isEnaSupported")
    def is_ena_supported(self) -> Optional[builtins.str]:
        """
        Ena is supported or not.
        """
        return pulumi.get(self, "is_ena_supported")

    @property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[builtins.int]:
        """
        Maximum total number of GPUs.
        """
        return pulumi.get(self, "max_gpu")

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[builtins.float]:
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxNetworkPerformance")
    def max_network_performance(self) -> Optional[builtins.int]:
        """
        Maximum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "max_network_performance")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_vcpu")

    @property
    @pulumi.getter(name="minEnis")
    def min_enis(self) -> Optional[builtins.int]:
        """
        Minimum number of network interfaces (ENIs).
        """
        return pulumi.get(self, "min_enis")

    @property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[builtins.int]:
        """
        Minimum total number of GPUs.
        """
        return pulumi.get(self, "min_gpu")

    @property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[builtins.float]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @property
    @pulumi.getter(name="minNetworkPerformance")
    def min_network_performance(self) -> Optional[builtins.int]:
        """
        Minimum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "min_network_performance")

    @property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[builtins.int]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @property
    @pulumi.getter(name="rootDeviceTypes")
    def root_device_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will have a root device types from this list.
        """
        return pulumi.get(self, "root_device_types")

    @property
    @pulumi.getter(name="virtualizationTypes")
    def virtualization_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The filtered instance types will support at least one of the virtualization types from this list.
        """
        return pulumi.get(self, "virtualization_types")


@pulumi.output_type
class OceanInstanceMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: builtins.str,
                 http_put_response_hop_limit: Optional[builtins.int] = None):
        """
        :param builtins.str http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param builtins.int http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> builtins.str:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[builtins.int]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")


@pulumi.output_type
class OceanLaunchSpecAttribute(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The label key.
        :param builtins.str value: The label value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanLaunchSpecAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numOfUnits":
            suggest = "num_of_units"
        elif key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_of_units: builtins.int,
                 cpu_per_unit: Optional[builtins.int] = None,
                 memory_per_unit: Optional[builtins.int] = None):
        """
        :param builtins.int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        :param builtins.int cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
        :param builtins.int memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> builtins.int:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: builtins.str,
                 ebs: Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbs'] = None,
                 no_device: Optional[builtins.str] = None,
                 virtual_name: Optional[builtins.str] = None):
        """
        :param builtins.str device_name: String. Set device name. (Example: "/dev/xvda1").
        :param 'OceanLaunchSpecBlockDeviceMappingEbsArgs' ebs: Object. Set Elastic Block Store properties .
        :param builtins.str no_device: String. suppresses the specified device included in the block device mapping of the AMI.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> builtins.str:
        """
        String. Set device name. (Example: "/dev/xvda1").
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbs']:
        """
        Object. Set Elastic Block Store properties .
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[builtins.str]:
        """
        String. suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "dynamicVolumeSize":
            suggest = "dynamic_volume_size"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[builtins.bool] = None,
                 dynamic_volume_size: Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize'] = None,
                 encrypted: Optional[builtins.bool] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.bool delete_on_termination: Boolean. Flag to delete the EBS on instance termination.
        :param 'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs' dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param builtins.bool encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param builtins.int iops: Int. The number of I/O operations per second (IOPS) that the volume supports.
        :param builtins.str kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param builtins.str snapshot_id: (Optional) String. The Snapshot ID to mount by.
        :param builtins.int throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        :param builtins.int volume_size: Int. The size, in GB of the volume.
        :param builtins.str volume_type: String. The type of the volume (example: "gp2").
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Boolean. Flag to delete the EBS on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize']:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        (Optional) String. The Snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        Int. The size, in GB of the volume.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        String. The type of the volume (example: "gp2").
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: builtins.int,
                 resource: builtins.str,
                 size_per_resource_unit: builtins.int):
        """
        :param builtins.int base_size: Int. Initial size for volume. (Example: 50)
        :param builtins.str resource: String. Resource type to increase volume size dynamically by. (valid values: "CPU")
        :param builtins.int size_per_resource_unit: Int. Additional size (in GB) per resource unit. (Example: baseSize= 50, sizePerResourceUnit=20, and instance with 2 CPU is launched - its total disk size will be: 90GB)
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> builtins.int:
        """
        Int. Initial size for volume. (Example: 50)
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        String. Resource type to increase volume size dynamically by. (valid values: "CPU")
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> builtins.int:
        """
        Int. Additional size (in GB) per resource unit. (Example: baseSize= 50, sizePerResourceUnit=20, and instance with 2 CPU is launched - its total disk size will be: 90GB)
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class OceanLaunchSpecImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[builtins.str] = None):
        """
        :param builtins.str image_id: Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        """
        Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        return pulumi.get(self, "image_id")


@pulumi.output_type
class OceanLaunchSpecInstanceMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: builtins.str,
                 http_put_response_hop_limit: Optional[builtins.int] = None):
        """
        :param builtins.str http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param builtins.int http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> builtins.str:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[builtins.int]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")


@pulumi.output_type
class OceanLaunchSpecSchedulingTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "taskHeadrooms":
            suggest = "task_headrooms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecSchedulingTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecSchedulingTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecSchedulingTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: builtins.str,
                 is_enabled: builtins.bool,
                 task_type: builtins.str,
                 task_headrooms: Optional[Sequence['outputs.OceanLaunchSpecSchedulingTaskTaskHeadroom']] = None):
        """
        :param builtins.str cron_expression: A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        :param builtins.bool is_enabled: Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        :param builtins.str task_type: The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        :param Sequence['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs'] task_headrooms: The config of this scheduled task. Depends on the value of taskType.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)
        if task_headrooms is not None:
            pulumi.set(__self__, "task_headrooms", task_headrooms)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> builtins.str:
        """
        A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> builtins.str:
        """
        The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="taskHeadrooms")
    def task_headrooms(self) -> Optional[Sequence['outputs.OceanLaunchSpecSchedulingTaskTaskHeadroom']]:
        """
        The config of this scheduled task. Depends on the value of taskType.
        """
        return pulumi.get(self, "task_headrooms")


@pulumi.output_type
class OceanLaunchSpecSchedulingTaskTaskHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numOfUnits":
            suggest = "num_of_units"
        elif key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecSchedulingTaskTaskHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecSchedulingTaskTaskHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecSchedulingTaskTaskHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_of_units: builtins.int,
                 cpu_per_unit: Optional[builtins.int] = None,
                 memory_per_unit: Optional[builtins.int] = None):
        """
        :param builtins.int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        :param builtins.int cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param builtins.int memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> builtins.int:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        """
        return pulumi.get(self, "num_of_units")

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[builtins.int]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")


@pulumi.output_type
class OceanLaunchSpecStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spotPercentage":
            suggest = "spot_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spot_percentage: Optional[builtins.int] = None):
        """
        :param builtins.int spot_percentage: When set, Ocean will proactively try to maintain as close as possible to the percentage of Spot instances out of all the Virtual Node Group instances.
        """
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[builtins.int]:
        """
        When set, Ocean will proactively try to maintain as close as possible to the percentage of Spot instances out of all the Virtual Node Group instances.
        """
        return pulumi.get(self, "spot_percentage")


@pulumi.output_type
class OceanLaunchSpecTag(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The label key.
        :param builtins.str value: The label value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanLogging(dict):
    def __init__(__self__, *,
                 export: Optional['outputs.OceanLoggingExport'] = None):
        """
        :param 'OceanLoggingExportArgs' export: Logging Export configuration.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)

    @property
    @pulumi.getter
    def export(self) -> Optional['outputs.OceanLoggingExport']:
        """
        Logging Export configuration.
        """
        return pulumi.get(self, "export")


@pulumi.output_type
class OceanLoggingExport(dict):
    def __init__(__self__, *,
                 s3s: Optional[Sequence['outputs.OceanLoggingExportS3']] = None):
        """
        :param Sequence['OceanLoggingExportS3Args'] s3s: Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        if s3s is not None:
            pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Optional[Sequence['outputs.OceanLoggingExportS3']]:
        """
        Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        return pulumi.get(self, "s3s")


@pulumi.output_type
class OceanLoggingExportS3(dict):
    def __init__(__self__, *,
                 id: builtins.str):
        """
        :param builtins.str id: The identifier of The S3 data integration to export the logs to.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier of The S3 data integration to export the logs to.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class OceanOptimizeImages(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"
        elif key == "shouldOptimizeEcsAmi":
            suggest = "should_optimize_ecs_ami"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanOptimizeImages. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanOptimizeImages.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanOptimizeImages.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: builtins.str,
                 should_optimize_ecs_ami: builtins.bool,
                 time_windows: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str perform_at: String. Valid values: "always" "never" "timeWindow".
        :param builtins.bool should_optimize_ecs_ami: Boolean. Enable auto image (AMI) update for the ECS container instances. The auto update applies for ECS-Optimized AMIs.
        :param Sequence[builtins.str] time_windows: Array of strings. Set time windows for image update, at least one time window. Each string is in the format of ddd:hh:mm-ddd:hh:mm ddd. Time windows should not overlap.
        """
        pulumi.set(__self__, "perform_at", perform_at)
        pulumi.set(__self__, "should_optimize_ecs_ami", should_optimize_ecs_ami)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> builtins.str:
        """
        String. Valid values: "always" "never" "timeWindow".
        """
        return pulumi.get(self, "perform_at")

    @property
    @pulumi.getter(name="shouldOptimizeEcsAmi")
    def should_optimize_ecs_ami(self) -> builtins.bool:
        """
        Boolean. Enable auto image (AMI) update for the ECS container instances. The auto update applies for ECS-Optimized AMIs.
        """
        return pulumi.get(self, "should_optimize_ecs_ami")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[builtins.str]]:
        """
        Array of strings. Set time windows for image update, at least one time window. Each string is in the format of ddd:hh:mm-ddd:hh:mm ddd. Time windows should not overlap.
        """
        return pulumi.get(self, "time_windows")


@pulumi.output_type
class OceanScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shutdownHours":
            suggest = "shutdown_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shutdown_hours: Optional['outputs.OceanScheduledTaskShutdownHours'] = None,
                 tasks: Optional[Sequence['outputs.OceanScheduledTaskTask']] = None):
        """
        :param 'OceanScheduledTaskShutdownHoursArgs' shutdown_hours: Set shutdown hours for cluster object.
        :param Sequence['OceanScheduledTaskTaskArgs'] tasks: The scheduling tasks for the cluster.
        """
        if shutdown_hours is not None:
            pulumi.set(__self__, "shutdown_hours", shutdown_hours)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @property
    @pulumi.getter(name="shutdownHours")
    def shutdown_hours(self) -> Optional['outputs.OceanScheduledTaskShutdownHours']:
        """
        Set shutdown hours for cluster object.
        """
        return pulumi.get(self, "shutdown_hours")

    @property
    @pulumi.getter
    def tasks(self) -> Optional[Sequence['outputs.OceanScheduledTaskTask']]:
        """
        The scheduling tasks for the cluster.
        """
        return pulumi.get(self, "tasks")


@pulumi.output_type
class OceanScheduledTaskShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeWindows":
            suggest = "time_windows"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_windows: Sequence[builtins.str],
                 is_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] time_windows: Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of `ddd:hh:mm-ddd:hh:mm` (ddd = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat hh = hour 24 = 0 -23 mm = minute = 0 - 59). Time windows should not overlap. Required when `cluster.scheduling.isEnabled` is true. API Times are in UTC. Example: `Fri:15:30-Wed:14:30`.
        :param builtins.bool is_enabled: Flag to enable / disable the shutdown hours.
        """
        pulumi.set(__self__, "time_windows", time_windows)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Sequence[builtins.str]:
        """
        Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of `ddd:hh:mm-ddd:hh:mm` (ddd = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat hh = hour 24 = 0 -23 mm = minute = 0 - 59). Time windows should not overlap. Required when `cluster.scheduling.isEnabled` is true. API Times are in UTC. Example: `Fri:15:30-Wed:14:30`.
        """
        return pulumi.get(self, "time_windows")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        Flag to enable / disable the shutdown hours.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class OceanScheduledTaskTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: builtins.str,
                 is_enabled: builtins.bool,
                 task_type: builtins.str):
        """
        :param builtins.str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. Example: `0 1 * * *`.
        :param builtins.bool is_enabled: Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        :param builtins.str task_type: Valid values: "clusterRoll". Required for `cluster.scheduling.tasks object`. Example: `clusterRoll`.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> builtins.str:
        """
        A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. Example: `0 1 * * *`.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> builtins.str:
        """
        Valid values: "clusterRoll". Required for `cluster.scheduling.tasks object`. Example: `clusterRoll`.
        """
        return pulumi.get(self, "task_type")


@pulumi.output_type
class OceanTag(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The tag value.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldRoll":
            suggest = "should_roll"
        elif key == "autoApplyTags":
            suggest = "auto_apply_tags"
        elif key == "conditionedRoll":
            suggest = "conditioned_roll"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_roll: builtins.bool,
                 auto_apply_tags: Optional[builtins.bool] = None,
                 conditioned_roll: Optional[builtins.bool] = None,
                 roll_config: Optional['outputs.OceanUpdatePolicyRollConfig'] = None):
        """
        :param builtins.bool should_roll: Enables the roll.
        :param builtins.bool auto_apply_tags: will update instance tags on the fly without rolling the cluster.
        :param builtins.bool conditioned_roll: Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if auto_apply_tags is not None:
            pulumi.set(__self__, "auto_apply_tags", auto_apply_tags)
        if conditioned_roll is not None:
            pulumi.set(__self__, "conditioned_roll", conditioned_roll)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> builtins.bool:
        """
        Enables the roll.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="autoApplyTags")
    def auto_apply_tags(self) -> Optional[builtins.bool]:
        """
        will update instance tags on the fly without rolling the cluster.
        """
        return pulumi.get(self, "auto_apply_tags")

    @property
    @pulumi.getter(name="conditionedRoll")
    def conditioned_roll(self) -> Optional[builtins.bool]:
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        return pulumi.get(self, "conditioned_roll")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.OceanUpdatePolicyRollConfig']:
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class OceanUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size_percentage: builtins.int,
                 batch_min_healthy_percentage: Optional[builtins.int] = None):
        """
        :param builtins.int batch_size_percentage: Sets the percentage of the instances to deploy in each batch.
        :param builtins.int batch_min_healthy_percentage: Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> builtins.int:
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[builtins.int]:
        """
        Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")


