# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RolloutSpecFailurePolicy',
    'RolloutSpecSpotDeployment',
    'RolloutSpecStrategy',
    'RolloutSpecStrategyArg',
    'RolloutSpecStrategyArgValueFrom',
    'RolloutSpecStrategyArgValueFromFieldRef',
    'RolloutSpecTraffic',
    'RolloutSpecTrafficAlb',
    'RolloutSpecTrafficAlbStickinessConfig',
    'RolloutSpecTrafficAmbassador',
    'RolloutSpecTrafficIstio',
    'RolloutSpecTrafficIstioDestinationRule',
    'RolloutSpecTrafficIstioVirtualService',
    'RolloutSpecTrafficIstioVirtualServiceTlsRoute',
    'RolloutSpecTrafficNginx',
    'RolloutSpecTrafficNginxAdditionalIngressAnnotation',
    'RolloutSpecTrafficPingPong',
    'RolloutSpecTrafficSmi',
    'StrategyCanary',
    'StrategyCanaryBackgroundVerification',
    'StrategyCanaryStep',
    'StrategyCanaryStepPause',
    'StrategyCanaryStepSetCanaryScale',
    'StrategyCanaryStepSetHeaderRoute',
    'StrategyCanaryStepSetHeaderRouteMatch',
    'StrategyCanaryStepSetHeaderRouteMatchHeaderValue',
    'StrategyCanaryStepVerification',
    'StrategyRolling',
    'StrategyRollingStep',
    'StrategyRollingStepPause',
    'StrategyRollingStepVerification',
    'VerificationProviderCloudWatch',
    'VerificationProviderDatadog',
    'VerificationProviderJenkins',
    'VerificationProviderNewRelic',
    'VerificationProviderPrometheus',
    'VerificationTemplateArg',
    'VerificationTemplateArgValueFrom',
    'VerificationTemplateArgValueFromSecretKeyRef',
    'VerificationTemplateMetric',
    'VerificationTemplateMetricBaseline',
    'VerificationTemplateMetricBaselineBaselineProvider',
    'VerificationTemplateMetricBaselineBaselineProviderDatadog',
    'VerificationTemplateMetricBaselineBaselineProviderNewRelic',
    'VerificationTemplateMetricBaselineBaselineProviderPrometheus',
    'VerificationTemplateMetricProvider',
    'VerificationTemplateMetricProviderCloudWatch',
    'VerificationTemplateMetricProviderCloudWatchMetricDataQuery',
    'VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat',
    'VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric',
    'VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension',
    'VerificationTemplateMetricProviderDatadog',
    'VerificationTemplateMetricProviderJenkins',
    'VerificationTemplateMetricProviderJenkinsJenkinsParameters',
    'VerificationTemplateMetricProviderJob',
    'VerificationTemplateMetricProviderJobSpec',
    'VerificationTemplateMetricProviderJobSpecJobTemplate',
    'VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec',
    'VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer',
    'VerificationTemplateMetricProviderNewRelic',
    'VerificationTemplateMetricProviderPrometheus',
    'VerificationTemplateMetricProviderWeb',
    'VerificationTemplateMetricProviderWebWebHeader',
]

@pulumi.output_type
class RolloutSpecFailurePolicy(dict):
    def __init__(__self__, *,
                 action: builtins.str):
        """
        :param builtins.str action: Choose an action to perform on failure. Default is `abort`.  Enum: "abort" "pause" "promote".
        """
        pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Choose an action to perform on failure. Default is `abort`.  Enum: "abort" "pause" "promote".
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class RolloutSpecSpotDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spotDeploymentsClusterId":
            suggest = "spot_deployments_cluster_id"
        elif key == "spotDeploymentsName":
            suggest = "spot_deployments_name"
        elif key == "spotDeploymentsNamespace":
            suggest = "spot_deployments_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecSpotDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecSpotDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecSpotDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spot_deployments_cluster_id: Optional[builtins.str] = None,
                 spot_deployments_name: Optional[builtins.str] = None,
                 spot_deployments_namespace: Optional[builtins.str] = None):
        """
        :param builtins.str spot_deployments_cluster_id: Ocean CD cluster identifier for the references `SpotDeployment`.
        :param builtins.str spot_deployments_name: The name of the `SpotDeployment` resource
        :param builtins.str spot_deployments_namespace: The namespace which the `SpotDeployment` resource exists within.
        """
        if spot_deployments_cluster_id is not None:
            pulumi.set(__self__, "spot_deployments_cluster_id", spot_deployments_cluster_id)
        if spot_deployments_name is not None:
            pulumi.set(__self__, "spot_deployments_name", spot_deployments_name)
        if spot_deployments_namespace is not None:
            pulumi.set(__self__, "spot_deployments_namespace", spot_deployments_namespace)

    @property
    @pulumi.getter(name="spotDeploymentsClusterId")
    def spot_deployments_cluster_id(self) -> Optional[builtins.str]:
        """
        Ocean CD cluster identifier for the references `SpotDeployment`.
        """
        return pulumi.get(self, "spot_deployments_cluster_id")

    @property
    @pulumi.getter(name="spotDeploymentsName")
    def spot_deployments_name(self) -> Optional[builtins.str]:
        """
        The name of the `SpotDeployment` resource
        """
        return pulumi.get(self, "spot_deployments_name")

    @property
    @pulumi.getter(name="spotDeploymentsNamespace")
    def spot_deployments_namespace(self) -> Optional[builtins.str]:
        """
        The namespace which the `SpotDeployment` resource exists within.
        """
        return pulumi.get(self, "spot_deployments_namespace")


@pulumi.output_type
class RolloutSpecStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "strategyName":
            suggest = "strategy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 strategy_name: builtins.str,
                 args: Optional[Sequence['outputs.RolloutSpecStrategyArg']] = None):
        """
        :param builtins.str strategy_name: Ocean CD strategy name identifier.
        :param Sequence['RolloutSpecStrategyArgArgs'] args: Arguments defined in Verification Templates.
        """
        pulumi.set(__self__, "strategy_name", strategy_name)
        if args is not None:
            pulumi.set(__self__, "args", args)

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> builtins.str:
        """
        Ocean CD strategy name identifier.
        """
        return pulumi.get(self, "strategy_name")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence['outputs.RolloutSpecStrategyArg']]:
        """
        Arguments defined in Verification Templates.
        """
        return pulumi.get(self, "args")


@pulumi.output_type
class RolloutSpecStrategyArg(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argName":
            suggest = "arg_name"
        elif key == "argValue":
            suggest = "arg_value"
        elif key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecStrategyArg. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecStrategyArg.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecStrategyArg.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arg_name: builtins.str,
                 arg_value: Optional[builtins.str] = None,
                 value_from: Optional['outputs.RolloutSpecStrategyArgValueFrom'] = None):
        """
        :param builtins.str arg_name: Name of an argument.
        :param builtins.str arg_value: Value of an argument.
        :param 'RolloutSpecStrategyArgValueFromArgs' value_from: Defines from where to get the value of an argument.
        """
        pulumi.set(__self__, "arg_name", arg_name)
        if arg_value is not None:
            pulumi.set(__self__, "arg_value", arg_value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter(name="argName")
    def arg_name(self) -> builtins.str:
        """
        Name of an argument.
        """
        return pulumi.get(self, "arg_name")

    @property
    @pulumi.getter(name="argValue")
    def arg_value(self) -> Optional[builtins.str]:
        """
        Value of an argument.
        """
        return pulumi.get(self, "arg_value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional['outputs.RolloutSpecStrategyArgValueFrom']:
        """
        Defines from where to get the value of an argument.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class RolloutSpecStrategyArgValueFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecStrategyArgValueFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecStrategyArgValueFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecStrategyArgValueFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: 'outputs.RolloutSpecStrategyArgValueFromFieldRef'):
        """
        :param 'RolloutSpecStrategyArgValueFromFieldRefArgs' field_ref: Defines the field path from where to get the value of an argument.
        """
        pulumi.set(__self__, "field_ref", field_ref)

    @property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> 'outputs.RolloutSpecStrategyArgValueFromFieldRef':
        """
        Defines the field path from where to get the value of an argument.
        """
        return pulumi.get(self, "field_ref")


@pulumi.output_type
class RolloutSpecStrategyArgValueFromFieldRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecStrategyArgValueFromFieldRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecStrategyArgValueFromFieldRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecStrategyArgValueFromFieldRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: builtins.str):
        """
        :param builtins.str field_path: Path to SpotDeployment's field from where to get the value of an argument.
        """
        pulumi.set(__self__, "field_path", field_path)

    @property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> builtins.str:
        """
        Path to SpotDeployment's field from where to get the value of an argument.
        """
        return pulumi.get(self, "field_path")


@pulumi.output_type
class RolloutSpecTraffic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canaryService":
            suggest = "canary_service"
        elif key == "pingPong":
            suggest = "ping_pong"
        elif key == "stableService":
            suggest = "stable_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTraffic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTraffic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTraffic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alb: Optional['outputs.RolloutSpecTrafficAlb'] = None,
                 ambassador: Optional['outputs.RolloutSpecTrafficAmbassador'] = None,
                 canary_service: Optional[builtins.str] = None,
                 istio: Optional['outputs.RolloutSpecTrafficIstio'] = None,
                 nginx: Optional['outputs.RolloutSpecTrafficNginx'] = None,
                 ping_pong: Optional['outputs.RolloutSpecTrafficPingPong'] = None,
                 smi: Optional['outputs.RolloutSpecTrafficSmi'] = None,
                 stable_service: Optional[builtins.str] = None):
        """
        :param 'RolloutSpecTrafficAlbArgs' alb: Holds ALB Ingress specific configuration to route traffic.
        :param 'RolloutSpecTrafficAmbassadorArgs' ambassador: Holds specific configuration to use Ambassador to route traffic.
        :param builtins.str canary_service: The canary service name.
        :param 'RolloutSpecTrafficIstioArgs' istio: Holds Istio specific configuration to route traffic.
        :param 'RolloutSpecTrafficNginxArgs' nginx: Holds Nginx Ingress specific configuration to route traffic.
        :param 'RolloutSpecTrafficPingPongArgs' ping_pong: Holds the ping and pong services. You can use `pingPong` field only when using ALB as a traffic manager with the IP Mode approach.
        :param 'RolloutSpecTrafficSmiArgs' smi: Holds TrafficSplit specific configuration to route traffic.
        :param builtins.str stable_service: The stable service name.
        """
        if alb is not None:
            pulumi.set(__self__, "alb", alb)
        if ambassador is not None:
            pulumi.set(__self__, "ambassador", ambassador)
        if canary_service is not None:
            pulumi.set(__self__, "canary_service", canary_service)
        if istio is not None:
            pulumi.set(__self__, "istio", istio)
        if nginx is not None:
            pulumi.set(__self__, "nginx", nginx)
        if ping_pong is not None:
            pulumi.set(__self__, "ping_pong", ping_pong)
        if smi is not None:
            pulumi.set(__self__, "smi", smi)
        if stable_service is not None:
            pulumi.set(__self__, "stable_service", stable_service)

    @property
    @pulumi.getter
    def alb(self) -> Optional['outputs.RolloutSpecTrafficAlb']:
        """
        Holds ALB Ingress specific configuration to route traffic.
        """
        return pulumi.get(self, "alb")

    @property
    @pulumi.getter
    def ambassador(self) -> Optional['outputs.RolloutSpecTrafficAmbassador']:
        """
        Holds specific configuration to use Ambassador to route traffic.
        """
        return pulumi.get(self, "ambassador")

    @property
    @pulumi.getter(name="canaryService")
    def canary_service(self) -> Optional[builtins.str]:
        """
        The canary service name.
        """
        return pulumi.get(self, "canary_service")

    @property
    @pulumi.getter
    def istio(self) -> Optional['outputs.RolloutSpecTrafficIstio']:
        """
        Holds Istio specific configuration to route traffic.
        """
        return pulumi.get(self, "istio")

    @property
    @pulumi.getter
    def nginx(self) -> Optional['outputs.RolloutSpecTrafficNginx']:
        """
        Holds Nginx Ingress specific configuration to route traffic.
        """
        return pulumi.get(self, "nginx")

    @property
    @pulumi.getter(name="pingPong")
    def ping_pong(self) -> Optional['outputs.RolloutSpecTrafficPingPong']:
        """
        Holds the ping and pong services. You can use `pingPong` field only when using ALB as a traffic manager with the IP Mode approach.
        """
        return pulumi.get(self, "ping_pong")

    @property
    @pulumi.getter
    def smi(self) -> Optional['outputs.RolloutSpecTrafficSmi']:
        """
        Holds TrafficSplit specific configuration to route traffic.
        """
        return pulumi.get(self, "smi")

    @property
    @pulumi.getter(name="stableService")
    def stable_service(self) -> Optional[builtins.str]:
        """
        The stable service name.
        """
        return pulumi.get(self, "stable_service")


@pulumi.output_type
class RolloutSpecTrafficAlb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "albIngress":
            suggest = "alb_ingress"
        elif key == "albRootService":
            suggest = "alb_root_service"
        elif key == "servicePort":
            suggest = "service_port"
        elif key == "albAnnotationPrefix":
            suggest = "alb_annotation_prefix"
        elif key == "stickinessConfig":
            suggest = "stickiness_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficAlb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficAlb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficAlb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alb_ingress: builtins.str,
                 alb_root_service: builtins.str,
                 service_port: builtins.int,
                 alb_annotation_prefix: Optional[builtins.str] = None,
                 stickiness_config: Optional['outputs.RolloutSpecTrafficAlbStickinessConfig'] = None):
        """
        :param builtins.str alb_ingress: Refers to the name of an `Ingress` resource in the same namespace as the `SpotDeployment`.
        :param builtins.str alb_root_service: References the service in the ingress to the controller should add the action to.
        :param builtins.int service_port: Refers to the port that the Ingress action should route traffic to.
        :param builtins.str alb_annotation_prefix: Has to match the configured annotation prefix on the alb ingress controller.
        :param 'RolloutSpecTrafficAlbStickinessConfigArgs' stickiness_config: Allows to specify further settings on the ForwardConfig.
        """
        pulumi.set(__self__, "alb_ingress", alb_ingress)
        pulumi.set(__self__, "alb_root_service", alb_root_service)
        pulumi.set(__self__, "service_port", service_port)
        if alb_annotation_prefix is not None:
            pulumi.set(__self__, "alb_annotation_prefix", alb_annotation_prefix)
        if stickiness_config is not None:
            pulumi.set(__self__, "stickiness_config", stickiness_config)

    @property
    @pulumi.getter(name="albIngress")
    def alb_ingress(self) -> builtins.str:
        """
        Refers to the name of an `Ingress` resource in the same namespace as the `SpotDeployment`.
        """
        return pulumi.get(self, "alb_ingress")

    @property
    @pulumi.getter(name="albRootService")
    def alb_root_service(self) -> builtins.str:
        """
        References the service in the ingress to the controller should add the action to.
        """
        return pulumi.get(self, "alb_root_service")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> builtins.int:
        """
        Refers to the port that the Ingress action should route traffic to.
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="albAnnotationPrefix")
    def alb_annotation_prefix(self) -> Optional[builtins.str]:
        """
        Has to match the configured annotation prefix on the alb ingress controller.
        """
        return pulumi.get(self, "alb_annotation_prefix")

    @property
    @pulumi.getter(name="stickinessConfig")
    def stickiness_config(self) -> Optional['outputs.RolloutSpecTrafficAlbStickinessConfig']:
        """
        Allows to specify further settings on the ForwardConfig.
        """
        return pulumi.get(self, "stickiness_config")


@pulumi.output_type
class RolloutSpecTrafficAlbStickinessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationSeconds":
            suggest = "duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficAlbStickinessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficAlbStickinessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficAlbStickinessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_seconds: Optional[builtins.int] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.int duration_seconds: Defines how long the load balancer should consistently route the user's request to the same target.
        :param builtins.bool enabled: Enables the load balancer to bind a user's session to a specific target.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[builtins.int]:
        """
        Defines how long the load balancer should consistently route the user's request to the same target.
        """
        return pulumi.get(self, "duration_seconds")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables the load balancer to bind a user's session to a specific target.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class RolloutSpecTrafficAmbassador(dict):
    def __init__(__self__, *,
                 mappings: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] mappings: A list of names of the Ambassador Mappings used to route traffic to the service.
        """
        pulumi.set(__self__, "mappings", mappings)

    @property
    @pulumi.getter
    def mappings(self) -> Sequence[builtins.str]:
        """
        A list of names of the Ambassador Mappings used to route traffic to the service.
        """
        return pulumi.get(self, "mappings")


@pulumi.output_type
class RolloutSpecTrafficIstio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualServices":
            suggest = "virtual_services"
        elif key == "destinationRule":
            suggest = "destination_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficIstio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficIstio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficIstio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_services: Sequence['outputs.RolloutSpecTrafficIstioVirtualService'],
                 destination_rule: Optional['outputs.RolloutSpecTrafficIstioDestinationRule'] = None):
        """
        :param Sequence['RolloutSpecTrafficIstioVirtualServiceArgs'] virtual_services: Defines a set of traffic routing rules to apply when a host is addressed.
        :param 'RolloutSpecTrafficIstioDestinationRuleArgs' destination_rule: It references to an Istio DestinationRule to modify and shape traffic. `DestinationRule` field belongs only to the Subset Level approach.
        """
        pulumi.set(__self__, "virtual_services", virtual_services)
        if destination_rule is not None:
            pulumi.set(__self__, "destination_rule", destination_rule)

    @property
    @pulumi.getter(name="virtualServices")
    def virtual_services(self) -> Sequence['outputs.RolloutSpecTrafficIstioVirtualService']:
        """
        Defines a set of traffic routing rules to apply when a host is addressed.
        """
        return pulumi.get(self, "virtual_services")

    @property
    @pulumi.getter(name="destinationRule")
    def destination_rule(self) -> Optional['outputs.RolloutSpecTrafficIstioDestinationRule']:
        """
        It references to an Istio DestinationRule to modify and shape traffic. `DestinationRule` field belongs only to the Subset Level approach.
        """
        return pulumi.get(self, "destination_rule")


@pulumi.output_type
class RolloutSpecTrafficIstioDestinationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canarySubsetName":
            suggest = "canary_subset_name"
        elif key == "destinationRuleName":
            suggest = "destination_rule_name"
        elif key == "stableSubsetName":
            suggest = "stable_subset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficIstioDestinationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficIstioDestinationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficIstioDestinationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canary_subset_name: builtins.str,
                 destination_rule_name: builtins.str,
                 stable_subset_name: builtins.str):
        """
        :param builtins.str canary_subset_name: The subset name to modify labels with the canary version.
        :param builtins.str destination_rule_name: Holds the name of the DestinationRule.
        :param builtins.str stable_subset_name: The subset name to modify labels with the stable version.
        """
        pulumi.set(__self__, "canary_subset_name", canary_subset_name)
        pulumi.set(__self__, "destination_rule_name", destination_rule_name)
        pulumi.set(__self__, "stable_subset_name", stable_subset_name)

    @property
    @pulumi.getter(name="canarySubsetName")
    def canary_subset_name(self) -> builtins.str:
        """
        The subset name to modify labels with the canary version.
        """
        return pulumi.get(self, "canary_subset_name")

    @property
    @pulumi.getter(name="destinationRuleName")
    def destination_rule_name(self) -> builtins.str:
        """
        Holds the name of the DestinationRule.
        """
        return pulumi.get(self, "destination_rule_name")

    @property
    @pulumi.getter(name="stableSubsetName")
    def stable_subset_name(self) -> builtins.str:
        """
        The subset name to modify labels with the stable version.
        """
        return pulumi.get(self, "stable_subset_name")


@pulumi.output_type
class RolloutSpecTrafficIstioVirtualService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualServiceName":
            suggest = "virtual_service_name"
        elif key == "tlsRoutes":
            suggest = "tls_routes"
        elif key == "virtualServiceRoutes":
            suggest = "virtual_service_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficIstioVirtualService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficIstioVirtualService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficIstioVirtualService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_service_name: builtins.str,
                 tls_routes: Optional[Sequence['outputs.RolloutSpecTrafficIstioVirtualServiceTlsRoute']] = None,
                 virtual_service_routes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str virtual_service_name: Holds the name of the VirtualService.
        :param Sequence['RolloutSpecTrafficIstioVirtualServiceTlsRouteArgs'] tls_routes: A list of HTTPS routes within VirtualService.
        :param Sequence[builtins.str] virtual_service_routes: A list of HTTP routes within VirtualService.
        """
        pulumi.set(__self__, "virtual_service_name", virtual_service_name)
        if tls_routes is not None:
            pulumi.set(__self__, "tls_routes", tls_routes)
        if virtual_service_routes is not None:
            pulumi.set(__self__, "virtual_service_routes", virtual_service_routes)

    @property
    @pulumi.getter(name="virtualServiceName")
    def virtual_service_name(self) -> builtins.str:
        """
        Holds the name of the VirtualService.
        """
        return pulumi.get(self, "virtual_service_name")

    @property
    @pulumi.getter(name="tlsRoutes")
    def tls_routes(self) -> Optional[Sequence['outputs.RolloutSpecTrafficIstioVirtualServiceTlsRoute']]:
        """
        A list of HTTPS routes within VirtualService.
        """
        return pulumi.get(self, "tls_routes")

    @property
    @pulumi.getter(name="virtualServiceRoutes")
    def virtual_service_routes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of HTTP routes within VirtualService.
        """
        return pulumi.get(self, "virtual_service_routes")


@pulumi.output_type
class RolloutSpecTrafficIstioVirtualServiceTlsRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sniHosts":
            suggest = "sni_hosts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficIstioVirtualServiceTlsRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficIstioVirtualServiceTlsRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficIstioVirtualServiceTlsRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[builtins.int] = None,
                 sni_hosts: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int port: The port of the TLS Route desired to be matched in the given Istio VirtualService.
        :param Sequence[builtins.str] sni_hosts: A list of all the SNI Hosts of the TLS Route desired to be matched in the given Istio VirtualService.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if sni_hosts is not None:
            pulumi.set(__self__, "sni_hosts", sni_hosts)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port of the TLS Route desired to be matched in the given Istio VirtualService.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sniHosts")
    def sni_hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of all the SNI Hosts of the TLS Route desired to be matched in the given Istio VirtualService.
        """
        return pulumi.get(self, "sni_hosts")


@pulumi.output_type
class RolloutSpecTrafficNginx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stableIngress":
            suggest = "stable_ingress"
        elif key == "additionalIngressAnnotation":
            suggest = "additional_ingress_annotation"
        elif key == "nginxAnnotationPrefix":
            suggest = "nginx_annotation_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficNginx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficNginx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficNginx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stable_ingress: builtins.str,
                 additional_ingress_annotation: Optional['outputs.RolloutSpecTrafficNginxAdditionalIngressAnnotation'] = None,
                 nginx_annotation_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str stable_ingress: Refers to the name of an `Ingress` resource in the same namespace as the `SpotDeployment`.
        :param 'RolloutSpecTrafficNginxAdditionalIngressAnnotationArgs' additional_ingress_annotation: Provides additional features to add to the canary ingress (such as routing by header, cookie, etc). You can add these Kubernetes annotations to specific Ingress objects to customize their behavior. Above are found examples of accepted k8s keys.For the full list of supported keys, you may reach the following documentation - https://kubernetes.github.io/ingress-nginx/user-guide/nginx-configuration/annotations/#canary.
        :param builtins.str nginx_annotation_prefix: Has to match the configured annotation prefix on the Nginx ingress controller.
        """
        pulumi.set(__self__, "stable_ingress", stable_ingress)
        if additional_ingress_annotation is not None:
            pulumi.set(__self__, "additional_ingress_annotation", additional_ingress_annotation)
        if nginx_annotation_prefix is not None:
            pulumi.set(__self__, "nginx_annotation_prefix", nginx_annotation_prefix)

    @property
    @pulumi.getter(name="stableIngress")
    def stable_ingress(self) -> builtins.str:
        """
        Refers to the name of an `Ingress` resource in the same namespace as the `SpotDeployment`.
        """
        return pulumi.get(self, "stable_ingress")

    @property
    @pulumi.getter(name="additionalIngressAnnotation")
    def additional_ingress_annotation(self) -> Optional['outputs.RolloutSpecTrafficNginxAdditionalIngressAnnotation']:
        """
        Provides additional features to add to the canary ingress (such as routing by header, cookie, etc). You can add these Kubernetes annotations to specific Ingress objects to customize their behavior. Above are found examples of accepted k8s keys.For the full list of supported keys, you may reach the following documentation - https://kubernetes.github.io/ingress-nginx/user-guide/nginx-configuration/annotations/#canary.
        """
        return pulumi.get(self, "additional_ingress_annotation")

    @property
    @pulumi.getter(name="nginxAnnotationPrefix")
    def nginx_annotation_prefix(self) -> Optional[builtins.str]:
        """
        Has to match the configured annotation prefix on the Nginx ingress controller.
        """
        return pulumi.get(self, "nginx_annotation_prefix")


@pulumi.output_type
class RolloutSpecTrafficNginxAdditionalIngressAnnotation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canaryByHeader":
            suggest = "canary_by_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficNginxAdditionalIngressAnnotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficNginxAdditionalIngressAnnotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficNginxAdditionalIngressAnnotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canary_by_header: Optional[builtins.str] = None,
                 key1: Optional[builtins.str] = None):
        """
        :param builtins.str canary_by_header: Allows customizing the header value instead of using hardcoded values.
        :param builtins.str key1: Any of supported annotations.
        """
        if canary_by_header is not None:
            pulumi.set(__self__, "canary_by_header", canary_by_header)
        if key1 is not None:
            pulumi.set(__self__, "key1", key1)

    @property
    @pulumi.getter(name="canaryByHeader")
    def canary_by_header(self) -> Optional[builtins.str]:
        """
        Allows customizing the header value instead of using hardcoded values.
        """
        return pulumi.get(self, "canary_by_header")

    @property
    @pulumi.getter
    def key1(self) -> Optional[builtins.str]:
        """
        Any of supported annotations.
        """
        return pulumi.get(self, "key1")


@pulumi.output_type
class RolloutSpecTrafficPingPong(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pingService":
            suggest = "ping_service"
        elif key == "pongService":
            suggest = "pong_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficPingPong. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficPingPong.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficPingPong.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ping_service: builtins.str,
                 pong_service: builtins.str):
        """
        :param builtins.str ping_service: Holds the name of the ping service.
        :param builtins.str pong_service: Holds the name of the pong service.
        """
        pulumi.set(__self__, "ping_service", ping_service)
        pulumi.set(__self__, "pong_service", pong_service)

    @property
    @pulumi.getter(name="pingService")
    def ping_service(self) -> builtins.str:
        """
        Holds the name of the ping service.
        """
        return pulumi.get(self, "ping_service")

    @property
    @pulumi.getter(name="pongService")
    def pong_service(self) -> builtins.str:
        """
        Holds the name of the pong service.
        """
        return pulumi.get(self, "pong_service")


@pulumi.output_type
class RolloutSpecTrafficSmi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smiRootService":
            suggest = "smi_root_service"
        elif key == "trafficSplitName":
            suggest = "traffic_split_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutSpecTrafficSmi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutSpecTrafficSmi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutSpecTrafficSmi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 smi_root_service: Optional[builtins.str] = None,
                 traffic_split_name: Optional[builtins.str] = None):
        """
        :param builtins.str smi_root_service: Holds the name of service that clients use to communicate.
        :param builtins.str traffic_split_name: Holds the name of the TrafficSplit.
        """
        if smi_root_service is not None:
            pulumi.set(__self__, "smi_root_service", smi_root_service)
        if traffic_split_name is not None:
            pulumi.set(__self__, "traffic_split_name", traffic_split_name)

    @property
    @pulumi.getter(name="smiRootService")
    def smi_root_service(self) -> Optional[builtins.str]:
        """
        Holds the name of service that clients use to communicate.
        """
        return pulumi.get(self, "smi_root_service")

    @property
    @pulumi.getter(name="trafficSplitName")
    def traffic_split_name(self) -> Optional[builtins.str]:
        """
        Holds the name of the TrafficSplit.
        """
        return pulumi.get(self, "traffic_split_name")


@pulumi.output_type
class StrategyCanary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backgroundVerification":
            suggest = "background_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 steps: Sequence['outputs.StrategyCanaryStep'],
                 background_verification: Optional['outputs.StrategyCanaryBackgroundVerification'] = None):
        """
        :param Sequence['StrategyCanaryStepArgs'] steps: A set of separate conditions of rollout processing.
        :param 'StrategyCanaryBackgroundVerificationArgs' background_verification: A list of background verifications.
        """
        pulumi.set(__self__, "steps", steps)
        if background_verification is not None:
            pulumi.set(__self__, "background_verification", background_verification)

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.StrategyCanaryStep']:
        """
        A set of separate conditions of rollout processing.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="backgroundVerification")
    def background_verification(self) -> Optional['outputs.StrategyCanaryBackgroundVerification']:
        """
        A list of background verifications.
        """
        return pulumi.get(self, "background_verification")


@pulumi.output_type
class StrategyCanaryBackgroundVerification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateNames":
            suggest = "template_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryBackgroundVerification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryBackgroundVerification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryBackgroundVerification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template_names: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] template_names: List of Verification Template names.
        """
        pulumi.set(__self__, "template_names", template_names)

    @property
    @pulumi.getter(name="templateNames")
    def template_names(self) -> Sequence[builtins.str]:
        """
        List of Verification Template names.
        """
        return pulumi.get(self, "template_names")


@pulumi.output_type
class StrategyCanaryStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "setCanaryScale":
            suggest = "set_canary_scale"
        elif key == "setHeaderRoute":
            suggest = "set_header_route"
        elif key == "setWeight":
            suggest = "set_weight"
        elif key == "stepName":
            suggest = "step_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pause: Optional['outputs.StrategyCanaryStepPause'] = None,
                 set_canary_scale: Optional['outputs.StrategyCanaryStepSetCanaryScale'] = None,
                 set_header_route: Optional['outputs.StrategyCanaryStepSetHeaderRoute'] = None,
                 set_weight: Optional[builtins.int] = None,
                 step_name: Optional[builtins.str] = None,
                 verification: Optional['outputs.StrategyCanaryStepVerification'] = None):
        """
        :param 'StrategyCanaryStepPauseArgs' pause: Defines the duration of time to freeze the rollout.
        :param 'StrategyCanaryStepSetCanaryScaleArgs' set_canary_scale: Defines how to scale the version without traffic weight changing.
        :param 'StrategyCanaryStepSetHeaderRouteArgs' set_header_route: Defines the list of HeaderRoutes to add to the Rollout.
        :param builtins.int set_weight: Defines the percentage that the new version should receive.
        :param 'StrategyCanaryStepVerificationArgs' verification: Represents the list of verifications to run in a step.
        """
        if pause is not None:
            pulumi.set(__self__, "pause", pause)
        if set_canary_scale is not None:
            pulumi.set(__self__, "set_canary_scale", set_canary_scale)
        if set_header_route is not None:
            pulumi.set(__self__, "set_header_route", set_header_route)
        if set_weight is not None:
            pulumi.set(__self__, "set_weight", set_weight)
        if step_name is not None:
            pulumi.set(__self__, "step_name", step_name)
        if verification is not None:
            pulumi.set(__self__, "verification", verification)

    @property
    @pulumi.getter
    def pause(self) -> Optional['outputs.StrategyCanaryStepPause']:
        """
        Defines the duration of time to freeze the rollout.
        """
        return pulumi.get(self, "pause")

    @property
    @pulumi.getter(name="setCanaryScale")
    def set_canary_scale(self) -> Optional['outputs.StrategyCanaryStepSetCanaryScale']:
        """
        Defines how to scale the version without traffic weight changing.
        """
        return pulumi.get(self, "set_canary_scale")

    @property
    @pulumi.getter(name="setHeaderRoute")
    def set_header_route(self) -> Optional['outputs.StrategyCanaryStepSetHeaderRoute']:
        """
        Defines the list of HeaderRoutes to add to the Rollout.
        """
        return pulumi.get(self, "set_header_route")

    @property
    @pulumi.getter(name="setWeight")
    def set_weight(self) -> Optional[builtins.int]:
        """
        Defines the percentage that the new version should receive.
        """
        return pulumi.get(self, "set_weight")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter
    def verification(self) -> Optional['outputs.StrategyCanaryStepVerification']:
        """
        Represents the list of verifications to run in a step.
        """
        return pulumi.get(self, "verification")


@pulumi.output_type
class StrategyCanaryStepPause(dict):
    def __init__(__self__, *,
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str duration: The amount of time to wait before moving to the next step.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The amount of time to wait before moving to the next step.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class StrategyCanaryStepSetCanaryScale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchTrafficWeight":
            suggest = "match_traffic_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryStepSetCanaryScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryStepSetCanaryScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryStepSetCanaryScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_traffic_weight: Optional[builtins.bool] = None,
                 replicas: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.bool match_traffic_weight: Defines whether a rollout should match the current canary's setWeight step.
        :param builtins.int replicas: Sets the number of replicas the new version should have.
        :param builtins.int weight: Sets the percentage of replicas the new version should have.
        """
        if match_traffic_weight is not None:
            pulumi.set(__self__, "match_traffic_weight", match_traffic_weight)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="matchTrafficWeight")
    def match_traffic_weight(self) -> Optional[builtins.bool]:
        """
        Defines whether a rollout should match the current canary's setWeight step.
        """
        return pulumi.get(self, "match_traffic_weight")

    @property
    @pulumi.getter
    def replicas(self) -> Optional[builtins.int]:
        """
        Sets the number of replicas the new version should have.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Sets the percentage of replicas the new version should have.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class StrategyCanaryStepSetHeaderRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerRouteName":
            suggest = "header_route_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryStepSetHeaderRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryStepSetHeaderRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryStepSetHeaderRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_route_name: builtins.str,
                 matches: Sequence['outputs.StrategyCanaryStepSetHeaderRouteMatch']):
        """
        :param builtins.str header_route_name: The name of the HeaderRoute group.
        :param Sequence['StrategyCanaryStepSetHeaderRouteMatchArgs'] matches: The matching rules for the header route.
        """
        pulumi.set(__self__, "header_route_name", header_route_name)
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter(name="headerRouteName")
    def header_route_name(self) -> builtins.str:
        """
        The name of the HeaderRoute group.
        """
        return pulumi.get(self, "header_route_name")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.StrategyCanaryStepSetHeaderRouteMatch']:
        """
        The matching rules for the header route.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class StrategyCanaryStepSetHeaderRouteMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryStepSetHeaderRouteMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryStepSetHeaderRouteMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryStepSetHeaderRouteMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 header_value: 'outputs.StrategyCanaryStepSetHeaderRouteMatchHeaderValue'):
        """
        :param builtins.str header_name: The name of the header.
        :param 'StrategyCanaryStepSetHeaderRouteMatchHeaderValueArgs' header_value: Defines a single header to add to the Rollout. Must be only one initialized from the following (exact, prefix, regex).
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> 'outputs.StrategyCanaryStepSetHeaderRouteMatchHeaderValue':
        """
        Defines a single header to add to the Rollout. Must be only one initialized from the following (exact, prefix, regex).
        """
        return pulumi.get(self, "header_value")


@pulumi.output_type
class StrategyCanaryStepSetHeaderRouteMatchHeaderValue(dict):
    def __init__(__self__, *,
                 exact: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None,
                 regex: Optional[builtins.str] = None):
        """
        :param builtins.str exact: The exact header value.
        :param builtins.str prefix: The prefix of the value.
        :param builtins.str regex: The value in a regex format.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        The exact header value.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The prefix of the value.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.str]:
        """
        The value in a regex format.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class StrategyCanaryStepVerification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateNames":
            suggest = "template_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyCanaryStepVerification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyCanaryStepVerification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyCanaryStepVerification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template_names: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] template_names: List of Verification Template names.
        """
        pulumi.set(__self__, "template_names", template_names)

    @property
    @pulumi.getter(name="templateNames")
    def template_names(self) -> Sequence[builtins.str]:
        """
        List of Verification Template names.
        """
        return pulumi.get(self, "template_names")


@pulumi.output_type
class StrategyRolling(dict):
    def __init__(__self__, *,
                 steps: Sequence['outputs.StrategyRollingStep']):
        """
        :param Sequence['StrategyRollingStepArgs'] steps: A set of separate conditions of rollout processing.
        """
        pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.StrategyRollingStep']:
        """
        A set of separate conditions of rollout processing.
        """
        return pulumi.get(self, "steps")


@pulumi.output_type
class StrategyRollingStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepsName":
            suggest = "steps_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyRollingStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyRollingStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyRollingStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pause: Optional['outputs.StrategyRollingStepPause'] = None,
                 steps_name: Optional[builtins.str] = None,
                 verification: Optional['outputs.StrategyRollingStepVerification'] = None):
        """
        :param 'StrategyRollingStepPauseArgs' pause: Defines the duration of time to freeze the rollout.
        :param 'StrategyRollingStepVerificationArgs' verification: Represents the list of verifications to run in a step.
        """
        if pause is not None:
            pulumi.set(__self__, "pause", pause)
        if steps_name is not None:
            pulumi.set(__self__, "steps_name", steps_name)
        if verification is not None:
            pulumi.set(__self__, "verification", verification)

    @property
    @pulumi.getter
    def pause(self) -> Optional['outputs.StrategyRollingStepPause']:
        """
        Defines the duration of time to freeze the rollout.
        """
        return pulumi.get(self, "pause")

    @property
    @pulumi.getter(name="stepsName")
    def steps_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "steps_name")

    @property
    @pulumi.getter
    def verification(self) -> Optional['outputs.StrategyRollingStepVerification']:
        """
        Represents the list of verifications to run in a step.
        """
        return pulumi.get(self, "verification")


@pulumi.output_type
class StrategyRollingStepPause(dict):
    def __init__(__self__, *,
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str duration: The amount of time to wait before moving to the next step.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The amount of time to wait before moving to the next step.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class StrategyRollingStepVerification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateNames":
            suggest = "template_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StrategyRollingStepVerification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StrategyRollingStepVerification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StrategyRollingStepVerification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template_names: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] template_names: List of Verification Template names.
        """
        pulumi.set(__self__, "template_names", template_names)

    @property
    @pulumi.getter(name="templateNames")
    def template_names(self) -> Sequence[builtins.str]:
        """
        List of Verification Template names.
        """
        return pulumi.get(self, "template_names")


@pulumi.output_type
class VerificationProviderCloudWatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamArn":
            suggest = "iam_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationProviderCloudWatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationProviderCloudWatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationProviderCloudWatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_arn: builtins.str):
        """
        :param builtins.str iam_arn: Set label key.
        """
        pulumi.set(__self__, "iam_arn", iam_arn)

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> builtins.str:
        """
        Set label key.
        """
        return pulumi.get(self, "iam_arn")


@pulumi.output_type
class VerificationProviderDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "appKey":
            suggest = "app_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationProviderDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationProviderDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationProviderDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 api_key: builtins.str,
                 app_key: builtins.str):
        """
        :param builtins.str address: DataDog API URL.
        :param builtins.str api_key: API key required by the Datadog Agent to submit metrics and events to Datadog.
        :param builtins.str app_key: API key that gives users access to Datadog’s programmatic API.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "app_key", app_key)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        DataDog API URL.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> builtins.str:
        """
        API key required by the Datadog Agent to submit metrics and events to Datadog.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> builtins.str:
        """
        API key that gives users access to Datadog’s programmatic API.
        """
        return pulumi.get(self, "app_key")


@pulumi.output_type
class VerificationProviderJenkins(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiToken":
            suggest = "api_token"
        elif key == "baseUrl":
            suggest = "base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationProviderJenkins. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationProviderJenkins.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationProviderJenkins.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_token: builtins.str,
                 base_url: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str api_token: The Jenkins server’s access apiToken.
        :param builtins.str base_url: The address of the Jenkins server within the cluster.
        :param builtins.str username: The Jenkins server’s access username.
        """
        pulumi.set(__self__, "api_token", api_token)
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> builtins.str:
        """
        The Jenkins server’s access apiToken.
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> builtins.str:
        """
        The address of the Jenkins server within the cluster.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The Jenkins server’s access username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class VerificationProviderNewRelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "personalApiKey":
            suggest = "personal_api_key"
        elif key == "baseUrlNerdGraph":
            suggest = "base_url_nerd_graph"
        elif key == "baseUrlRest":
            suggest = "base_url_rest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationProviderNewRelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationProviderNewRelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationProviderNewRelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: builtins.str,
                 personal_api_key: builtins.str,
                 base_url_nerd_graph: Optional[builtins.str] = None,
                 base_url_rest: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str personal_api_key: The NewRelic user key
        :param builtins.str base_url_nerd_graph: The base URL for NerdGraph for a proxy.
        :param builtins.str base_url_rest: The base URL of the New Relic REST API for a proxy.
        :param builtins.str region: A region which the account is attached to. Default is "us".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "personal_api_key", personal_api_key)
        if base_url_nerd_graph is not None:
            pulumi.set(__self__, "base_url_nerd_graph", base_url_nerd_graph)
        if base_url_rest is not None:
            pulumi.set(__self__, "base_url_rest", base_url_rest)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="personalApiKey")
    def personal_api_key(self) -> builtins.str:
        """
        The NewRelic user key
        """
        return pulumi.get(self, "personal_api_key")

    @property
    @pulumi.getter(name="baseUrlNerdGraph")
    def base_url_nerd_graph(self) -> Optional[builtins.str]:
        """
        The base URL for NerdGraph for a proxy.
        """
        return pulumi.get(self, "base_url_nerd_graph")

    @property
    @pulumi.getter(name="baseUrlRest")
    def base_url_rest(self) -> Optional[builtins.str]:
        """
        The base URL of the New Relic REST API for a proxy.
        """
        return pulumi.get(self, "base_url_rest")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        A region which the account is attached to. Default is "us".
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class VerificationProviderPrometheus(dict):
    def __init__(__self__, *,
                 address: builtins.str):
        """
        :param builtins.str address: The address which the Prometheus server available on.
        """
        pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The address which the Prometheus server available on.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class VerificationTemplateArg(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argName":
            suggest = "arg_name"
        elif key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateArg. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateArg.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateArg.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arg_name: builtins.str,
                 value: Optional[builtins.str] = None,
                 value_from: Optional['outputs.VerificationTemplateArgValueFrom'] = None):
        """
        :param builtins.str arg_name: Name of an argument.
        :param builtins.str value: String representation of data.
        :param 'VerificationTemplateArgValueFromArgs' value_from: ValueFrom object.
        """
        pulumi.set(__self__, "arg_name", arg_name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter(name="argName")
    def arg_name(self) -> builtins.str:
        """
        Name of an argument.
        """
        return pulumi.get(self, "arg_name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        String representation of data.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional['outputs.VerificationTemplateArgValueFrom']:
        """
        ValueFrom object.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class VerificationTemplateArgValueFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateArgValueFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateArgValueFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateArgValueFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.VerificationTemplateArgValueFromSecretKeyRef'] = None):
        """
        :param 'VerificationTemplateArgValueFromSecretKeyRefArgs' secret_key_ref: Secret key to use.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.VerificationTemplateArgValueFromSecretKeyRef']:
        """
        Secret key to use.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class VerificationTemplateArgValueFromSecretKeyRef(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str key: The name of the field inside the secret.
        :param builtins.str name: The name of the secret.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name of the field inside the secret.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VerificationTemplateMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricsName":
            suggest = "metrics_name"
        elif key == "consecutiveErrorLimit":
            suggest = "consecutive_error_limit"
        elif key == "dryRun":
            suggest = "dry_run"
        elif key == "failureCondition":
            suggest = "failure_condition"
        elif key == "failureLimit":
            suggest = "failure_limit"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successCondition":
            suggest = "success_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metrics_name: builtins.str,
                 providers: Sequence['outputs.VerificationTemplateMetricProvider'],
                 baseline: Optional['outputs.VerificationTemplateMetricBaseline'] = None,
                 consecutive_error_limit: Optional[builtins.int] = None,
                 count: Optional[builtins.int] = None,
                 dry_run: Optional[builtins.bool] = None,
                 failure_condition: Optional[builtins.str] = None,
                 failure_limit: Optional[builtins.int] = None,
                 initial_delay: Optional[builtins.str] = None,
                 interval: Optional[builtins.str] = None,
                 success_condition: Optional[builtins.str] = None):
        """
        :param builtins.str metrics_name: The name of the verification metric.
        :param Sequence['VerificationTemplateMetricProviderArgs'] providers: The name of the monitoring tool chosen for the metric.
        :param 'VerificationTemplateMetricBaselineArgs' baseline: Baseline Object.
        :param builtins.int consecutive_error_limit: The maximum number of times the measurement is allowed to error in succession, before the metric is considered error.Default is 4.When choosing `Jenkins` as the provider, there is no need to send this variable.
        :param builtins.int count: The number of times to run the measurement. If both interval and count are omitted, the effective count is 1. If only interval is specified, metric runs indefinitely. If count > 1, interval must be specified. When choosing `Jenkins` as the provider, there is no need to send this variable.
        :param builtins.bool dry_run: Defines whether the metric should have an impact on the result of the rollout.
        :param builtins.str failure_condition: An expression which determines if a measurement is considered failed.If failureCondition is set, then successCondition is not allowed. When choosing Jenkins as the provider, there is no need to send this variable.
        :param builtins.int failure_limit: The maximum number of times the measurement is allowed to fail, before the entire metric is considered failed.Default is 0. When choosing `Jenkins` as the provider, there is no need to send this variable.
        :param builtins.str initial_delay: How long to wait before starting this metric measurements. When choosing Jenkins as the provider, there is no need to send this variable.
        :param builtins.str interval: Defines an interval string (30s, 5m, 1h) between each verification measurements. If omitted, will perform a single measurement.When choosing Jenkins as the provider, there is no need to send this variable.
        :param builtins.str success_condition: An expression which determines if a measurement is considered successful. The keyword `result` is a variable reference to the value of measurement. Results can be both structured data or primitive. If successCondition is set, then failureCondition is not allowed. When choosing `Jenkins` as the provider, there is no need to send this variable.
        """
        pulumi.set(__self__, "metrics_name", metrics_name)
        pulumi.set(__self__, "providers", providers)
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if consecutive_error_limit is not None:
            pulumi.set(__self__, "consecutive_error_limit", consecutive_error_limit)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if failure_condition is not None:
            pulumi.set(__self__, "failure_condition", failure_condition)
        if failure_limit is not None:
            pulumi.set(__self__, "failure_limit", failure_limit)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if success_condition is not None:
            pulumi.set(__self__, "success_condition", success_condition)

    @property
    @pulumi.getter(name="metricsName")
    def metrics_name(self) -> builtins.str:
        """
        The name of the verification metric.
        """
        return pulumi.get(self, "metrics_name")

    @property
    @pulumi.getter
    def providers(self) -> Sequence['outputs.VerificationTemplateMetricProvider']:
        """
        The name of the monitoring tool chosen for the metric.
        """
        return pulumi.get(self, "providers")

    @property
    @pulumi.getter
    def baseline(self) -> Optional['outputs.VerificationTemplateMetricBaseline']:
        """
        Baseline Object.
        """
        return pulumi.get(self, "baseline")

    @property
    @pulumi.getter(name="consecutiveErrorLimit")
    def consecutive_error_limit(self) -> Optional[builtins.int]:
        """
        The maximum number of times the measurement is allowed to error in succession, before the metric is considered error.Default is 4.When choosing `Jenkins` as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "consecutive_error_limit")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        """
        The number of times to run the measurement. If both interval and count are omitted, the effective count is 1. If only interval is specified, metric runs indefinitely. If count > 1, interval must be specified. When choosing `Jenkins` as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[builtins.bool]:
        """
        Defines whether the metric should have an impact on the result of the rollout.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="failureCondition")
    def failure_condition(self) -> Optional[builtins.str]:
        """
        An expression which determines if a measurement is considered failed.If failureCondition is set, then successCondition is not allowed. When choosing Jenkins as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "failure_condition")

    @property
    @pulumi.getter(name="failureLimit")
    def failure_limit(self) -> Optional[builtins.int]:
        """
        The maximum number of times the measurement is allowed to fail, before the entire metric is considered failed.Default is 0. When choosing `Jenkins` as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "failure_limit")

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[builtins.str]:
        """
        How long to wait before starting this metric measurements. When choosing Jenkins as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "initial_delay")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.str]:
        """
        Defines an interval string (30s, 5m, 1h) between each verification measurements. If omitted, will perform a single measurement.When choosing Jenkins as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="successCondition")
    def success_condition(self) -> Optional[builtins.str]:
        """
        An expression which determines if a measurement is considered successful. The keyword `result` is a variable reference to the value of measurement. Results can be both structured data or primitive. If successCondition is set, then failureCondition is not allowed. When choosing `Jenkins` as the provider, there is no need to send this variable.
        """
        return pulumi.get(self, "success_condition")


@pulumi.output_type
class VerificationTemplateMetricBaseline(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baselineProviders":
            suggest = "baseline_providers"
        elif key == "maxRange":
            suggest = "max_range"
        elif key == "minRange":
            suggest = "min_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricBaseline. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricBaseline.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricBaseline.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baseline_providers: Sequence['outputs.VerificationTemplateMetricBaselineBaselineProvider'],
                 threshold: builtins.str,
                 max_range: Optional[builtins.int] = None,
                 min_range: Optional[builtins.int] = None):
        """
        :param Sequence['VerificationTemplateMetricBaselineBaselineProviderArgs'] baseline_providers: The name of the monitoring tool chosen for the metric.
        :param builtins.str threshold: A mathematical expression needed for the comparison. Enum: "<" ">" "<=" ">=" "=" "range"
        :param builtins.int max_range: Number in percent we allow the new version’s data result to be under baseline data result.
        :param builtins.int min_range: Number in percent we allow the new version’s data result to be under baseline data result.*
        """
        pulumi.set(__self__, "baseline_providers", baseline_providers)
        pulumi.set(__self__, "threshold", threshold)
        if max_range is not None:
            pulumi.set(__self__, "max_range", max_range)
        if min_range is not None:
            pulumi.set(__self__, "min_range", min_range)

    @property
    @pulumi.getter(name="baselineProviders")
    def baseline_providers(self) -> Sequence['outputs.VerificationTemplateMetricBaselineBaselineProvider']:
        """
        The name of the monitoring tool chosen for the metric.
        """
        return pulumi.get(self, "baseline_providers")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.str:
        """
        A mathematical expression needed for the comparison. Enum: "<" ">" "<=" ">=" "=" "range"
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="maxRange")
    def max_range(self) -> Optional[builtins.int]:
        """
        Number in percent we allow the new version’s data result to be under baseline data result.
        """
        return pulumi.get(self, "max_range")

    @property
    @pulumi.getter(name="minRange")
    def min_range(self) -> Optional[builtins.int]:
        """
        Number in percent we allow the new version’s data result to be under baseline data result.*
        """
        return pulumi.get(self, "min_range")


@pulumi.output_type
class VerificationTemplateMetricBaselineBaselineProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newRelic":
            suggest = "new_relic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricBaselineBaselineProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricBaselineBaselineProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricBaselineBaselineProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datadog: Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderDatadog'] = None,
                 new_relic: Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderNewRelic'] = None,
                 prometheus: Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderPrometheus'] = None):
        """
        :param 'VerificationTemplateMetricBaselineBaselineProviderDatadogArgs' datadog: The datadog provider.
        :param 'VerificationTemplateMetricBaselineBaselineProviderNewRelicArgs' new_relic: The New Relic provider.
        :param 'VerificationTemplateMetricBaselineBaselineProviderPrometheusArgs' prometheus: The Prometheus provider.
        """
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if new_relic is not None:
            pulumi.set(__self__, "new_relic", new_relic)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderDatadog']:
        """
        The datadog provider.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter(name="newRelic")
    def new_relic(self) -> Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderNewRelic']:
        """
        The New Relic provider.
        """
        return pulumi.get(self, "new_relic")

    @property
    @pulumi.getter
    def prometheus(self) -> Optional['outputs.VerificationTemplateMetricBaselineBaselineProviderPrometheus']:
        """
        The Prometheus provider.
        """
        return pulumi.get(self, "prometheus")


@pulumi.output_type
class VerificationTemplateMetricBaselineBaselineProviderDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datadogQuery":
            suggest = "datadog_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricBaselineBaselineProviderDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datadog_query: builtins.str,
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str datadog_query: A request for information retrieved from Datadog.
        :param builtins.str duration: The window of time we are looking at in DataDog.
        """
        pulumi.set(__self__, "datadog_query", datadog_query)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter(name="datadogQuery")
    def datadog_query(self) -> builtins.str:
        """
        A request for information retrieved from Datadog.
        """
        return pulumi.get(self, "datadog_query")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The window of time we are looking at in DataDog.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class VerificationTemplateMetricBaselineBaselineProviderNewRelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newRelicQuery":
            suggest = "new_relic_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricBaselineBaselineProviderNewRelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderNewRelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderNewRelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_relic_query: builtins.str,
                 profile: Optional[builtins.str] = None):
        """
        :param builtins.str new_relic_query: A raw newrelic NRQL query to perform.
        :param builtins.str profile: The name of the secret holding NR account configuration.
        """
        pulumi.set(__self__, "new_relic_query", new_relic_query)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)

    @property
    @pulumi.getter(name="newRelicQuery")
    def new_relic_query(self) -> builtins.str:
        """
        A raw newrelic NRQL query to perform.
        """
        return pulumi.get(self, "new_relic_query")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        """
        The name of the secret holding NR account configuration.
        """
        return pulumi.get(self, "profile")


@pulumi.output_type
class VerificationTemplateMetricBaselineBaselineProviderPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prometheusQuery":
            suggest = "prometheus_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricBaselineBaselineProviderPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricBaselineBaselineProviderPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prometheus_query: builtins.str):
        """
        :param builtins.str prometheus_query: A request for information retrieved from Prometheus.
        """
        pulumi.set(__self__, "prometheus_query", prometheus_query)

    @property
    @pulumi.getter(name="prometheusQuery")
    def prometheus_query(self) -> builtins.str:
        """
        A request for information retrieved from Prometheus.
        """
        return pulumi.get(self, "prometheus_query")


@pulumi.output_type
class VerificationTemplateMetricProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatch":
            suggest = "cloud_watch"
        elif key == "newRelic":
            suggest = "new_relic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch: Optional['outputs.VerificationTemplateMetricProviderCloudWatch'] = None,
                 datadog: Optional['outputs.VerificationTemplateMetricProviderDatadog'] = None,
                 jenkins: Optional['outputs.VerificationTemplateMetricProviderJenkins'] = None,
                 job: Optional['outputs.VerificationTemplateMetricProviderJob'] = None,
                 new_relic: Optional['outputs.VerificationTemplateMetricProviderNewRelic'] = None,
                 prometheus: Optional['outputs.VerificationTemplateMetricProviderPrometheus'] = None,
                 web: Optional['outputs.VerificationTemplateMetricProviderWeb'] = None):
        """
        :param 'VerificationTemplateMetricProviderCloudWatchArgs' cloud_watch: The CloudWatch provider.
        :param 'VerificationTemplateMetricProviderDatadogArgs' datadog: The datadog provider.
        :param 'VerificationTemplateMetricProviderJenkinsArgs' jenkins: The Jenkins provider. Default is "{$}"
        :param 'VerificationTemplateMetricProviderJobArgs' job: The Job provider.
        :param 'VerificationTemplateMetricProviderNewRelicArgs' new_relic: The New Relic provider.
        :param 'VerificationTemplateMetricProviderPrometheusArgs' prometheus: The Prometheus provider.
        :param 'VerificationTemplateMetricProviderWebArgs' web: The Web provider.
        """
        if cloud_watch is not None:
            pulumi.set(__self__, "cloud_watch", cloud_watch)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if jenkins is not None:
            pulumi.set(__self__, "jenkins", jenkins)
        if job is not None:
            pulumi.set(__self__, "job", job)
        if new_relic is not None:
            pulumi.set(__self__, "new_relic", new_relic)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if web is not None:
            pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> Optional['outputs.VerificationTemplateMetricProviderCloudWatch']:
        """
        The CloudWatch provider.
        """
        return pulumi.get(self, "cloud_watch")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.VerificationTemplateMetricProviderDatadog']:
        """
        The datadog provider.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def jenkins(self) -> Optional['outputs.VerificationTemplateMetricProviderJenkins']:
        """
        The Jenkins provider. Default is "{$}"
        """
        return pulumi.get(self, "jenkins")

    @property
    @pulumi.getter
    def job(self) -> Optional['outputs.VerificationTemplateMetricProviderJob']:
        """
        The Job provider.
        """
        return pulumi.get(self, "job")

    @property
    @pulumi.getter(name="newRelic")
    def new_relic(self) -> Optional['outputs.VerificationTemplateMetricProviderNewRelic']:
        """
        The New Relic provider.
        """
        return pulumi.get(self, "new_relic")

    @property
    @pulumi.getter
    def prometheus(self) -> Optional['outputs.VerificationTemplateMetricProviderPrometheus']:
        """
        The Prometheus provider.
        """
        return pulumi.get(self, "prometheus")

    @property
    @pulumi.getter
    def web(self) -> Optional['outputs.VerificationTemplateMetricProviderWeb']:
        """
        The Web provider.
        """
        return pulumi.get(self, "web")


@pulumi.output_type
class VerificationTemplateMetricProviderCloudWatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricDataQueries":
            suggest = "metric_data_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderCloudWatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderCloudWatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderCloudWatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_data_queries: Sequence['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQuery'],
                 duration: Optional[builtins.str] = None):
        """
        :param Sequence['VerificationTemplateMetricProviderCloudWatchMetricDataQueryArgs'] metric_data_queries: The metric queries to be returned. A single MetricData call can include as many as 500 MetricDataQuery structures. Each of these structures can specify either a metric to retrieve, a Metrics Insights query, or a math expression to perform on retrieved data.
        :param builtins.str duration: The window of time we are looking at in CloudWatch.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Sequence['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQuery']:
        """
        The metric queries to be returned. A single MetricData call can include as many as 500 MetricDataQuery structures. Each of these structures can specify either a metric to retrieve, a Metrics Insights query, or a math expression to perform on retrieved data.
        """
        return pulumi.get(self, "metric_data_queries")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The window of time we are looking at in CloudWatch.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class VerificationTemplateMetricProviderCloudWatchMetricDataQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderCloudWatchMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 expression: Optional[builtins.str] = None,
                 label: Optional[builtins.str] = None,
                 metric_stat: Optional['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat'] = None,
                 period: Optional[builtins.int] = None,
                 return_data: Optional[builtins.bool] = None):
        """
        :param builtins.str id: The response ID. Must be unique and not null. This object can contain characters, letters, numbers and underscore. The first letter must be a lowercase letter.
        :param builtins.str expression: This field can contain either a Metrics Insights query, or a metric math expression to be performed on the returned data. Within one metricdataquery object, you must specify either expression or metricstat but not both.
        :param builtins.str label: A human-readable label for this metric or expression. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown
        :param 'VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatArgs' metric_stat: The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.Within one metricdataquery object, you must specify either expression or metricstat but not both.
        :param builtins.int period: The granularity, in seconds, of the returned data points.
        :param builtins.bool return_data: This option indicates whether to return the timestamps and raw data values of this metric. If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify `false`. If you omit this, the default of `true` is used.
        """
        pulumi.set(__self__, "id", id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The response ID. Must be unique and not null. This object can contain characters, letters, numbers and underscore. The first letter must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        This field can contain either a Metrics Insights query, or a metric math expression to be performed on the returned data. Within one metricdataquery object, you must specify either expression or metricstat but not both.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        A human-readable label for this metric or expression. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat']:
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.Within one metricdataquery object, you must specify either expression or metricstat but not both.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.int]:
        """
        The granularity, in seconds, of the returned data points.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[builtins.bool]:
        """
        This option indicates whether to return the timestamps and raw data values of this metric. If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify `false`. If you omit this, the default of `true` is used.
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricPeriod":
            suggest = "metric_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric: Optional['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric'] = None,
                 metric_period: Optional[builtins.int] = None,
                 stat: Optional[builtins.str] = None,
                 unit: Optional[builtins.str] = None):
        """
        :param 'VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricArgs' metric: The metric to return, including the metric name, namespace, and dimensions.
        :param builtins.int metric_period: The granularity, in seconds, of the returned data points.
        :param builtins.str stat: The statistic to return. It can include any CloudWatch statistic or extended statistic.
        :param builtins.str unit: This defines what unit you want to use when storing the metric.  Enum: `"Seconds" "Microseconds" "Milliseconds" "Bytes" "Kilobytes" "Megabytes" "Gigabytes" "Terabytes" "Bits" "Kilobits" "Megabits" "Gigabits" "Terabits" "Percent" "Count" "Bytes/Second" "Kilobytes/Second" "Megabytes/Second" "Gigabytes/Second" "Terabytes/Second" "Bits/Second" "Kilobits/Second" "Megabits/Second" "Gigabits/Second" "Terabits/Second" "Count/Second" "None"`
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_period is not None:
            pulumi.set(__self__, "metric_period", metric_period)
        if stat is not None:
            pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> Optional['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric']:
        """
        The metric to return, including the metric name, namespace, and dimensions.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="metricPeriod")
    def metric_period(self) -> Optional[builtins.int]:
        """
        The granularity, in seconds, of the returned data points.
        """
        return pulumi.get(self, "metric_period")

    @property
    @pulumi.getter
    def stat(self) -> Optional[builtins.str]:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic.
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        This defines what unit you want to use when storing the metric.  Enum: `"Seconds" "Microseconds" "Milliseconds" "Bytes" "Kilobytes" "Megabytes" "Gigabytes" "Terabytes" "Bits" "Kilobits" "Megabits" "Gigabits" "Terabits" "Percent" "Count" "Bytes/Second" "Kilobytes/Second" "Megabytes/Second" "Gigabytes/Second" "Terabytes/Second" "Bits/Second" "Kilobits/Second" "Megabits/Second" "Gigabits/Second" "Terabits/Second" "Count/Second" "None"`
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: builtins.str,
                 dimensions: Optional[Sequence['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension']] = None,
                 namespace: Optional[builtins.str] = None):
        """
        :param builtins.str metric_name: The name of the metric.
        :param Sequence['VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimensionArgs'] dimensions: A dimension is a name/value pair that is part of the identity of a metric.You can assign upto 30 dimensions to a metric
        :param builtins.str namespace: The namespace of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension']]:
        """
        A dimension is a name/value pair that is part of the identity of a metric.You can assign upto 30 dimensions to a metric
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionName":
            suggest = "dimension_name"
        elif key == "dimensionValue":
            suggest = "dimension_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderCloudWatchMetricDataQueryMetricStatMetricDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_name: builtins.str,
                 dimension_value: builtins.str):
        """
        :param builtins.str dimension_name: The name of the dimensions. These values must contain only ASCII characters and must include at least one non-whitespace characte
        :param builtins.str dimension_value: The value of the dimensions.These values must contain only ASCII characters and must include at least one non-whitespace characte
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "dimension_value", dimension_value)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> builtins.str:
        """
        The name of the dimensions. These values must contain only ASCII characters and must include at least one non-whitespace characte
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> builtins.str:
        """
        The value of the dimensions.These values must contain only ASCII characters and must include at least one non-whitespace characte
        """
        return pulumi.get(self, "dimension_value")


@pulumi.output_type
class VerificationTemplateMetricProviderDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datadogQuery":
            suggest = "datadog_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datadog_query: Optional[builtins.str] = None,
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.str datadog_query: A request for information retrieved from Datadog.
        :param builtins.str duration: The window of time we are looking at in DataDog.
        """
        if datadog_query is not None:
            pulumi.set(__self__, "datadog_query", datadog_query)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter(name="datadogQuery")
    def datadog_query(self) -> Optional[builtins.str]:
        """
        A request for information retrieved from Datadog.
        """
        return pulumi.get(self, "datadog_query")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The window of time we are looking at in DataDog.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class VerificationTemplateMetricProviderJenkins(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jenkinsInterval":
            suggest = "jenkins_interval"
        elif key == "pipelineName":
            suggest = "pipeline_name"
        elif key == "jenkinsParameters":
            suggest = "jenkins_parameters"
        elif key == "tlsVerification":
            suggest = "tls_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJenkins. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJenkins.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJenkins.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jenkins_interval: builtins.str,
                 pipeline_name: builtins.str,
                 timeout: builtins.str,
                 jenkins_parameters: Optional['outputs.VerificationTemplateMetricProviderJenkinsJenkinsParameters'] = None,
                 tls_verification: Optional[builtins.bool] = None):
        """
        :param builtins.str jenkins_interval: The interval time to poll status.
        :param builtins.str pipeline_name: The Jenkins pipeline name.
        :param builtins.str timeout: The total jenkins timeout.
        :param 'VerificationTemplateMetricProviderJenkinsJenkinsParametersArgs' jenkins_parameters: List of parameters.
        :param builtins.bool tls_verification: Host TLS verification.
        """
        pulumi.set(__self__, "jenkins_interval", jenkins_interval)
        pulumi.set(__self__, "pipeline_name", pipeline_name)
        pulumi.set(__self__, "timeout", timeout)
        if jenkins_parameters is not None:
            pulumi.set(__self__, "jenkins_parameters", jenkins_parameters)
        if tls_verification is not None:
            pulumi.set(__self__, "tls_verification", tls_verification)

    @property
    @pulumi.getter(name="jenkinsInterval")
    def jenkins_interval(self) -> builtins.str:
        """
        The interval time to poll status.
        """
        return pulumi.get(self, "jenkins_interval")

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> builtins.str:
        """
        The Jenkins pipeline name.
        """
        return pulumi.get(self, "pipeline_name")

    @property
    @pulumi.getter
    def timeout(self) -> builtins.str:
        """
        The total jenkins timeout.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="jenkinsParameters")
    def jenkins_parameters(self) -> Optional['outputs.VerificationTemplateMetricProviderJenkinsJenkinsParameters']:
        """
        List of parameters.
        """
        return pulumi.get(self, "jenkins_parameters")

    @property
    @pulumi.getter(name="tlsVerification")
    def tls_verification(self) -> Optional[builtins.bool]:
        """
        Host TLS verification.
        """
        return pulumi.get(self, "tls_verification")


@pulumi.output_type
class VerificationTemplateMetricProviderJenkinsJenkinsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterKey":
            suggest = "parameter_key"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJenkinsJenkinsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJenkinsJenkinsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJenkinsJenkinsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_key: builtins.str,
                 parameter_value: builtins.str):
        """
        :param builtins.str parameter_key: Key of an argument.
        :param builtins.str parameter_value: Value of an argument.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> builtins.str:
        """
        Key of an argument.
        """
        return pulumi.get(self, "parameter_key")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> builtins.str:
        """
        Value of an argument.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class VerificationTemplateMetricProviderJob(dict):
    def __init__(__self__, *,
                 specs: Sequence['outputs.VerificationTemplateMetricProviderJobSpec']):
        """
        :param Sequence['VerificationTemplateMetricProviderJobSpecArgs'] specs: The job spec require to run the metric.
        """
        pulumi.set(__self__, "specs", specs)

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.VerificationTemplateMetricProviderJobSpec']:
        """
        The job spec require to run the metric.
        """
        return pulumi.get(self, "specs")


@pulumi.output_type
class VerificationTemplateMetricProviderJobSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobTemplates":
            suggest = "job_templates"
        elif key == "backoffLimit":
            suggest = "backoff_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJobSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJobSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJobSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_templates: Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplate'],
                 backoff_limit: Optional[builtins.int] = None):
        """
        :param Sequence['VerificationTemplateMetricProviderJobSpecJobTemplateArgs'] job_templates: Describes the pod that will be created when executing a job.
        :param builtins.int backoff_limit: Specifies the number of retries before marking this job failed.
        """
        pulumi.set(__self__, "job_templates", job_templates)
        if backoff_limit is not None:
            pulumi.set(__self__, "backoff_limit", backoff_limit)

    @property
    @pulumi.getter(name="jobTemplates")
    def job_templates(self) -> Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplate']:
        """
        Describes the pod that will be created when executing a job.
        """
        return pulumi.get(self, "job_templates")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> Optional[builtins.int]:
        """
        Specifies the number of retries before marking this job failed.
        """
        return pulumi.get(self, "backoff_limit")


@pulumi.output_type
class VerificationTemplateMetricProviderJobSpecJobTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateSpecs":
            suggest = "template_specs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJobSpecJobTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template_specs: Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec']):
        """
        :param Sequence['VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecArgs'] template_specs: Specification of the desired behavior of the pod.
        """
        pulumi.set(__self__, "template_specs", template_specs)

    @property
    @pulumi.getter(name="templateSpecs")
    def template_specs(self) -> Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec']:
        """
        Specification of the desired behavior of the pod.
        """
        return pulumi.get(self, "template_specs")


@pulumi.output_type
class VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer'],
                 restart_policy: builtins.str):
        """
        :param Sequence['VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainerArgs'] containers: A list of containers belonging to the pod.
        :param builtins.str restart_policy: Restart policy for all containers within the pod. Enum: `"Never" "OnFailure"`
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "restart_policy", restart_policy)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer']:
        """
        A list of containers belonging to the pod.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> builtins.str:
        """
        Restart policy for all containers within the pod. Enum: `"Never" "OnFailure"`
        """
        return pulumi.get(self, "restart_policy")


@pulumi.output_type
class VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderJobSpecJobTemplateTemplateSpecContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Sequence[builtins.str],
                 container_name: builtins.str,
                 image: builtins.str):
        """
        :param Sequence[builtins.str] commands: The entry point of a container.
        :param builtins.str container_name: The name of a container.
        :param builtins.str image: The image name of a container.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        """
        The entry point of a container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        The name of a container.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The image name of a container.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class VerificationTemplateMetricProviderNewRelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newRelicQuery":
            suggest = "new_relic_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderNewRelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderNewRelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderNewRelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_relic_query: builtins.str,
                 profile: Optional[builtins.str] = None):
        """
        :param builtins.str new_relic_query: A raw newrelic NRQL query to perform.
        :param builtins.str profile: The name of the secret holding NR account configuration.
        """
        pulumi.set(__self__, "new_relic_query", new_relic_query)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)

    @property
    @pulumi.getter(name="newRelicQuery")
    def new_relic_query(self) -> builtins.str:
        """
        A raw newrelic NRQL query to perform.
        """
        return pulumi.get(self, "new_relic_query")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        """
        The name of the secret holding NR account configuration.
        """
        return pulumi.get(self, "profile")


@pulumi.output_type
class VerificationTemplateMetricProviderPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prometheusQuery":
            suggest = "prometheus_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prometheus_query: builtins.str):
        """
        :param builtins.str prometheus_query: A request for information retrieved from Prometheus.
        """
        pulumi.set(__self__, "prometheus_query", prometheus_query)

    @property
    @pulumi.getter(name="prometheusQuery")
    def prometheus_query(self) -> builtins.str:
        """
        A request for information retrieved from Prometheus.
        """
        return pulumi.get(self, "prometheus_query")


@pulumi.output_type
class VerificationTemplateMetricProviderWeb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "webHeaders":
            suggest = "web_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderWeb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderWeb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderWeb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 body: Optional[builtins.str] = None,
                 insecure: Optional[builtins.bool] = None,
                 json_path: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None,
                 timeout_seconds: Optional[builtins.int] = None,
                 web_headers: Optional[Sequence['outputs.VerificationTemplateMetricProviderWebWebHeader']] = None):
        """
        :param builtins.str url: The address of the web metric.
        :param builtins.str body: The body of the web metric.
        :param builtins.bool insecure: Skips host TLS verification.
        :param builtins.str json_path: A JSON Path to use as the result variable. Default is "{$}"
        :param builtins.str method: The method of the web metric.  Enum: "GET" "POST" "PUT"
        :param builtins.int timeout_seconds: The timeout for the request in seconds. Default is 10.
        :param Sequence['VerificationTemplateMetricProviderWebWebHeaderArgs'] web_headers: Optional HTTP headers to use in the request.
        """
        pulumi.set(__self__, "url", url)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if web_headers is not None:
            pulumi.set(__self__, "web_headers", web_headers)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The address of the web metric.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def body(self) -> Optional[builtins.str]:
        """
        The body of the web metric.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[builtins.bool]:
        """
        Skips host TLS verification.
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[builtins.str]:
        """
        A JSON Path to use as the result variable. Default is "{$}"
        """
        return pulumi.get(self, "json_path")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        The method of the web metric.  Enum: "GET" "POST" "PUT"
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        The timeout for the request in seconds. Default is 10.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter(name="webHeaders")
    def web_headers(self) -> Optional[Sequence['outputs.VerificationTemplateMetricProviderWebWebHeader']]:
        """
        Optional HTTP headers to use in the request.
        """
        return pulumi.get(self, "web_headers")


@pulumi.output_type
class VerificationTemplateMetricProviderWebWebHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webHeaderKey":
            suggest = "web_header_key"
        elif key == "webHeaderValue":
            suggest = "web_header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VerificationTemplateMetricProviderWebWebHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VerificationTemplateMetricProviderWebWebHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VerificationTemplateMetricProviderWebWebHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_header_key: builtins.str,
                 web_header_value: builtins.str):
        """
        :param builtins.str web_header_key: The name of a header
        :param builtins.str web_header_value: The value of a header
        """
        pulumi.set(__self__, "web_header_key", web_header_key)
        pulumi.set(__self__, "web_header_value", web_header_value)

    @property
    @pulumi.getter(name="webHeaderKey")
    def web_header_key(self) -> builtins.str:
        """
        The name of a header
        """
        return pulumi.get(self, "web_header_key")

    @property
    @pulumi.getter(name="webHeaderValue")
    def web_header_value(self) -> builtins.str:
        """
        The value of a header
        """
        return pulumi.get(self, "web_header_value")


