# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OceanComputeArgs',
    'OceanComputeArgsDict',
    'OceanIngressArgs',
    'OceanIngressArgsDict',
    'OceanIngressControllerArgs',
    'OceanIngressControllerArgsDict',
    'OceanIngressCustomEndpointArgs',
    'OceanIngressCustomEndpointArgsDict',
    'OceanIngressLoadBalancerArgs',
    'OceanIngressLoadBalancerArgsDict',
    'OceanIngressPrivateLinkArgs',
    'OceanIngressPrivateLinkArgsDict',
    'OceanLogCollectionArgs',
    'OceanLogCollectionArgsDict',
    'OceanSparkArgs',
    'OceanSparkArgsDict',
    'OceanWebhookArgs',
    'OceanWebhookArgsDict',
    'OceanWorkspacesArgs',
    'OceanWorkspacesArgsDict',
    'OceanWorkspacesStorageArgs',
    'OceanWorkspacesStorageArgsDict',
    'OceanWorkspacesStorageDefaultsArgs',
    'OceanWorkspacesStorageDefaultsArgsDict',
]

MYPY = False

if not MYPY:
    class OceanComputeArgsDict(TypedDict):
        create_vngs: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Enable/disable the creation of Ocean Spark VNGs during cluster creation.
        """
        use_taints: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Enable/disable Ocean Spark taints on the Ocean Spark VNGs. By default, Ocean Spark uses taints to prevent non-Spark workloads from running on Ocean Spark VNGs.
        """
elif False:
    OceanComputeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanComputeArgs:
    def __init__(__self__, *,
                 create_vngs: Optional[pulumi.Input[builtins.bool]] = None,
                 use_taints: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] create_vngs: - Enable/disable the creation of Ocean Spark VNGs during cluster creation.
        :param pulumi.Input[builtins.bool] use_taints: - Enable/disable Ocean Spark taints on the Ocean Spark VNGs. By default, Ocean Spark uses taints to prevent non-Spark workloads from running on Ocean Spark VNGs.
        """
        if create_vngs is not None:
            pulumi.set(__self__, "create_vngs", create_vngs)
        if use_taints is not None:
            pulumi.set(__self__, "use_taints", use_taints)

    @property
    @pulumi.getter(name="createVngs")
    def create_vngs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Enable/disable the creation of Ocean Spark VNGs during cluster creation.
        """
        return pulumi.get(self, "create_vngs")

    @create_vngs.setter
    def create_vngs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_vngs", value)

    @property
    @pulumi.getter(name="useTaints")
    def use_taints(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Enable/disable Ocean Spark taints on the Ocean Spark VNGs. By default, Ocean Spark uses taints to prevent non-Spark workloads from running on Ocean Spark VNGs.
        """
        return pulumi.get(self, "use_taints")

    @use_taints.setter
    def use_taints(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_taints", value)


if not MYPY:
    class OceanIngressArgsDict(TypedDict):
        controller: NotRequired[pulumi.Input['OceanIngressControllerArgsDict']]
        custom_endpoint: NotRequired[pulumi.Input['OceanIngressCustomEndpointArgsDict']]
        load_balancer: NotRequired[pulumi.Input['OceanIngressLoadBalancerArgsDict']]
        private_link: NotRequired[pulumi.Input['OceanIngressPrivateLinkArgsDict']]
        service_annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        - **DEPRECATED**: Use `load_balancer.service_annotations` instead.
        """
elif False:
    OceanIngressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanIngressArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input['OceanIngressControllerArgs']] = None,
                 custom_endpoint: Optional[pulumi.Input['OceanIngressCustomEndpointArgs']] = None,
                 load_balancer: Optional[pulumi.Input['OceanIngressLoadBalancerArgs']] = None,
                 private_link: Optional[pulumi.Input['OceanIngressPrivateLinkArgs']] = None,
                 service_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] service_annotations: - **DEPRECATED**: Use `load_balancer.service_annotations` instead.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if service_annotations is not None:
            pulumi.set(__self__, "service_annotations", service_annotations)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input['OceanIngressControllerArgs']]:
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input['OceanIngressControllerArgs']]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['OceanIngressCustomEndpointArgs']]:
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['OceanIngressCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['OceanIngressLoadBalancerArgs']]:
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['OceanIngressLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[pulumi.Input['OceanIngressPrivateLinkArgs']]:
        return pulumi.get(self, "private_link")

    @private_link.setter
    def private_link(self, value: Optional[pulumi.Input['OceanIngressPrivateLinkArgs']]):
        pulumi.set(self, "private_link", value)

    @property
    @pulumi.getter(name="serviceAnnotations")
    def service_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        - **DEPRECATED**: Use `load_balancer.service_annotations` instead.
        """
        return pulumi.get(self, "service_annotations")

    @service_annotations.setter
    def service_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_annotations", value)


if not MYPY:
    class OceanIngressControllerArgsDict(TypedDict):
        managed: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Should an ingress controller managed by Ocean for Apache Spark be installed on the cluster.
        """
elif False:
    OceanIngressControllerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanIngressControllerArgs:
    def __init__(__self__, *,
                 managed: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] managed: - Should an ingress controller managed by Ocean for Apache Spark be installed on the cluster.
        """
        if managed is not None:
            pulumi.set(__self__, "managed", managed)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Should an ingress controller managed by Ocean for Apache Spark be installed on the cluster.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "managed", value)


if not MYPY:
    class OceanIngressCustomEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        - The address the Ocean for Apache Spark control plane will use when addressing the cluster.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Should the Ocean for Apache Spark control plane address the cluster using a custom endpoint. Use this to specify the DNS address of an externally provisioned (unmanaged) load balancer.
        """
elif False:
    OceanIngressCustomEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanIngressCustomEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] address: - The address the Ocean for Apache Spark control plane will use when addressing the cluster.
        :param pulumi.Input[builtins.bool] enabled: - Should the Ocean for Apache Spark control plane address the cluster using a custom endpoint. Use this to specify the DNS address of an externally provisioned (unmanaged) load balancer.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - The address the Ocean for Apache Spark control plane will use when addressing the cluster.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Should the Ocean for Apache Spark control plane address the cluster using a custom endpoint. Use this to specify the DNS address of an externally provisioned (unmanaged) load balancer.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class OceanIngressLoadBalancerArgsDict(TypedDict):
        managed: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Should a load balancer managed by Ocean for Apache Spark be provisioned for the cluster. Set this to false if you want to use an existing load balancer (only available on AWS).
        """
        service_annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        - Annotations to add to the ingress controller load balancer service. This is useful to configure properties of the managed load balancer, like the nature of the load balancer (e.g. ELB, NLB, ALB on AWS), the security groups, or various timeouts.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        - The ARN of a target group that the Ocean for Apache Spark ingress controller will be bound to. Set this to use an existing load balancer with Ocean for Apache Spark. Has no effect if using a managed load balancer. Only available on AWS.
        """
elif False:
    OceanIngressLoadBalancerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanIngressLoadBalancerArgs:
    def __init__(__self__, *,
                 managed: Optional[pulumi.Input[builtins.bool]] = None,
                 service_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] managed: - Should a load balancer managed by Ocean for Apache Spark be provisioned for the cluster. Set this to false if you want to use an existing load balancer (only available on AWS).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] service_annotations: - Annotations to add to the ingress controller load balancer service. This is useful to configure properties of the managed load balancer, like the nature of the load balancer (e.g. ELB, NLB, ALB on AWS), the security groups, or various timeouts.
        :param pulumi.Input[builtins.str] target_group_arn: - The ARN of a target group that the Ocean for Apache Spark ingress controller will be bound to. Set this to use an existing load balancer with Ocean for Apache Spark. Has no effect if using a managed load balancer. Only available on AWS.
        """
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if service_annotations is not None:
            pulumi.set(__self__, "service_annotations", service_annotations)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Should a load balancer managed by Ocean for Apache Spark be provisioned for the cluster. Set this to false if you want to use an existing load balancer (only available on AWS).
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="serviceAnnotations")
    def service_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        - Annotations to add to the ingress controller load balancer service. This is useful to configure properties of the managed load balancer, like the nature of the load balancer (e.g. ELB, NLB, ALB on AWS), the security groups, or various timeouts.
        """
        return pulumi.get(self, "service_annotations")

    @service_annotations.setter
    def service_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_annotations", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - The ARN of a target group that the Ocean for Apache Spark ingress controller will be bound to. Set this to use an existing load balancer with Ocean for Apache Spark. Has no effect if using a managed load balancer. Only available on AWS.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)


if not MYPY:
    class OceanIngressPrivateLinkArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Should the Ocean for Apache Spark control plane address the cluster via an AWS Private Link. Only available on AWS.
        """
        vpc_endpoint_service: NotRequired[pulumi.Input[builtins.str]]
        """
        - The name of the VPC Endpoint Service the Ocean for Apache Spark control plane should bind to.
        """
elif False:
    OceanIngressPrivateLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanIngressPrivateLinkArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_endpoint_service: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: - Should the Ocean for Apache Spark control plane address the cluster via an AWS Private Link. Only available on AWS.
        :param pulumi.Input[builtins.str] vpc_endpoint_service: - The name of the VPC Endpoint Service the Ocean for Apache Spark control plane should bind to.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if vpc_endpoint_service is not None:
            pulumi.set(__self__, "vpc_endpoint_service", vpc_endpoint_service)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Should the Ocean for Apache Spark control plane address the cluster via an AWS Private Link. Only available on AWS.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="vpcEndpointService")
    def vpc_endpoint_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - The name of the VPC Endpoint Service the Ocean for Apache Spark control plane should bind to.
        """
        return pulumi.get(self, "vpc_endpoint_service")

    @vpc_endpoint_service.setter
    def vpc_endpoint_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_endpoint_service", value)


if not MYPY:
    class OceanLogCollectionArgsDict(TypedDict):
        collect_app_logs: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Enable/Disable collecting driver and executor logs. When enabled, logs are stored by NetApp and can be downloaded from the Spot console web interface. The logs are deleted after 30 days.
        """
elif False:
    OceanLogCollectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLogCollectionArgs:
    def __init__(__self__, *,
                 collect_app_logs: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] collect_app_logs: - Enable/Disable collecting driver and executor logs. When enabled, logs are stored by NetApp and can be downloaded from the Spot console web interface. The logs are deleted after 30 days.
        """
        if collect_app_logs is not None:
            pulumi.set(__self__, "collect_app_logs", collect_app_logs)

    @property
    @pulumi.getter(name="collectAppLogs")
    def collect_app_logs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Enable/Disable collecting driver and executor logs. When enabled, logs are stored by NetApp and can be downloaded from the Spot console web interface. The logs are deleted after 30 days.
        """
        return pulumi.get(self, "collect_app_logs")

    @collect_app_logs.setter
    def collect_app_logs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "collect_app_logs", value)


if not MYPY:
    class OceanSparkArgsDict(TypedDict):
        additional_app_namespaces: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        - List of Kubernetes namespaces that should be configured to run Spark applications, in addition to the default Spark application namespace `spark-apps`.
        """
elif False:
    OceanSparkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanSparkArgs:
    def __init__(__self__, *,
                 additional_app_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_app_namespaces: - List of Kubernetes namespaces that should be configured to run Spark applications, in addition to the default Spark application namespace `spark-apps`.
        """
        if additional_app_namespaces is not None:
            pulumi.set(__self__, "additional_app_namespaces", additional_app_namespaces)

    @property
    @pulumi.getter(name="additionalAppNamespaces")
    def additional_app_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        - List of Kubernetes namespaces that should be configured to run Spark applications, in addition to the default Spark application namespace `spark-apps`.
        """
        return pulumi.get(self, "additional_app_namespaces")

    @additional_app_namespaces.setter
    def additional_app_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_app_namespaces", value)


if not MYPY:
    class OceanWebhookArgsDict(TypedDict):
        host_network_ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        - List of ports allowed to use on the host network - if empty default is `25554`.
        """
        use_host_network: NotRequired[pulumi.Input[builtins.bool]]
        """
        - Enable/disable host networking for the Spark Operator. Host networking can be useful when using custom CNI plugins like Calico on EKS.
        """
elif False:
    OceanWebhookArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanWebhookArgs:
    def __init__(__self__, *,
                 host_network_ports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 use_host_network: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] host_network_ports: - List of ports allowed to use on the host network - if empty default is `25554`.
        :param pulumi.Input[builtins.bool] use_host_network: - Enable/disable host networking for the Spark Operator. Host networking can be useful when using custom CNI plugins like Calico on EKS.
        """
        if host_network_ports is not None:
            pulumi.set(__self__, "host_network_ports", host_network_ports)
        if use_host_network is not None:
            pulumi.set(__self__, "use_host_network", use_host_network)

    @property
    @pulumi.getter(name="hostNetworkPorts")
    def host_network_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        - List of ports allowed to use on the host network - if empty default is `25554`.
        """
        return pulumi.get(self, "host_network_ports")

    @host_network_ports.setter
    def host_network_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "host_network_ports", value)

    @property
    @pulumi.getter(name="useHostNetwork")
    def use_host_network(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        - Enable/disable host networking for the Spark Operator. Host networking can be useful when using custom CNI plugins like Calico on EKS.
        """
        return pulumi.get(self, "use_host_network")

    @use_host_network.setter
    def use_host_network(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_host_network", value)


if not MYPY:
    class OceanWorkspacesArgsDict(TypedDict):
        storage: NotRequired[pulumi.Input['OceanWorkspacesStorageArgsDict']]
elif False:
    OceanWorkspacesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanWorkspacesArgs:
    def __init__(__self__, *,
                 storage: Optional[pulumi.Input['OceanWorkspacesStorageArgs']] = None):
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['OceanWorkspacesStorageArgs']]:
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['OceanWorkspacesStorageArgs']]):
        pulumi.set(self, "storage", value)


if not MYPY:
    class OceanWorkspacesStorageArgsDict(TypedDict):
        defaults: NotRequired[pulumi.Input['OceanWorkspacesStorageDefaultsArgsDict']]
elif False:
    OceanWorkspacesStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanWorkspacesStorageArgs:
    def __init__(__self__, *,
                 defaults: Optional[pulumi.Input['OceanWorkspacesStorageDefaultsArgs']] = None):
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)

    @property
    @pulumi.getter
    def defaults(self) -> Optional[pulumi.Input['OceanWorkspacesStorageDefaultsArgs']]:
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: Optional[pulumi.Input['OceanWorkspacesStorageDefaultsArgs']]):
        pulumi.set(self, "defaults", value)


if not MYPY:
    class OceanWorkspacesStorageDefaultsArgsDict(TypedDict):
        storage_class_name: NotRequired[pulumi.Input[builtins.str]]
        """
        - The name of the default storage class to use for new workspaces. If not specified, the default storage class of the Kubernetes cluster will be used.
        """
elif False:
    OceanWorkspacesStorageDefaultsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanWorkspacesStorageDefaultsArgs:
    def __init__(__self__, *,
                 storage_class_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] storage_class_name: - The name of the default storage class to use for new workspaces. If not specified, the default storage class of the Kubernetes cluster will be used.
        """
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)

    @property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - The name of the default storage class to use for new workspaces. If not specified, the default storage class of the Kubernetes cluster will be used.
        """
        return pulumi.get(self, "storage_class_name")

    @storage_class_name.setter
    def storage_class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_class_name", value)


