(cli)=

# `vak` command-line interface

`vak` provides a command-line interface for users to run commands.
This section documents all the available commands.

You can list all these commands at the command line by running `vak -h`,
which will print out the following message:

```bash
$ vak -h
usage: vak [-h] command configfile

vak command-line interface

positional arguments:
  command     Command to run, valid options are:
              ('prep', 'train', 'eval', 'predict', 'learncurve')
              $ vak train ./configs/config_2018-12-17.toml
  configfile  name of config.toml file to use
              $ vak train ./configs/config_2018-12-17.toml
```

As the message states, all commands will have the format `vak command configfile`,
e.g., `$ vak train ./configs/config_2018-12-17.toml`.
The `command` will be one of those described here, and `configfile` is a `.toml`
configuration file as described in {ref}`config`.

## `prep`

Prepares a dataset.
Produces a `.csv` file representing the dataset,
that is used by other commands when they run.
This command may also generate spectrogram from audio files,
when this is specified in the configuration file.

In general, the workflow for the command-line interface
is to first run `vak prep` for every configuration file,
and then run another command that will use the dataset
prepared by `vak prep`.

## `train`

Train a single model.
Trains the model specified in the configuration file,
using a dataset generated by running `vak prep`.

## `eval`

Evaluate a single trained model.
Computes evaluation metrics for the trained model
using a dataset generated by running `vak prep`,
as specified in the configuration file.

## `predict`

Generate predictions using a trained model.
Saves the output of the model,
and applies any post-processing specified in the configuration file,
using a dataset generated by running `vak prep`.

## `learncurve`

Generate data for a learning curve
that plots model performance
as a function of training set size.

Trains a model with multiple training set durations
and multiple randomly-drawn training sets for each duration,
and evaluates all trained models
on a fixed test set.

The total training, test, and validation set
are generated by first running `vak prep`,
and then subsets are randomly drawn from the training set
when running `vak learncurve`.
