"""tests for vak.common.files.files.files module"""
import itertools

import pytest

import vak.common.files.files

from ...fixtures.spect import (
    SPECT_LIST_MAT,
    SPECT_LIST_NPZ,
)

SPECT_FNAME_LIST_MAT = [
    spect_path.name for spect_path in SPECT_LIST_MAT
] + [
    # duplicate list but replace underscores in filenames with spaces to test handling spaces
    spect_path.name.replace('_', ' ') for spect_path in SPECT_LIST_MAT
]

SPECT_FNAME_LIST_NPZ = [
    spect_path.name for spect_path in SPECT_LIST_NPZ
] + [
    spect_path.name.replace('_', ' ') for spect_path in SPECT_LIST_NPZ
]

SPECT_FNAME_LIST_MAT_WITH_EXT = list(zip(
    SPECT_FNAME_LIST_MAT,
    itertools.repeat('.wav'),
    itertools.repeat('.mat'),
))

SPECT_FNAME_LIST_NPZ_WITH_EXT = list(zip(
    SPECT_FNAME_LIST_NPZ,
    itertools.repeat('.cbin'),
    itertools.repeat('.spect.npz'),
))

TEST_FIND_FNAME_PARAMETRIZE = SPECT_FNAME_LIST_MAT_WITH_EXT + SPECT_FNAME_LIST_NPZ_WITH_EXT


@pytest.mark.parametrize(
    'fname, find_ext, spect_ext',
    TEST_FIND_FNAME_PARAMETRIZE
)
def test_find_fname(fname, find_ext, spect_ext):
    """Test ``vak.common.files.files.find_fname`` works as expected."""
    expected = fname.replace(spect_ext, '')

    out = vak.common.files.files.find_fname(fname, find_ext)

    assert fname.startswith(out)
    assert out == expected


def test_files_from_dir_with_mat(spect_dir_mat, spect_list_mat):
    files = vak.common.files.files.from_dir(spect_dir_mat, "mat")
    # files.from_dir returns str not Path, need to convert fixture
    spect_list_mat = [str(spect_path) for spect_path in spect_list_mat]
    assert sorted(spect_list_mat) == sorted(files)


def test_files_from_dir_with_cbin(audio_dir_cbin, audio_list_cbin):
    files = vak.common.files.files.from_dir(audio_dir_cbin, "cbin")
    # files.from_dir returns str not Path, need to convert fixture
    audio_list_cbin = [str(audio_path) for audio_path in audio_list_cbin]
    assert sorted(audio_list_cbin) == sorted(files)
