import pytest
import os
from pathlib import Path
from multi_instance_pipeline import get_flow
from pydiverse.pipedag.core.config import PipedagConfig


@pytest.fixture(scope="function")
def cfg_file_path(request):
    password_cfg_path = str(Path(__file__).parent / "postgres_password.yaml")

    old_environ = dict(os.environ)
    os.environ["POSTGRES_PASSWORD_CFG"] = password_cfg_path

    yield Path(__file__).parent / "pipedag.yaml"

    os.environ.clear()
    os.environ.update(old_environ)


@pytest.mark.pipedag
def test_run_midi_instance(cfg_file_path):
    pipedag_config = PipedagConfig(cfg_file_path)
    cfg = pipedag_config.get(instance="midi")

    flow, out1, out2 = get_flow(cfg.attrs, pipedag_config)

    flow.run(config=cfg)


@pytest.mark.pipedag
def test_run_mini_instance(cfg_file_path):
    pipedag_config = PipedagConfig(cfg_file_path)
    cfg = pipedag_config.get(instance="midi")

    flow, out1, out2 = get_flow(cfg.attrs, pipedag_config)

    flow.run(config=cfg)
