import { cn } from "@/lib/utils";

type LogoProps = {
  className?: string;
};

export const GoogleLogo: React.FC<LogoProps> = ({ className }) => (
  <svg
    className={cn("w-5 h-5", className)}
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M16.2856 13.4546V18.8764H23.974C23.6364 20.62 22.6233 22.0964 21.1038 23.0891L25.7402 26.6146C28.4415 24.1711 30 20.582 30 16.3184C30 15.3257 29.9091 14.371 29.7402 13.4547L16.2856 13.4546Z"
      fill="#4285F4"
    />

    <path
      d="M8.27956 18.6646L7.23387 19.449L3.53247 22.2744C5.88314 26.8434 10.701 29.9998 16.2855 29.9998C20.1425 29.9998 23.3763 28.7525 25.74 26.6144L21.1036 23.089C19.8309 23.9289 18.2075 24.4381 16.2855 24.4381C12.5711 24.4381 9.41536 21.9817 8.2854 18.6726L8.27956 18.6646Z"
      fill="#34A853"
    />

    <path
      d="M3.53237 9.72559C2.55839 11.6091 2 13.7346 2 16C2 18.2654 2.55839 20.3909 3.53237 22.2745C3.53237 22.2871 8.28576 18.6599 8.28576 18.6599C8.00004 17.8199 7.83116 16.9291 7.83116 15.9999C7.83116 15.0707 8.00004 14.1798 8.28576 13.3398L3.53237 9.72559Z"
      fill="#FBBC05"
    />

    <path
      d="M16.2858 7.57452C18.3897 7.57452 20.2598 8.28723 21.7533 9.66179L25.8443 5.65276C23.3637 3.38735 20.143 2 16.2858 2C10.7013 2 5.88314 5.14362 3.53247 9.72544L8.28571 13.34C9.41552 10.0309 12.5714 7.57452 16.2858 7.57452Z"
      fill="#EA4335"
    />
  </svg>
);

export const AppleLogo: React.FC<LogoProps> = ({ className }) => (
  <svg
    className={cn("w-5 h-5 fill-black dark:fill-white", className)}
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M22.5475 16.0837C22.5813 19.7157 25.7337 20.9243 25.7687 20.9397C25.742 21.0249 25.2649 22.6621 24.1078 24.3532C23.1074 25.8152 22.0693 27.2718 20.4338 27.302C18.8268 27.3316 18.3101 26.3491 16.4728 26.3491C14.6361 26.3491 14.062 27.2719 12.5408 27.3317C10.9622 27.3914 9.76003 25.7507 8.75145 24.294C6.69045 21.3143 5.11542 15.8742 7.23028 12.202C8.2809 10.3784 10.1584 9.22356 12.1963 9.19394C13.7465 9.16437 15.2097 10.2368 16.1573 10.2368C17.1044 10.2368 18.8825 8.9471 20.7517 9.13652C21.5342 9.16909 23.7308 9.45261 25.1412 11.5172C25.0276 11.5876 22.5203 13.0472 22.5475 16.0837ZM19.5274 7.16521C20.3655 6.15072 20.9296 4.73845 20.7757 3.33325C19.5676 3.38181 18.1068 4.13827 17.2403 5.15221C16.4637 6.0501 15.7836 7.48722 15.9671 8.86461C17.3136 8.96879 18.6892 8.18035 19.5274 7.16521Z" />
  </svg>
);

export const GithubLogo: React.FC<LogoProps> = ({ className }) => (
  <svg
    className={cn("w-5 h-5 dark:fill-white", className)}
    width="32"
    height="32"
    viewBox="0 0 32 32"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M16.0099 4C9.36875 4 4 9.49998 4 16.3042C4 21.7432 7.43994 26.3472 12.2121 27.9767C12.8087 28.0991 13.0272 27.7119 13.0272 27.3862C13.0272 27.1009 13.0076 26.1232 13.0076 25.1044C9.6667 25.8379 8.97099 23.6377 8.97099 23.6377C8.43409 22.2117 7.63858 21.8452 7.63858 21.8452C6.54511 21.0914 7.71823 21.0914 7.71823 21.0914C8.93117 21.1729 9.56763 22.3544 9.56763 22.3544C10.6412 24.2284 12.3711 23.6989 13.0671 23.3729C13.1664 22.5784 13.4847 22.0284 13.8228 21.7229C11.1582 21.4377 8.35469 20.3784 8.35469 15.6522C8.35469 14.3077 8.8316 13.2077 9.58729 12.3522C9.46807 12.0467 9.0504 10.7835 9.70677 9.09273C9.70677 9.09273 10.7208 8.76673 13.0073 10.3557C13.9863 10.0864 14.9958 9.94938 16.0099 9.94823C17.024 9.94823 18.0577 10.091 19.0123 10.3557C21.299 8.76673 22.3131 9.09273 22.3131 9.09273C22.9695 10.7835 22.5515 12.0467 22.4323 12.3522C23.2079 13.2077 23.6652 14.3077 23.6652 15.6522C23.6652 20.3784 20.8617 21.4172 18.1772 21.7229C18.6148 22.1099 18.9924 22.8432 18.9924 24.0044C18.9924 25.6544 18.9727 26.9787 18.9727 27.3859C18.9727 27.7119 19.1915 28.0991 19.7879 27.9769C24.56 26.3469 27.9999 21.7432 27.9999 16.3042C28.0196 9.49998 22.6312 4 16.0099 4Z"
    />
  </svg>
);
