import * as cdk from '@aws-cdk/core';
/**
 * Behavioral Interface for the Properties of a P6Barrier.
 *
 * @stability stable
 */
export interface IP6BarrierProps {
    /**
     * CloudFormation Name.
     *
     * @stability stable
     */
    name: string;
    /**
     * What am I the barrier for.
     *
     * @stability stable
     */
    dependencies: cdk.Construct[];
    /**
     * The Function Arn.
     *
     * @stability stable
     */
    functionArn: string;
}
/**
 * @stability stable
 */
export declare class P6Barrier extends cdk.Resource {
    /**
     *
     */
    private readonly readyBarrier;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: IP6BarrierProps);
    /**
     * @stability stable
     */
    addDependency(dependencies: cdk.Construct[]): void;
}
