WORKS_SCHEMA = {
    "id": "VARCHAR",
    "doi": "VARCHAR",
    "title": "VARCHAR",
    "display_name": "VARCHAR",
    "publication_year": "BIGINT",
    "publication_date": "VARCHAR",
    "ids": "STRUCT(openalex VARCHAR, doi VARCHAR, mag VARCHAR, pmid VARCHAR, pmcid VARCHAR)",
    "language": "VARCHAR",
    "primary_location": "STRUCT(is_oa BOOLEAN, landing_page_url VARCHAR, pdf_url VARCHAR, source STRUCT(id VARCHAR, display_name VARCHAR, issn_l VARCHAR, issn VARCHAR[], is_oa BOOLEAN, is_in_doaj BOOLEAN, is_indexed_in_scopus BOOLEAN, is_core BOOLEAN, host_organization VARCHAR, host_organization_name VARCHAR, host_organization_lineage VARCHAR[], host_organization_lineage_names VARCHAR[], type VARCHAR), license VARCHAR, license_id VARCHAR, is_accepted BOOLEAN, is_published BOOLEAN)",
    "type": "VARCHAR",
    "type_crossref": "VARCHAR",
    "indexed_in": "VARCHAR[]",
    "open_access": "STRUCT(is_oa BOOLEAN, oa_status VARCHAR, oa_url VARCHAR, any_repository_has_fulltext BOOLEAN)",
    "authorships": "STRUCT(author_position VARCHAR, author STRUCT(id VARCHAR, display_name VARCHAR, orcid VARCHAR), institutions STRUCT(id VARCHAR, display_name VARCHAR, ror VARCHAR, country_code VARCHAR, type VARCHAR, lineage VARCHAR[])[], countries VARCHAR[], is_corresponding BOOLEAN, raw_author_name VARCHAR, raw_affiliation_strings VARCHAR[], affiliations STRUCT(raw_affiliation_string VARCHAR, institution_ids VARCHAR[])[])[]",
    # "abstract_inverted_index": "MAP(VARCHAR, BIGINT[])",
    "abstract_inverted_index": "JSON",
    "institution_assertions": "VARCHAR[]",
    "countries_distinct_count": "BIGINT",
    "institutions_distinct_count": "BIGINT",
    "corresponding_author_ids": "VARCHAR[]",
    "corresponding_institution_ids": "VARCHAR[]",
    "apc_list": "STRUCT(value BIGINT, currency VARCHAR, value_usd BIGINT)",
    "apc_paid": "STRUCT(value BIGINT, currency VARCHAR, value_usd BIGINT)",
    "fwci": "DOUBLE",
    "has_fulltext": "BOOLEAN",
    "fulltext_origin": "VARCHAR",
    "cited_by_count": "BIGINT",
    "citation_normalized_percentile": "STRUCT(value DOUBLE, is_in_top_1_percent BOOLEAN, is_in_top_10_percent BOOLEAN)",
    "cited_by_percentile_year": "STRUCT(min BIGINT, max BIGINT)",
    "biblio": "STRUCT(volume VARCHAR, issue VARCHAR, first_page VARCHAR, last_page VARCHAR)",
    "is_retracted": "BOOLEAN",
    "is_paratext": "BOOLEAN",
    "primary_topic": "STRUCT(id VARCHAR, display_name VARCHAR, score DOUBLE, subfield STRUCT(id VARCHAR, display_name VARCHAR), field STRUCT(id VARCHAR, display_name VARCHAR), domain STRUCT(id VARCHAR, display_name VARCHAR))",
    "topics": "STRUCT(id VARCHAR, display_name VARCHAR, score DOUBLE, subfield STRUCT(id VARCHAR, display_name VARCHAR), field STRUCT(id VARCHAR, display_name VARCHAR), domain STRUCT(id VARCHAR, display_name VARCHAR))[]",
    "keywords": "STRUCT(id VARCHAR, display_name VARCHAR, score DOUBLE)[]",
    "concepts": "STRUCT(id VARCHAR, wikidata VARCHAR, display_name VARCHAR, level BIGINT, score DOUBLE)[]",
    "mesh": "STRUCT(descriptor_ui VARCHAR, descriptor_name VARCHAR, qualifier_ui VARCHAR, qualifier_name VARCHAR, is_major_topic BOOLEAN)[]",
    "locations_count": "BIGINT",
    "locations": "STRUCT(is_oa BOOLEAN, landing_page_url VARCHAR, pdf_url VARCHAR, source STRUCT(id VARCHAR, display_name VARCHAR, issn_l VARCHAR, issn VARCHAR[], is_oa BOOLEAN, is_in_doaj BOOLEAN, is_indexed_in_scopus BOOLEAN, is_core BOOLEAN, host_organization VARCHAR, host_organization_name VARCHAR, host_organization_lineage VARCHAR[], host_organization_lineage_names VARCHAR[], type VARCHAR), license VARCHAR, license_id VARCHAR, is_accepted BOOLEAN, is_published BOOLEAN)[]",
    "best_oa_location": "STRUCT(is_oa BOOLEAN, landing_page_url VARCHAR, pdf_url VARCHAR, source STRUCT(id VARCHAR, display_name VARCHAR, issn_l VARCHAR, issn VARCHAR[], is_oa BOOLEAN, is_in_doaj BOOLEAN, is_indexed_in_scopus BOOLEAN, is_core BOOLEAN, host_organization VARCHAR, host_organization_name VARCHAR, host_organization_lineage VARCHAR[], host_organization_lineage_names VARCHAR[], type VARCHAR), license VARCHAR, license_id VARCHAR, is_accepted BOOLEAN, is_published BOOLEAN)",
    "sustainable_development_goals": "STRUCT(id VARCHAR, display_name VARCHAR, score DOUBLE)[]",
    "grants": "STRUCT(funder VARCHAR, funder_display_name VARCHAR, award_id VARCHAR)[]",
    "datasets": "VARCHAR[]",
    "versions": "VARCHAR[]",
    "referenced_works_count": "BIGINT",
    "referenced_works": "VARCHAR[]",
    "related_works": "VARCHAR[]",
    "cited_by_api_url": "VARCHAR",
    "counts_by_year": "STRUCT(year BIGINT, cited_by_count BIGINT)[]",
    "updated_date": "DATE",
    "created_date": "DATE",
}


AUTHORS_SCHEMA = {
    "id": "VARCHAR",
    "orcid": "VARCHAR",
    "display_name": "VARCHAR",
    "display_name_alternatives": "VARCHAR[]",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, h_index BIGINT, i10_index BIGINT)',
    "ids": "STRUCT(openalex VARCHAR, orcid VARCHAR, scopus VARCHAR)",
    "affiliations": "STRUCT(institution STRUCT(id VARCHAR, ror VARCHAR, display_name VARCHAR, country_code VARCHAR, type VARCHAR, lineage VARCHAR[]), years BIGINT[])[]",
    "last_known_institutions": "STRUCT(id VARCHAR, ror VARCHAR, display_name VARCHAR, country_code VARCHAR, type VARCHAR, lineage VARCHAR[])[]",
    "topics": "STRUCT(id VARCHAR, display_name VARCHAR, count BIGINT, subfield STRUCT(id VARCHAR, display_name VARCHAR), field STRUCT(id VARCHAR, display_name VARCHAR), domain STRUCT(id VARCHAR, display_name VARCHAR))[]",
    "topic_share": "STRUCT(id VARCHAR, display_name VARCHAR, value DOUBLE, subfield STRUCT(id VARCHAR, display_name VARCHAR), field STRUCT(id VARCHAR, display_name VARCHAR), domain STRUCT(id VARCHAR, display_name VARCHAR))[]",
    "x_concepts": "STRUCT(id VARCHAR, wikidata VARCHAR, display_name VARCHAR, level BIGINT, score DOUBLE)[]",
    "counts_by_year": "STRUCT(year BIGINT, works_count BIGINT, oa_works_count BIGINT, cited_by_count BIGINT)[]",
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}


SOURCE_SCHEMA = {
    "id": "VARCHAR",
    "issn_l": "VARCHAR",
    "issn": "VARCHAR[]",
    "display_name": "VARCHAR",
    "host_organization": "VARCHAR",
    "host_organization_name": "VARCHAR",
    "host_organization_lineage": "VARCHAR[]",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, "h_index" BIGINT, "i10_index" BIGINT)',
    "is_oa": "BOOLEAN",
    "is_in_doaj": "BOOLEAN",
    "is_indexed_in_scopus": "BOOLEAN",
    "is_core": "BOOLEAN",
    "ids": 'STRUCT(openalex VARCHAR, "issn_l" VARCHAR, issn VARCHAR[], mag VARCHAR, wikidata VARCHAR)',
    "homepage_url": "VARCHAR",
    "apc_prices": "STRUCT(price BIGINT, currency VARCHAR)[]",
    "apc_usd": "BIGINT",
    "country_code": "VARCHAR",
    "societies": "STRUCT(url VARCHAR, organization VARCHAR)[]",
    "alternate_titles": "VARCHAR[]",
    "abbreviated_title": "VARCHAR",
    "type": "VARCHAR",
    "topics": 'STRUCT(id VARCHAR, "display_name" VARCHAR, count BIGINT, subfield STRUCT(id VARCHAR, "display_name" VARCHAR), field STRUCT(id VARCHAR, "display_name" VARCHAR), domain STRUCT(id VARCHAR, "display_name" VARCHAR))[]',
    "topic_share": 'STRUCT(id VARCHAR, "display_name" VARCHAR, value DOUBLE, subfield STRUCT(id VARCHAR, "display_name" VARCHAR), field STRUCT(id VARCHAR, "display_name" VARCHAR), domain STRUCT(id VARCHAR, "display_name" VARCHAR))[]',
    "x_concepts": 'STRUCT(id VARCHAR, wikidata VARCHAR, "display_name" VARCHAR, level BIGINT, score DOUBLE)[]',
    "counts_by_year": 'STRUCT(year BIGINT, "works_count" BIGINT, "oa_works_count" BIGINT, "cited_by_count" BIGINT)[]',
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}

INSTITUION_SCHEMA = {
    "id": "VARCHAR",
    "ror": "VARCHAR",
    "display_name": "VARCHAR",
    "country_code": "VARCHAR",
    "type": "VARCHAR",
    "type_id": "VARCHAR",
    "lineage": "VARCHAR[]",
    "homepage_url": "VARCHAR",
    "image_url": "VARCHAR",
    "image_thumbnail_url": "VARCHAR",
    "display_name_acronyms": "VARCHAR[]",
    "display_name_alternatives": "VARCHAR[]",
    "repositories": 'STRUCT(id VARCHAR, "display_name" VARCHAR, "host_organization" VARCHAR, "host_organization_name" VARCHAR, "host_organization_lineage" VARCHAR[])[]',
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, "h_index" BIGINT, "i10_index" BIGINT)',
    "ids": "STRUCT(openalex VARCHAR, ror VARCHAR, mag VARCHAR, grid VARCHAR, wikipedia VARCHAR, wikidata VARCHAR)",
    "geo": 'STRUCT(city VARCHAR, "geonames_city_id" VARCHAR, region VARCHAR, "country_code" VARCHAR, country VARCHAR, latitude DOUBLE, longitude DOUBLE)',
    "international": "MAP(VARCHAR, MAP(VARCHAR, VARCHAR))",
    "associated_institutions": 'STRUCT(id VARCHAR, ror VARCHAR, "display_name" VARCHAR, "country_code" VARCHAR, type VARCHAR, relationship VARCHAR)[]',
    "counts_by_year": 'STRUCT(year BIGINT, "works_count" BIGINT, "oa_works_count" BIGINT, "cited_by_count" BIGINT)[]',
    "roles": 'STRUCT(role VARCHAR, id VARCHAR, "works_count" BIGINT)[]',
    "topics": 'STRUCT(id VARCHAR, "display_name" VARCHAR, count BIGINT, subfield STRUCT(id VARCHAR, "display_name" VARCHAR), field STRUCT(id VARCHAR, "display_name" VARCHAR), domain STRUCT(id VARCHAR, "display_name" VARCHAR))[]',
    "topic_share": 'STRUCT(id VARCHAR, "display_name" VARCHAR, value DOUBLE, subfield STRUCT(id VARCHAR, "display_name" VARCHAR), field STRUCT(id VARCHAR, "display_name" VARCHAR), domain STRUCT(id VARCHAR, "display_name" VARCHAR))[]',
    "x_concepts": 'STRUCT(id VARCHAR, wikidata VARCHAR, "display_name" VARCHAR, level BIGINT, score DOUBLE)[]',
    "is_super_system": "BOOLEAN",
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}


TOPIC_SCHEMA = {
    "id": "VARCHAR",
    "display_name": "VARCHAR",
    "description": "VARCHAR",
    "keywords": "VARCHAR[]",
    "ids": "STRUCT(openalex VARCHAR, wikipedia VARCHAR)",
    "subfield": "STRUCT(id VARCHAR, display_name VARCHAR)",
    "field": "STRUCT(id VARCHAR, display_name VARCHAR)",
    "domain": "STRUCT(id VARCHAR, display_name VARCHAR)",
    "siblings": "STRUCT(id VARCHAR, display_name VARCHAR)[]",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}

KEYWORD_SCHEMA = {
    "id": "VARCHAR",
    "display_name": "VARCHAR",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}

PUBLISHER_SCHEMA = {
    "id": "VARCHAR",
    "display_name": "VARCHAR",
    "alternate_titles": "VARCHAR[]",
    "hierarchy_level": "BIGINT",
    "parent_publisher": "VARCHAR",
    "lineage": "VARCHAR[]",
    "country_codes": "VARCHAR[]",
    "homepage_url": "VARCHAR",
    "image_url": "VARCHAR",
    "image_thumbnail_url": "VARCHAR",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, h_index BIGINT, i10_index BIGINT)',
    "ids": "STRUCT(openalex VARCHAR, ror VARCHAR, wikidata VARCHAR)",
    "counts_by_year": "STRUCT(year BIGINT, works_count BIGINT, oa_works_count BIGINT, cited_by_count BIGINT)[]",
    "roles": "STRUCT(role VARCHAR, id VARCHAR, works_count BIGINT)[]",
    "sources_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}

FUNDER_SCHEMA = {
    "id": "VARCHAR",
    "display_name": "VARCHAR",
    "alternate_titles": "VARCHAR[]",
    "country_code": "VARCHAR",
    "description": "VARCHAR",
    "homepage_url": "VARCHAR",
    "image_url": "VARCHAR",
    "image_thumbnail_url": "VARCHAR",
    "grants_count": "BIGINT",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, h_index BIGINT, i10_index BIGINT)',
    "ids": "STRUCT(openalex VARCHAR, ror VARCHAR, wikidata VARCHAR, crossref VARCHAR, doi VARCHAR)",
    "counts_by_year": "STRUCT(year BIGINT, works_count BIGINT, oa_works_count BIGINT, cited_by_count BIGINT)[]",
    "roles": "STRUCT(role VARCHAR, id VARCHAR, works_count BIGINT)[]",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}

CONCEPT_SCHEMA = {
    "id": "VARCHAR",
    "wikidata": "VARCHAR",
    "display_name": "VARCHAR",
    "level": "BIGINT",
    "description": "VARCHAR",
    "works_count": "BIGINT",
    "cited_by_count": "BIGINT",
    "summary_stats": 'STRUCT("2yr_mean_citedness" DOUBLE, "h_index" BIGINT, "i10_index" BIGINT)',
    "ids": 'STRUCT(openalex VARCHAR, wikidata VARCHAR, mag VARCHAR, wikipedia VARCHAR, "umls_cui" VARCHAR[])',
    "image_url": "VARCHAR",
    "image_thumbnail_url": "VARCHAR",
    "international": "MAP(VARCHAR, MAP(VARCHAR, VARCHAR))",
    "ancestors": "STRUCT(id VARCHAR, wikidata VARCHAR, display_name VARCHAR, level BIGINT)[]",
    "related_concepts": 'STRUCT(id VARCHAR, wikidata VARCHAR, "display_name" VARCHAR, level BIGINT, score DOUBLE)[]',
    "counts_by_year": 'STRUCT(year BIGINT, "works_count" BIGINT, "oa_works_count" BIGINT, "cited_by_count" BIGINT)[]',
    "works_api_url": "VARCHAR",
    "updated_date": "VARCHAR",
    "created_date": "VARCHAR",
}
