# Arize
API specification for the backend data server. The API is hosted globally at https://app.arize.com/api/v1 or in your own environment. You can access the OpenAPI spec for this API at https://app.arize.com/api/v1/spec.yaml 

The `arize._generated.api_client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.0
- Generator version: 7.15.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 2.1.0, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with Arize,
you can run the following:

```python

import arize._generated.api_client
from arize._generated.api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = arize._generated.api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with arize._generated.api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = arize._generated.api_client.DatasetsApi(api_client)
    datasets_create_request = arize._generated.api_client.DatasetsCreateRequest() # DatasetsCreateRequest | Body containing dataset creation parameters

    try:
        # Create a new dataset with JSON examples
        api_response = api_instance.datasets_create(datasets_create_request)
        print("The response of DatasetsApi->datasets_create:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DatasetsApi->datasets_create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DatasetsApi* | [**datasets_create**](arize/_generated/api_client/docs/DatasetsApi.md#datasets_create) | **POST** /api/v1/datasets | Create a new dataset with JSON examples
*DatasetsApi* | [**datasets_delete**](arize/_generated/api_client/docs/DatasetsApi.md#datasets_delete) | **DELETE** /api/v1/datasets/{datasetId} | Delete a dataset by ID
*DatasetsApi* | [**datasets_get**](arize/_generated/api_client/docs/DatasetsApi.md#datasets_get) | **GET** /api/v1/datasets/{datasetId} | Get dataset by ID
*DatasetsApi* | [**datasets_list**](arize/_generated/api_client/docs/DatasetsApi.md#datasets_list) | **GET** /api/v1/datasets | List datasets the user has access to
*DatasetsApi* | [**datasets_list_examples**](arize/_generated/api_client/docs/DatasetsApi.md#datasets_list_examples) | **GET** /api/v1/datasets/{datasetId}/examples | List examples for a dataset
*ExperimentsApi* | [**experiments_list**](arize/_generated/api_client/docs/ExperimentsApi.md#experiments_list) | **GET** /api/v1/datasets/{datasetId}/experiments | List experiments for a given dataset


## Documentation For Models

 - [Dataset](arize/_generated/api_client/docs/Dataset.md)
 - [DatasetVersion](arize/_generated/api_client/docs/DatasetVersion.md)
 - [DatasetsCreate201Response](arize/_generated/api_client/docs/DatasetsCreate201Response.md)
 - [DatasetsCreateRequest](arize/_generated/api_client/docs/DatasetsCreateRequest.md)
 - [DatasetsList200Response](arize/_generated/api_client/docs/DatasetsList200Response.md)
 - [DatasetsListExamples200Response](arize/_generated/api_client/docs/DatasetsListExamples200Response.md)
 - [Error](arize/_generated/api_client/docs/Error.md)
 - [Experiment](arize/_generated/api_client/docs/Experiment.md)
 - [ExperimentsList200Response](arize/_generated/api_client/docs/ExperimentsList200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




