# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNodeResult',
    'AwaitableGetNodeResult',
    'get_node',
    'get_node_output',
]

@pulumi.output_type
class GetNodeResult:
    """
    A collection of values returned by getNode.
    """
    def __init__(__self__, address=None, connection_limit=None, description=None, dynamic_ratio=None, fqdn=None, full_path=None, id=None, monitor=None, name=None, partition=None, rate_limit=None, ratio=None, session=None, state=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if connection_limit and not isinstance(connection_limit, int):
            raise TypeError("Expected argument 'connection_limit' to be a int")
        pulumi.set(__self__, "connection_limit", connection_limit)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dynamic_ratio and not isinstance(dynamic_ratio, int):
            raise TypeError("Expected argument 'dynamic_ratio' to be a int")
        pulumi.set(__self__, "dynamic_ratio", dynamic_ratio)
        if fqdn and not isinstance(fqdn, dict):
            raise TypeError("Expected argument 'fqdn' to be a dict")
        pulumi.set(__self__, "fqdn", fqdn)
        if full_path and not isinstance(full_path, str):
            raise TypeError("Expected argument 'full_path' to be a str")
        pulumi.set(__self__, "full_path", full_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor and not isinstance(monitor, str):
            raise TypeError("Expected argument 'monitor' to be a str")
        pulumi.set(__self__, "monitor", monitor)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if rate_limit and not isinstance(rate_limit, str):
            raise TypeError("Expected argument 'rate_limit' to be a str")
        pulumi.set(__self__, "rate_limit", rate_limit)
        if ratio and not isinstance(ratio, int):
            raise TypeError("Expected argument 'ratio' to be a int")
        pulumi.set(__self__, "ratio", ratio)
        if session and not isinstance(session, str):
            raise TypeError("Expected argument 'session' to be a str")
        pulumi.set(__self__, "session", session)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the node.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> _builtins.int:
        """
        Node connection limit.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        User defined description of the node.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dynamicRatio")
    def dynamic_ratio(self) -> _builtins.int:
        """
        The dynamic ratio number for the node.
        """
        return pulumi.get(self, "dynamic_ratio")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> 'outputs.GetNodeFqdnResult':
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[_builtins.str]:
        """
        Full path of the node (partition and name)
        """
        return pulumi.get(self, "full_path")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> _builtins.str:
        """
        Specifies the health monitors the system currently uses to monitor this node.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> _builtins.str:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> _builtins.str:
        """
        Node rate limit.
        """
        return pulumi.get(self, "rate_limit")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> _builtins.int:
        """
        Node ratio weight.
        """
        return pulumi.get(self, "ratio")

    @_builtins.property
    @pulumi.getter
    def session(self) -> _builtins.str:
        return pulumi.get(self, "session")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the node.
        """
        return pulumi.get(self, "state")


class AwaitableGetNodeResult(GetNodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeResult(
            address=self.address,
            connection_limit=self.connection_limit,
            description=self.description,
            dynamic_ratio=self.dynamic_ratio,
            fqdn=self.fqdn,
            full_path=self.full_path,
            id=self.id,
            monitor=self.monitor,
            name=self.name,
            partition=self.partition,
            rate_limit=self.rate_limit,
            ratio=self.ratio,
            session=self.session,
            state=self.state)


def get_node(address: Optional[_builtins.str] = None,
             description: Optional[_builtins.str] = None,
             fqdn: Optional[Union['GetNodeFqdnArgs', 'GetNodeFqdnArgsDict']] = None,
             full_path: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             partition: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeResult:
    """
    Use this data source (`ltm.Node`) to get the ltm node details available on BIG-IP


    :param _builtins.str address: The address of the node.
    :param _builtins.str description: User defined description of the node.
    :param _builtins.str full_path: Full path of the node (partition and name)
    :param _builtins.str name: Name of the node.
    :param _builtins.str partition: partition of the node.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['description'] = description
    __args__['fqdn'] = fqdn
    __args__['fullPath'] = full_path
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('f5bigip:ltm/getNode:getNode', __args__, opts=opts, typ=GetNodeResult).value

    return AwaitableGetNodeResult(
        address=pulumi.get(__ret__, 'address'),
        connection_limit=pulumi.get(__ret__, 'connection_limit'),
        description=pulumi.get(__ret__, 'description'),
        dynamic_ratio=pulumi.get(__ret__, 'dynamic_ratio'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        full_path=pulumi.get(__ret__, 'full_path'),
        id=pulumi.get(__ret__, 'id'),
        monitor=pulumi.get(__ret__, 'monitor'),
        name=pulumi.get(__ret__, 'name'),
        partition=pulumi.get(__ret__, 'partition'),
        rate_limit=pulumi.get(__ret__, 'rate_limit'),
        ratio=pulumi.get(__ret__, 'ratio'),
        session=pulumi.get(__ret__, 'session'),
        state=pulumi.get(__ret__, 'state'))
def get_node_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    fqdn: Optional[pulumi.Input[Optional[Union['GetNodeFqdnArgs', 'GetNodeFqdnArgsDict']]]] = None,
                    full_path: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    name: Optional[pulumi.Input[_builtins.str]] = None,
                    partition: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodeResult]:
    """
    Use this data source (`ltm.Node`) to get the ltm node details available on BIG-IP


    :param _builtins.str address: The address of the node.
    :param _builtins.str description: User defined description of the node.
    :param _builtins.str full_path: Full path of the node (partition and name)
    :param _builtins.str name: Name of the node.
    :param _builtins.str partition: partition of the node.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['description'] = description
    __args__['fqdn'] = fqdn
    __args__['fullPath'] = full_path
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('f5bigip:ltm/getNode:getNode', __args__, opts=opts, typ=GetNodeResult)
    return __ret__.apply(lambda __response__: GetNodeResult(
        address=pulumi.get(__response__, 'address'),
        connection_limit=pulumi.get(__response__, 'connection_limit'),
        description=pulumi.get(__response__, 'description'),
        dynamic_ratio=pulumi.get(__response__, 'dynamic_ratio'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        full_path=pulumi.get(__response__, 'full_path'),
        id=pulumi.get(__response__, 'id'),
        monitor=pulumi.get(__response__, 'monitor'),
        name=pulumi.get(__response__, 'name'),
        partition=pulumi.get(__response__, 'partition'),
        rate_limit=pulumi.get(__response__, 'rate_limit'),
        ratio=pulumi.get(__response__, 'ratio'),
        session=pulumi.get(__response__, 'session'),
        state=pulumi.get(__response__, 'state')))
