# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeArgs', 'Node']

@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 fqdn: Optional[pulumi.Input['NodeFqdnArgs']] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Node resource.
        :param pulumi.Input[_builtins.str] address: IP or hostname of the node
        :param pulumi.Input[_builtins.str] name: Name of the node
        :param pulumi.Input[_builtins.int] connection_limit: Specifies the maximum number of connections allowed for the node or node address.
        :param pulumi.Input[_builtins.str] description: User-defined description give ltm_node
        :param pulumi.Input[_builtins.int] dynamic_ratio: Specifies the fixed ratio value used for a node during ratio load balancing.
        :param pulumi.Input[_builtins.str] monitor: specifies the name of the monitor or monitor rule that you want to associate with the node.
        :param pulumi.Input[_builtins.str] rate_limit: Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        :param pulumi.Input[_builtins.int] ratio: Sets the ratio number for the node.
        :param pulumi.Input[_builtins.str] session: Enables or disables the node for new sessions. The default value is user-enabled.
        :param pulumi.Input[_builtins.str] state: Default is "user-up" you can set to "user-down" if you want to disable
               
               > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_ratio is not None:
            pulumi.set(__self__, "dynamic_ratio", dynamic_ratio)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if session is not None:
            pulumi.set(__self__, "session", session)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        IP or hostname of the node
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the node
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of connections allowed for the node or node address.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined description give ltm_node
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicRatio")
    def dynamic_ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the fixed ratio value used for a node during ratio load balancing.
        """
        return pulumi.get(self, "dynamic_ratio")

    @dynamic_ratio.setter
    def dynamic_ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dynamic_ratio", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input['NodeFqdnArgs']]:
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input['NodeFqdnArgs']]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specifies the name of the monitor or monitor rule that you want to associate with the node.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rate_limit", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the ratio number for the node.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter
    def session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables the node for new sessions. The default value is user-enabled.
        """
        return pulumi.get(self, "session")

    @session.setter
    def session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default is "user-up" you can set to "user-down" if you want to disable

        > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _NodeState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 fqdn: Optional[pulumi.Input['NodeFqdnArgs']] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Node resources.
        :param pulumi.Input[_builtins.str] address: IP or hostname of the node
        :param pulumi.Input[_builtins.int] connection_limit: Specifies the maximum number of connections allowed for the node or node address.
        :param pulumi.Input[_builtins.str] description: User-defined description give ltm_node
        :param pulumi.Input[_builtins.int] dynamic_ratio: Specifies the fixed ratio value used for a node during ratio load balancing.
        :param pulumi.Input[_builtins.str] monitor: specifies the name of the monitor or monitor rule that you want to associate with the node.
        :param pulumi.Input[_builtins.str] name: Name of the node
        :param pulumi.Input[_builtins.str] rate_limit: Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        :param pulumi.Input[_builtins.int] ratio: Sets the ratio number for the node.
        :param pulumi.Input[_builtins.str] session: Enables or disables the node for new sessions. The default value is user-enabled.
        :param pulumi.Input[_builtins.str] state: Default is "user-up" you can set to "user-down" if you want to disable
               
               > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_ratio is not None:
            pulumi.set(__self__, "dynamic_ratio", dynamic_ratio)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if session is not None:
            pulumi.set(__self__, "session", session)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP or hostname of the node
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of connections allowed for the node or node address.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined description give ltm_node
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicRatio")
    def dynamic_ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the fixed ratio value used for a node during ratio load balancing.
        """
        return pulumi.get(self, "dynamic_ratio")

    @dynamic_ratio.setter
    def dynamic_ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dynamic_ratio", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input['NodeFqdnArgs']]:
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input['NodeFqdnArgs']]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specifies the name of the monitor or monitor rule that you want to associate with the node.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the node
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rate_limit", value)

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the ratio number for the node.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ratio", value)

    @_builtins.property
    @pulumi.getter
    def session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables the node for new sessions. The default value is user-enabled.
        """
        return pulumi.get(self, "session")

    @session.setter
    def session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default is "user-up" you can set to "user-down" if you want to disable

        > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("f5bigip:ltm/node:Node")
class Node(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 fqdn: Optional[pulumi.Input[Union['NodeFqdnArgs', 'NodeFqdnArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.Node` Manages a node configuration

        For resources should be named with their `full path`.The full path is the combination of the `partition + name` of the resource( example: `/Common/my-node` ) or `partition + Direcroty + name` of the resource ( example: `/Common/test/my-node` ).
        When including directory in `full path` we have to make sure it is created in the given partition before using it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        node = f5bigip.ltm.Node("node",
            name="/Common/terraform_node1",
            address="192.168.30.1",
            connection_limit=0,
            dynamic_ratio=1,
            monitor="/Common/icmp",
            description="Test-Node",
            rate_limit="disabled",
            fqdn={
                "address_family": "ipv4",
                "interval": "3000",
            })
        ```

        ## Importing

        An existing Node can be imported into this resource by supplying Node Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_node.site2_node "/TEST/testnode"
                    (or)
        $ terraform import bigip_ltm_node.site2_node "/Common/3.3.3.3"

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: IP or hostname of the node
        :param pulumi.Input[_builtins.int] connection_limit: Specifies the maximum number of connections allowed for the node or node address.
        :param pulumi.Input[_builtins.str] description: User-defined description give ltm_node
        :param pulumi.Input[_builtins.int] dynamic_ratio: Specifies the fixed ratio value used for a node during ratio load balancing.
        :param pulumi.Input[_builtins.str] monitor: specifies the name of the monitor or monitor rule that you want to associate with the node.
        :param pulumi.Input[_builtins.str] name: Name of the node
        :param pulumi.Input[_builtins.str] rate_limit: Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        :param pulumi.Input[_builtins.int] ratio: Sets the ratio number for the node.
        :param pulumi.Input[_builtins.str] session: Enables or disables the node for new sessions. The default value is user-enabled.
        :param pulumi.Input[_builtins.str] state: Default is "user-up" you can set to "user-down" if you want to disable
               
               > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.Node` Manages a node configuration

        For resources should be named with their `full path`.The full path is the combination of the `partition + name` of the resource( example: `/Common/my-node` ) or `partition + Direcroty + name` of the resource ( example: `/Common/test/my-node` ).
        When including directory in `full path` we have to make sure it is created in the given partition before using it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        node = f5bigip.ltm.Node("node",
            name="/Common/terraform_node1",
            address="192.168.30.1",
            connection_limit=0,
            dynamic_ratio=1,
            monitor="/Common/icmp",
            description="Test-Node",
            rate_limit="disabled",
            fqdn={
                "address_family": "ipv4",
                "interval": "3000",
            })
        ```

        ## Importing

        An existing Node can be imported into this resource by supplying Node Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_node.site2_node "/TEST/testnode"
                    (or)
        $ terraform import bigip_ltm_node.site2_node "/Common/3.3.3.3"

        ```

        :param str resource_name: The name of the resource.
        :param NodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 fqdn: Optional[pulumi.Input[Union['NodeFqdnArgs', 'NodeFqdnArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 ratio: Optional[pulumi.Input[_builtins.int]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeArgs.__new__(NodeArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamic_ratio"] = dynamic_ratio
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["monitor"] = monitor
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["rate_limit"] = rate_limit
            __props__.__dict__["ratio"] = ratio
            __props__.__dict__["session"] = session
            __props__.__dict__["state"] = state
        super(Node, __self__).__init__(
            'f5bigip:ltm/node:Node',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_ratio: Optional[pulumi.Input[_builtins.int]] = None,
            fqdn: Optional[pulumi.Input[Union['NodeFqdnArgs', 'NodeFqdnArgsDict']]] = None,
            monitor: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rate_limit: Optional[pulumi.Input[_builtins.str]] = None,
            ratio: Optional[pulumi.Input[_builtins.int]] = None,
            session: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'Node':
        """
        Get an existing Node resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: IP or hostname of the node
        :param pulumi.Input[_builtins.int] connection_limit: Specifies the maximum number of connections allowed for the node or node address.
        :param pulumi.Input[_builtins.str] description: User-defined description give ltm_node
        :param pulumi.Input[_builtins.int] dynamic_ratio: Specifies the fixed ratio value used for a node during ratio load balancing.
        :param pulumi.Input[_builtins.str] monitor: specifies the name of the monitor or monitor rule that you want to associate with the node.
        :param pulumi.Input[_builtins.str] name: Name of the node
        :param pulumi.Input[_builtins.str] rate_limit: Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        :param pulumi.Input[_builtins.int] ratio: Sets the ratio number for the node.
        :param pulumi.Input[_builtins.str] session: Enables or disables the node for new sessions. The default value is user-enabled.
        :param pulumi.Input[_builtins.str] state: Default is "user-up" you can set to "user-down" if you want to disable
               
               > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeState.__new__(_NodeState)

        __props__.__dict__["address"] = address
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamic_ratio"] = dynamic_ratio
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["rate_limit"] = rate_limit
        __props__.__dict__["ratio"] = ratio
        __props__.__dict__["session"] = session
        __props__.__dict__["state"] = state
        return Node(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        IP or hostname of the node
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of connections allowed for the node or node address.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined description give ltm_node
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dynamicRatio")
    def dynamic_ratio(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the fixed ratio value used for a node during ratio load balancing.
        """
        return pulumi.get(self, "dynamic_ratio")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[Optional['outputs.NodeFqdn']]:
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        specifies the name of the monitor or monitor rule that you want to associate with the node.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the node
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the maximum number of connections per second allowed for a node or node address. The default value is 'disabled'.
        """
        return pulumi.get(self, "rate_limit")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the ratio number for the node.
        """
        return pulumi.get(self, "ratio")

    @_builtins.property
    @pulumi.getter
    def session(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables the node for new sessions. The default value is user-enabled.
        """
        return pulumi.get(self, "session")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Default is "user-up" you can set to "user-down" if you want to disable

        > *NOTE* Below attributes needs to be configured under fqdn option.
        """
        return pulumi.get(self, "state")

