# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataGroupRecord',
    'NodeFqdn',
    'PolicyRule',
    'PolicyRuleAction',
    'PolicyRuleCondition',
    'ProfileClientSslCertKeyChain',
    'ProfileHttpEnforcement',
    'ProfileHttpHttpStrictTransportSecurity',
    'ProfileRewriteCookieRule',
    'ProfileRewriteRequest',
    'ProfileRewriteResponse',
    'ProfileRewriteUriRulesClient',
    'ProfileRewriteUriRulesServer',
    'SnatOrigin',
    'GetDataGroupRecordResult',
    'GetNodeFqdnResult',
    'GetPolicyRuleResult',
    'GetPolicyRuleActionResult',
    'GetPolicyRuleConditionResult',
]

@pulumi.output_type
class DataGroupRecord(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: , sets the value of the record's `name` attribute, must be of type defined in `type` attribute
        :param _builtins.str data: , sets the value of the record's `data` attribute, specifying a value here will create a record in the form of `name := data`
        """
        pulumi.set(__self__, "name", name)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        , sets the value of the record's `name` attribute, must be of type defined in `type` attribute
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        """
        , sets the value of the record's `data` attribute, specifying a value here will create a record in the form of `name := data`
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class NodeFqdn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressFamily":
            suggest = "address_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeFqdn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeFqdn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeFqdn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_family: Optional[_builtins.str] = None,
                 autopopulate: Optional[_builtins.str] = None,
                 downinterval: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str address_family: Specifies the node's address family. The default is 'unspecified', or IP-agnostic. This needs to be specified inside the fqdn (fully qualified domain name).
        :param _builtins.str autopopulate: Specifies whether the node should scale to the IP address set returned by DNS.
        :param _builtins.int downinterval: Specifies the number of attempts to resolve a domain name. The default is 5.
        :param _builtins.str interval: Specifies the amount of time before sending the next DNS query. Default is 3600. This needs to be specified inside the fqdn (fully qualified domain name).
        :param _builtins.str name: Name of the node
        """
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if autopopulate is not None:
            pulumi.set(__self__, "autopopulate", autopopulate)
        if downinterval is not None:
            pulumi.set(__self__, "downinterval", downinterval)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[_builtins.str]:
        """
        Specifies the node's address family. The default is 'unspecified', or IP-agnostic. This needs to be specified inside the fqdn (fully qualified domain name).
        """
        return pulumi.get(self, "address_family")

    @_builtins.property
    @pulumi.getter
    def autopopulate(self) -> Optional[_builtins.str]:
        """
        Specifies whether the node should scale to the IP address set returned by DNS.
        """
        return pulumi.get(self, "autopopulate")

    @_builtins.property
    @pulumi.getter
    def downinterval(self) -> Optional[_builtins.int]:
        """
        Specifies the number of attempts to resolve a domain name. The default is 5.
        """
        return pulumi.get(self, "downinterval")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Specifies the amount of time before sending the next DNS query. Default is 3600. This needs to be specified inside the fqdn (fully qualified domain name).
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the node
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PolicyRule(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 actions: Optional[Sequence['outputs.PolicyRuleAction']] = None,
                 conditions: Optional[Sequence['outputs.PolicyRuleCondition']] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of Rule to be applied in policy.
        :param Sequence['PolicyRuleActionArgs'] actions: Block type. See action block for more details.
        :param Sequence['PolicyRuleConditionArgs'] conditions: Block type. See condition block for more details.
        :param _builtins.str description: Specifies descriptive text that identifies the irule attached to policy.
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Rule to be applied in policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.PolicyRuleAction']]:
        """
        Block type. See action block for more details.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PolicyRuleCondition']]:
        """
        Block type. See condition block for more details.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies descriptive text that identifies the irule attached to policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PolicyRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"
        elif key == "clonePool":
            suggest = "clone_pool"
        elif key == "cookieHash":
            suggest = "cookie_hash"
        elif key == "cookieInsert":
            suggest = "cookie_insert"
        elif key == "cookiePassive":
            suggest = "cookie_passive"
        elif key == "cookieRewrite":
            suggest = "cookie_rewrite"
        elif key == "destinationAddress":
            suggest = "destination_address"
        elif key == "expirySecs":
            suggest = "expiry_secs"
        elif key == "fromProfile":
            suggest = "from_profile"
        elif key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "httpCookie":
            suggest = "http_cookie"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpHost":
            suggest = "http_host"
        elif key == "httpReferer":
            suggest = "http_referer"
        elif key == "httpReply":
            suggest = "http_reply"
        elif key == "httpSetCookie":
            suggest = "http_set_cookie"
        elif key == "httpUri":
            suggest = "http_uri"
        elif key == "internalVirtual":
            suggest = "internal_virtual"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ltmPolicy":
            suggest = "ltm_policy"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "requestAdapt":
            suggest = "request_adapt"
        elif key == "responseAdapt":
            suggest = "response_adapt"
        elif key == "serverSsl":
            suggest = "server_ssl"
        elif key == "setVariable":
            suggest = "set_variable"
        elif key == "sourceAddress":
            suggest = "source_address"
        elif key == "sslClientHello":
            suggest = "ssl_client_hello"
        elif key == "sslServerHandshake":
            suggest = "ssl_server_handshake"
        elif key == "sslServerHello":
            suggest = "ssl_server_hello"
        elif key == "sslSessionId":
            suggest = "ssl_session_id"
        elif key == "tcpNagle":
            suggest = "tcp_nagle"
        elif key == "tmName":
            suggest = "tm_name"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_service: Optional[_builtins.str] = None,
                 application: Optional[_builtins.str] = None,
                 asm: Optional[_builtins.bool] = None,
                 avr: Optional[_builtins.bool] = None,
                 cache: Optional[_builtins.bool] = None,
                 carp: Optional[_builtins.bool] = None,
                 category: Optional[_builtins.str] = None,
                 classify: Optional[_builtins.bool] = None,
                 clone_pool: Optional[_builtins.str] = None,
                 code: Optional[_builtins.int] = None,
                 compress: Optional[_builtins.bool] = None,
                 connection: Optional[_builtins.bool] = None,
                 content: Optional[_builtins.str] = None,
                 cookie_hash: Optional[_builtins.bool] = None,
                 cookie_insert: Optional[_builtins.bool] = None,
                 cookie_passive: Optional[_builtins.bool] = None,
                 cookie_rewrite: Optional[_builtins.bool] = None,
                 decompress: Optional[_builtins.bool] = None,
                 defer: Optional[_builtins.bool] = None,
                 destination_address: Optional[_builtins.bool] = None,
                 disable: Optional[_builtins.bool] = None,
                 domain: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 expiry: Optional[_builtins.str] = None,
                 expiry_secs: Optional[_builtins.int] = None,
                 expression: Optional[_builtins.str] = None,
                 extension: Optional[_builtins.str] = None,
                 facility: Optional[_builtins.str] = None,
                 forward: Optional[_builtins.bool] = None,
                 from_profile: Optional[_builtins.str] = None,
                 hash: Optional[_builtins.bool] = None,
                 host: Optional[_builtins.str] = None,
                 http: Optional[_builtins.bool] = None,
                 http_basic_auth: Optional[_builtins.bool] = None,
                 http_cookie: Optional[_builtins.bool] = None,
                 http_header: Optional[_builtins.bool] = None,
                 http_host: Optional[_builtins.bool] = None,
                 http_referer: Optional[_builtins.bool] = None,
                 http_reply: Optional[_builtins.bool] = None,
                 http_set_cookie: Optional[_builtins.bool] = None,
                 http_uri: Optional[_builtins.bool] = None,
                 ifile: Optional[_builtins.str] = None,
                 insert: Optional[_builtins.bool] = None,
                 internal_virtual: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 l7dos: Optional[_builtins.bool] = None,
                 length: Optional[_builtins.int] = None,
                 location: Optional[_builtins.str] = None,
                 log: Optional[_builtins.bool] = None,
                 ltm_policy: Optional[_builtins.bool] = None,
                 member: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 netmask: Optional[_builtins.str] = None,
                 nexthop: Optional[_builtins.str] = None,
                 node: Optional[_builtins.str] = None,
                 offset: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 pem: Optional[_builtins.bool] = None,
                 persist: Optional[_builtins.bool] = None,
                 pin: Optional[_builtins.bool] = None,
                 policy: Optional[_builtins.str] = None,
                 pool: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 priority: Optional[_builtins.str] = None,
                 profile: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 query_string: Optional[_builtins.str] = None,
                 rateclass: Optional[_builtins.str] = None,
                 redirect: Optional[_builtins.bool] = None,
                 remove: Optional[_builtins.bool] = None,
                 replace: Optional[_builtins.bool] = None,
                 request: Optional[_builtins.bool] = None,
                 request_adapt: Optional[_builtins.bool] = None,
                 reset: Optional[_builtins.bool] = None,
                 response: Optional[_builtins.bool] = None,
                 response_adapt: Optional[_builtins.bool] = None,
                 scheme: Optional[_builtins.str] = None,
                 script: Optional[_builtins.str] = None,
                 select: Optional[_builtins.bool] = None,
                 server_ssl: Optional[_builtins.bool] = None,
                 set_variable: Optional[_builtins.bool] = None,
                 shutdown: Optional[_builtins.bool] = None,
                 snat: Optional[_builtins.str] = None,
                 snatpool: Optional[_builtins.str] = None,
                 source_address: Optional[_builtins.bool] = None,
                 ssl_client_hello: Optional[_builtins.bool] = None,
                 ssl_server_handshake: Optional[_builtins.bool] = None,
                 ssl_server_hello: Optional[_builtins.bool] = None,
                 ssl_session_id: Optional[_builtins.bool] = None,
                 status: Optional[_builtins.int] = None,
                 tcl: Optional[_builtins.bool] = None,
                 tcp_nagle: Optional[_builtins.bool] = None,
                 text: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.int] = None,
                 tm_name: Optional[_builtins.str] = None,
                 uie: Optional[_builtins.bool] = None,
                 universal: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None,
                 virtual: Optional[_builtins.str] = None,
                 vlan: Optional[_builtins.str] = None,
                 vlan_id: Optional[_builtins.int] = None,
                 wam: Optional[_builtins.bool] = None,
                 write: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool connection: This action is set to `true` by default, it needs to be explicitly set to `false` for actions it conflicts with.
        :param _builtins.bool forward: This action will affect forwarding.
        :param _builtins.str pool: This action will direct the stream to this pool.
        """
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if asm is not None:
            pulumi.set(__self__, "asm", asm)
        if avr is not None:
            pulumi.set(__self__, "avr", avr)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if carp is not None:
            pulumi.set(__self__, "carp", carp)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if classify is not None:
            pulumi.set(__self__, "classify", classify)
        if clone_pool is not None:
            pulumi.set(__self__, "clone_pool", clone_pool)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if cookie_hash is not None:
            pulumi.set(__self__, "cookie_hash", cookie_hash)
        if cookie_insert is not None:
            pulumi.set(__self__, "cookie_insert", cookie_insert)
        if cookie_passive is not None:
            pulumi.set(__self__, "cookie_passive", cookie_passive)
        if cookie_rewrite is not None:
            pulumi.set(__self__, "cookie_rewrite", cookie_rewrite)
        if decompress is not None:
            pulumi.set(__self__, "decompress", decompress)
        if defer is not None:
            pulumi.set(__self__, "defer", defer)
        if destination_address is not None:
            pulumi.set(__self__, "destination_address", destination_address)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if expiry_secs is not None:
            pulumi.set(__self__, "expiry_secs", expiry_secs)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if from_profile is not None:
            pulumi.set(__self__, "from_profile", from_profile)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if http_cookie is not None:
            pulumi.set(__self__, "http_cookie", http_cookie)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)
        if http_referer is not None:
            pulumi.set(__self__, "http_referer", http_referer)
        if http_reply is not None:
            pulumi.set(__self__, "http_reply", http_reply)
        if http_set_cookie is not None:
            pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        if http_uri is not None:
            pulumi.set(__self__, "http_uri", http_uri)
        if ifile is not None:
            pulumi.set(__self__, "ifile", ifile)
        if insert is not None:
            pulumi.set(__self__, "insert", insert)
        if internal_virtual is not None:
            pulumi.set(__self__, "internal_virtual", internal_virtual)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if l7dos is not None:
            pulumi.set(__self__, "l7dos", l7dos)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if ltm_policy is not None:
            pulumi.set(__self__, "ltm_policy", ltm_policy)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pem is not None:
            pulumi.set(__self__, "pem", pem)
        if persist is not None:
            pulumi.set(__self__, "persist", persist)
        if pin is not None:
            pulumi.set(__self__, "pin", pin)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if rateclass is not None:
            pulumi.set(__self__, "rateclass", rateclass)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if request_adapt is not None:
            pulumi.set(__self__, "request_adapt", request_adapt)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if response_adapt is not None:
            pulumi.set(__self__, "response_adapt", response_adapt)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if server_ssl is not None:
            pulumi.set(__self__, "server_ssl", server_ssl)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if snat is not None:
            pulumi.set(__self__, "snat", snat)
        if snatpool is not None:
            pulumi.set(__self__, "snatpool", snatpool)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if ssl_client_hello is not None:
            pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        if ssl_server_handshake is not None:
            pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        if ssl_server_hello is not None:
            pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        if ssl_session_id is not None:
            pulumi.set(__self__, "ssl_session_id", ssl_session_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tcl is not None:
            pulumi.set(__self__, "tcl", tcl)
        if tcp_nagle is not None:
            pulumi.set(__self__, "tcp_nagle", tcp_nagle)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tm_name is not None:
            pulumi.set(__self__, "tm_name", tm_name)
        if uie is not None:
            pulumi.set(__self__, "uie", uie)
        if universal is not None:
            pulumi.set(__self__, "universal", universal)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if virtual is not None:
            pulumi.set(__self__, "virtual", virtual)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wam is not None:
            pulumi.set(__self__, "wam", wam)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter
    def asm(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "asm")

    @_builtins.property
    @pulumi.getter
    def avr(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "avr")

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cache")

    @_builtins.property
    @pulumi.getter
    def carp(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "carp")

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def classify(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "classify")

    @_builtins.property
    @pulumi.getter(name="clonePool")
    def clone_pool(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "clone_pool")

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def compress(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter
    def connection(self) -> Optional[_builtins.bool]:
        """
        This action is set to `true` by default, it needs to be explicitly set to `false` for actions it conflicts with.
        """
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="cookieHash")
    def cookie_hash(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cookie_hash")

    @_builtins.property
    @pulumi.getter(name="cookieInsert")
    def cookie_insert(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cookie_insert")

    @_builtins.property
    @pulumi.getter(name="cookiePassive")
    def cookie_passive(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cookie_passive")

    @_builtins.property
    @pulumi.getter(name="cookieRewrite")
    def cookie_rewrite(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cookie_rewrite")

    @_builtins.property
    @pulumi.getter
    def decompress(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "decompress")

    @_builtins.property
    @pulumi.getter
    def defer(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "defer")

    @_builtins.property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "destination_address")

    @_builtins.property
    @pulumi.getter
    def disable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "disable")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter(name="expirySecs")
    def expiry_secs(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "expiry_secs")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def facility(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "facility")

    @_builtins.property
    @pulumi.getter
    def forward(self) -> Optional[_builtins.bool]:
        """
        This action will affect forwarding.
        """
        return pulumi.get(self, "forward")

    @_builtins.property
    @pulumi.getter(name="fromProfile")
    def from_profile(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "from_profile")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_basic_auth")

    @_builtins.property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_cookie")

    @_builtins.property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_header")

    @_builtins.property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_host")

    @_builtins.property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_referer")

    @_builtins.property
    @pulumi.getter(name="httpReply")
    def http_reply(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_reply")

    @_builtins.property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_set_cookie")

    @_builtins.property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_uri")

    @_builtins.property
    @pulumi.getter
    def ifile(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ifile")

    @_builtins.property
    @pulumi.getter
    def insert(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "insert")

    @_builtins.property
    @pulumi.getter(name="internalVirtual")
    def internal_virtual(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "internal_virtual")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def l7dos(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "l7dos")

    @_builtins.property
    @pulumi.getter
    def length(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "log")

    @_builtins.property
    @pulumi.getter(name="ltmPolicy")
    def ltm_policy(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ltm_policy")

    @_builtins.property
    @pulumi.getter
    def member(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "member")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def pem(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "pem")

    @_builtins.property
    @pulumi.getter
    def persist(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "persist")

    @_builtins.property
    @pulumi.getter
    def pin(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "pin")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def pool(self) -> Optional[_builtins.str]:
        """
        This action will direct the stream to this pool.
        """
        return pulumi.get(self, "pool")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter
    def rateclass(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "rateclass")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "redirect")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "replace")

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter(name="requestAdapt")
    def request_adapt(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "request_adapt")

    @_builtins.property
    @pulumi.getter
    def reset(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "reset")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="responseAdapt")
    def response_adapt(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "response_adapt")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter(name="serverSsl")
    def server_ssl(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "server_ssl")

    @_builtins.property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "set_variable")

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "shutdown")

    @_builtins.property
    @pulumi.getter
    def snat(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "snat")

    @_builtins.property
    @pulumi.getter
    def snatpool(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "snatpool")

    @_builtins.property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "source_address")

    @_builtins.property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_client_hello")

    @_builtins.property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_server_handshake")

    @_builtins.property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_server_hello")

    @_builtins.property
    @pulumi.getter(name="sslSessionId")
    def ssl_session_id(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_session_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tcl(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "tcl")

    @_builtins.property
    @pulumi.getter(name="tcpNagle")
    def tcp_nagle(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "tcp_nagle")

    @_builtins.property
    @pulumi.getter
    def text(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tm_name")

    @_builtins.property
    @pulumi.getter
    def uie(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "uie")

    @_builtins.property
    @pulumi.getter
    def universal(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "universal")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def virtual(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "virtual")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter
    def wam(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "wam")

    @_builtins.property
    @pulumi.getter
    def write(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "write")


@pulumi.output_type
class PolicyRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"
        elif key == "browserType":
            suggest = "browser_type"
        elif key == "browserVersion":
            suggest = "browser_version"
        elif key == "caseInsensitive":
            suggest = "case_insensitive"
        elif key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "cipherBits":
            suggest = "cipher_bits"
        elif key == "clientAccepted":
            suggest = "client_accepted"
        elif key == "clientSsl":
            suggest = "client_ssl"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "countryName":
            suggest = "country_name"
        elif key == "cpuUsage":
            suggest = "cpu_usage"
        elif key == "deviceMake":
            suggest = "device_make"
        elif key == "deviceModel":
            suggest = "device_model"
        elif key == "endsWith":
            suggest = "ends_with"
        elif key == "greaterOrEqual":
            suggest = "greater_or_equal"
        elif key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "httpCookie":
            suggest = "http_cookie"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpHost":
            suggest = "http_host"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "httpReferer":
            suggest = "http_referer"
        elif key == "httpSetCookie":
            suggest = "http_set_cookie"
        elif key == "httpStatus":
            suggest = "http_status"
        elif key == "httpUri":
            suggest = "http_uri"
        elif key == "httpUserAgent":
            suggest = "http_user_agent"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "lessOrEqual":
            suggest = "less_or_equal"
        elif key == "not":
            suggest = "not_"
        elif key == "pathSegment":
            suggest = "path_segment"
        elif key == "queryParameter":
            suggest = "query_parameter"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "regionCode":
            suggest = "region_code"
        elif key == "regionName":
            suggest = "region_name"
        elif key == "routeDomain":
            suggest = "route_domain"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslCert":
            suggest = "ssl_cert"
        elif key == "sslClientHello":
            suggest = "ssl_client_hello"
        elif key == "sslExtension":
            suggest = "ssl_extension"
        elif key == "sslServerHandshake":
            suggest = "ssl_server_handshake"
        elif key == "sslServerHello":
            suggest = "ssl_server_hello"
        elif key == "startsWith":
            suggest = "starts_with"
        elif key == "tmName":
            suggest = "tm_name"
        elif key == "unnamedQueryParameter":
            suggest = "unnamed_query_parameter"
        elif key == "userAgentToken":
            suggest = "user_agent_token"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.bool] = None,
                 all: Optional[_builtins.bool] = None,
                 app_service: Optional[_builtins.str] = None,
                 browser_type: Optional[_builtins.bool] = None,
                 browser_version: Optional[_builtins.bool] = None,
                 case_insensitive: Optional[_builtins.bool] = None,
                 case_sensitive: Optional[_builtins.bool] = None,
                 cipher: Optional[_builtins.bool] = None,
                 cipher_bits: Optional[_builtins.bool] = None,
                 client_accepted: Optional[_builtins.bool] = None,
                 client_ssl: Optional[_builtins.bool] = None,
                 code: Optional[_builtins.bool] = None,
                 common_name: Optional[_builtins.bool] = None,
                 contains: Optional[_builtins.bool] = None,
                 continent: Optional[_builtins.bool] = None,
                 country_code: Optional[_builtins.bool] = None,
                 country_name: Optional[_builtins.bool] = None,
                 cpu_usage: Optional[_builtins.bool] = None,
                 datagroup: Optional[_builtins.str] = None,
                 device_make: Optional[_builtins.bool] = None,
                 device_model: Optional[_builtins.bool] = None,
                 domain: Optional[_builtins.bool] = None,
                 ends_with: Optional[_builtins.bool] = None,
                 equals: Optional[_builtins.bool] = None,
                 exists: Optional[_builtins.bool] = None,
                 expiry: Optional[_builtins.bool] = None,
                 extension: Optional[_builtins.bool] = None,
                 external: Optional[_builtins.bool] = None,
                 geoip: Optional[_builtins.bool] = None,
                 greater: Optional[_builtins.bool] = None,
                 greater_or_equal: Optional[_builtins.bool] = None,
                 host: Optional[_builtins.bool] = None,
                 http_basic_auth: Optional[_builtins.bool] = None,
                 http_cookie: Optional[_builtins.bool] = None,
                 http_header: Optional[_builtins.bool] = None,
                 http_host: Optional[_builtins.bool] = None,
                 http_method: Optional[_builtins.bool] = None,
                 http_referer: Optional[_builtins.bool] = None,
                 http_set_cookie: Optional[_builtins.bool] = None,
                 http_status: Optional[_builtins.bool] = None,
                 http_uri: Optional[_builtins.bool] = None,
                 http_user_agent: Optional[_builtins.bool] = None,
                 http_version: Optional[_builtins.bool] = None,
                 index: Optional[_builtins.int] = None,
                 internal: Optional[_builtins.bool] = None,
                 isp: Optional[_builtins.bool] = None,
                 last15secs: Optional[_builtins.bool] = None,
                 last1min: Optional[_builtins.bool] = None,
                 last5mins: Optional[_builtins.bool] = None,
                 less: Optional[_builtins.bool] = None,
                 less_or_equal: Optional[_builtins.bool] = None,
                 local: Optional[_builtins.bool] = None,
                 major: Optional[_builtins.bool] = None,
                 matches: Optional[_builtins.bool] = None,
                 minor: Optional[_builtins.bool] = None,
                 missing: Optional[_builtins.bool] = None,
                 mss: Optional[_builtins.bool] = None,
                 not_: Optional[_builtins.bool] = None,
                 org: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.bool] = None,
                 path_segment: Optional[_builtins.bool] = None,
                 port: Optional[_builtins.bool] = None,
                 present: Optional[_builtins.bool] = None,
                 protocol: Optional[_builtins.bool] = None,
                 query_parameter: Optional[_builtins.bool] = None,
                 query_string: Optional[_builtins.bool] = None,
                 region_code: Optional[_builtins.bool] = None,
                 region_name: Optional[_builtins.bool] = None,
                 remote: Optional[_builtins.bool] = None,
                 request: Optional[_builtins.bool] = None,
                 response: Optional[_builtins.bool] = None,
                 route_domain: Optional[_builtins.bool] = None,
                 rtt: Optional[_builtins.bool] = None,
                 scheme: Optional[_builtins.bool] = None,
                 server_name: Optional[_builtins.bool] = None,
                 ssl_cert: Optional[_builtins.bool] = None,
                 ssl_client_hello: Optional[_builtins.bool] = None,
                 ssl_extension: Optional[_builtins.bool] = None,
                 ssl_server_handshake: Optional[_builtins.bool] = None,
                 ssl_server_hello: Optional[_builtins.bool] = None,
                 starts_with: Optional[_builtins.bool] = None,
                 tcp: Optional[_builtins.bool] = None,
                 text: Optional[_builtins.bool] = None,
                 tm_name: Optional[_builtins.str] = None,
                 unnamed_query_parameter: Optional[_builtins.bool] = None,
                 user_agent_token: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.bool] = None,
                 values: Optional[Sequence[_builtins.str]] = None,
                 version: Optional[_builtins.bool] = None,
                 vlan: Optional[_builtins.bool] = None,
                 vlan_id: Optional[_builtins.bool] = None):
        if address is not None:
            pulumi.set(__self__, "address", address)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if browser_type is not None:
            pulumi.set(__self__, "browser_type", browser_type)
        if browser_version is not None:
            pulumi.set(__self__, "browser_version", browser_version)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if cipher_bits is not None:
            pulumi.set(__self__, "cipher_bits", cipher_bits)
        if client_accepted is not None:
            pulumi.set(__self__, "client_accepted", client_accepted)
        if client_ssl is not None:
            pulumi.set(__self__, "client_ssl", client_ssl)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if country_name is not None:
            pulumi.set(__self__, "country_name", country_name)
        if cpu_usage is not None:
            pulumi.set(__self__, "cpu_usage", cpu_usage)
        if datagroup is not None:
            pulumi.set(__self__, "datagroup", datagroup)
        if device_make is not None:
            pulumi.set(__self__, "device_make", device_make)
        if device_model is not None:
            pulumi.set(__self__, "device_model", device_model)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ends_with is not None:
            pulumi.set(__self__, "ends_with", ends_with)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if exists is not None:
            pulumi.set(__self__, "exists", exists)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if geoip is not None:
            pulumi.set(__self__, "geoip", geoip)
        if greater is not None:
            pulumi.set(__self__, "greater", greater)
        if greater_or_equal is not None:
            pulumi.set(__self__, "greater_or_equal", greater_or_equal)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if http_cookie is not None:
            pulumi.set(__self__, "http_cookie", http_cookie)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if http_referer is not None:
            pulumi.set(__self__, "http_referer", http_referer)
        if http_set_cookie is not None:
            pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if http_uri is not None:
            pulumi.set(__self__, "http_uri", http_uri)
        if http_user_agent is not None:
            pulumi.set(__self__, "http_user_agent", http_user_agent)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if last15secs is not None:
            pulumi.set(__self__, "last15secs", last15secs)
        if last1min is not None:
            pulumi.set(__self__, "last1min", last1min)
        if last5mins is not None:
            pulumi.set(__self__, "last5mins", last5mins)
        if less is not None:
            pulumi.set(__self__, "less", less)
        if less_or_equal is not None:
            pulumi.set(__self__, "less_or_equal", less_or_equal)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if major is not None:
            pulumi.set(__self__, "major", major)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if minor is not None:
            pulumi.set(__self__, "minor", minor)
        if missing is not None:
            pulumi.set(__self__, "missing", missing)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_segment is not None:
            pulumi.set(__self__, "path_segment", path_segment)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if present is not None:
            pulumi.set(__self__, "present", present)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query_parameter is not None:
            pulumi.set(__self__, "query_parameter", query_parameter)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if region_code is not None:
            pulumi.set(__self__, "region_code", region_code)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if route_domain is not None:
            pulumi.set(__self__, "route_domain", route_domain)
        if rtt is not None:
            pulumi.set(__self__, "rtt", rtt)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_client_hello is not None:
            pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        if ssl_extension is not None:
            pulumi.set(__self__, "ssl_extension", ssl_extension)
        if ssl_server_handshake is not None:
            pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        if ssl_server_hello is not None:
            pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        if starts_with is not None:
            pulumi.set(__self__, "starts_with", starts_with)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if tm_name is not None:
            pulumi.set(__self__, "tm_name", tm_name)
        if unnamed_query_parameter is not None:
            pulumi.set(__self__, "unnamed_query_parameter", unnamed_query_parameter)
        if user_agent_token is not None:
            pulumi.set(__self__, "user_agent_token", user_agent_token)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def all(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "all")

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "browser_type")

    @_builtins.property
    @pulumi.getter(name="browserVersion")
    def browser_version(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "browser_version")

    @_builtins.property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "case_insensitive")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter
    def cipher(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cipher")

    @_builtins.property
    @pulumi.getter(name="cipherBits")
    def cipher_bits(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cipher_bits")

    @_builtins.property
    @pulumi.getter(name="clientAccepted")
    def client_accepted(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "client_accepted")

    @_builtins.property
    @pulumi.getter(name="clientSsl")
    def client_ssl(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "client_ssl")

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def contains(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "contains")

    @_builtins.property
    @pulumi.getter
    def continent(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "continent")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="countryName")
    def country_name(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "country_name")

    @_builtins.property
    @pulumi.getter(name="cpuUsage")
    def cpu_usage(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cpu_usage")

    @_builtins.property
    @pulumi.getter
    def datagroup(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "datagroup")

    @_builtins.property
    @pulumi.getter(name="deviceMake")
    def device_make(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "device_make")

    @_builtins.property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "device_model")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="endsWith")
    def ends_with(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ends_with")

    @_builtins.property
    @pulumi.getter
    def equals(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "equals")

    @_builtins.property
    @pulumi.getter
    def exists(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "exists")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def geoip(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "geoip")

    @_builtins.property
    @pulumi.getter
    def greater(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "greater")

    @_builtins.property
    @pulumi.getter(name="greaterOrEqual")
    def greater_or_equal(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "greater_or_equal")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_basic_auth")

    @_builtins.property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_cookie")

    @_builtins.property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_header")

    @_builtins.property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_host")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_referer")

    @_builtins.property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_set_cookie")

    @_builtins.property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_status")

    @_builtins.property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_uri")

    @_builtins.property
    @pulumi.getter(name="httpUserAgent")
    def http_user_agent(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_user_agent")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter
    def last15secs(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "last15secs")

    @_builtins.property
    @pulumi.getter
    def last1min(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "last1min")

    @_builtins.property
    @pulumi.getter
    def last5mins(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "last5mins")

    @_builtins.property
    @pulumi.getter
    def less(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "less")

    @_builtins.property
    @pulumi.getter(name="lessOrEqual")
    def less_or_equal(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "less_or_equal")

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter
    def major(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "major")

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "matches")

    @_builtins.property
    @pulumi.getter
    def minor(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "minor")

    @_builtins.property
    @pulumi.getter
    def missing(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "missing")

    @_builtins.property
    @pulumi.getter
    def mss(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "mss")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def org(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "org")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathSegment")
    def path_segment(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "path_segment")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def present(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "present")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="queryParameter")
    def query_parameter(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "query_parameter")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "region_code")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter
    def remote(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "remote")

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "route_domain")

    @_builtins.property
    @pulumi.getter
    def rtt(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "rtt")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_cert")

    @_builtins.property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_client_hello")

    @_builtins.property
    @pulumi.getter(name="sslExtension")
    def ssl_extension(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_extension")

    @_builtins.property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_server_handshake")

    @_builtins.property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ssl_server_hello")

    @_builtins.property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "starts_with")

    @_builtins.property
    @pulumi.getter
    def tcp(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "tcp")

    @_builtins.property
    @pulumi.getter
    def text(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tm_name")

    @_builtins.property
    @pulumi.getter(name="unnamedQueryParameter")
    def unnamed_query_parameter(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "unnamed_query_parameter")

    @_builtins.property
    @pulumi.getter(name="userAgentToken")
    def user_agent_token(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "user_agent_token")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ProfileClientSslCertKeyChain(dict):
    def __init__(__self__, *,
                 cert: Optional[_builtins.str] = None,
                 chain: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 passphrase: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert: Specifies the name of the certificate that the system uses for client-side SSL processing. The default is `default`
        :param _builtins.str chain: Specifies a certificate chain file that a server can use for authentication. The default is `None`.
        :param _builtins.str key: Specifies the file name of the SSL key. The default is `default`
        :param _builtins.str name: Name of Cert-key-chain
        :param _builtins.str passphrase: Type the name of the pass phrase used to encrypt the key.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the certificate that the system uses for client-side SSL processing. The default is `default`
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[_builtins.str]:
        """
        Specifies a certificate chain file that a server can use for authentication. The default is `None`.
        """
        return pulumi.get(self, "chain")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Specifies the file name of the SSL key. The default is `default`
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of Cert-key-chain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[_builtins.str]:
        """
        Type the name of the pass phrase used to encrypt the key.
        """
        return pulumi.get(self, "passphrase")


@pulumi.output_type
class ProfileHttpEnforcement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knownMethods":
            suggest = "known_methods"
        elif key == "maxHeaderCount":
            suggest = "max_header_count"
        elif key == "maxHeaderSize":
            suggest = "max_header_size"
        elif key == "unknownMethod":
            suggest = "unknown_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileHttpEnforcement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileHttpEnforcement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileHttpEnforcement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 known_methods: Optional[Sequence[_builtins.str]] = None,
                 max_header_count: Optional[_builtins.int] = None,
                 max_header_size: Optional[_builtins.int] = None,
                 unknown_method: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] known_methods: Specifies which HTTP methods count as being known. Removing RFC-defined methods from this list will cause the HTTP filter to not recognize them. Default value is [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK].If no value is specified while creating, then default value will be assigned by BigIP. In order to remove it, [""] list is to be passed. If known_methods is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK] explicitly.
        :param _builtins.int max_header_count: Specifies the maximum number of headers allowed in HTTP request/response. The default is 64 headers.If no value is specified while creating, then default value will be assigned by BigIP. If max_header_count is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "64" explicitly.
        :param _builtins.int max_header_size: Specifies the maximum header size. The default value is 32768. If no string is specified while creating, then default value will be assigned by BigIP. If max_header_size is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "32768" explicitly.
        :param _builtins.str unknown_method: Specifies whether to allow, reject or switch to pass-through mode when an unknown HTTP method is parsed. Default value is "allow". If no string is specified while creating, then default value will be assigned by BigIP. If unknown_method is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "allow" explicitly.
        """
        if known_methods is not None:
            pulumi.set(__self__, "known_methods", known_methods)
        if max_header_count is not None:
            pulumi.set(__self__, "max_header_count", max_header_count)
        if max_header_size is not None:
            pulumi.set(__self__, "max_header_size", max_header_size)
        if unknown_method is not None:
            pulumi.set(__self__, "unknown_method", unknown_method)

    @_builtins.property
    @pulumi.getter(name="knownMethods")
    def known_methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies which HTTP methods count as being known. Removing RFC-defined methods from this list will cause the HTTP filter to not recognize them. Default value is [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK].If no value is specified while creating, then default value will be assigned by BigIP. In order to remove it, [""] list is to be passed. If known_methods is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK] explicitly.
        """
        return pulumi.get(self, "known_methods")

    @_builtins.property
    @pulumi.getter(name="maxHeaderCount")
    def max_header_count(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum number of headers allowed in HTTP request/response. The default is 64 headers.If no value is specified while creating, then default value will be assigned by BigIP. If max_header_count is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "64" explicitly.
        """
        return pulumi.get(self, "max_header_count")

    @_builtins.property
    @pulumi.getter(name="maxHeaderSize")
    def max_header_size(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum header size. The default value is 32768. If no string is specified while creating, then default value will be assigned by BigIP. If max_header_size is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "32768" explicitly.
        """
        return pulumi.get(self, "max_header_size")

    @_builtins.property
    @pulumi.getter(name="unknownMethod")
    def unknown_method(self) -> Optional[_builtins.str]:
        """
        Specifies whether to allow, reject or switch to pass-through mode when an unknown HTTP method is parsed. Default value is "allow". If no string is specified while creating, then default value will be assigned by BigIP. If unknown_method is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "allow" explicitly.
        """
        return pulumi.get(self, "unknown_method")


@pulumi.output_type
class ProfileHttpHttpStrictTransportSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"
        elif key == "maximumAge":
            suggest = "maximum_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileHttpHttpStrictTransportSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileHttpHttpStrictTransportSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileHttpHttpStrictTransportSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_subdomains: Optional[_builtins.str] = None,
                 maximum_age: Optional[_builtins.int] = None,
                 mode: Optional[_builtins.str] = None,
                 preload: Optional[_builtins.str] = None):
        """
        :param _builtins.str include_subdomains: The Include Subdomains setting applies the HSTS policy to the HSTS host and its subdomains. The default is "enabled". If no string is specified during Create, then default value will be assigned by BigIp. If include_subdomains is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "enabled" explicitly.
        :param _builtins.int maximum_age: The Maximum Age value specifies the length of time, in seconds, that HSTS functionality requests that clients only use HTTPS to connect to the current host and any subdomains of the current host's domain name.  The default is 16070400 seconds. If no value is specified during Create, then default value will be assigned by BigIp. If maximum_age is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass 16070400 explicitly.
        :param _builtins.str mode: The Mode setting enables and disables HSTS functionality within the HTTP profile. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If mode is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        :param _builtins.str preload: An HSTS preload list is a list of domains built into a web browser. When you enable the Preload setting, the domain for the web site that this HTTP profile is associated with is submitted for inclusion in the browser's preload list. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If preload is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if maximum_age is not None:
            pulumi.set(__self__, "maximum_age", maximum_age)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @_builtins.property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[_builtins.str]:
        """
        The Include Subdomains setting applies the HSTS policy to the HSTS host and its subdomains. The default is "enabled". If no string is specified during Create, then default value will be assigned by BigIp. If include_subdomains is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "enabled" explicitly.
        """
        return pulumi.get(self, "include_subdomains")

    @_builtins.property
    @pulumi.getter(name="maximumAge")
    def maximum_age(self) -> Optional[_builtins.int]:
        """
        The Maximum Age value specifies the length of time, in seconds, that HSTS functionality requests that clients only use HTTPS to connect to the current host and any subdomains of the current host's domain name.  The default is 16070400 seconds. If no value is specified during Create, then default value will be assigned by BigIp. If maximum_age is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass 16070400 explicitly.
        """
        return pulumi.get(self, "maximum_age")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The Mode setting enables and disables HSTS functionality within the HTTP profile. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If mode is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def preload(self) -> Optional[_builtins.str]:
        """
        An HSTS preload list is a list of domains built into a web browser. When you enable the Preload setting, the domain for the web site that this HTTP profile is associated with is submitted for inclusion in the browser's preload list. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If preload is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        return pulumi.get(self, "preload")


@pulumi.output_type
class ProfileRewriteCookieRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientDomain":
            suggest = "client_domain"
        elif key == "clientPath":
            suggest = "client_path"
        elif key == "ruleName":
            suggest = "rule_name"
        elif key == "serverDomain":
            suggest = "server_domain"
        elif key == "serverPath":
            suggest = "server_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteCookieRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteCookieRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteCookieRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_domain: _builtins.str,
                 client_path: _builtins.str,
                 rule_name: _builtins.str,
                 server_domain: _builtins.str,
                 server_path: _builtins.str):
        """
        :param _builtins.str rule_name: Name of the cookie rewrite rule.
        """
        pulumi.set(__self__, "client_domain", client_domain)
        pulumi.set(__self__, "client_path", client_path)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "server_domain", server_domain)
        pulumi.set(__self__, "server_path", server_path)

    @_builtins.property
    @pulumi.getter(name="clientDomain")
    def client_domain(self) -> _builtins.str:
        return pulumi.get(self, "client_domain")

    @_builtins.property
    @pulumi.getter(name="clientPath")
    def client_path(self) -> _builtins.str:
        return pulumi.get(self, "client_path")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        Name of the cookie rewrite rule.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="serverDomain")
    def server_domain(self) -> _builtins.str:
        return pulumi.get(self, "server_domain")

    @_builtins.property
    @pulumi.getter(name="serverPath")
    def server_path(self) -> _builtins.str:
        return pulumi.get(self, "server_path")


@pulumi.output_type
class ProfileRewriteRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insertXfwdFor":
            suggest = "insert_xfwd_for"
        elif key == "insertXfwdHost":
            suggest = "insert_xfwd_host"
        elif key == "insertXfwdProtocol":
            suggest = "insert_xfwd_protocol"
        elif key == "rewriteHeaders":
            suggest = "rewrite_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insert_xfwd_for: Optional[_builtins.str] = None,
                 insert_xfwd_host: Optional[_builtins.str] = None,
                 insert_xfwd_protocol: Optional[_builtins.str] = None,
                 rewrite_headers: Optional[_builtins.str] = None):
        """
        :param _builtins.str insert_xfwd_for: Enable to add the X-Forwarded For (XFF) header, to specify the originating IP address of the client. Valid choices are: `enabled, disabled`
        :param _builtins.str insert_xfwd_host: Enable to add the X-Forwarded Host header, to specify the originating host of the client. Valid choices are: `enabled, disabled`
        :param _builtins.str insert_xfwd_protocol: Enable to add the X-Forwarded Proto header, to specify the originating protocol of the client. Valid choices are: `enabled, disabled`
        :param _builtins.str rewrite_headers: Enable to rewrite headers in Request settings. Valid choices are: `enabled, disabled`
        """
        if insert_xfwd_for is not None:
            pulumi.set(__self__, "insert_xfwd_for", insert_xfwd_for)
        if insert_xfwd_host is not None:
            pulumi.set(__self__, "insert_xfwd_host", insert_xfwd_host)
        if insert_xfwd_protocol is not None:
            pulumi.set(__self__, "insert_xfwd_protocol", insert_xfwd_protocol)
        if rewrite_headers is not None:
            pulumi.set(__self__, "rewrite_headers", rewrite_headers)

    @_builtins.property
    @pulumi.getter(name="insertXfwdFor")
    def insert_xfwd_for(self) -> Optional[_builtins.str]:
        """
        Enable to add the X-Forwarded For (XFF) header, to specify the originating IP address of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_for")

    @_builtins.property
    @pulumi.getter(name="insertXfwdHost")
    def insert_xfwd_host(self) -> Optional[_builtins.str]:
        """
        Enable to add the X-Forwarded Host header, to specify the originating host of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_host")

    @_builtins.property
    @pulumi.getter(name="insertXfwdProtocol")
    def insert_xfwd_protocol(self) -> Optional[_builtins.str]:
        """
        Enable to add the X-Forwarded Proto header, to specify the originating protocol of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_protocol")

    @_builtins.property
    @pulumi.getter(name="rewriteHeaders")
    def rewrite_headers(self) -> Optional[_builtins.str]:
        """
        Enable to rewrite headers in Request settings. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_headers")


@pulumi.output_type
class ProfileRewriteResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rewriteContent":
            suggest = "rewrite_content"
        elif key == "rewriteHeaders":
            suggest = "rewrite_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rewrite_content: Optional[_builtins.str] = None,
                 rewrite_headers: Optional[_builtins.str] = None):
        """
        :param _builtins.str rewrite_content: Enable to rewrite links in content in the response. Valid choices are: `enabled, disabled`
        :param _builtins.str rewrite_headers: Enable to rewrite headers in the response. Valid choices are: `enabled, disabled`
        """
        if rewrite_content is not None:
            pulumi.set(__self__, "rewrite_content", rewrite_content)
        if rewrite_headers is not None:
            pulumi.set(__self__, "rewrite_headers", rewrite_headers)

    @_builtins.property
    @pulumi.getter(name="rewriteContent")
    def rewrite_content(self) -> Optional[_builtins.str]:
        """
        Enable to rewrite links in content in the response. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_content")

    @_builtins.property
    @pulumi.getter(name="rewriteHeaders")
    def rewrite_headers(self) -> Optional[_builtins.str]:
        """
        Enable to rewrite headers in the response. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_headers")


@pulumi.output_type
class ProfileRewriteUriRulesClient(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 scheme: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: Host part of the uri, e.g. `www.foo.com`.
        :param _builtins.str scheme: Scheme part of the uri, e.g. `https`, `ftp`.
        :param _builtins.str path: Path part of the uri, must always end with `/`. Default value is: `/`
        :param _builtins.str port: Port part of the uri. Default value is: `none`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "scheme", scheme)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Host part of the uri, e.g. `www.foo.com`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> _builtins.str:
        """
        Scheme part of the uri, e.g. `https`, `ftp`.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path part of the uri, must always end with `/`. Default value is: `/`
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        Port part of the uri. Default value is: `none`
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ProfileRewriteUriRulesServer(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 scheme: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: Host part of the uri, e.g. `www.foo.com`.
        :param _builtins.str scheme: Scheme part of the uri, e.g. `https`, `ftp`.
        :param _builtins.str path: Path part of the uri, must always end with `/`. Default value is: `/`
        :param _builtins.str port: Port part of the uri. Default value is: `none`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "scheme", scheme)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Host part of the uri, e.g. `www.foo.com`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> _builtins.str:
        """
        Scheme part of the uri, e.g. `https`, `ftp`.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path part of the uri, must always end with `/`. Default value is: `/`
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        Port part of the uri. Default value is: `none`
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SnatOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnatOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnatOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnatOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_service: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str app_service: app service
        :param _builtins.str name: Name of the SNAT, name of SNAT should be full path. Full path is the combination of the `partition + SNAT name`,For example `/Common/test-snat`.
        """
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[_builtins.str]:
        """
        app service
        """
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the SNAT, name of SNAT should be full path. Full path is the combination of the `partition + SNAT name`,For example `/Common/test-snat`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDataGroupRecordResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 data: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the datagroup
        """
        pulumi.set(__self__, "name", name)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the datagroup
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "data")


@pulumi.output_type
class GetNodeFqdnResult(dict):
    def __init__(__self__, *,
                 autopopulate: _builtins.str,
                 downinterval: _builtins.int,
                 interval: _builtins.str,
                 address_family: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str autopopulate: Specifies if the node should scale to the IP address set returned by DNS.
        :param _builtins.int downinterval: The number of attempts to resolve a domain name.
        :param _builtins.str interval: The amount of time before sending the next DNS query.
        :param _builtins.str address_family: The FQDN node's address family.
        :param _builtins.str name: Name of the node.
        """
        pulumi.set(__self__, "autopopulate", autopopulate)
        pulumi.set(__self__, "downinterval", downinterval)
        pulumi.set(__self__, "interval", interval)
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def autopopulate(self) -> _builtins.str:
        """
        Specifies if the node should scale to the IP address set returned by DNS.
        """
        return pulumi.get(self, "autopopulate")

    @_builtins.property
    @pulumi.getter
    def downinterval(self) -> _builtins.int:
        """
        The number of attempts to resolve a domain name.
        """
        return pulumi.get(self, "downinterval")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        The amount of time before sending the next DNS query.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[_builtins.str]:
        """
        The FQDN node's address family.
        """
        return pulumi.get(self, "address_family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPolicyRuleResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 actions: Optional[Sequence['outputs.GetPolicyRuleActionResult']] = None,
                 conditions: Optional[Sequence['outputs.GetPolicyRuleConditionResult']] = None):
        """
        :param _builtins.str name: Name of the policy which includes partion ( /partition/policy-name )
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the policy which includes partion ( /partition/policy-name )
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.GetPolicyRuleActionResult']]:
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetPolicyRuleConditionResult']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GetPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 app_service: _builtins.str,
                 application: _builtins.str,
                 asm: _builtins.bool,
                 avr: _builtins.bool,
                 cache: _builtins.bool,
                 carp: _builtins.bool,
                 category: _builtins.str,
                 classify: _builtins.bool,
                 clone_pool: _builtins.str,
                 code: _builtins.int,
                 compress: _builtins.bool,
                 connection: _builtins.bool,
                 content: _builtins.str,
                 cookie_hash: _builtins.bool,
                 cookie_insert: _builtins.bool,
                 cookie_passive: _builtins.bool,
                 cookie_rewrite: _builtins.bool,
                 decompress: _builtins.bool,
                 defer: _builtins.bool,
                 destination_address: _builtins.bool,
                 disable: _builtins.bool,
                 domain: _builtins.str,
                 enable: _builtins.bool,
                 expiry: _builtins.str,
                 expiry_secs: _builtins.int,
                 expression: _builtins.str,
                 extension: _builtins.str,
                 facility: _builtins.str,
                 from_profile: _builtins.str,
                 hash: _builtins.bool,
                 host: _builtins.str,
                 http: _builtins.bool,
                 http_basic_auth: _builtins.bool,
                 http_cookie: _builtins.bool,
                 http_header: _builtins.bool,
                 http_referer: _builtins.bool,
                 http_reply: _builtins.bool,
                 http_set_cookie: _builtins.bool,
                 http_uri: _builtins.bool,
                 ifile: _builtins.str,
                 insert: _builtins.bool,
                 internal_virtual: _builtins.str,
                 ip_address: _builtins.str,
                 key: _builtins.str,
                 l7dos: _builtins.bool,
                 length: _builtins.int,
                 location: _builtins.str,
                 log: _builtins.bool,
                 ltm_policy: _builtins.bool,
                 member: _builtins.str,
                 message: _builtins.str,
                 netmask: _builtins.str,
                 nexthop: _builtins.str,
                 node: _builtins.str,
                 offset: _builtins.int,
                 path: _builtins.str,
                 pem: _builtins.bool,
                 persist: _builtins.bool,
                 pin: _builtins.bool,
                 policy: _builtins.str,
                 pool: _builtins.str,
                 port: _builtins.int,
                 priority: _builtins.str,
                 profile: _builtins.str,
                 protocol: _builtins.str,
                 query_string: _builtins.str,
                 rateclass: _builtins.str,
                 redirect: _builtins.bool,
                 remove: _builtins.bool,
                 replace: _builtins.bool,
                 request: _builtins.bool,
                 request_adapt: _builtins.bool,
                 reset: _builtins.bool,
                 response: _builtins.bool,
                 response_adapt: _builtins.bool,
                 scheme: _builtins.str,
                 script: _builtins.str,
                 select: _builtins.bool,
                 server_ssl: _builtins.bool,
                 set_variable: _builtins.bool,
                 shutdown: _builtins.bool,
                 snat: _builtins.str,
                 snatpool: _builtins.str,
                 source_address: _builtins.bool,
                 ssl_client_hello: _builtins.bool,
                 ssl_server_handshake: _builtins.bool,
                 ssl_server_hello: _builtins.bool,
                 ssl_session_id: _builtins.bool,
                 status: _builtins.int,
                 tcl: _builtins.bool,
                 tcp_nagle: _builtins.bool,
                 text: _builtins.str,
                 timeout: _builtins.int,
                 tm_name: _builtins.str,
                 uie: _builtins.bool,
                 universal: _builtins.bool,
                 value: _builtins.str,
                 virtual: _builtins.str,
                 vlan: _builtins.str,
                 vlan_id: _builtins.int,
                 wam: _builtins.bool,
                 write: _builtins.bool,
                 forward: Optional[_builtins.bool] = None,
                 http_host: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "app_service", app_service)
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "asm", asm)
        pulumi.set(__self__, "avr", avr)
        pulumi.set(__self__, "cache", cache)
        pulumi.set(__self__, "carp", carp)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "classify", classify)
        pulumi.set(__self__, "clone_pool", clone_pool)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "cookie_hash", cookie_hash)
        pulumi.set(__self__, "cookie_insert", cookie_insert)
        pulumi.set(__self__, "cookie_passive", cookie_passive)
        pulumi.set(__self__, "cookie_rewrite", cookie_rewrite)
        pulumi.set(__self__, "decompress", decompress)
        pulumi.set(__self__, "defer", defer)
        pulumi.set(__self__, "destination_address", destination_address)
        pulumi.set(__self__, "disable", disable)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "expiry_secs", expiry_secs)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "facility", facility)
        pulumi.set(__self__, "from_profile", from_profile)
        pulumi.set(__self__, "hash", hash)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http", http)
        pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        pulumi.set(__self__, "http_cookie", http_cookie)
        pulumi.set(__self__, "http_header", http_header)
        pulumi.set(__self__, "http_referer", http_referer)
        pulumi.set(__self__, "http_reply", http_reply)
        pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        pulumi.set(__self__, "http_uri", http_uri)
        pulumi.set(__self__, "ifile", ifile)
        pulumi.set(__self__, "insert", insert)
        pulumi.set(__self__, "internal_virtual", internal_virtual)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "l7dos", l7dos)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "log", log)
        pulumi.set(__self__, "ltm_policy", ltm_policy)
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "pem", pem)
        pulumi.set(__self__, "persist", persist)
        pulumi.set(__self__, "pin", pin)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "rateclass", rateclass)
        pulumi.set(__self__, "redirect", redirect)
        pulumi.set(__self__, "remove", remove)
        pulumi.set(__self__, "replace", replace)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "request_adapt", request_adapt)
        pulumi.set(__self__, "reset", reset)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "response_adapt", response_adapt)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "select", select)
        pulumi.set(__self__, "server_ssl", server_ssl)
        pulumi.set(__self__, "set_variable", set_variable)
        pulumi.set(__self__, "shutdown", shutdown)
        pulumi.set(__self__, "snat", snat)
        pulumi.set(__self__, "snatpool", snatpool)
        pulumi.set(__self__, "source_address", source_address)
        pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        pulumi.set(__self__, "ssl_session_id", ssl_session_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tcl", tcl)
        pulumi.set(__self__, "tcp_nagle", tcp_nagle)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "tm_name", tm_name)
        pulumi.set(__self__, "uie", uie)
        pulumi.set(__self__, "universal", universal)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "virtual", virtual)
        pulumi.set(__self__, "vlan", vlan)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "wam", wam)
        pulumi.set(__self__, "write", write)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> _builtins.str:
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter
    def application(self) -> _builtins.str:
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter
    def asm(self) -> _builtins.bool:
        return pulumi.get(self, "asm")

    @_builtins.property
    @pulumi.getter
    def avr(self) -> _builtins.bool:
        return pulumi.get(self, "avr")

    @_builtins.property
    @pulumi.getter
    def cache(self) -> _builtins.bool:
        return pulumi.get(self, "cache")

    @_builtins.property
    @pulumi.getter
    def carp(self) -> _builtins.bool:
        return pulumi.get(self, "carp")

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def classify(self) -> _builtins.bool:
        return pulumi.get(self, "classify")

    @_builtins.property
    @pulumi.getter(name="clonePool")
    def clone_pool(self) -> _builtins.str:
        return pulumi.get(self, "clone_pool")

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def compress(self) -> _builtins.bool:
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter
    def connection(self) -> _builtins.bool:
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="cookieHash")
    def cookie_hash(self) -> _builtins.bool:
        return pulumi.get(self, "cookie_hash")

    @_builtins.property
    @pulumi.getter(name="cookieInsert")
    def cookie_insert(self) -> _builtins.bool:
        return pulumi.get(self, "cookie_insert")

    @_builtins.property
    @pulumi.getter(name="cookiePassive")
    def cookie_passive(self) -> _builtins.bool:
        return pulumi.get(self, "cookie_passive")

    @_builtins.property
    @pulumi.getter(name="cookieRewrite")
    def cookie_rewrite(self) -> _builtins.bool:
        return pulumi.get(self, "cookie_rewrite")

    @_builtins.property
    @pulumi.getter
    def decompress(self) -> _builtins.bool:
        return pulumi.get(self, "decompress")

    @_builtins.property
    @pulumi.getter
    def defer(self) -> _builtins.bool:
        return pulumi.get(self, "defer")

    @_builtins.property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> _builtins.bool:
        return pulumi.get(self, "destination_address")

    @_builtins.property
    @pulumi.getter
    def disable(self) -> _builtins.bool:
        return pulumi.get(self, "disable")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.str:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter(name="expirySecs")
    def expiry_secs(self) -> _builtins.int:
        return pulumi.get(self, "expiry_secs")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> _builtins.str:
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def facility(self) -> _builtins.str:
        return pulumi.get(self, "facility")

    @_builtins.property
    @pulumi.getter(name="fromProfile")
    def from_profile(self) -> _builtins.str:
        return pulumi.get(self, "from_profile")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> _builtins.bool:
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def http(self) -> _builtins.bool:
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> _builtins.bool:
        return pulumi.get(self, "http_basic_auth")

    @_builtins.property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> _builtins.bool:
        return pulumi.get(self, "http_cookie")

    @_builtins.property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> _builtins.bool:
        return pulumi.get(self, "http_header")

    @_builtins.property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> _builtins.bool:
        return pulumi.get(self, "http_referer")

    @_builtins.property
    @pulumi.getter(name="httpReply")
    def http_reply(self) -> _builtins.bool:
        return pulumi.get(self, "http_reply")

    @_builtins.property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> _builtins.bool:
        return pulumi.get(self, "http_set_cookie")

    @_builtins.property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> _builtins.bool:
        return pulumi.get(self, "http_uri")

    @_builtins.property
    @pulumi.getter
    def ifile(self) -> _builtins.str:
        return pulumi.get(self, "ifile")

    @_builtins.property
    @pulumi.getter
    def insert(self) -> _builtins.bool:
        return pulumi.get(self, "insert")

    @_builtins.property
    @pulumi.getter(name="internalVirtual")
    def internal_virtual(self) -> _builtins.str:
        return pulumi.get(self, "internal_virtual")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def l7dos(self) -> _builtins.bool:
        return pulumi.get(self, "l7dos")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def log(self) -> _builtins.bool:
        return pulumi.get(self, "log")

    @_builtins.property
    @pulumi.getter(name="ltmPolicy")
    def ltm_policy(self) -> _builtins.bool:
        return pulumi.get(self, "ltm_policy")

    @_builtins.property
    @pulumi.getter
    def member(self) -> _builtins.str:
        return pulumi.get(self, "member")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> _builtins.str:
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def node(self) -> _builtins.str:
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> _builtins.int:
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def pem(self) -> _builtins.bool:
        return pulumi.get(self, "pem")

    @_builtins.property
    @pulumi.getter
    def persist(self) -> _builtins.bool:
        return pulumi.get(self, "persist")

    @_builtins.property
    @pulumi.getter
    def pin(self) -> _builtins.bool:
        return pulumi.get(self, "pin")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def pool(self) -> _builtins.str:
        return pulumi.get(self, "pool")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> _builtins.str:
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> _builtins.str:
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter
    def rateclass(self) -> _builtins.str:
        return pulumi.get(self, "rateclass")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> _builtins.bool:
        return pulumi.get(self, "redirect")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> _builtins.bool:
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> _builtins.bool:
        return pulumi.get(self, "replace")

    @_builtins.property
    @pulumi.getter
    def request(self) -> _builtins.bool:
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter(name="requestAdapt")
    def request_adapt(self) -> _builtins.bool:
        return pulumi.get(self, "request_adapt")

    @_builtins.property
    @pulumi.getter
    def reset(self) -> _builtins.bool:
        return pulumi.get(self, "reset")

    @_builtins.property
    @pulumi.getter
    def response(self) -> _builtins.bool:
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="responseAdapt")
    def response_adapt(self) -> _builtins.bool:
        return pulumi.get(self, "response_adapt")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> _builtins.str:
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def select(self) -> _builtins.bool:
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter(name="serverSsl")
    def server_ssl(self) -> _builtins.bool:
        return pulumi.get(self, "server_ssl")

    @_builtins.property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> _builtins.bool:
        return pulumi.get(self, "set_variable")

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> _builtins.bool:
        return pulumi.get(self, "shutdown")

    @_builtins.property
    @pulumi.getter
    def snat(self) -> _builtins.str:
        return pulumi.get(self, "snat")

    @_builtins.property
    @pulumi.getter
    def snatpool(self) -> _builtins.str:
        return pulumi.get(self, "snatpool")

    @_builtins.property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> _builtins.bool:
        return pulumi.get(self, "source_address")

    @_builtins.property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_client_hello")

    @_builtins.property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_server_handshake")

    @_builtins.property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_server_hello")

    @_builtins.property
    @pulumi.getter(name="sslSessionId")
    def ssl_session_id(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_session_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tcl(self) -> _builtins.bool:
        return pulumi.get(self, "tcl")

    @_builtins.property
    @pulumi.getter(name="tcpNagle")
    def tcp_nagle(self) -> _builtins.bool:
        return pulumi.get(self, "tcp_nagle")

    @_builtins.property
    @pulumi.getter
    def text(self) -> _builtins.str:
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> _builtins.str:
        return pulumi.get(self, "tm_name")

    @_builtins.property
    @pulumi.getter
    def uie(self) -> _builtins.bool:
        return pulumi.get(self, "uie")

    @_builtins.property
    @pulumi.getter
    def universal(self) -> _builtins.bool:
        return pulumi.get(self, "universal")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def virtual(self) -> _builtins.str:
        return pulumi.get(self, "virtual")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> _builtins.str:
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> _builtins.int:
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter
    def wam(self) -> _builtins.bool:
        return pulumi.get(self, "wam")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.bool:
        return pulumi.get(self, "write")

    @_builtins.property
    @pulumi.getter
    def forward(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "forward")

    @_builtins.property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "http_host")


@pulumi.output_type
class GetPolicyRuleConditionResult(dict):
    def __init__(__self__, *,
                 address: _builtins.bool,
                 all: _builtins.bool,
                 app_service: _builtins.str,
                 browser_type: _builtins.bool,
                 browser_version: _builtins.bool,
                 case_insensitive: _builtins.bool,
                 case_sensitive: _builtins.bool,
                 cipher: _builtins.bool,
                 cipher_bits: _builtins.bool,
                 client_ssl: _builtins.bool,
                 code: _builtins.bool,
                 common_name: _builtins.bool,
                 contains: _builtins.bool,
                 continent: _builtins.bool,
                 country_code: _builtins.bool,
                 country_name: _builtins.bool,
                 cpu_usage: _builtins.bool,
                 datagroup: _builtins.str,
                 device_make: _builtins.bool,
                 device_model: _builtins.bool,
                 domain: _builtins.bool,
                 ends_with: _builtins.bool,
                 equals: _builtins.bool,
                 expiry: _builtins.bool,
                 extension: _builtins.bool,
                 external: _builtins.bool,
                 geoip: _builtins.bool,
                 greater: _builtins.bool,
                 greater_or_equal: _builtins.bool,
                 host: _builtins.bool,
                 http_basic_auth: _builtins.bool,
                 http_cookie: _builtins.bool,
                 http_header: _builtins.bool,
                 http_host: _builtins.bool,
                 http_method: _builtins.bool,
                 http_referer: _builtins.bool,
                 http_set_cookie: _builtins.bool,
                 http_status: _builtins.bool,
                 http_uri: _builtins.bool,
                 http_user_agent: _builtins.bool,
                 http_version: _builtins.bool,
                 index: _builtins.int,
                 internal: _builtins.bool,
                 isp: _builtins.bool,
                 last15secs: _builtins.bool,
                 last1min: _builtins.bool,
                 last5mins: _builtins.bool,
                 less: _builtins.bool,
                 less_or_equal: _builtins.bool,
                 local: _builtins.bool,
                 major: _builtins.bool,
                 matches: _builtins.bool,
                 minor: _builtins.bool,
                 missing: _builtins.bool,
                 mss: _builtins.bool,
                 not_: _builtins.bool,
                 org: _builtins.bool,
                 password: _builtins.bool,
                 path: _builtins.bool,
                 path_segment: _builtins.bool,
                 port: _builtins.bool,
                 present: _builtins.bool,
                 protocol: _builtins.bool,
                 query_parameter: _builtins.bool,
                 query_string: _builtins.bool,
                 region_code: _builtins.bool,
                 region_name: _builtins.bool,
                 remote: _builtins.bool,
                 request: _builtins.bool,
                 response: _builtins.bool,
                 route_domain: _builtins.bool,
                 rtt: _builtins.bool,
                 scheme: _builtins.bool,
                 server_name: _builtins.bool,
                 ssl_cert: _builtins.bool,
                 ssl_client_hello: _builtins.bool,
                 ssl_extension: _builtins.bool,
                 ssl_server_handshake: _builtins.bool,
                 ssl_server_hello: _builtins.bool,
                 starts_with: _builtins.bool,
                 tcp: _builtins.bool,
                 text: _builtins.bool,
                 tm_name: _builtins.str,
                 unnamed_query_parameter: _builtins.bool,
                 user_agent_token: _builtins.bool,
                 username: _builtins.bool,
                 value: _builtins.bool,
                 values: Sequence[_builtins.str],
                 version: _builtins.bool,
                 vlan: _builtins.bool,
                 vlan_id: _builtins.bool):
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "app_service", app_service)
        pulumi.set(__self__, "browser_type", browser_type)
        pulumi.set(__self__, "browser_version", browser_version)
        pulumi.set(__self__, "case_insensitive", case_insensitive)
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "cipher", cipher)
        pulumi.set(__self__, "cipher_bits", cipher_bits)
        pulumi.set(__self__, "client_ssl", client_ssl)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "contains", contains)
        pulumi.set(__self__, "continent", continent)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "cpu_usage", cpu_usage)
        pulumi.set(__self__, "datagroup", datagroup)
        pulumi.set(__self__, "device_make", device_make)
        pulumi.set(__self__, "device_model", device_model)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "ends_with", ends_with)
        pulumi.set(__self__, "equals", equals)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "external", external)
        pulumi.set(__self__, "geoip", geoip)
        pulumi.set(__self__, "greater", greater)
        pulumi.set(__self__, "greater_or_equal", greater_or_equal)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        pulumi.set(__self__, "http_cookie", http_cookie)
        pulumi.set(__self__, "http_header", http_header)
        pulumi.set(__self__, "http_host", http_host)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "http_referer", http_referer)
        pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        pulumi.set(__self__, "http_status", http_status)
        pulumi.set(__self__, "http_uri", http_uri)
        pulumi.set(__self__, "http_user_agent", http_user_agent)
        pulumi.set(__self__, "http_version", http_version)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "internal", internal)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "last15secs", last15secs)
        pulumi.set(__self__, "last1min", last1min)
        pulumi.set(__self__, "last5mins", last5mins)
        pulumi.set(__self__, "less", less)
        pulumi.set(__self__, "less_or_equal", less_or_equal)
        pulumi.set(__self__, "local", local)
        pulumi.set(__self__, "major", major)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "minor", minor)
        pulumi.set(__self__, "missing", missing)
        pulumi.set(__self__, "mss", mss)
        pulumi.set(__self__, "not_", not_)
        pulumi.set(__self__, "org", org)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_segment", path_segment)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "present", present)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query_parameter", query_parameter)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "region_code", region_code)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "remote", remote)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "route_domain", route_domain)
        pulumi.set(__self__, "rtt", rtt)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_cert", ssl_cert)
        pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        pulumi.set(__self__, "ssl_extension", ssl_extension)
        pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        pulumi.set(__self__, "starts_with", starts_with)
        pulumi.set(__self__, "tcp", tcp)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "tm_name", tm_name)
        pulumi.set(__self__, "unnamed_query_parameter", unnamed_query_parameter)
        pulumi.set(__self__, "user_agent_token", user_agent_token)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vlan", vlan)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.bool:
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def all(self) -> _builtins.bool:
        return pulumi.get(self, "all")

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> _builtins.str:
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> _builtins.bool:
        return pulumi.get(self, "browser_type")

    @_builtins.property
    @pulumi.getter(name="browserVersion")
    def browser_version(self) -> _builtins.bool:
        return pulumi.get(self, "browser_version")

    @_builtins.property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> _builtins.bool:
        return pulumi.get(self, "case_insensitive")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> _builtins.bool:
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter
    def cipher(self) -> _builtins.bool:
        return pulumi.get(self, "cipher")

    @_builtins.property
    @pulumi.getter(name="cipherBits")
    def cipher_bits(self) -> _builtins.bool:
        return pulumi.get(self, "cipher_bits")

    @_builtins.property
    @pulumi.getter(name="clientSsl")
    def client_ssl(self) -> _builtins.bool:
        return pulumi.get(self, "client_ssl")

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.bool:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.bool:
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def contains(self) -> _builtins.bool:
        return pulumi.get(self, "contains")

    @_builtins.property
    @pulumi.getter
    def continent(self) -> _builtins.bool:
        return pulumi.get(self, "continent")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> _builtins.bool:
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="countryName")
    def country_name(self) -> _builtins.bool:
        return pulumi.get(self, "country_name")

    @_builtins.property
    @pulumi.getter(name="cpuUsage")
    def cpu_usage(self) -> _builtins.bool:
        return pulumi.get(self, "cpu_usage")

    @_builtins.property
    @pulumi.getter
    def datagroup(self) -> _builtins.str:
        return pulumi.get(self, "datagroup")

    @_builtins.property
    @pulumi.getter(name="deviceMake")
    def device_make(self) -> _builtins.bool:
        return pulumi.get(self, "device_make")

    @_builtins.property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> _builtins.bool:
        return pulumi.get(self, "device_model")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.bool:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="endsWith")
    def ends_with(self) -> _builtins.bool:
        return pulumi.get(self, "ends_with")

    @_builtins.property
    @pulumi.getter
    def equals(self) -> _builtins.bool:
        return pulumi.get(self, "equals")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.bool:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> _builtins.bool:
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def external(self) -> _builtins.bool:
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def geoip(self) -> _builtins.bool:
        return pulumi.get(self, "geoip")

    @_builtins.property
    @pulumi.getter
    def greater(self) -> _builtins.bool:
        return pulumi.get(self, "greater")

    @_builtins.property
    @pulumi.getter(name="greaterOrEqual")
    def greater_or_equal(self) -> _builtins.bool:
        return pulumi.get(self, "greater_or_equal")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.bool:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> _builtins.bool:
        return pulumi.get(self, "http_basic_auth")

    @_builtins.property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> _builtins.bool:
        return pulumi.get(self, "http_cookie")

    @_builtins.property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> _builtins.bool:
        return pulumi.get(self, "http_header")

    @_builtins.property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> _builtins.bool:
        return pulumi.get(self, "http_host")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> _builtins.bool:
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> _builtins.bool:
        return pulumi.get(self, "http_referer")

    @_builtins.property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> _builtins.bool:
        return pulumi.get(self, "http_set_cookie")

    @_builtins.property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> _builtins.bool:
        return pulumi.get(self, "http_status")

    @_builtins.property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> _builtins.bool:
        return pulumi.get(self, "http_uri")

    @_builtins.property
    @pulumi.getter(name="httpUserAgent")
    def http_user_agent(self) -> _builtins.bool:
        return pulumi.get(self, "http_user_agent")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> _builtins.bool:
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.int:
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> _builtins.bool:
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> _builtins.bool:
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter
    def last15secs(self) -> _builtins.bool:
        return pulumi.get(self, "last15secs")

    @_builtins.property
    @pulumi.getter
    def last1min(self) -> _builtins.bool:
        return pulumi.get(self, "last1min")

    @_builtins.property
    @pulumi.getter
    def last5mins(self) -> _builtins.bool:
        return pulumi.get(self, "last5mins")

    @_builtins.property
    @pulumi.getter
    def less(self) -> _builtins.bool:
        return pulumi.get(self, "less")

    @_builtins.property
    @pulumi.getter(name="lessOrEqual")
    def less_or_equal(self) -> _builtins.bool:
        return pulumi.get(self, "less_or_equal")

    @_builtins.property
    @pulumi.getter
    def local(self) -> _builtins.bool:
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter
    def major(self) -> _builtins.bool:
        return pulumi.get(self, "major")

    @_builtins.property
    @pulumi.getter
    def matches(self) -> _builtins.bool:
        return pulumi.get(self, "matches")

    @_builtins.property
    @pulumi.getter
    def minor(self) -> _builtins.bool:
        return pulumi.get(self, "minor")

    @_builtins.property
    @pulumi.getter
    def missing(self) -> _builtins.bool:
        return pulumi.get(self, "missing")

    @_builtins.property
    @pulumi.getter
    def mss(self) -> _builtins.bool:
        return pulumi.get(self, "mss")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> _builtins.bool:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def org(self) -> _builtins.bool:
        return pulumi.get(self, "org")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.bool:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.bool:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathSegment")
    def path_segment(self) -> _builtins.bool:
        return pulumi.get(self, "path_segment")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.bool:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def present(self) -> _builtins.bool:
        return pulumi.get(self, "present")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.bool:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="queryParameter")
    def query_parameter(self) -> _builtins.bool:
        return pulumi.get(self, "query_parameter")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> _builtins.bool:
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> _builtins.bool:
        return pulumi.get(self, "region_code")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.bool:
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter
    def remote(self) -> _builtins.bool:
        return pulumi.get(self, "remote")

    @_builtins.property
    @pulumi.getter
    def request(self) -> _builtins.bool:
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter
    def response(self) -> _builtins.bool:
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> _builtins.bool:
        return pulumi.get(self, "route_domain")

    @_builtins.property
    @pulumi.getter
    def rtt(self) -> _builtins.bool:
        return pulumi.get(self, "rtt")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> _builtins.bool:
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> _builtins.bool:
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_cert")

    @_builtins.property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_client_hello")

    @_builtins.property
    @pulumi.getter(name="sslExtension")
    def ssl_extension(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_extension")

    @_builtins.property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_server_handshake")

    @_builtins.property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_server_hello")

    @_builtins.property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> _builtins.bool:
        return pulumi.get(self, "starts_with")

    @_builtins.property
    @pulumi.getter
    def tcp(self) -> _builtins.bool:
        return pulumi.get(self, "tcp")

    @_builtins.property
    @pulumi.getter
    def text(self) -> _builtins.bool:
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> _builtins.str:
        return pulumi.get(self, "tm_name")

    @_builtins.property
    @pulumi.getter(name="unnamedQueryParameter")
    def unnamed_query_parameter(self) -> _builtins.bool:
        return pulumi.get(self, "unnamed_query_parameter")

    @_builtins.property
    @pulumi.getter(name="userAgentToken")
    def user_agent_token(self) -> _builtins.bool:
        return pulumi.get(self, "user_agent_token")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.bool:
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.bool:
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.bool:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> _builtins.bool:
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> _builtins.bool:
        return pulumi.get(self, "vlan_id")


