# Generated by Django 3.2.9 on 2022-01-07 13:44

import django.db.models.deletion
import django.db.models.manager
import django_handleref.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_fullctl", "0017_alter_organizationuser_options"),
    ]

    operations = [
        migrations.AddField(
            model_name="task",
            name="org",
            field=models.ForeignKey(
                blank=True,
                help_text="Task belongs to this organization",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="django_fullctl.organization",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="user",
            field=models.ForeignKey(
                blank=True,
                help_text="Task was started by this user",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.CreateModel(
            name="TaskSchedule",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "created",
                    django_handleref.models.CreatedDateTimeField(
                        auto_now_add=True, verbose_name="Created"
                    ),
                ),
                (
                    "updated",
                    django_handleref.models.UpdatedDateTimeField(
                        auto_now=True, verbose_name="Updated"
                    ),
                ),
                ("version", models.IntegerField(default=0)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ok", "Ok"),
                            ("pending", "Pending"),
                            ("deactivated", "Deactivated"),
                            ("failed", "Failed"),
                            ("expired", "Expired"),
                        ],
                        default="ok",
                        max_length=12,
                    ),
                ),
                (
                    "interval",
                    models.PositiveIntegerField(help_text="Interval in seconds"),
                ),
                ("repeat", models.BooleanField(default=False, help_text="Repeat task")),
                (
                    "schedule",
                    models.DateTimeField(
                        db_index=True, help_text="Next scheduled execution"
                    ),
                ),
                (
                    "description",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("task_config", models.JSONField(help_text="Task setup")),
                (
                    "org",
                    models.ForeignKey(
                        blank=True,
                        help_text="Task schedule belongs to this organization",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_fullctl.organization",
                    ),
                ),
                ("tasks", models.ManyToManyField(blank=True, to="django_fullctl.Task")),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        help_text="Task schedule was started by this user",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Scheduled Task",
                "verbose_name_plural": "Scheduled Tasks",
                "db_table": "fullctl_task_schedule",
            },
            managers=[
                ("handleref", django.db.models.manager.Manager()),
            ],
        ),
    ]
