Cognite Python SDK Generator
==========================

[![release](https://img.shields.io/github/actions/workflow/status/cognitedata/pygen/release.yaml?style=for-the-badge)](https://github.com/cognitedata/pygen/actions/workflows/release.yaml)
[![Documentation Status](https://readthedocs.com/projects/cognite-pygen/badge/?version=latest&style=for-the-badge)](https://cognite-pygen.readthedocs-hosted.com/en/latest/?badge=latest)
[![Github](https://shields.io/badge/github-cognite/pygen-green?logo=github&style=for-the-badge)](https://github.com/cognitedata/pygen)
[![PyPI](https://img.shields.io/pypi/v/cognite-pygen?style=for-the-badge)](https://pypi.org/project/cognite-pygen/)
[![Downloads](https://img.shields.io/pypi/dm/cognite-pygen?style=for-the-badge)](https://pypistats.org/packages/cognite-pygen)
[![GitHub](https://img.shields.io/github/license/cognitedata/pygen?style=for-the-badge)](https://github.com/cognitedata/pygen/blob/master/LICENSE)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg?style=for-the-badge)](https://github.com/ambv/black)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json&style=for-the-badge)](https://github.com/astral-sh/ruff)
[![mypy](https://img.shields.io/badge/mypy-checked-000000.svg?style=for-the-badge&color=blue)](http://mypy-lang.org)

This is the Cognite Python SDK Generator, `pygen`. The purpose of this package is to help developers to
work with Cognite Data Fusion's (CDF) Data Models (DM) in Python.

The core functionality is to provide a Python client that matches a data model. This enables the developer for the following
benefits

* Client-side validation of the data before writing it to CDF.
* Autocompletion is matching the data model in the integrated developer environment (IDE). This is important as it enables:
  * Discoverability of a data model through Python.
  * Reduced typing errors in development.
* Keeping the language domain specific for the developer. Instead of working with generic concepts such as instances,
  nodes and edges, the developer can work with the concepts in the data model.

## Documentation

See the [documentation](https://cognite-pygen.readthedocs-hosted.com/en/latest/) for more information.

## Installation

### Without any optional dependencies

To install this package without CLI support:
```bash
pip install cognite-pygen
```

### With optional dependencies

* `cli` This includes CLI support such that you can run the package from the command line.

```bash
pip install cognite-pygen[cli]
```
If using zsh:
```bash
pip install 'cognite-pygen[cli]'
```

## Usage

The goal of the package is to have representations of all the types in a given data model with API calls to *.list()*,
*.apply()*, *.delete()*, and *.retrieve()* individuals for each type.

![image](https://github.com/cognitedata/pygen/assets/60234212/b9942595-424c-4c5e-8a9c-37a43e0a5a7c)

![image](https://github.com/cognitedata/pygen/assets/60234212/70a5f6b0-cec0-4178-93e1-4f9902658638)


## Creating a Python SDK from a Data Model

Given a Data Model with external id `Movie` in the space `movies` in CDF, the following command will generate a Python SDK
```bash
pygen generate --space movies \
    --external-id Movie \
    --version 1 \
    --tenant-id <tenant-id> \
    --client-id <client-id> \
    --client-secret <client-secret> \
    --cdf-cluster <cdf-cluster> \
    --cdf-project <cdf-project>
```

If you are not using Microsoft Entra ID (Azure AD) you need to specify the parameter --token-url, --scopes and --audience instead of --tenant-id.

## Dependencies

### Dependencies for the generated SDK

* [cognite-sdk](https://cognite-sdk-python.readthedocs-hosted.com/en/latest/) This is the basis for all requests to the Cognite Data Fusion API.
* [pydantic](https://docs.pydantic.dev/latest/) This is used for all data classes in the generated SDK.
* [pandas](https://pandas.pydata.org/docs/) This is used for `.to_pandas()` methods in the generated SDK.

### Dependencies for the `pygen`

* [jinja2](https://jinja.palletsprojects.com/en/3.1.x/) This is used for the templating of the generated SDK.
* [inflect](https://pypi.org/project/inflect/) This is used for the singularization/pluralization of words in the generated SDK.
* [typer](https://typer.tiangolo.com/) (Optional) This is used for the CLI of the `pygen` package.
* [black](https://pypi.org/project/black/) (Optional) This is used to format the code generated by the `pygen` package.


## Changelog
Wondering about previous changes to the SDK? Take a look at the [CHANGELOG](https://github.com/cognitedata/pygen/blob/master/docs/CHANGELOG.md).

## Contributing
Want to contribute? Check out [CONTRIBUTING](https://github.com/cognitedata/pygen/blob/master/CONTRIBUTING.md).
