from __future__ import annotations
from typing import Protocol, runtime_checkable, AsyncIterator, Any

@runtime_checkable
class FileServicePort(Protocol):
    def upload_file(self, file_bytes: bytes, filename: str, params: dict[str, Any] | None = None, token: str | None = None) -> dict: ...
    def commit_file(self, file_id: int, client_id: str, token: str | None = None) -> None: ...
    def list_files(self, limit: int = 10, offset: int = 0, filters: dict[str, Any] | None = None, sort: list[tuple[str, str]] | None = None, token: str | None = None) -> dict: ...
    def get_file(self, file_id: int, token: str | None = None) -> dict: ...
    def download_file(self, file_id: int, token: str | None = None) -> tuple[bytes, str, str]: ...
    def delete_file(self, file_id: int, token: str | None = None) -> None: ...

@runtime_checkable
class AsyncFileServicePort(Protocol):
    async def upload_file(self, file_bytes: bytes, filename: str, params: dict[str, Any] | None = None, token: str | None = None) -> dict: ...
    async def commit_file(self, file_id: int, client_id: str, token: str | None = None) -> None: ...
    async def list_files(self, limit: int = 10, offset: int = 0, filters: dict[str, Any] | None = None, sort: list[tuple[str, str]] | None = None, token: str | None = None) -> dict: ...
    async def get_file(self, file_id: int, token: str | None = None) -> dict: ...
    async def download_file(self, file_id: int, token: str | None = None) -> tuple[AsyncIterator[bytes], str, str]: ...
    async def delete_file(self, file_id: int, token: str | None = None) -> None: ...
