from __future__ import annotations

from typing import TYPE_CHECKING, Protocol

if TYPE_CHECKING:
    from cartographer.core import MacroRegistration, PrinterCartographer
    from cartographer.interfaces.printer import Endstop


class Integrator(Protocol):
    def setup(self) -> None: ...
    def register_cartographer(self, cartographer: PrinterCartographer) -> None: ...
    def register_macro(self, registration: MacroRegistration) -> None: ...
    def register_endstop_pin(self, chip_name: str, pin: str, endstop: Endstop) -> None: ...
    def register_coil_temperature_sensor(self) -> None: ...
