# CHANGELOG

## v1.15.3 (2025-07-16)

### Fix

* fix: Bundled renovate dependency bumps &amp; docs typo fixes ([`f04fd86`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f04fd8612042e2f218750c642943a90e8482aef2))

## v1.15.2 (2025-04-24)

### Fix

* fix: Add verify arg to gql client (#128) ([`c50cec0`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c50cec058bbefd59902e9dad6051723aee3a3e6d))

## v1.15.1 (2025-04-15)

### Fix

* fix: remove non-required detect cmd (#127) ([`14ff8da`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/14ff8dacf83b6a79e5391779779b04fa99717c1c))

## v1.15.0 (2025-04-10)

### Feature

* feat: Add Group input type controls in build pipelines (&amp;2) &amp; (#125) ([`a5bca5d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a5bca5d93fb404c57ca2fc7c3941cd5c9fc98150))

## v1.14.0 (2025-04-07)

### Documentation

* docs: add statement for benchmark contributions ([`3693222`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3693222faea8e0db1a8485b6b56eed036a122788))

### Feature

* feat: Add group controls for source_code code_changes (&amp;2), (#125), (#118) ([`dac4b1e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/dac4b1e17b27d75bb78d8b898ef90da9c3264ee9))

### Fix

* fix: Hardpin release dependencies ([`079c94a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/079c94a67ed5f3e0c93dacc22c8d6b30dbb369ca))

## v1.13.2 (2025-03-20)

### Fix

* fix: add dependency sbom to version control (#124) ([`d890086`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d890086614a6ebfe99e96e89efa06268d781a109))

## v1.13.1 (2025-03-18)

### Fix

* fix: add error handling for 404 responses (#117) ([`06bdb55`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/06bdb5573fe65ed63820496d5d48b63e0ef28b03))

## v1.13.0 (2025-03-14)

### Feature

* feat: add final instance type control functions (deployment) (#111) ([`b98fcb9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b98fcb96bc41440790e886ee60564b159e52f92f))

## v1.12.0 (2025-03-14)

### Feature

* feat: add cli option &#34;--no-ssl-verify&#34; to disable ssl cert verifications (#121) ([`a53ed08`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a53ed08882c7e70e8460d4c1aa247d140a15991a))

## v1.11.3 (2025-03-11)

### Fix

* fix: add better error handling for 1.1.14 (#120) ([`ce774b5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ce774b5bbce978f67f4e2542d1fdd25ee75a1d93))

## v1.11.2 (2025-03-11)

### Fix

* fix(deps): update dependency gql to v3.5.2 ([`2bd3d8a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2bd3d8a79245c0e32c959a41d97885222efd57d8))

## v1.11.1 (2025-02-27)

### Fix

* fix: error out with invalid projects &amp; groups ([`0485549`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0485549e4a9c9c3a5d024b487b135b3ec5cae2eb))

## v1.11.0 (2025-02-26)

### Feature

* feat: add instance controls for the final benchmark category (#111) ([`f421a20`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f421a207c015782c35fa3f183f67e5047c605e86))

## v1.10.0 (2025-02-25)

### Feature

* feat: add instance controls for dependencies &amp; build_pipelines (#111) ([`8648d76`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8648d7670bcd816acd660782d4864c4515b16214))

## v1.9.2 (2025-02-25)

### Fix

* fix(deps): update dependency gql to v3.5.1 ([`b7a93ef`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b7a93efa418f218433e74106a8250bde31c0df1c))

## v1.9.1 (2025-02-22)

### Fix

* fix(deps): update dependency tqdm to v4.67.1 ([`39aef73`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/39aef73af28a16b464d3bc5d9423e4b08ca5f5fb))

## v1.9.0 (2025-02-21)

### Documentation

* docs: move contrib doc to root dir ([`989a11c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/989a11c685edc2e551657f20a6f59f1edde42927))

* docs(license): add year ([`5da7570`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5da7570ee901289bc04c184e5d5dcb0edb7dfc45))

### Feature

* feat: add instance checks for build_worker &amp; build_environment ([`19fe076`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/19fe076b95536f49d97a0200d24442a5bad53d84))

## v1.8.1 (2025-02-19)

### Fix

* fix(deps): update dependency pyyaml to v6.0.2 ([`b7c2aaa`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b7c2aaa218f66069e6878b65840faacf2edbc99c))

## v1.8.0 (2025-02-17)

### Feature

* feat: add instance types for source_code categories (cont) ([`b44a288`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b44a2888b3c105eceac0f016741979213dac4022))

## v1.7.0 (2025-02-16)

### Feature

* feat: add instance type checks for code_changes &amp; file logging ([`4a2ff53`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4a2ff530cb074f7524e667a5695b2044a53fe088))

## v1.6.1 (2025-02-09)

### Fix

* fix: update url to new top level group (#110) ([`3dc634e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3dc634ed9f1d1b4b8d70404b937df354dbd34cb0))

## v1.6.0 (2025-01-20)

### Feature

* feat: support group &amp; instance URL inputs (&amp;2) ([`a3e45a8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a3e45a8ac8af9a0889b6d3e27bb9f9f3fa1a05f9))

## v1.5.1 (2024-12-06)

### Fix

* fix: Update dependency python-gitlab to ~=4.13.0 ([`9ab5b10`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9ab5b10bd0e27d3b1f2eead2d12d6e408c77c967))

## v1.5.0 (2024-11-21)

### Feature

* feat: Introduce related_issues for 1.1.2 (#32) ([`13cdee9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/13cdee900e8974cbeba8a9fe35c04e298b7811d6))

## v1.4.1 (2024-11-21)

### Fix

* fix: Timing bug on last_activity_at (#104) &amp; reference tags yaml parse (#105) ([`600ef8d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/600ef8d512ecb9ee406f3735342b719cba3664fe))

## v1.4.0 (2024-11-13)

### Feature

* feat: add oauth token support (#101 &amp; #102) ([`3d1d075`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3d1d07572bbe74f2a3d3f8a9507745db9ace6624))

## v1.3.2 (2024-10-29)

### Fix

* fix: update pypi API URL ([`8f81094`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8f8109469875ee5f99850885d4b3a3c37dab9f3b))

## v1.3.1 (2024-10-29)

### Fix

* fix: allow reporters to SKIP list errors ([`ed5a5b0`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ed5a5b09815e224b7e8fb06d21c6b2e74b7da697))

## v1.3.0 (2024-10-28)

### Documentation

* docs: update project repo link in README.md ([`5ab0107`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5ab010715759e61f6544cc26cb90b991e5a09761))

* docs: correct wording (#98) ([`9ef0893`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9ef0893da2a809be910b0ec098891eea65a85078))

### Feature

* feat: public release (#99) ([`3212222`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/32122222c86789b01a60da3510322ae63d89eab3))

## v1.2.0 (2024-10-11)

### Feature

* feat: apply controls for dog-fooding (#75 &amp; #89) ([`f1e521d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f1e521d770d13adba6174d23e7c301166612398d))

## v1.1.1 (2024-10-07)

### Fix

* fix: re-enable dependency scanning ([`c10e407`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c10e407ad17459aa2dbd95aa081c434a815bd9e6))

## v1.1.0 (2024-09-26)

### Documentation

* docs: update disclaimers, background &amp; usage ([`aafbe67`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/aafbe67c3432e73394cb717c97a757d64f657194))

### Feature

* feat: improve runtime, token handling &amp; pre-commit tools ([`0b0e02c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0b0e02cb48dfb2c9006eb427a9b29519167dd89c))

## v1.0.0 (2024-09-20)

### Documentation

* docs: add singular benchmark check step ([`463f8b7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/463f8b7da733654d63c31563706fa3f3402eee17))

* docs: add limitations ([`d8040b8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d8040b81d091ae5e81b9c6bef7e386aac2b4dcb3))

* docs: add limitations ([`7bfd0ac`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7bfd0ac35a6493c4c170c585441addcee33a49df))

* docs: add readme gif ([`afb3090`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/afb3090b51d15ccfe2bd81bab616cb45bbb69a2e))

* docs: update readme gif ([`f49d615`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f49d615be3235fb4e8f0e31952664d176da8965a))

* docs: add 1.2.3 &amp; 1.2.4 to SKIP by default - add to limitations ([`0c44d69`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0c44d69fa3464d3cf37cc56c25a4d65c1d91a9aa))

* docs: add statement on reason return ([`902600a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/902600aba930df29b87b9a379204ace1fdd48d16))

* docs: add 1.2.3 &amp; 1.2.4 ([`832465d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/832465d250b8d7745ac0d88c4a1514ed5fb0e7bc))

* docs: add 1.2.5 to limitations ([`801c429`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/801c429702b1a5d7390d50def5369d197946a8b7))

* docs: add 1.2.1 to limitations ([`a704075`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a704075295a9858f72e718de5e1e5356daf6b00a))

* docs: add admin level limitiation ([`d71e9af`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d71e9af6962f0ee67f370abab2daa7cb0fd67ccb))

* docs: add make init to local validation steps ([`b20e35c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b20e35c20ff9b705204650cc1d332423c26861a5))

* docs: add blurb about project-level tool usage ([`d88bce8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d88bce8f9d88982c410279b4359ac68482ad8c8b))

* docs: add 1.1.19 to limitations ([`616f501`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/616f501452e7d769144894ba62192ac5191276f0))

* docs: add benchmark limitations ([`b4f8c28`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b4f8c28224ffe8098ee0b89a0c02dfb5309f7230))

* docs: add approvals for recommendations (#38) ([`e107471`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e107471f704233ff19e2d3e6e39afdd4d47d1df3))

* docs: add SKIP option ([`550c046`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/550c04690f6c89c7ff6591018c16075bb6ef87da))

* docs: add local validation to MR template ([`776e59f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/776e59f9f55c8022b2a560e4669c9f35d3d98aea))

* docs: add git commit guidelines ([`10925ac`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/10925ac264570340eac3ffd203a9e730552152fb))

* docs: add background/overview ([`c28e9ad`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c28e9ad3d975640304fd10db7f661c2fc05b5137))

* docs: add background/overview ([`55e662a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/55e662a00715b5c9f40f20d30899725a7d1da785))

* docs: shift .md to docs dir (#33) ([`4eca9d4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4eca9d4e0aa95ef8f6795fab0069dee13b13e218))

### Feature

* feat: add pyproject (#80) ([`6fa629d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6fa629dbdf04556b9faa6933f79059c87716ef29))

* feat: Get &amp; Search a CI config file (#64) (#61) ([`da452c8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/da452c86169e1df489cb893f8e94e9d4254700ff))

* feat: add commitlint ([`91c736b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/91c736bb1c995671417733c0d08f1fde5179f4fb))

* feat: omit skipped results if enabled ([`98d22ce`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/98d22cee350b71a25b41c364ab8036dd8cfa2b42))

* feat: ensure tox runs coverage ([`47d9588`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/47d95886bcaafc19cde7bae11d234472f146ed63))

* feat: introduce tox tests for coverage ([`2cee283`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2cee283c7f91a6136d429fe45a4c8d4a31632d1b))

* feat: add SKIP for 1.3.13 ([`d393312`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d393312887c4e5ac35cc4c253cec1d799eeb19f8))

* feat: add SKIP for 1.3.12 ([`e19a5f1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e19a5f1725d31a4f07d7ba3dc210c8a84296ebd4))

* feat: add 1.3.11 ([`ebfae4e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ebfae4e0381b5dd53c4d115acc8f369bde2fe822))

* feat: skip 1.3.10 ([`eb7e698`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/eb7e698a516f20d68cfd72607e5b7dd692b9c690))

* feat: SKIP 1.3.9 ([`7098da2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7098da2906597fa3f542db15f7e40e201f56914d))

* feat: add 1.3.8 (SKIP by default) ([`e17d2da`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e17d2da72fa5bbe3920d031ebc8ae5059a035d2a))

* feat: add 1.3.7 ([`06be314`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/06be31447083b5dda0f7be4174e6f0e9a9ccef5a))

* feat: add 1.3.6 ([`7334ed4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7334ed449cdaed7f47157ea34bdd5ea1a9e17c0e))

* feat: add 1.3.5 ([`e911113`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e911113a5e161394f36a1d844ee3247df487d0af))

* feat: add 1.3.4 ([`05d0e22`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/05d0e226ccb81ff9dfd948ae9cfb15e635261dd7))

* feat: add 1.3.3 - SKIP if .com ([`ed93b9c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ed93b9c2e930a5013b3c5881318b09615d49e0e6))

* feat: add 1.3.2 ([`f4ef5d0`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f4ef5d0a3f51d9ef3614af704eb07332fb5c6cde))

* feat: add SKIP for 1.3.1 ([`7d380f8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7d380f80ca8c66cb160e5ea760ec7d94c28a577e))

* feat: calculate stats ([`1e331b2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1e331b24880228af7889890075bdd3e492ed87bd))

* feat: add stats to terminal output ([`16783cb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/16783cb5f1c73d88a3ba180c8b28af1369591c19))

* feat: add kwargs to benchmark functions ([`f0a70ed`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f0a70edd7fcefc1f3cca7a3cb456ec2bb1d2d516))

* feat: add python-dateutil requirement ([`0c41a94`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0c41a94be607169f43a8200b2cd7b9fc40dafe4d))

* feat: set maxcolwidth for results table ([`9eef88a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9eef88a6dfe91d184499452f3e0d35713d682831))

* feat: add repository_management to benchmarks import ([`1772ee3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1772ee3ea3894c221d608e4f2aa73208b3c34af2))

* feat: add reasons to repository_mgmt ([`ada0c62`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ada0c62524c89bbb0e2816c400dc85ea4b0836df))

* feat: add default SKIP for 1.2.6 ([`881e981`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/881e981ba482265319889f4e5bb6dd2631a9dfc4))

* feat: add default SKIP for 1.1.18 ([`58c8e76`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/58c8e76eea2f4c31fc9c7c0bff73065e988476c6))

* feat: add reason to table results ([`eac2e5a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/eac2e5aeccea6a734f01f83503bdd34feda4afa6))

* feat: add reasons to results ([`cd74482`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cd7448275c500a28726ff52ca3c1d1b1c1a1906c))

* feat: add 1.2.3 &amp; 1.2.4 ([`baf3da9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/baf3da98013b052049b3ef5a44cfd5d43e3bf657))

* feat: add 1.2.5 (#42) ([`c813d36`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c813d36a6e51e934a637eceaa200fdd2816ae3e2))

* feat: add 1.2.7 review_and_archive_stale_repos (#42) ([`5131168`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/513116869401bfa517ca7523b1bb2c044b1d5a31))

* feat: add yamllint ([`a17d78f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a17d78f1ef71866df429ac87558f2640f2a21e65))

* feat: add yamllint ([`27997be`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/27997be76ae91d99f97b3bdb2755c720118683fb))

* feat: add bandit scanning ([`93a2b54`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/93a2b54c4ea3dba14a8ca6bd852f24a505682617))

* feat: add lxml for xml outputs ([`5837c13`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5837c1304df6e407aa68390b33c8074be1847b63))

* feat: add a functional test for the pipeline token against this project ([`09029ac`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/09029ac9c7f2f7b4d198351c6342b68dc593c749))

* feat: add a build stage for the tool ([`79bbf33`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/79bbf3334c4b266e0c173301313ed7c0903438f3))

* feat: add 1.1.20 (#31) ([`a0c16eb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a0c16eb10649210e6a78708e242eaa6b38ca6270))

* feat: add 1.1.18 (#29) ([`ff7f4f6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ff7f4f6f1ba400fc96b9ba6e1d128da56154e9af))

* feat: add 1.1.17 (#28) ([`2d64992`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2d64992ce30b73a967a435fca09b77b99be0f519))

* feat: add 1.1.16 (#27) ([`a9fdeb7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a9fdeb7ce700f8393ba551fc1916c63fe9c8e83e))

* feat: add 1.1.15 (#26) ([`8248244`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8248244dd798ae82bffca698964d9bd10473efc9))

* feat: add 1.1.14 (#25) ([`6e3ded7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6e3ded7fd731365031dafd52148c69a7720d0442))

* feat: add SKIP icon ([`b5d0725`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b5d0725303d4157f221a2c4eac9a1f854a576f40))

* feat: add SKIP results ([`46900fa`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/46900fa867a30ffa3d2bf142558bf5d01025e8fb))

* feat: add error msg for insufficient token ([`e623711`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e623711088b7f63975e325916c16c245b6ca837e))

* feat: add error msg for insufficient token ([`099bf91`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/099bf91369d97e3a3c0d7ef05f8cf0412dfc9a20))

* feat: add txt format output ([`be95b2b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/be95b2b93f1234bb8efbc1999851ba82a449136c))

* feat: add txt format output ([`666fae5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/666fae5ed3e7817063368eea1e46cb16a565fd54))

* feat: add --remediations ([`48fac1a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/48fac1ad8646c1a29af50b9d3a461d6f75d9973f))

* feat: add --recommendations arg ([`cc183b7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cc183b7450f785eee42344aae65fae27de37e749))

* feat: add --version arg (#34) ([`453df88`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/453df880740f8db2caaf0406493998da6a9e64bc))

* feat: add initial codeowners (#33) ([`a459a77`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a459a77cb73a56ad529ef58d1d0589c96a69738c))

### Fix

* fix: update authors &amp; screenshots ([`11fa33f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/11fa33f0ab8476183133d3a80e2e3561fa74bca6))

* fix: update dep typo (#78) ([`373a9dd`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/373a9ddb6272c4909777119e5a73e6ae974ec7f5))

* fix: bool op switch (#71) ([`467df15`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/467df15430bb0b5194a6d953978583cb4c524e41))

* fix: check 2 project owners vs admins on 1.3.7 ([`8fe4a49`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8fe4a49e894b0c0ac2e959cecefcd4d1cc353405))

* fix: add grace period pass check for 1.3.5 ([`ecb50a9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ecb50a924c56574ada4c47d242d4f4bfaa589d42))

* fix: update title for 1.3.7 ([`4ee2af4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4ee2af4ec67ba4d2f55788d9973035161df31507))

* fix: add more key restrictions to 1.3.11 ([`9e105d2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9e105d268e01b73d577369faa6002cafe26867ed))

* fix: update 1.3.12 title ([`e8f3430`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e8f343030c8d033bc87dee6fe384ebe25659210a))

* fix: remove gitlab.com restriction ([`68f5328`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/68f5328e324f74ce95a785b9ab0f1e959b1a1a45))

* fix: update zerodivision error ([`357443b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/357443b5d989693bffcb4908f1158a7a22dcb94a))

* fix: final score of recommendations count ([`2c7b2f6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2c7b2f6454c2bd20c628cc3a924251dc5452e084))

* fix: update correct amount of benchmarks to execute, fix final score colour ([`6035659`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/60356599f1f4c031e47e64ab9e6fdedaf9c50f53))

* fix: re-introduce gitlab.com ([`e8a6fe5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e8a6fe55f14e179760c9e24fa1c762b7e2a269a4))

* fix: add FAIL when default branch is not protected ([`02515d4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/02515d45672cfae2af78bea57a883714b1d37a5d))

* fix: 1.1.7 code_owner_approval_required attr ([`691acee`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/691acee092952c1f05b038df951e68f0036c2e00))

* fix: 1.1.16 protected branch default ([`ba7cae5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ba7cae59faf877e2ade8d7dcfcf8f75bb6217ea9))

* fix: 1.1.16 fix fail ([`6f091b7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6f091b7f232a1ab891c630af0aa7b0c67db906a0))

* fix: safetynet a license check using a project pat ([`0e4e782`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0e4e782f8bec02cc12b7a8a5bdbdf69874f6d563))

* fix: remove gl.auth() for job tokens ([`67a0169`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/67a0169e27a651db88fc176114927b95ff97da21))

* fix: run pipeline test in debug ([`9dfea86`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9dfea86056afe976ca0088ed994219b4c005f96a))

* fix: add auth errors to debug ([`c60d591`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c60d5912890a4d1d53b6cf9f59dc73a12621e564))

* fix: add ci job token to gl.auth() ([`5073670`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/50736700214938cfc8131665004dd094124c6016))

* fix: replace JOB_TOKEN with CI_JOB_TOKEN ([`6d08a04`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6d08a042e9307f8877ac7895781cb4b2a8806e19))

* fix: build ([`8ffcc3a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8ffcc3a126bac9dbe157f2fafaac2a1d2fa7ee02))

* fix: add venv ([`9fac21d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9fac21de1862660cac7b16facd5d10304598c7ee))

* fix: add builder deps ([`d1ccea2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d1ccea240807008baa0b4d4c006e292a97099683))

* fix: builder ([`cb5a884`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cb5a8846db48000c7a1c7dbe1f11b41c7656a738))

* fix: unit ordering ([`d80c6f5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d80c6f5edfefad80ec05fba4802943241fcc9e27))

* fix: builder ([`50cec4b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/50cec4b86ae00463049aaf12110f7a0f3fed9b43))

* fix: needs ordering ([`ebc714e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ebc714ea8aeba95448bdb0d79160e90cbbfdf0d9))

* fix: add unit stage ([`76ea1c6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/76ea1c6b5688cb0af0db038d721b1ddf471ea45a))

* fix: add plan to license check ([`1a77a59`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1a77a5910dad7a3417d1148708b5c5b5ec64b872))

* fix: add 1.1.19 premium+ users ([`48c74ba`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/48c74babc42a2be4f2ad9d5906439b0f53af7a19))

* fix: remove SEP function, use future gql instead ([`e0a22d0`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e0a22d040b76443db67f3eb657a7db0b2069a622))

* fix: 1.1.17 title typo ([`2f10492`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2f104927f6b7e580eb956fc511ba2afa049cc8f1))

* fix: 1.1.7 check only default branch ([`0647e2b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0647e2b1975dcb0a11a834c6ef0be0b788d83f3b))

* fix: add Error when group/project is not found ([`72fb025`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/72fb0251551e86c1cb486a37dfe370b0ffd64df3))

* fix: add error handling and SKIP checks that do not have permissions ([`94dfeb4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/94dfeb4185804c074e12c93598149aebb4915d73))

* fix: add light blue escape code for SKIP ([`595e2ed`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/595e2ed2d722689682a2fdc52b5e39baccfc2719))

* fix: add error handling and SKIP checks that do not have permissions ([`24f9ff2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/24f9ff2a2d6e90189f40446f1292271d22f71449))

### Unknown

* Update __init__.py to add from origin_traceability ([`0c480d4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0c480d470f8b28423e065fe55c7558e9680b9c74))

* Update limitations.md to remove duplicates ([`80644a8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/80644a84840b7a6b1e7545fed9680e0244fc9a61))

* Update file deployment_configuration.py ([`2091305`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/209130595f0ca4052390d550788a0993503a1191))

* Deployment Configuration checks to Deployment ([`0dd732b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0dd732b9f221e060da00c1c28beb634241b24354))

* adding deployment_environment to deployment ([`2cd1c21`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2cd1c2194460440dcc16a1eae08d5b960c719497))

* adding Origin Traceability to artifacts ([`23a8b97`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/23a8b9747a039a22a92ef375ac47475c3bec8a68))

* adding-package_registries-in-artifacts ([`58995bc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/58995bcc27f793bca7f5fbe1666d4908e09451f3))

* Adding artifacts _ verification ([`a117734`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a117734d533faa8d0c7821dbae1fbc0890345dca))

* adding access to artifacts benchmarks in artifacts ([`dcd4a19`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/dcd4a19d15ed9e4f1ee7adeba36ea19f51b7e7c9))

* adding Pipeline Integrity in build pipeline ([`35e2790`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/35e27904e00c6797c424dcc7be4c46dd2d5f7e10))

* adding Pipeline Instructions &gt; Build Pipelines ([`3581109`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3581109be52844e5055885a96424d9e8bd3a7cdf))

* adding build_worker in build_pipelines ([`51b415c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/51b415cb7dce2d9e22aeab3557a7e017e1d5ec5d))

* Update limitations.md to add the assumption we made for 2.1.4,2.1.5, 2.1.6, 2.1.11 ([`72b39e6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/72b39e60fe8c227dcae7749b5dcd852e8a0ad748))

* build_environment part 2 - ([`3432f20`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3432f20a3751fc1f1c3e40c4af9b4fc3ac616a02))

* adding third_party_packages ([`398c31f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/398c31f5d0201c23b9f744769b2d01eb4cb33b48))

* Add Build Pipelines / Build Environment benchmarks ([`970f08e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/970f08eac76a157cc94dd407beb177b9f1b8dc6a))

* Add dependencies - validate_packages ([`33c7048`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/33c70488945da9eafabe93ae8f1a98d6a1cd35bf))

* Add source_code/code_risks Benchmarks ([`87daef7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/87daef7ad46d57dcaec1f2e8ff714b9afce1f7cf))

* Add Third Party Source Code benchmarks ([`7d0881e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7d0881ec00bb36eae08aa401717cfc07dbba4bf2))

* tidy: remove all job token references ([`bdd7641`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bdd76415a51dd4af3e753483e35920dc62f2f24e))

* tidy: remove all job token references ([`2a5dde5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2a5dde5bbf7b9035a846836ec74465d5ae4bb921))

* tidy: remove progress str ([`497b3e4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/497b3e4b72f4cd709f4b3194f848a9b2abc61624))

* tidy: Update progress bar ([`ff54012`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ff54012d8cb941c1bb476fcdd814e779fb089e87))

* tidy: remove newlines due to maxcolwidth ([`cc75483`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cc7548377a189a050acf3a87c5b3c5825e19d3ca))

* tidy: add new lines to reasons for smaller results table ([`fee74fc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/fee74fc72eea7fe51b543024152331effdcf889c))

* tidy: remove name column ([`d04dd91`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d04dd912205154b0f23d6a797a5ab8b4d5ffbc94))

* tidy: change order of columns ([`91f56d7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/91f56d7fadef35e39fbd3a6583f9a26a647f0ea1))

* tidy: fix typo ([`6c159d8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6c159d8f684a5a07481cfd3ed07880452f7beb4c))

* tidy: remove init from make statements ([`62a187a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/62a187aa27a132439fc5c38d4d15482c932455ac))

* add 1.2.2  limit_repo_creations (#42) ([`3331ee1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3331ee1770a2862da8c368f6d1f793c567abf798))

* 1.2.1 public_repos_have_security_file (#42) ([`6fec3e3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6fec3e38c36d4408026269cdbb0d89f1961c0704))

* tidy: add limitations reference in MR template ([`ec3cf82`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ec3cf82a02281056989de476f9aaf8fe2b15e36c))

* sast: add defusedxml and nosec for b405 false positive ([`4edf60b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4edf60bf98e49974cea988799a24f4f60ca71bc3))

* sast: Bandit lxml finding ([`30cb547`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/30cb5473efff6e50e67f8eeba0fda43ee46c6ccf))

* tidy: reorder lint tests ([`a6f3d61`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a6f3d61b1e337a76fa049bc97fb76121b32e4295))

* tidy: remove non required arg ([`0e7fc04`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0e7fc045ec69821b540283d41aae566bb296bd5a))

* add yaml / benchmark tests ([`5a1230c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5a1230cf08c418a367e26d4ba7ed7b5b896a1b32))

* tidy: 1 line the 1.1.16 check ([`b465dc1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b465dc1ebf087e030b0bffb9113ade112d9e5de2))

* tests: add Nonetype for bad permission functions ([`0108d56`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0108d56ae2f479580f8f26db16c2e3420a2c70a9))

* tidy: rm sec doc ([`b4704b2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b4704b282fa0a29442567b824b892462b4f9dc7f))

* fix ordering of output format ([`6b98f3b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6b98f3b1ae1ddfd6eabebd83a60bcf856dbed066))

* add 1.1.13 (#24) ([`b912888`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b912888187ebdc6fb67e8966f450f7d51cb7d875))

* fix correct path, typo 1.1.13 (#24) ([`5bbc083`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5bbc083c16ee14c56789d44ef0312b20aee71468))

* add 1.1.12 (#23) ([`4ff2a93`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4ff2a935659973438a022e77dd5476dd02c3728b))

* add 1.1.12 (#23) ([`861a4cb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/861a4cbb20c1dd173fdc008b3db81afc0e115995))

* add 1.1.11 (#22) ([`5f3abd8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5f3abd8f4e6899c4ac9bdf1ac9feec2ecf0ab9e7))

* fix 1.1.8 greater than (#19) ([`b1dedb6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b1dedb69d741b717e1589fa38370b9628fa36863))

* add 1.1.10 (#21) ([`8445490`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8445490244e463b56500170ec47de087af961703))

* add 1.1.9 (#20) ([`4c24b2e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4c24b2e5fc64c2182873669e4c7a06d26894ced2))

* add 1.1.8 (#19) ([`5cce6e3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5cce6e305b0ce878b64d5e456e9e44c8df5c86db))

* add 1.1.7 (#18) ([`5c7e955`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5c7e955a6ed6e16a5b91cb8d4f5fcc4e91722a21))

* add 1.1.6 (#17) ([`002e3b1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/002e3b179b492952444cba85d229dfd61c9fcf23))

* add 1.1.6 (#17) ([`7b3ce46`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7b3ce46d5dca6ab9a8842f325c3b80025ac4009e))

* remove redundant list compare, use set instead ([`a78e46d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a78e46d08d238df604b464e09bd1505e380029ec))

* add disclaimer on usage ([`8d255c4`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8d255c45686c84568b3bbf75c9bac975187fc2d9))

* change the PASS colour to a brighter green ([`6375935`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/637593551e09f432ef5a22abd99cbcd8204b987e))

* fix reset approvals check (#15) ([`bb08fa3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bb08fa315951efe041fd97375c7f26bc315b76a0))

* exclude zero authed users (#16) ([`d719993`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d7199939e7811473010fb2ab0a2c5915901565ab))

* add 1.1.5 (#16) ([`f4ea7b9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f4ea7b9ea701c927590283686041f47366413ac7))

* add 1.1.4 (#15) ([`4f1613b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4f1613b834b71081ee1e39470a675a5d90b71c91))

* add 1.1.3 (#14) ([`27666fe`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/27666fe5916a0b88cdc650f32b3dfa2c829b5e30))

* add 1.1.2 (#13) ([`7e1e0c8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7e1e0c813a48b24fe92b936d9a0ab9ce76b427ab))

* add 1.1.1 (#12) ([`ff81f3c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ff81f3c49d8d717c56c62e9a51487fea11f401a0))

* add install actions ([`cb728d2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cb728d209967afc585b20827af96911951182397))

* add a poc img ([`b42bb02`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b42bb026ce95123ac7c598320795de8e346f50bd))

* fix bandit.B318 for xml.minidom ([`9234690`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/92346904934cc9324f7421ac4f4587b26dc0a9eb))

* ensure output formats function ([`825ca18`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/825ca188facb7abaea3080f5829c27e5fb6ea7c4))

* ensure output format requires output file ([`c1aec31`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c1aec31873d137f354e376e7ba679e20ffc19a97))

* remove --quiet ([`601b9fc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/601b9fc31275dc00148cac404b2100465afc5f77))

* add dev testing info ([`2c85702`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2c85702625163a78d8d61f6789cba42443da1eff))

* update link text ([`42d666c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/42d666cb955a1911520aa5f9477224f30046633d))

* fix typo ([`b3291e1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b3291e18d04f4bbce938988f389e75d41f308794))

* update assign to cc ([`9aa06cc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9aa06ccd336d5ca2bd78a88dd895c82652cdb0cf))

* Add recommendations bullet points to readme ([`0a05a75`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0a05a75ab6806e5ffbcb5c009757ca03de349d9a))

* add recommendations list ([`f0dac10`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f0dac1053573124c4ce2899cacb33cfabba97e08))

* add recommendations list ([`567a648`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/567a6486588eb7a0dbe1721414ed4f032cb190d6))

* add sections to artifacts readme ([`b3ce677`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b3ce67744b88ae099a12a000da4d682da81575f0))

* add pipeline integrity to sections ([`5fec3e8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5fec3e809b8bb1cebf4433bcb395ab8cad3caec5))

* add sections to dependencies readme ([`ca6a119`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ca6a11957ba7f5bd92f38493e80c8980197a87f2))

* add sections to deployment readme ([`6f14fb7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6f14fb7be07a058d0ff9d0b057f479cc30133945))

* change links to folders instead of readmes ([`36ae194`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/36ae194a10f0172b96c1e6b78688d3c2f40059e4))

* change links to folders instead of readmes ([`fd6914d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/fd6914d3c6b996ed79d5d06ec4df3d84b6de9f88))

* add tqdm progress bar ([`7dbd8ce`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7dbd8ce505aedbe4fdabc5b713543a99e8bfaa4c))

* add tqdm progress bar ([`7e020d1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7e020d15d293f0b8b314e21e11408d75fb812e55))

* update assign self ([`3dc430f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3dc430fd7f4d32688ad69912e230c30e024447eb))

* remove individual test check ([`09c5067`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/09c5067a580d4a8a68fa5fbacee273b6a875e99a))

* add requester checklist ([`0d7e8de`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0d7e8de6b9c8eef1b47e1ace9a399d9acd6abfd8))

* update MR template for pytest checks ([`302615f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/302615f7a3f29099255fbbb3de2547712afc33da))

* update pytest fixtures ([`de00fdb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/de00fdba3fa20ce10b297862e11ec598d7c8328f))

* add benchmark unit tests ([`805f008`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/805f008f80ebfd5298002a9770d517701846e162))

* update yaml unit tests ([`da262a9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/da262a96ccbfafdc4872c2f1d85234dbcbdf64c1))

* fix pytest error ([`0fb5cbc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0fb5cbc93059239894da5116bd136b40ef7422ac))

* fix pytest error ([`61966f6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/61966f6568265db7adffe9f66552bb815c542904))

* add unit tests ([`6f98832`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6f98832080cf32117d20455b4432216c239465db))

* update MR template checklists ([`0b83acb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0b83acb49d11b2109876f986d4c83e0e86678885))

* add recommendation 1.1.1 ([`d18a41e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d18a41e8cb4e3b177631a244a552dcabd4cb2d69))

* add a counter ([`8216cf6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8216cf6e16ccc37c61b716787913ff31bf530143))

* sort benchmark func loader ([`30054e5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/30054e5bfe9513c5e052230bfe25619cb8294b9b))

* add filtering opts (#8) ([`2c0e71a`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2c0e71a81781bcf7d777ec99b8d4642bbe20c40e))

* setup easy install ([`cbc27ef`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cbc27eff452c35f7d20e97b14e1f85b49bdcb665))

* include deps ([`6a5b1b1`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6a5b1b1fec5df11890c3a7e4d975e1bdd7394b16))

* add install stanza ([`180ddf5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/180ddf5819a4eee9eddab8bf47803b599614f1c2))

* update build dep (#10) ([`f08a468`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f08a468e174075d732b7910750371eac3bd3f768))

* change gitlabcis dir path (#10) ([`35be4d7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/35be4d7f4d29846ea70fc953fe79a4b3ced7c27a))

* add makefile for gitlabcis (#10) ([`71315cc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/71315ccb9cf007543dd3734d5d0aafba7c385fb6))

* add build &amp; wheel for gitlabcis pkg (#10) ([`074a5b8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/074a5b83876aa9ef101099aa550aedb18442fd5b))

* refactor for gitlabcis (#10) ([`3a4002f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3a4002f3bcdb83344dd8c42cecd50bcf60be8a48))

* add first iteration sec doc (#3) ([`1d91610`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1d916103ed2dd84c4db45e066f8b1fe05a397c53))

* add a contrib doc (#4) ([`7c1d2a7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7c1d2a765bf2ee3eb7d94982f5be5a6dd4a85408))

* add issue templates (#9) ([`41ae024`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/41ae02491833fc307323e3a5d330d655771e1063))

* add MR templates (#9) ([`64b850d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/64b850d8722b5e46636fd0c57924646899fc045c))

* mv to gitlabcis (#10) ([`8fe3589`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8fe358965a1768795640152663afdf1eca1adf06))

* convert to gitlabcis ([`c720aaa`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c720aaae067673f073d676b5fa30b462d6fa0e51))

* Switch to gitlab_cis (#6) ([`ad3d1e8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ad3d1e8abf8a281b5cfb8373e6719b150638aa50))

* rm dedent ([`c7f68a2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c7f68a2c4533feb1a69ac7f864fe03c33613136b))

* extend python-gitlab version (#7) ([`ef9be13`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ef9be1359aa908b8174eea4ac6e36fafff1e2e59))

* Switch to gitlab_cis (#6) ([`4a9d092`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4a9d0928f41665e28688b93f499afadcf9de0ace))

* switch to gitlab-python (#7) ([`7508b45`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7508b459040b9171f2a1c29283a43049ebcbdd0e))

* switch to gitlab-python (#7) ([`1342b55`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1342b550aa37d06f92185451f2054ede4b4a0e28))

* add recommendation coverage (#6) ([`53e6885`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/53e688506081a941c042aaf4a0c0a314d013f982))

* tidy argparse ([`8de05b3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8de05b37358bdb1aa2715924bc69939c0896a279))

* v1.0.1 changes ([`19fcb33`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/19fcb334e174395440c40147709e54483b87dcb8))

* add references to template value test ([`67c1a54`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/67c1a54a6afc4f3db291b93842a35d02da9e1ab3))

* v1.0.1 changes ([`cb92645`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/cb92645feafb144acca0f59d73d276fc864ab374))

* v1.0.1 changes ([`e52567e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e52567ef00cfec2d47e1b0a274baf4c3d6cc72e3))

* v1.0.1 changes ([`908ce35`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/908ce35ea1ee9f18964c1b0208a9a83073182f37))

* v1.0.1 changes ([`6383cd8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6383cd85f17807e5736c2a24eee211f77620b10d))

* v1.0.1 changes ([`ab41b66`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ab41b66e741e1674a582d56200dcbc3a21e307d7))

* v1.0.1 changes ([`c4a670f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c4a670fd54566299cf96a349f4cbe454025bc9ef))

* v1.0.1 changes ([`30dd7af`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/30dd7afb2e1eb38a58df99b2c3eb262897dd4ae0))

* v1.0.1 changes ([`1e11510`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1e11510dbb0c5e800e0e9b22febb06d67e653501))

* v1.0.1 changes ([`de2ab76`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/de2ab76fc5a10176a67cd719cccb8a5e50a5e98c))

* v1.0.1 changes ([`ae32521`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ae3252162db5cbd3d21fe3284e76b1f06736df2b))

* increment version ([`8461919`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8461919601a2be1ef7c3df6c328dec3545f5a344))

* remove github mention ([`e147f88`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e147f888fbbcdf4048d5c27afd566e9a105483d8))

* add control coverage ([`17e7307`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/17e7307cbbc8a575ac4f074044e9d72f7f3e018f))

* add benchmark coverage ([`d3661ac`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d3661acdb896d2a11251118499612b2c82f583d3))

* fix pytest ([`d2ee889`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d2ee889b641b6fb76a648e608c87d650c0f1c69b))

* add first iteration of scanner ([`45a4066`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/45a406667f0d84e9f96f33331fd6a5e141ac86cc))

* add first iteration of benchmarks ([`6faf6d5`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6faf6d50368ed8b7a87ca37f4e09e96c5b0793b3))

* add debug 404s ([`612b404`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/612b4040a0f349cc386f16c291680e0b72236197))

* update dev reqs ([`e9e472e`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/e9e472e83c9f49a42dc4b262d23f43c333321d89))

* add deployment environment ([`f336251`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f336251424fd0888c5768b4a137827f79a596c99))

* fix pytest errors ([`a4177eb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a4177ebca40744fb47ef39d30672f7e73fda4d9d))

* add deployment ([`24d9c33`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/24d9c33231bc4f4a83f6ffa93e770c7f20e76bab))

* add origin traceability ([`a92fb65`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/a92fb6538ddd3c9d5f26247489d055f5774d2b25))

* add package_registries ([`4be3bf3`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4be3bf33d1d8fcbd76cbaa4d1732d7504f8bd2c8))

* fix pytest errors ([`2f35682`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2f35682fd1ca325cefbc22972d9e6b1dc9a936f1))

* add package registries ([`0f028ba`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0f028ba1a189a3a2d3def27417210e11b10175c5))

* add verification ([`9563732`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/95637329200890fb3f6e1863fd61efd45caf828f))

* add access to artifacts ([`ce983b6`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ce983b6938d9304a5acdca4b6b4a85f4b9ede116))

* add recommendations ([`81084e9`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/81084e987b0c3f3e08ef9858b40fd30a296ed33e))

* add validate_packages ([`6fb2e7d`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6fb2e7dbf3e2084e71839288b316896ec12eca3f))

* add artifacts ([`d9e8179`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d9e8179a2ea31f6f0b9e4b4084fa25075257ad4d))

* add dependencies ([`4ce8f2f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4ce8f2f9e40baa3e079104adfc23fe40a291da26))

* fix from pytest ([`ac3fa1b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ac3fa1bddffca135fc58af96dd052a59721af200))

* add pipeline_integrity ([`b1237fa`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b1237fa452b64c00a88854a0505a252df772cabe))

* remove template ([`5b4b55c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5b4b55c9a6ea757733b6adc4f4c90d9c6597904f))

* add pipeline_instructions ([`35a83d8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/35a83d8982d7b989ad28bdb797387d56bfcf7a37))

* add versioning ([`ce18a22`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/ce18a229cfa1388e0c066a23d613ce2b0ea9be9e))

* add linting ([`43ff638`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/43ff6381ca335d7659e88192c7052f7bb82b596b))

* add category &amp; sub_category tests ([`0e11695`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0e116950eb4d2ab1444877923283433c38a9fc8e))

* refactor ([`9d81500`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/9d81500a048f5f7ee04244d61c6c56a831c5bdfe))

* add tabulate for output ([`8131134`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/81311344b30f31af9f03b43fef2a23e213cd1fda))

* add build pipelines ([`4899a34`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4899a345613b364976b6d0f0a06fc7a817d40160))

* add pipeline dependencies ([`4636237`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4636237217f96636e5117296e95720e40b58000a))

* fix from local tests ([`8b704a0`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8b704a0efc8260c69f71ab0f49771addd2edba71))

* add docs ([`91917ec`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/91917ecbc39f226094824d57850d646dac07ebbf))

* add recommendations ([`3717c14`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/3717c14b6e8af434a4bb34d6e00b448ba506bdf6))

* add code risks ([`d490c25`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/d490c25ba828b708ec33e32f81433f7e2d16a5d5))

* fix template values ([`8ab2325`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/8ab2325b095a45d4f8e7830d69a0f4686d129b2a))

* add template value test ([`2f73219`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/2f73219cee880cb3df7090d521338458d6a963f6))

* add third party ([`7bffe7b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/7bffe7b0c58488abd63472a16c23f03f699557f8))

* add name id and filename tests to recommendations ([`5f4191c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/5f4191c02a2f4f48490dfe1122b208b555b1771b))

* increase id of template to exclude from testing errors ([`1a3d024`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/1a3d024d736063fd06f2c1fbe71df290102d93d2))

* add recommendations fixture ([`419084f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/419084fd6d2474d01b42e2ba35a2902f0d74c02f))

* ignore pytest cache ([`bd63552`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bd63552311e23fcaaf80b250d39851b3a4687404))

* include template ([`b2c0b6b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b2c0b6b8687dd6576ffc8bcd8beb3d677f9806f7))

* add verbose to pytest ([`b58a4c8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/b58a4c8b0a951f293f909f7b5349daab03743291))

* add yaml syntax test ([`c53c0ad`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c53c0adbf167fb6b778b584f9a45d4b508c9fbac))

* fix pytest error ([`08a9177`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/08a9177b9b9499736a23cff34c2cd49905b02e52))

* add pytest ([`6333f42`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/6333f424a7ddf32f8985a0cf3843d2051162b22d))

* add dependencies ([`f17ae89`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f17ae89f5324eb92f096df0a71f3754deda7720b))

* add ci ([`0bfc3a8`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/0bfc3a8881d7ac6f6883a1d96025cdaaac1ec6ce))

* edit refs ([`79c79eb`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/79c79eb8d754715219180ac8acb786c92b973470))

* add contribution_access ([`22d28bd`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/22d28bdab371eb5e577d9309f1c94904e476d38f))

* re-shuffle src ([`bee960b`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bee960b44a0b19adecad876574e7f3f705e7d127))

* fix line breaks ([`011681c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/011681c5bdd2ce096364d38b3a3c069179cb4346))

* re-shuffle src ([`51e34fe`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/51e34fe9ab1ec63f2a872c865c13ab931d8222e8))

* add mit license ([`bb6940c`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bb6940c7a456e9b2e20a69c65ee1767e0c942038))

* add repository_management ([`4813e38`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4813e38087f6245dfec5a3b30cf2533ef88ccc8d))

* update line breaks ([`c3deb6f`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c3deb6f796606aeed8d2b3cbf968f5fb80cfdf8b))

* add title ([`f745cbc`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/f745cbc22199553a0926fd5c7ef8f2ff0c33e911))

* add an ignore file ([`79d08b2`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/79d08b2e7373bb45b01d7b6ca994712f59a6e20f))

* add code_changes recommendations ([`4b9c829`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/4b9c829d7eac7bf2c1bcb53fde2a513e82844e8e))

* add main executor ([`bacd2b7`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/bacd2b780133ef3bdb6d5a2c16b721c01d06bb47))

* add recommendations ([`25ea8ce`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/25ea8ceaad36948fa79091623e0b786373a1e18a))

* Initial commit ([`c63f460`](https://gitlab.com/gitlab-security-oss/cis/gitlabcis/-/commit/c63f460a4829cd52e624b6d9f55ae5bb03367ab5))
