# 1.1 Code Changes

This section consists of security recommendations for code changes and how they should be done. It contains recommendations to protect the main branch of the application code. This branch is the most important one, because it contains the actual code that is being delivered to the costumer. It should be protected from any mistake or malicious deed in order to keep the software secured.

## Recommendations

* [1.1.1 - version_control.yml](./version_control.yml)
* [1.1.2 - code_tracing.yml](./code_tracing.yml)
* [1.1.3 - code_approvals.yml](./code_approvals.yml)
* [1.1.4 - code_approval_dismissals.yml](./code_approval_dismissals.yml)
* [1.1.5 - code_dismissal_restrictions.yml](./code_dismissal_restrictions.yml)
* [1.1.6 - code_owners.yml](./code_owners.yml)
* [1.1.7 - code_changes_require_code_owners.yml](./code_changes_require_code_owners.yml)
* [1.1.8 - stale_branch_reviews.yml](./stale_branch_reviews.yml)
* [1.1.9 - checks_pass_before_merging.yml](./checks_pass_before_merging.yml)
* [1.1.10 - branches_updated_before_merging.yml](./branches_updated_before_merging.yml)
* [1.1.11 - comments_resolved_before_merging.yml](./comments_resolved_before_merging.yml)
* [1.1.12 - commits_must_be_signed_before_merging.yml](./commits_must_be_signed_before_merging.yml)
* [1.1.13 - linear_history_required.yml](./linear_history_required.yml)
* [1.1.14 - branch_protections_for_admins.yml](./branch_protections_for_admins.yml)
* [1.1.15 - merging_restrictions.yml](./merging_restrictions.yml)
* [1.1.16 - ensure_force_push_is_denied.yml](./ensure_force_push_is_denied.yml)
* [1.1.17 - deny_branch_deletions.yml](./deny_branch_deletions.yml)
* [1.1.18 - auto_risk_scan_merges.yml](./auto_risk_scan_merges.yml)
* [1.1.19 - audit_branch_protections.yml](./audit_branch_protections.yml)
* [1.1.20 - default_branch_protected.yml](./default_branch_protected.yml)
