default_initial_settings = {
    "name": "Biqu BX",
    "manufacturer": "Biqu",
    "start_gcode": "; BIQU BX Start G-code
\n; For information on how to tune this profile and get the
\n; most out of your BX visit: https://github.com/looxonline/Marlin
\n; For the official github site visit: https://github.com/bigtreetech/BIQU-BX
\n
\nM117 Initial homing sequence.                         ; Home so that the probe is positioned to heat
\nG28
\n
\nM117 Probe heating position
\nG0 X65 Y5 Z1                                                   ; Move the probe to the heating position.
\n
\nM117 Getting the heaters up to temp!
\nM104 S140                                                          ; Set Extruder temperature, no wait
\nM140 S60                                                            ; Set Heat Bed temperature
\nM190 S60                                                            ; Wait for Heat Bed temperature
\n
\nM117 Waiting for probe to warm!                        ; Wait another 90s for the probe to absorb heat.
\nG4 S90 
\n
\nM117 Post warming re-home
\nG28                                                                      ; Home all axes again after warming
\n
\nM117 Z-Dance of my people
\nG34
\n
\nM117 ABL Probing
\nG29
\n
\nM900 K0 L0 T0                                 ;Edit the K and L values if you have calibrated a k factor for your filament
\nM900 T0 S0
\n
\nG1 Z2.0 F3000                                        ; Move Z Axis up little to prevent scratching of Heat Bed
\nG1 X4.1 Y10 Z0.3 F5000.0                      ; Move to start position
\n
\nM117 Getting the extruder up to temp
\nM140 S{data['bed_temp']}      ; Set Heat Bed temperature
\nM104 S{data['nozzle_temp']}    ; Set Extruder temperature
\nM109 S{data['nozzle_temp']}    ; Wait for Extruder temperature
\nM190 S{data['bed_temp']}      ; Wait for Heat Bed temperature
\n
\nG92 E0                                        ; Reset Extruder
\nM117 Purging
\nG1 X4.1 Y200.0 Z0.3 F1500.0 E15               ; Draw the first line
\nG1 X4.4 Y200.0 Z0.3 F5000.0                   ; Move to side a little
\nG1 X4.4 Y20 Z0.3 F1500.0 E30                  ; Draw the second line
\nG92 E0                                        ; Reset Extruder
\nM117 Lets make
\nG1 X8 Y20 Z0.3 F5000.0                        ; Move over to prevent blob squish",
    "end_gcode": "                               ;BIQU Default End Gcode\nG91                            ;Relative positioning\nG1 E-2 F2700                   ;Retract a bit\nG1 E-2 Z0.2 F2400              ;Retract a bit more and raise Z\nG1 X5 Y5 F3000                 ;Wipe out\nG1 Z10                         ;Raise Z by 10mm\nG90                            ;Return to absolute positioning\n\nG1 X0 Y{data['build_volume_y']}         ;TaDaaaa\nM106 S0                        ;Turn-off fan\nM104 S0                        ;Turn-off hotend\nM140 S0                        ;Turn-off bed\n\nM84 X Y E                      ;Disable all steppers but Z\n",
    "bed_temp": 60,
    "nozzle_temp": 210,
    "material_flow_percent": 100,
    "print_speed": 50,
    "travel_speed": 150.0,
    "dia_feed": 1.75,
    "build_volume_x": 250,
    "build_volume_y": 250,
    "build_volume_z": 250,
}
