default_initial_settings = {
    "name": "Imade3D JellyBOX 2",
    "manufacturer": "Imade3D",
    "start_gcode": ";---------------------------------------\n; ; ; Jellybox Start Script Begin ; ; ;\n;_______________________________________\n; for slicer: CURA 3\n; start gcode last modified Jun 1, 2019\n\n;              Print Settings Summary\n; (leave these alone: this is only a list of the slicing settings)\n; (overwriting these values will NOT change your printer's behavior)\n\nG21               ;metric values\nG90               ;absolute positioning\nM82               ;set extruder to absolute mode\nM107              ;start with the fan off\nM117 Preparing    ;write Preparing\nM190 S{data['bed_temp']}              ;wait for the bed to reach desired temperature\nM109 S180         ;wait for the extruder to reach 180C\nG28               ;home all axes\nM203 Z4           ;slow Z speed down for greater accuracy when probing\nG29 O             ;run auto bed leveling procedure IF leveling not active already\n; M500            ;optionally save the mesh\nM203 Z7           ;pick up z speed again for printing\nG28 X             ;home x to get as far from the plate as possible\nM420 S1           ;(re) enable bed leveling if turned off by the G28\nG0 Y0 F5000       ;position Y in front\nG0 Z15 F3000      ;position Z\nM109 S{data['nozzle_temp']}             ;wait for the extruder to reach desired temperature\nM300 S440 P300    ;play a tone\n; M0 Ready! Click to start ; optionally, stop and wait for user to continue\nM420 S1           ;(re) enable bed leveling to make iron-sure\nM117 Print starting   ;write Print starting\n;================ ;PRINT:LINE start\nG90               ;absolute positioning\nG92 E0            ;reset the extruder position\nM420 S1           ;(re) enable bed leveling to make iron-sure\nG0 Z0             ;get Z down\nM83               ;relative extrusion mode\nM420 S1           ;(re) enable bed leveling to make iron-sure\nG1 E20 F300       ;extrude __mm of feed stock\nG1 E18 F250       ;extrude __mm of feed stock\nG1 E10 F250       ;extrude __mm of feed stock\nG4 S2             ;pause for ooze\nM400              ;make sure all is finished\nM420 S1           ;(re) enable bed leveling to make iron-sure\nG0 F500 X3 Y0 Z0.3;get to the start of the LINE\nG1 E2 F300        ;extrude __mm of feed stock\nG1 F1000 X152 E7  ;print a thick LINE extruding __mm along the way\nG92 E0            ;reset the extruder position\n;---------------------------------------------\n; ; ; Jellybox Printer Start Script End ; ; ;\n;_____________________________________________\n",
    "end_gcode": "\n;---------------------------------\n;;; Jellybox End Script Begin ;;;\n;_________________________________\n; end gcode last modified Nov 30, 2018\nM117 Finishing Up ;write Finishing Up\n\nM107        ;turn the fan off\nM104 S0     ;extruder heater off\nM140 S0     ;bed heater off (if you have it)\nG91         ;relative positioning (includes extruder)\nG1 E-1 F2500 ;retract the filament a bit before lifting the nozzle to release some of the pressure\nG1 Z0.5 E-4 X-10 F9000 ;get out and retract filament even more\nG1 E-25 F2500 ;retract even more\nG90         ;absolute positioning (includes extruder)\nG28 X       ;home X so the head is out of the way\nG1 Y140     ;move Y forward, so the print is more accessible\nM84         ;steppers off\n\nM117 Print finished ;write Print finished\n;---------------------------------------\n;;; Jellybox End Script End ;;;\n;_______________________________________",
    "bed_temp": 60,
    "nozzle_temp": 210,
    "material_flow_percent": 100,
    "print_speed": 60,
    "travel_speed": 120,
    "dia_feed": 1.75,
    "build_volume_x": 180,
    "build_volume_y": 165,
    "build_volume_z": 145,
}
