default_initial_settings = {
    "name": "Lulzbot TAZ Pro Dual Extruder",
    "manufacturer": "Fargo Additive Manufacturing Equipment 3D, LLC",
    "start_gcode": "; This profile is designed specifically for the LulzBot TAZ Pro with Dual Extruder Tool Head\nM73 P0 ; clear GLCD progress bar\nM75 ; start GLCD timer\nM107 ; disable fans\nG90 ; absolute positioning\nM420 S0 ; disable previous leveling matrix\nM140 S{data['bed_temp']} ; begin bed temping up\nM104 S{150} T0  ; soften filament\nM104 S{150} T1  ; soften filament\nG28 ; home\nM117 Heating... ; LCD status message\nM109 R{150} T0 ; wait for temp\nM109 R{150} T1 ; wait for temp\nT0 ; select this extruder first\nM82 ; set extruder to absolute mode\nG92 E0 ; set extruder to zero\nG1 E-10 F100 ; retract 10mm of filament on first extruder\nG0 X50 F1000 ; move over to switch extruders\nT1 ; switch extruders\nM82 ; set extruder to absolute mode\nG92 E0 ; set extruder to zero\nG1 E-10 F100 ; retract 10mm of filament on second extruder\nM104 S{150} T0 ; set to wipe temp\nM104 S{150} T1 ; set to wipe temp\nM106 ; turn on fans to speed cooling\nT0 ; select first extruder for probing\nG1 X-16.5 Y100 F2000 ; move above wiper pad\nM117 Cooling... ; LCD status message\nM109 R{150} T0 ; wait for T0 to reach temp\nM109 R{150} T1 ; wait for T1 to reach temp\nM107 ; turn off fan\nG1 Z 1.0 ; push nozzle into wiper\nG1 X -16.5 Y100 F1000 ; slow wipe\nG1 X -16.5 Y90 F1000 ; slow wipe\nG1 X -15.5 Y86 F2000 ; fast wipe\nG1 X -17.5 Y80 F2000 ; fast wipe\nG1 X -15.5 Y74 F2000 ; fast wipe\nG1 X -17.5 Y70 F2000 ; fast wipe\nG1 X -16.5 Y68 F1000 ; slow wipe\nG1 X -16.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y60 F1000 ; slow wipe\nG1 X -14.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y46 F1000 ; slow wipe\nG1 X -17.5 Y60 F1000 ; slow wipe\nG1 X -16.5 Y60 F1000 ; slow wipe\nG1 X -16.5 Y42 F1000 ; slow wipe\nG1 X -15.5 Y40 F2000 ; fast wipe\nG1 X -17.5 Y38 F2000 ; fast wipe\nG1 X -15.5 Y36 F2000 ; fast wipe\nG1 X -17.5 Y34 F2000 ; fast wipe\nG1 X -16.5 Y30 F1000 ; slow wipe\nG1 X -16.5 Y19 F1000 ; slow wipe\nG1 X -16.5 Y19 Z20 F1000 ; raise extruder\nM106 S255 ; turn on fan to blow away fuzzies\nG4 S5 ; wait 5 seconds\nM107 ; turn off fan\nG0 X50 F1000 ; move over to switch extruders\nT1 ; switch to second extruder\nG1 X296.5 Y100  F5000 ; move E2 above second wiper pad\nG1 Z 1.0 ; push nozzle into wiper\nG1 X 296.5 Y100 F1000 ; slow wipe\nG1 X 296.5 Y90 F1000 ; slow wipe\nG1 X 297.5 Y86 F2000 ; fast wipe\nG1 X 295.5 Y80 F2000 ; fast wipe\nG1 X 297.5 Y74 F2000 ; fast wipe\nG1 X 295.5 Y70 F2000 ; fast wipe\nG1 X 296.5 Y68 F1000 ; slow wipe\nG1 X 296.5 Y60 F1000 ; slow wipe\nG1 X 298 Y60 F1000 ; slow wipe\nG1 X 298 Y46 F1000 ; slow wipe\nG1 X 295 Y46 F1000 ; slow wipe\nG1 X 295 Y60 F1000 ; slow wipe\nG1 X 298 Y60 F1000 ; slow wipe\nG1 X 298 Y46 F1000 ; slow wipe\nG1 X 295 Y46 F1000 ; slow wipe\nG1 X 295 Y60 F1000 ; slow wipe\nG1 X 298 Y60 F1000 ; slow wipe\nG1 X 298 Y46 F1000 ; slow wipe\nG1 X 295 Y46 F1000 ; slow wipe\nG1 X 295 Y60 F1000 ; slow wipe\nG1 X 296.5 Y60 F1000 ; slow wipe\nG1 X 296.5 Y42 F1000 ; slow wipe\nG1 X 297.5 Y40 F2000 ; fast wipe\nG1 X 295.5 Y38 F2000 ; fast wipe\nG1 X 297.5 Y36 F2000 ; fast wipe\nG1 X 295.5 Y34 F2000 ; fast wipe\nG1 X 297.5 Y30 F1000 ; slow wipe\nG1 X 296.5 Y19 F1000 ; slow wipe\nG1 X 296.5 Y19 Z20 F1000 ; raise extruder\nM106 S255 ; turn on fan to blow away fuzzies\nG4 S5 ; wait 5 seconds\nM107 ; turn off fan\nG0 X247 F1000 ; move over to switch extruders\nT0 ; switch to first extruder\nM109 R{150} ; heat to probe temp\nM204 S100 ; set accel for probing\nG29 ; probe sequence (for auto-leveling)\nM420 S1 ; enable leveling matrix\nM204 S500 ; set accel back to normal\nM104 S{data['nozzle_temp']}  T0 ; set extruder temp\nM104 S{data['nozzle_temp']}  T1 ; set extruder temp\nG1 X100 Y-29 Z0.5 F3000 ; move to open space\nM400 ; clear buffer\nM117 Heating... ; LCD status message\nM109 R{data['nozzle_temp']}  T0 ; set extruder temp and wait\nM109 R{data['nozzle_temp']}  T1 ; set extruder temp and wait\nM117 Purging... ; LCD status message\nT0 ; select this extruder first\nG1 E0 F100 ; undo retraction\nG92 E-30 ; set extruder negative amount to purge\nG1 E0 F100 ; purge XXmm of filament\nG1 E-3 F200 ; purge retraction\nG1 Z0.45 ; clear bed (barely)\nG1 X100 Y10 F4000 ; move above bed to shear off filament\nM106 S255 ; turn on fan\nG4 S7 ; wait 7 seconds\nM107 ; turn off fan\nG1 X180 Y-29 Z0.45 F3000 ; move to open space\nT1 ; set extruder\nG1 E0 F100 ; undo retraction\nG92 E-30 ; set extruder negative amount to purge\nG1 E0 F100 ; purge XXmm of filament\nG1 E-4 F200 ; purge retraction\nG1 Z0.35 ; clear bed (barely)\nG1 X180 Y10 F4000 ; move above bed to shear off filament\nT0 ; set extruder\nM190 R{data['bed_temp']} ; get bed temping up during first layer\nG1 Z2 E0 F75 ; raise head and 0 extruder\nM82 ; set to absolute mode\nM400 ; clear buffer\nM117 TAZ Printing... ; LCD status message\n",
    "end_gcode": "; part removal temp is hardcoded to 45\nM400\nM104 S0 T0 ; T0 hotend off\nM104 S0 T1 ; T1 hotend off\nM107 ; fans off\nG91 ; relative positioning\nT0\nG1 E-1 F300 ; retract the filament a bit before lifting the nozzle, to release some of the pressure\nG1 Z20 E-1 X-20 Y-20 F2000 ; move Z up a bit and retract filament even more\nG1 E0 ; re-prime extruder 1\nT1\nG1 E-1 F300 ; retract the filament a bit before lifting the nozzle, to release some of the pressure\nG1 E0 ; re-prime extruder 2\nT0\nM117 Cooling please wait ; progress indicator message\nG90 ; absolute positioning\nG1 Y0 F3000 ; move to cooling position\nM190 R45 ; set bed to cool off\nG1 Y280 F3000 ; present finished print\nM140 S0 ; cool down\nM77 ; stop GLCD timer\nM18 X Y E ; turn off x y and e axis\nG90 ; absolute positioning\nM117 Print complete ; progress indicator message\n",
    "bed_temp": 60,
    "nozzle_temp": 210,
    "material_flow_percent": 100,
    "print_speed": 60,
    "travel_speed": 120,
    "dia_feed": 2.85,
    "build_volume_x": 282,
    "build_volume_y": 286,
    "build_volume_z": 286,
}
