default_initial_settings = {
    "name": "SyndaverAxi2",
    "manufacturer": "Syndaver3D",
    "start_gcode": ";This G-Code has been generated specifically for Syndaver AXI 2 with Hemera toolhead\nM73 P0                                       ; clear LCD progress bar\nM75                                          ; Start LCD Print Timer\nM107                                         ; disable fans\nM420 S0                                      ; disable leveling matrix\nM82                                          ; set extruder to absolute mode\nG92 E0                                       ; set extruder position to 0\nM140 S{data['bed_temp']}     ; start bed heating up\nM104 S170                                    ; start nozzle heating up\nG28                                          ; home all axes\nM117 AXI Heating Up...\nG1 X-17.5 Y100 F3000                         ; move to wiper pad\nG1 Z10 F5000                                 ; move to wiper pad\nG29 L1                                       ; load leveling matrix slot 1\nG29 A                                        ; ensure mesh is enabled\nM109 R170                                    ; wait for nozzle to reach wiping temp\nG1 E-3                                       ; retract material before wipe\nM117 AXI Wiping Nozzle...\nG1 Z-3                                       ; lower nozzle\nG1 Y90 F1000                                 ; slow wipe\nG1 Y65 F1000                                 ; slow wipe\nG1 Y80 F1000                                 ; slow wipe\nG1 Y65 F1000                                 ; slow wipe\nG1 Y55 F1000                                 ; slow wipe\nG1 Y30 F3000                                 ; fast wipe\nG1 Y55 F3000                                 ; fast wipe\nG1 Y30 F3000                                 ; fast wipe\nG1 Y55 F3000                                 ; fast wipe\nG1 Z10                                       ; raise nozzle\nM117 Heating...\nM190 R{data['bed_temp']}     ; wait for bed to reach printing temp\nM104 S{data['nozzle_temp']}   ; set extruder to reach initial printing temp, held back for ooze reasons\nM117 Probe Z at Temp\nG28 Z                                        ; re-probe Z0 to account for any thermal expansion in the bed\nG1 X-17.5 Y80 F3000                          ; move to wiper pad\nG1 Z10 F5000                                 ; move to wiper pad\nM117 Heating...\nM109 R{data['nozzle_temp']}   ; wait for extruder to reach initial printing temp\nM117 AXI Wiping Nozzle...\nG1 E0                                        ; prime material in nozzle\nG1 Z-3                                       ; final ooze wipe\nG1 Y60 F2000                                 ; final ooze wipe\nG1 Y20 F2000                                 ; final ooze wipe\nM117 AXI Starting Print\nG1 Z2                                        ; move nozzle back up to not run into things on print start\nM400                                         ; wait for moves to finish\nM117 AXI Printing",
    "end_gcode": "M400                                               ; wait for moves to finish\nM140 S50                                           ; start bed cooling\nM104 S0                                            ; disable hotend\nM107                                               ; disable fans\nM117 Cooling please wait\nG91                                                ; relative positioning\nG1 Z5 F3000                                        ; move Z up 5mm so it wont drag on the print\nG90                                                ; absolute positioning\nG1 X5 Y5 F3000                                     ; move to cooling position\nM190 R50                                           ; wait for bed to cool down to removal temp\nG1 X145 Y260 F1000                                 ; present finished print\nM140 S0                                            ; cool down bed\nM77                                                ; End LCD Print Timer\nM18 X Y E                                          ; turn off x y and e axis\nM117 Print Complete.",
    "bed_temp": 60,
    "nozzle_temp": 210,
    "material_flow_percent": 100,
    "print_speed": 60,
    "travel_speed": 120,
    "dia_feed": 2.85,
    "build_volume_x": 280,
    "build_volume_y": 280,
    "build_volume_z": 280,
}
