default_initial_settings = {
    "name": "Tevo Tornado",
    "manufacturer": "Tevo",
    "start_gcode": "; start_gcode\nM117 Start Clean        ; Indicate nozzle clean in progress on LCD\n;\nM104 S{data['nozzle_temp']} \nM109 S{data['nozzle_temp']} \nM109 R{data['nozzle_temp']} \n;\nM107                    ; Turn layer fan off\nG21                     ; Set to metric [change to G20 if you want Imperial]\nG90                     ; Force coordinates to be absolute relative to the origin\nG28                     ; Home X/Y/Z axis\n;\nG1 X3 Y1 Z15 F9000      ; Move safe Z height to shear strings\nG0 X1 Y1 Z0.2 F9000     ; Move in 1mm from edge and up [z] 0.2mm\nG92 E0                  ; Set extruder to [0] zero\nG1 X100 E12 F500        ; Extrude 30mm filiment along X axis 100mm long to prime and clean the nozzle\nG92 E0                  ; Reset extruder to [0] zero end of cleaning run\nG1 E-1 F500             ; Retract filiment by 1 mm to reduce string effect\nG1 X180 F4000           ; quick wipe away from the filament line / purge\nM117 End Clean          ; Indicate nozzle clean in progress on LCD\n;\nM117 Printing...\n; Begin printing with sliced GCode after here\n;",
    "end_gcode": ";\n; end_gcode\nG92 E0                          ; zero the extruded length\nG1 E-5 F9000                    ; retract\nM104 S0                         ; turn off temperature\nM140 S0                         ; turn off bed\nG91                             ; relative positioning\nG1 E-1 F300                     ; retract the filament a bit before lifting the nozzle, to release some of the pressure\nG1 Z+20 E-5 X-20 Y-20 F7200     ; move Z up a bit and retract filament even more\nG1 X320 Y150 F10000             ; move right mid\nM107                            ; turn off layer fan\nM84                             ; disable motors\nG90                             ; absolute positioning\n;\n;EOF",
    "bed_temp": 60,
    "nozzle_temp": 210,
    "material_flow_percent": 100,
    "print_speed": 60,
    "travel_speed": 120,
    "dia_feed": 2.85,
    "build_volume_x": 300,
    "build_volume_y": 300,
    "build_volume_z": 400,
}
