# FullControl tutorials

the following tutorials introduce the concept of FullControl, walk through its capabilities, and give tips for creating designs in FullControl

they refer to ***designs***, ***state***, ***things*** and ***results***  which are defined in the broad overview tutorial notebook

these links open the notebooks directly in google colab

for use on a local system, clone this repo and open the contents notebooks (contents.ipynb) in this folder to navigate and open the other notebooks

### introductory documentation:
1. one-minute introduction to FullControl - [fast_demo.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/fast_demo_colab.ipynb)
1. broad overview of FullControl - [overview.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/overview_colab.ipynb)

### technical use of FullControl:
1. create a ***design*** in FullControl with built-in objects - [state_objects.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/state_objects_colab.ipynb)
1. format gcode - [gcode_controls.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/gcode_controls_colab.ipynb)
    - controls that can be used to adjust how a FullControl ***design*** is transformed into a 'gcode' ***result***
1. format plots - [plot_controls.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/plot_controls_colab.ipynb)
    - controls that can be used to adjust how a FullControl ***design*** is transformed into a 'plot' ***result***
1. geometric modeling functions - [geometry_functions.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/geometry_functions_colab.ipynb)
    - demonstration of built-in geometry functions that can be used to create, modify or measure points (or lists of points)
1. other FullControl functions - [other_functions.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/other_functions_colab.ipynb)

### tips and examples:
1. design tips - [design_tips.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/design_tips_colab.ipynb)
1. example model (nonplanar spacer) - [nonplanar_spacer.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/models/colab/nonplanar_spacer_colab.ipynb)
1. example model (nuts and bolts) - [nuts_and_bolts.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/models/colab/nuts_and_bolts_colab.ipynb)
1. colab design template - [design_template_colab.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/models/colab/design_template_colab.ipynb)
1. more designs are available on the fullcontrol [gists page](https://gist.github.com/fullcontrol-xyz)


### FullControl lab:
1. FullControl lab geometry - [lab_geometry.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/lab_geometry_colab.ipynb)
1. four-axis example - [lab_four_axis_demo.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/lab_four_axis_demo_colab.ipynb)
1. five-axis example - [lab_five_axis_demo.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/lab_five_axis_demo_colab.ipynb)
1. stl-output example - [lab_stl_output.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/lab_stl_output_colab.ipynb)
1. 3mf-output example - [lab_3mf_output.ipynb](https://colab.research.google.com/github/FullControlXYZ/fullcontrol/blob/master/tutorials/colab/lab_3mf_output_colab.ipynb)

