# Changelog

All notable changes to this project after version 1.0.1 will be documented in this file. There is
changelog data prior to this present, but it is not to be considered complete.

The format is based on \[Keep a Changelog\](<http://keepachangelog.com/en/1.0.0/>)
and this project adheres to \[Semantic Versioning\](<http://semver.org/spec/v2.0.0.html>).


## \[v4.1.0\]


**Changed**
- Workflow stack has been updated with different inputs, a new set of workflows (v2) has been added and made as defaults.
- The parser framework has been simplified and integrated into a single module.

**Added**
- `BuilderUpdater` system for quickly setting up calculation with pre-define default calculation/code specific parameters and remote job launching settings.
- Default python-AiiDA type conversion for process inputs
- Validation of workchain control parameters using `pydantic`

**Development**
- No longer using `tox` for test running.
- Switched to `ruff` from `pylint` for faster linting.

**Notes for updating from v3.x.x to v4.x.x**

**Configuring the parsers**

The script for launching calculation should be updated. In particular, note that the new parser systems takes a
different format for the `parser_settings`.

Previously, this looks like:
```python
parser_settings = {
        "add_energies": True,
        "add_forces": True,
        "add_stress": True,
        "add_bands": True,
        "electronic_step_energies": True,
    }
builder.settings = Dict({'parser_settings' : parser_settings})
```

Now, one should use:

```python
parser_settings = {
  include_node: ['energies', 'bands'],
'electronic_step_energies': True
}
builder.settings = Dict({'parser_settings' : parser_settings})
# Getting energies
energies = node.outputs.arrays.get_array("energy_extrapolated")
forces = node.outputs.misc['forces']
```

The new parser system adapts a parse-if-exists principle with some quantities disabled by default, such as
the eigenvalues and electronic step energies. The `'include_node'` key in the `parser_settings` dictionary
allows to selectively enable output nodes.
This is because some output nodes are disabled by default, such as `'bands'` and `'dos'` and `'trajectory'`. This is because the underlying quantities exist in almost all calculations, but the output are only useful in specific cases.

Previously forces was stored in an `ArrayData` node with link name `forces`.
Now the last forces and stress are stored in `misc` node (`Dict`) which is **enabled by default**.
To obtain forces at every structure iteration, add `'trajectory'` to the `'include_node'` field in `parser_settings` as shown above.


**Controlling workchains**

The `VaspConvergenceWorkChain`, `VaspRelaxWorkChain` and `VaspBandsWorkChain` are controlled by special ports
`conv_settings`, `relax_settings` and `band_settings` respectively. These ports should be used to pass the
desired settings to the respective workchains.
Previously, each key is made a single input port, make these workchains takes a large amount of input nodes.


**Deploying workchains**

We now recommend using the `BuilderUpdater` system to quickly set up calculation with pre-define default calculation/code specific parameters and remote job launching settings.
The old approach was to use a dictionary or a `ProcessBuilder` object, which requires the user to explicitly specify all the required inputs.

While `BuilderUpdater` is a convenient way to quickly set up a calculation, it is not recommended to still
manually verify the inputs in case of unexpected behavior.

**Rerunning workchains**

The workchain nowentry points such as `vasp.vasp` now points to different workchains. Unfortunately,
this means that the `get_builder_restart` method no longer works.

**Calculation and workchain output**

There are a few notable changes to the calculation and workchain output

- The forces of the calculations are now included in the `misc` output under the key `forces`. This quantities is parsed and stored by default.
- The `arrays` output includes array-like quantities, such as `energy_extrapolated` of individual ionic steps (excluded by default).
- The key under which the quantities are stored inside the `ArrayData` node of the `arrays`, `dielectrics` may change. Please refer to the [code](src/aiida_vasp/parsers/vasp.py) for details.


## \[v3.0.1\]

**Changed**
\- New structure of the Read The Docs configure file to enable more recent Python versions and successful documentation builds.

## \[v3.0.0\]

**Added**
\- `AiiDA>=2.0` support.

- Python 3.11 support.
- `pyproject.toml` support.
- Option to ommit a static run in the relax workflow.
- Support for generalized k-point grids.
- Wrappers for the moved parsers.

**Changed**
\- Updated documentation.

- Necessary changes to support `AiiDA>=2.3`.
- LICENSE file to reflect plugin work in recent years.
- Dependency of `parsevasp~=3.2`.
- Contact info and author info.

**Removed**
\- Python 3.7 support.

- `pymatgen` dependency.
- Remaining parsers moved to `parsevasp`.

## \[v2.2.0\]

**Added**
\- Error handlers for the ACWF study, disabled by default to retain backwards compatibility. These

> offer bare minimum, basically changing `ALGO` and `NBANDS` in case that is needed due to lack of
> electronic convergence.

**Changed**
\- Deviates from the `develop` branch and releases `>2` from commit `837870c4f0080434955a491b269858caa9243005` and forward.
\- Removed pylint requirement in CI.

## \[v2.1.1\]

**Changed**
\- Bugfix to handle NaN values in parsed entries.

- Removed `fermi_level` and `symmetries` are removed from default `misc` quantities to avoid stalling relaxation jobs etc.
- Fix to the DOSCAR parser to not fail when spin-orbit couplings have been enabled.
- Fixes the convergence workchain so that a final relaxation is possible.
- Fixes the convergence workchain lack of the structure not being exposed as an input.
- Fixes the convergence workchain in cases where a plane wave cutoff was supplied, the plane wave convergence tests
  were still executed.
- Fixes parsing of DOSCAR when the data for the partial density of states is not available.
- Removed version pinning on postgresql install for GitHub Action tests.

## \[v2.1.0\]

**Added**
\- The `metadata.label` and `metadata.description` is now passed from the `VaspWorkChain` to the `VaspCalculation`.

- Possibilities to skip `INCAR` tag validation altogether.
- Recommended plane wave cutoff and k-point grid is now set as an output on the `ConvergeWorkChain`.

**Changed**
\- Bugfix in the check for electronic and ionic convergence for the run status.

- Bugfix in the stream output of the `vasp_output` file, which is now always printed without adding redirection to the executable.
- Bugfix pertaining to the matching of `POTCAR` data and hash upon. Fixes import and linking issues.
- Bugfix for the passing of selective dynamics.
- Parser has been re-factored.
- Pinned AiiDA to latest available version on PyPI for the CI.

## \[v2.0.0\]

**Added**
\- A new dedicated parameter namespace `incar` override namespace that is to be used when utilizing the existing workchain stack to supply `INCAR` tags directly (needs to be valid).

- Possibility to control selective dynamics with the `positions_dof` flag.
- Added possibility to parse magnetization.
- Added framework to parse errors and warnings (notifications) from VASP.
- Nightly test runs against AiiDA core develop.
- Symbols are properly attached to `BandsData`.

**Changed**
\- Updated dependencies, in particular `parsevasp` to enable additional parsing of streams, selective dynamics and magnetization.

- Renamed override parameter namespace from `vasp` to `incar`.
- Fixed warnings related to missing context on file open etc.
- We now instead use a positive match when copying files from the restart folder so that only the required files are copying. This removes possible failures related to the restarted job failing while the parser believes the vasprun.xml etc. is okey (but in reality is from the previous run).
- Fixed missing yaml files.
- We do not allow the install of AiiDA core 1.4.0 and 1.4.1 due to a bug that caused `POTCAR` to be present in the repository.
- Removed `py` dependencies.

## \[v1.0.1\]

This is to be consider the first production release. Backwards compatibility is broken.

## \[v0.3.0\]

This is a major rewrite to be compatible with AiiDA core beta release. Backwards compatibility is broken.

## \[v0.2.4\]

**Added**
\- `vasp.base` workchain which transparently calls through to the 'vasp.vasp' calculation and restarts if appropriate.

- restarting conditions are minimal yet (only submission failed will trigger a retry)
- `vasp.relax` workchain which specializes in structure relaxation and optionally iterates until the structure converges.
- 'vasp.calc.immigrant' added in order to support VASP import Aiida-external jobs.

**Changed**
\- PotcarData.get_potcars_from_structure() now returns an entry for each `kind.name` in the structure, not one per `kind.symbol`

- PotcarData.get_potcars_dict() no longer fails if there is more than one PotcarData with the same full name in the family
- Minor changes in parser.

## \[v0.2.3\]

**Changed**
\- fixed POSCAR writing (was writing 'direct' followed by cartesian coordinates)

**Removed**
\- pruned outdated parts of documentation

## \[v0.2.2\] - 2018-03-15

**Changed**
\- missing requirement added

- PyPI description and keywords updated

## \[v0.2.1\] - 2018-03-12

**Added**
\- Allow Structures which do not have sites of same element grouped

- Allow using different potentials for atoms of same element in a structure
- `VaspCalculation`'s `settings` input now accepts `poscar_precision` key to set maximum precision for coordinates in POSCAR
- This can be indicated in the structure by adding sites with same `symbol` but different `name`.
- `io.poscar.PoscarIo`, POSCAR writer replacing pymatgen one, to be replaced by parsevasp.

**Changed**
\- Use always the same order for species in POSCAR and POTCAR
\- POSCAR float precision default changed to 10 decimal places

## \[v0.2.0\] - 2018-03-07

**Added**
\- `data.potcar.PotcarData` (`vasp.potcar`) & `data.potcar.PotcarFileData`, replacement for PawData

- `PotcarData` is shareable, holds no licenced data

- `PotcarFileData` holds the licenced POTCAR file

- `io.potcar.PotcarIo`, handle conversion between File and DB representation of POTCAR information

- `io.potcar.MultiPotcarIo`, handle concatenation and splitting of POTCAR files containing multiple potentials

- `verdi data vasp-potcar`, CLI for importing and exporting POTCAR files

  - `uploadfamily`, loads a set of POTCAR files into the db
  - `exportfamily`, creates a compressed archive of POTCAR files in a family
  - `listfamilies`, list existing POTCAR families

- `io.outcar.OutcarParser`, parses some information from OUTCAR file

- `calcs.VaspCalculation` and descendants

  - inputs: `settings:ParameterData` additional settings that are not passed to VASP but to parsers etc

**Changed**
\- `calcs.VaspCalculation` and descendants

> - inputs: `paw:PawData` -> `potentials:PotcarData`

- `parsers.vasp.VaspParser`, redesigned

  - parses OUTCAR too (or tries to)
  - takes `parser_options` that can be given in the `settings` input in a `VaspCalculation`

- renamed `data.paw.PawData` -> `data.paw.LegacyPawData`

  - `LegacyPawData` can not be stored or changed (read-only)

**Removed**
\- `io.potcar.PawParser`

**Deprecated**
\- `PawData` is deprecated and has been renamed `LegacyPawData`, it can be used to read `PawData` database objects.

## \[v0.1.1\]

Baseline
