---
file_format: mystnb
kernelspec:
  display_name: Python 3
  name: python3
myst:
  substitutions:
    VaspWorkChain: "{py:class}`VaspWorkChain <aiida_vasp.workchains.v2.vasp.VaspWorkChain>`"
    VaspBandsWorkchain: "{py:class}`VaspBandsWorkChain <aiida_vasp.workchains.v2.bands.VaspBandsWorkchain>`"
    hybrid_bands: "{py:class}`VaspHybridBandsWorkChain <aiida_vasp.workchains.v2.bands.VaspHybridBandsWorkchain>`"
    VaspRelaxWorkChain: "{py:class}`VaspWorkChain <aiida_vasp.workchains.v2.relax.VaspRelaxWorkChain>`"
    VaspConvergenceWorkChain: "{py:class}`VaspConvergenceWorkChain <aiida_vasp.workchains.v2.converge.VaspConvergenceWorkChain>`"
    calcfunction: "{py:class}`calcfunction <aiida.engine.calcfunction>`"
    workfunction: "{py:class}`calcfunction <aiida.engine.workfunction>`"
---

(bundled_workflows)=
# Bundled workflows

:::{note}
This notebook can be downloaded as **{nb-download}`bundled.ipynb`** and {download}`bundled.md`
:::


This section we give some brief introduction to the bundled workflows in AiiDA-VASP.

## Convergence workchain

The {{ VaspConvergenceWorkChain }} is a simple workflow that runs a series of VASP calculations with different parameters and checks if the results converge.
The convergence of cut off energy and kpoints are currently implemented.

As metioned above, the inputs to the {{ VaspWorkChain }} should be placed into the `vasp` namespace.
The convergence settings are specified using the `convergence_settings` input which is a `Dict` containing the following keys:

```python
print(WorkflowFactory('vasp.v2.relax').option_class.aiida_description())
```

## Relaxation workchain

The {{ VaspRelaxWorkChain }} is a simple workflow that runs a VASP relaxation calculation.
It will run VASP geometry optimizations until the specified convergence criteria are met.

This may involve one or more actual VASP calculations. This is because:

- A single VASP calculation may not fully relax the structure, especially when the maximum number of ionic steps is set to a relatively small value.
- For variable cell geometry optimization, multiple VASP calculations are required as each restart resets the basis set, otherwise the effective cut off energy can change.
- A final singlepoint calculation may be needed to ensure that the energy is consistent with the cut off, if the lattice has been changed.

The inputs to the {{ VaspRelaxWorkChain }} should be placed into the `vasp` namespace.
The convergence settings are specified using the `relax_settings` input which is a `Dict` containing the following keys:

```{code-cell}
from aiida.plugins import WorkflowFactory
print(WorkflowFactory('vasp.v2.relax').option_class.aiida_description())
```

Note the keys such as `algo`, `steps`, `force_cutoff` are translated into INCAR tags (`IBRION`, `NSW`, `EDIFFG`, etc.), so one should not explicitly set these tags in the `parameters` input.

:::{hint}
This means one can quickly reuse the `parameters` from a single point calculation for a relaxation and *vice versa*.
:::

See [this tutorial](#silicon_relax) for an example of how to run the {{ VaspRelaxWorkChain }}.

## Band structure workflow

The {{ VaspBandsWorkchain }} is a workflow for calculating the band structure of a material using VASP.
A band structure typically involves computing the ground state electron density then using this fixed density to
solve for the eigenvalues of the Kohn-Sham equation at specific k-points in the Brillouin zone.

Typically, a path along which the eigenvalues are computed is generated based on the point group symmetry of the
input structure.
There are approaches to generate this path automatically，here we default to using `seekpath`, but it can be
switched to using the paths generated by `sumo`.

Another complication is that the path generated is for a specific primitive-cell configuration (as there are infinite ways of choosing the primitive cell).
Hence, a common mistake is to blindly using the path of the input cell, which may not be the standardized primitive cell.
Here, the workchain handles this internally, and the generated standardized primitive cell is returned by the workchain as one of the outputs.

In addition, an exposed `relax` namespace for running {{ VaspRelaxWorkChain }} exists and the workchain will perform
geometry optimization before the band structure calculation if it is specified.

The parameters for the scf (for generating the charge density) the actual band structure structure calculation should be specified under the exposed {{ VaspWorkChain }} namespace called  `scf` and `bands`.
An additional `dos` namespace is also exposed for calculating the density of states and can be specified if desired.


:::{note}
The `scf` namespace should always be specified, while specifying `bands` namespace is only needed if the
input nodes should be different from that in the `scf` namespace. The same rule applies to the `dos` namespace.
:::

Similar to the {{ VaspRelaxWorkChain }} the behavor of the {{ VaspBandsWorkchain }} can be controlled using the `band_settings` input:

```{code-cell}
from aiida.plugins import WorkflowFactory
print(WorkflowFactory('vasp.v2.bands').option_class.aiida_description())
```


The {{ hybrid_bands }} is an variant of the {{ VaspBandsWorkchain }} for running band structure calculation with hybrid functional.
In this case, the potential is not completely determined from the electron density, hence one cannot use the standard
approach that first compute the ground state electron density and then use it to solve the Kohn-Sham equation.
Instead, the Kohn-Sham equation has to be solved self-consistently, and the k-points along the path are inserted
as *zero-weighted k-points*.

The {{ hybrid_bands }} is designed for this purpose.
In addition, the large compute cost of hybrid functional means it may be advantageous to split the full k-point path into smaller sub-paths,
and run multiple self-consistent calculations in parallel instead of doing a single large calculation,
given the constraints of the available computing resources.
The number of kpoints included in each sub-path can be specified using the `kpoints_per_subpath` input.

:::{hint}
Set `kpoints_per_subpath` to a very large number  to run a single self-consistent calculation with all k-points.
:::


See [this tutorial](#band_dos) for an example of how to run the {{ VaspBandsWorkchain }}.
