# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .prompt_agent_api_model_override import PromptAgentApiModelOverride


class AgentConfigOverride(UncheckedBaseModel):
    first_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    If non-empty, the first message the agent will say. If empty, the agent waits for the user to start the discussion.
    """

    language: typing.Optional[str] = pydantic.Field(default=None)
    """
    Language of the agent - used for ASR and TTS
    """

    prompt: typing.Optional[PromptAgentApiModelOverride] = pydantic.Field(default=None)
    """
    The prompt for the agent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
