import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

with open('requirements.txt', 'r', encoding='utf-8') as f:
    required = [ele.strip() for ele in f.read().splitlines() if not ele.strip().startswith("#") and ele.strip() != ""]

VERSION = "0.3.5"

setuptools.setup(
    name="exploitfarm",
    version= VERSION if "{" not in VERSION else "0.0.0", #uv pip install -U . --no-cache-dir for testing
    author="Pwnzer0tt1",
    author_email="pwnzer0tt1@poliba.it",
    scripts=["xfarm"],
    py_modules=["xfarm"],
    install_requires=required,
    include_package_data=True,
    description="Exploit Farm client",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/pwnzer0tt1/exploitfarm",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.10',
)
