# mypy-boto3-pricing

[![PyPI - mypy-boto3-pricing](https://img.shields.io/pypi/v/mypy-boto3-pricing.svg?color=blue)](https://pypi.org/project/mypy-boto3-pricing)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-pricing.svg?color=blue)](https://pypi.org/project/mypy-boto3-pricing)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Pricing 1.15.3](https://boto3.amazonaws.com/v1/documentation/api/1.15.3/reference/services/pricing.html#Pricing) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-pricing](#mypy-boto3-pricing)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Pricing` service.

```bash
python -m pip install boto3-stubs[pricing]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[pricing]` in your environment: `python -m pip install 'boto3-stubs[pricing]'`

Both type checking and auto-complete should work for `Pricing` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[pricing]` in your environment: `python -m pip install 'boto3-stubs[pricing]'`

Both type checking and auto-complete should work for `Pricing` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[pricing]` in your environment: `python -m pip install 'boto3-stubs[pricing]'`
- Run `mypy` as usual

Type checking should work for `Pricing` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[pricing]` in your environment: `python -m pip install 'boto3-stubs[pricing]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Pricing` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`PricingClient` provides annotations for `boto3.client("pricing")`.

```python
import boto3

from mypy_boto3_pricing import PricingClient

client: PricingClient = boto3.client("pricing")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: PricingClient = session.client("pricing")
```

### Paginators annotations

`mypy_boto3_pricing.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_pricing import PricingClient
from mypy_boto3_pricing.paginator import (
    DescribeServicesPaginator,
    GetAttributeValuesPaginator,
    GetProductsPaginator,
)

client: PricingClient = boto3.client("pricing")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_services_paginator: DescribeServicesPaginator = client.get_paginator("describe_services")
get_attribute_values_paginator: GetAttributeValuesPaginator = client.get_paginator("get_attribute_values")
get_products_paginator: GetProductsPaginator = client.get_paginator("get_products")
```







### Typed dictionations

`mypy_boto3_pricing.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_pricing.type_defs import (
    AttributeValueTypeDef,
    DescribeServicesResponseTypeDef,
    FilterTypeDef,
    GetAttributeValuesResponseTypeDef,
    GetProductsResponseTypeDef,
    PaginatorConfigTypeDef,
    ServiceTypeDef,
)

def get_structure() -> AttributeValueTypeDef:
    return {
      ...
    }
```
