import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecsPatterns from '@aws-cdk/aws-ecs-patterns';
export interface ExpressServiceProps {
    /**
     * The VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * options to customize the servide
     *
     * @defult - None
     */
    readonly serviceOptions?: ecsPatterns.ApplicationLoadBalancedFargateServiceProps;
    /**
     * local path to the docker assets directory
     */
    readonly expressAssets: string;
}
export declare class ExpressService extends cdk.Construct {
    readonly expressAssets: string;
    constructor(scope: cdk.Construct, id: string, props: ExpressServiceProps);
}
