"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpressService = void 0;
const cdk = require("@aws-cdk/core");
const ecs = require("@aws-cdk/aws-ecs");
const ecsPatterns = require("@aws-cdk/aws-ecs-patterns");
class ExpressService extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.expressAssets = props.expressAssets;
        new ecsPatterns.ApplicationLoadBalancedFargateService(this, 'Service', {
            vpc: props.vpc,
            taskImageOptions: {
                image: ecs.ContainerImage.fromAsset(this.expressAssets),
            },
        });
    }
}
exports.ExpressService = ExpressService;
//# sourceMappingURL=data:application/json;base64,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