"""WNBA combined league model."""

# pylint: disable=line-too-long
from scrapesession.scrapesession import ScrapeSession  # type: ignore

from ...combined.combined_league_model import CombinedLeagueModel
from ...league import League
from ..espn.wnba_espn_league_model import WNBAESPNLeagueModel
from ..oddsportal.wnba_oddsportal_league_model import WNBAOddsPortalLeagueModel
from ..wnbacom.wnba_wnbacom_league_model import WNBAWNBAComLeagueModel

MERCURY = "11"
LIBERTY = "9"
MYSTICS = "16"
ROCKERS = "2"
MONARCHS = "13"
SPARKS = "6"
COMETS = "4"
STARZZ = "15"
LYNX = "8"
STING = "1"
MIRACLE = "10"
SHOCK = "3"
SOL = "7"
STORM = "14"
FIRE = "12"
FEVER = "5"
WEST = "99"
EAST = "98"
SUN = "18"
SILVER_STARS = "17"
TEAM_USA = "97"
TEAM_WNBA = "96"
SKY = "19"
DREAM = "20"
TEAM_CHINA = "21"
TEAM_POLAND = "22"
TEAM_GREAT_BRITAIN = "24"
JX_SUNFLOWERS = "23"
TEAM_JAPAN = "25"
TEAM_BRAZIL = "17473"
TEAM_AUSTRALIA = "17472"
TEAM_PARKER = "111720"
TEAM_DELLE_DONNE = "111719"
TEAM_WILSON = "112530"
VALKYRIES = "129689"
TEAM_COLLIER = "131247"
TEAM_CLARK = "131246"
PUERTO_RICO = "104959"
TEAM_STEWART = "126287"
ANTELOPES = "130927"
WNBA_TEAM_IDENTITY_MAP: dict[str, str] = {
    # ESPN
    "11": MERCURY,
    "9": LIBERTY,
    "16": MYSTICS,
    "2": ROCKERS,
    "13": MONARCHS,
    "6": SPARKS,
    "4": COMETS,
    "15": STARZZ,
    "8": LYNX,
    "1": STING,
    "10": MIRACLE,
    "3": SHOCK,
    "7": SOL,
    "14": STORM,
    "12": FIRE,
    "5": FEVER,
    "99": WEST,
    "98": EAST,
    "18": SUN,
    "17": SILVER_STARS,
    "97": TEAM_USA,
    "96": TEAM_WNBA,
    "19": SKY,
    "20": DREAM,
    "21": TEAM_CHINA,
    "22": TEAM_POLAND,
    "24": TEAM_GREAT_BRITAIN,
    "23": JX_SUNFLOWERS,
    "25": TEAM_JAPAN,
    # OddsPortal
    "17473": TEAM_BRAZIL,
    "17475": TEAM_JAPAN,
    "17472": TEAM_AUSTRALIA,
    "111720": TEAM_PARKER,
    "111719": TEAM_DELLE_DONNE,
    "112530": TEAM_WILSON,
    "129689": VALKYRIES,
    "131247": TEAM_COLLIER,
    "131246": TEAM_CLARK,
    "104959": PUERTO_RICO,
    "126287": TEAM_STEWART,
    "130927": ANTELOPES,
    # WNBACom
    "1611661319": SILVER_STARS,
    "1611661325": FEVER,
}
MADISON_SQUARE_GARDEN = "1830"
CAPITAL_ONE_ARENA = "1823"
QUICKEN_LOANS_ARENA = "3417"
CRYPTO_COM_ARENA = "1841"
TARGET_CENTER = "2029"
THE_PALACE_OF_AUBURN_HILLS = "3419"
KEY_ARENA = "2184"
AMERICAN_AIRLINES_ARENA = "3438"
PHX_ARENA = "1949"
ROSE_GARDEN = "3423"
MOHEGAN_SUN_ARENA = "2160"
FROST_BANK_CENTER = "780"
PRUDENTIAL_CENTER = "1826"
BOK_CENTER = "1911"
GAINBRIDGE_FIELDHOUSE = "2183"
STATE_FARM_ARENA = "1827"
ALLSTATE_ARENA = "977"
THE_ARENA_AT_GWINNETT_CENTER = "1245"
JACOBY_DICKENS_CENTER = "4332"
WALTER_PYRAMID = "539"
SRC_ARENA = "2082"
BISMARCK_EVENT_CENTER = "3446"
MCCAMISH_PAVILION = "2206"
HP_FIELD_HOUSE = "2222"
LAKIN_CENTER = "3500"
BOB_CARPENTER_CENTER = "2189"
FREEMAN_COLISEUM = "2935"
CORTEVA_COLISEUM = "4947"
KFC_YUM_CENTER = "2030"
LEVIEN_GYMNASIUM = "2002"
MAYO_CIVIC_CENTER = "5240"
HUTTO_PATTERSON_GYMNASIUM = "3498"
WILLIAMS_ARENA = "2094"
GRAND_CASINO_ARENA = "1835"
COLLEGE_PARK_CENTER = "3416"
DESERT_FINANCIAL_ARENA = "833"
CHARLES_E_SMITH_CENTER = "2125"
EAGLEBANK_ARENA = "2167"
MICHELOB_ULTRA_ARENA = "4005"
WESTCHESTER_COUNTY_CENTER = "5584"
WINTRUST_ARENA = "5427"
WELLS_FARGO_ARENA = "1475"
TOTAL_MORTGAGE_ARENA = "1259"
ANGEL_OF_THE_WINDS_ARENA = "5242"
CAREFIRST_ARENA = "5946"
THOMAS_AND_MACK_CENTER = "2083"
ALASKA_AIRLINES_ARENA = "782"
BARCLAYS_CENTER = "3559"
T_MOBILE_ARENA = "5060"
ALBANY_CIVIC_CENTER = "6178"
COX_PAVILION = "1051"
MVP_ARENA = "20"
IMG_ACADEMY = "7097"
GATEWAY_CENTER = "6282"
SAP_CENTER_AT_SAN_JOSE = "1653"
CLIMATE_PLEDGE_ARENA = "7224"
CFG_BANK_ARENA = "4938"
CHASE_CENTER = "6270"
ROGERS_ARENA = "1833"
AMERICAN_AIRLINES_CENTER = "516"
UNITED_CENTER = "1847"
TD_GARDEN = "1824"
UBS_ARENA = "7226"
COLONIAL_LIFE_ARENA = "1962"
ROGERS_PLACE = "5282"
SCOTIABANK_ARENA = "1838"
HINKLE_FIELDHOUSE = "2032"
GLOBAL_CREDIT_UNION_ARENA = "4534"
LOS_ANGELES_CONVENTION_CENTER = "2512"
MATTHEW_KNIGHT_ARENA = "1977"
CARVER_HAWKEYE_ARENA = "363"
PETE_MAROVICH_ASSEMBLY_CENTER = "557"
PURCELL_PAVILION = "282"
WNBA_VENUE_IDENTITY_MAP: dict[str, str] = {
    # ESPN
    "1830": MADISON_SQUARE_GARDEN,
    "1823": CAPITAL_ONE_ARENA,
    "3417": QUICKEN_LOANS_ARENA,
    "1841": CRYPTO_COM_ARENA,
    "2029": TARGET_CENTER,
    "3419": THE_PALACE_OF_AUBURN_HILLS,
    "2184": KEY_ARENA,
    "3438": AMERICAN_AIRLINES_ARENA,
    "1949": PHX_ARENA,
    "3423": ROSE_GARDEN,
    "2160": MOHEGAN_SUN_ARENA,
    "780": FROST_BANK_CENTER,
    "1826": PRUDENTIAL_CENTER,
    "1911": BOK_CENTER,
    "2183": GAINBRIDGE_FIELDHOUSE,
    "1827": STATE_FARM_ARENA,
    "977": ALLSTATE_ARENA,
    "1245": THE_ARENA_AT_GWINNETT_CENTER,
    "4332": JACOBY_DICKENS_CENTER,
    "539": WALTER_PYRAMID,
    "2082": SRC_ARENA,
    "3446": BISMARCK_EVENT_CENTER,
    "2206": MCCAMISH_PAVILION,
    "2222": HP_FIELD_HOUSE,
    "3500": LAKIN_CENTER,
    "2189": BOB_CARPENTER_CENTER,
    "2935": FREEMAN_COLISEUM,
    "4947": CORTEVA_COLISEUM,
    "2030": KFC_YUM_CENTER,
    "2002": LEVIEN_GYMNASIUM,
    "5240": MAYO_CIVIC_CENTER,
    "3498": HUTTO_PATTERSON_GYMNASIUM,
    "2094": WILLIAMS_ARENA,
    "1835": GRAND_CASINO_ARENA,
    "3416": COLLEGE_PARK_CENTER,
    "833": DESERT_FINANCIAL_ARENA,
    "2125": CHARLES_E_SMITH_CENTER,
    "2167": EAGLEBANK_ARENA,
    "4005": MICHELOB_ULTRA_ARENA,
    "5584": WESTCHESTER_COUNTY_CENTER,
    "5427": WINTRUST_ARENA,
    "1475": WELLS_FARGO_ARENA,
    "1259": TOTAL_MORTGAGE_ARENA,
    "5242": ANGEL_OF_THE_WINDS_ARENA,
    "5946": CAREFIRST_ARENA,
    "2083": THOMAS_AND_MACK_CENTER,
    "782": ALASKA_AIRLINES_ARENA,
    "3559": BARCLAYS_CENTER,
    "5060": T_MOBILE_ARENA,
    "6178": ALBANY_CIVIC_CENTER,
    "1051": COX_PAVILION,
    "20": MVP_ARENA,
    "7097": IMG_ACADEMY,
    "6282": GATEWAY_CENTER,
    "1653": SAP_CENTER_AT_SAN_JOSE,
    "7224": CLIMATE_PLEDGE_ARENA,
    "4938": CFG_BANK_ARENA,
    "6270": CHASE_CENTER,
    "1833": ROGERS_ARENA,
    "516": AMERICAN_AIRLINES_CENTER,
    "1847": UNITED_CENTER,
    "1824": TD_GARDEN,
    "7226": UBS_ARENA,
    "1962": COLONIAL_LIFE_ARENA,
    "5282": ROGERS_PLACE,
    "1838": SCOTIABANK_ARENA,
    "2032": HINKLE_FIELDHOUSE,
    "4534": GLOBAL_CREDIT_UNION_ARENA,
    "2512": LOS_ANGELES_CONVENTION_CENTER,
    "1977": MATTHEW_KNIGHT_ARENA,
    "363": CARVER_HAWKEYE_ARENA,
    "557": PETE_MAROVICH_ASSEMBLY_CENTER,
    "282": PURCELL_PAVILION,
    # WNBA.com
    "Michelob ULTRA Arena - Las Vegas - NV": MICHELOB_ULTRA_ARENA,
}
WNBA_PLAYER_IDENTITY_MAP: dict[str, str] = {}


class WNBACombinedLeagueModel(CombinedLeagueModel):
    """WNBA combined implementation of the league model."""

    def __init__(self, session: ScrapeSession, league_filter: str | None) -> None:
        super().__init__(
            session,
            League.WNBA,
            [
                WNBAESPNLeagueModel(session, position=0),
                WNBAOddsPortalLeagueModel(session, position=1),
                WNBAWNBAComLeagueModel(session, position=2),
            ],
            league_filter,
        )

    @classmethod
    def team_identity_map(cls) -> dict[str, str]:
        return WNBA_TEAM_IDENTITY_MAP

    @classmethod
    def venue_identity_map(cls) -> dict[str, str]:
        return WNBA_VENUE_IDENTITY_MAP

    @classmethod
    def player_identity_map(cls) -> dict[str, str]:
        return WNBA_PLAYER_IDENTITY_MAP

    @classmethod
    def name(cls) -> str:
        return "wnba-combined-league-model"
