You are systematically screening the market for new investment opportunities based on user-defined criteria. Execute this opportunity discovery workflow:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: Initial Screening**
Use screen-forge agent for systematic equity screening to generate candidate list (sequential - required first).

**Phase 2: PARALLEL Analysis of Top Candidates**
After screening, launch these agents IN PARALLEL using the Task tool to analyze top 3-5 candidates:

1. **quill-equity-analyst** - Fundamental deep dive on candidates
2. **news-sentry-market-watch** - News sentiment and catalyst check
3. **risk-shield-manager** - Portfolio integration analysis

**CRITICAL INSTRUCTIONS:**
- Complete screening FIRST to identify candidates
- Then launch ALL THREE analysis agents SIMULTANEOUSLY in a single response
- Each agent analyzes the same candidate list from different perspectives
- Wait for ALL agents to complete before final ranking
- This parallel approach reduces execution time by 60-70%

**WORKFLOW: Investment Opportunity Screening & Selection**

1. **Market Screening (Screen Forge) - Sequential First Step**
   - Use screen-forge agent for systematic equity screening
   - Apply user-specified criteria: value metrics, growth rates, quality factors, momentum signals
   - Consider market conditions and sector rotation opportunities
   - Generate ranked shortlist of 10-15 candidates with key screening metrics
   - Include entry criteria and technical trigger levels
   - **Select top 3-5 candidates for parallel deep-dive analysis**

2. **PARALLEL Deep Analysis Phase (Launch Simultaneously)**

   Once you have the candidate list, launch all three agents IN PARALLEL:

   **Agent 1: quill-equity-analyst** (Fundamental Deep Dive)
   - Task: "Analyze these [3-5] candidates with comprehensive fundamental analysis: [candidate symbols]. For each, provide investment thesis, DCF valuation, fair value range, BUY/HOLD/SELL recommendation, key catalysts, and material risks."

   **Agent 2: news-sentry-market-watch** (News & Sentiment)
   - Task: "Assess recent news flow and sentiment for these candidates: [candidate symbols]. For each, check for material developments, red flags, positive catalysts, upcoming events, and analyst coverage trends."

   **Agent 3: risk-shield-manager** (Portfolio Integration)
   - Task: "Evaluate how these candidates fit in existing portfolio: [candidate symbols]. For each, assess impact on sector concentration, risk metrics, correlation with existing holdings, and recommend position sizing."

3. **Final Ranking & Selection**
   - Wait for all parallel agents to complete
   - Synthesize insights from all agents to create final opportunity ranking
   - Consider: fundamental attractiveness, risk-adjusted return potential, portfolio fit
   - Provide specific entry strategies and position sizing recommendations
   - Include monitoring framework for ongoing evaluation

**Output Format:**
- Opportunity Scorecard: Top 3-5 ranked opportunities with key metrics
- Investment Cases: Summary thesis for each recommended opportunity
- Entry Strategy: Specific price targets, position sizes, and timing recommendations
- Risk Assessment: Portfolio impact and position-level risk considerations
- Action Plan: Immediate next steps and ongoing monitoring requirements

Focus on delivering high-conviction investment opportunities that align with user criteria while maintaining appropriate portfolio diversification and risk management.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.