You are conducting a comprehensive portfolio review to assess performance, risk, and optimization opportunities. Follow this systematic evaluation workflow:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: PARALLEL Agent Coordination**
Launch these specialized agents IN PARALLEL using the Task tool - DO NOT run them sequentially:

1. **ledger-performance-analyst** - Performance and attribution analysis
2. **risk-shield-manager** - Risk assessment and stress testing
3. **factor-scout** - Factor exposure and style analysis
4. **news-sentry-market-watch** - News impact on portfolio holdings

**CRITICAL INSTRUCTIONS:**
- Use the Task tool to launch ALL FOUR agents SIMULTANEOUSLY in a single response
- Each agent analyzes different aspects of the portfolio in parallel
- Wait for ALL agents to complete before synthesizing results
- This parallel approach reduces execution time by 60-70%

**WORKFLOW: Complete Portfolio Health Check**

1. **PARALLEL Analysis Phase (Launch Simultaneously)**

   **Agent 1: ledger-performance-analyst** (Performance Analysis)
   - Task: "Analyze portfolio performance with comprehensive return analysis, benchmark comparison, attribution analysis, risk-adjusted metrics, and identify top/bottom performers across different time periods."

   **Agent 2: risk-shield-manager** (Risk Assessment)
   - Task: "Evaluate portfolio risk comprehensively: calculate VAR, maximum drawdown, concentration risks, perform stress testing against historical scenarios (2008, COVID), check limit breaches, and generate risk heatmap."

   **Agent 3: factor-scout** (Factor & Style Analysis)
   - Task: "Analyze portfolio factor exposures and style tilts (value/growth, large/small cap, quality, momentum), check for unintended factor bets or style drift, evaluate positioning relative to market regime."

   **Agent 4: news-sentry-market-watch** (News & Events)
   - Task: "Assess recent news impact on portfolio holdings, identify material events affecting companies, check for upcoming catalysts or potential risk events."

2. **Sequential Follow-up Analysis**

   After parallel agents complete, proceed with:

   **Holdings Review (Quill Equity Analyst)**
   - Use quill-equity-analyst agent for updated thesis validation on major holdings
   - Review investment cases for top 10 positions based on parallel analysis results
   - Identify positions that may need updating or exit consideration

   **Rebalancing Assessment (Rebalance Bot)**
   - Use rebalance-bot agent to identify portfolio drift and rebalancing needs
   - Calculate target vs current allocations based on risk and factor analysis
   - Recommend specific trades to restore strategic targets
   - Consider tax implications and transaction costs

**Output Format:**
- Portfolio Scorecard: Overall health rating (Green/Yellow/Red) with key metrics
- Performance Summary: Returns, attribution, benchmark comparison
- Risk Dashboard: Current exposures, limit status, stress test results
- Action Items: Prioritized recommendations with specific trades and timeline
- Monitoring Alerts: Key events to watch and review triggers

Deliver a comprehensive portfolio assessment that enables informed decisions about performance, risk management, and optimization opportunities. 
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.