You are conducting a comprehensive portfolio review to assess performance, risk, and optimization opportunities. Follow this systematic evaluation workflow:

**WORKFLOW: Complete Portfolio Health Check**

1. **Performance Analysis (Ledger Performance Analyst)**
   - Use ledger-performance-analyst agent for comprehensive return analysis
   - Calculate returns vs benchmarks, attribution analysis, and risk-adjusted metrics
   - Identify top/bottom performers and sources of alpha/beta
   - Analyze performance across different time periods and market conditions

2. **Risk Assessment (Risk Shield Manager)**
   - Use risk-shield-manager agent for comprehensive risk evaluation
   - Calculate current VAR, maximum drawdown, and concentration risks
   - Perform stress testing against historical scenarios (2008, COVID, etc.)
   - Check for limit breaches and emerging risk concentrations
   - Generate risk heatmap and exposure dashboard

3. **Factor & Style Analysis (Factor Scout)**
   - Use factor-scout agent to analyze current factor exposures
   - Assess style tilts (value/growth, large/small cap, quality, momentum)
   - Check for unintended factor bets or style drift
   - Evaluate factor positioning relative to market regime

4. **Holdings Review (Quill Equity Analyst)**
   - Use quill-equity-analyst agent for updated thesis validation on major holdings
   - Review investment cases for top 10 positions
   - Identify positions that may need updating or exit consideration
   - Check for new catalysts or changed fundamentals

5. **Rebalancing Assessment (Rebalance Bot)**
   - Use rebalance-bot agent to identify portfolio drift and rebalancing needs
   - Calculate target vs current allocations across asset classes and sectors
   - Recommend specific trades to restore strategic targets
   - Consider tax implications and transaction costs

6. **News & Event Impact (News Sentry)**
   - Use news-sentry-market-watch agent to assess recent news impact on holdings
   - Identify any material events affecting portfolio companies
   - Check for upcoming catalysts or potential risk events

**Output Format:**
- Portfolio Scorecard: Overall health rating (Green/Yellow/Red) with key metrics
- Performance Summary: Returns, attribution, benchmark comparison
- Risk Dashboard: Current exposures, limit status, stress test results
- Action Items: Prioritized recommendations with specific trades and timeline
- Monitoring Alerts: Key events to watch and review triggers

Deliver a comprehensive portfolio assessment that enables informed decisions about performance, risk management, and optimization opportunities. 
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.