You are systematically screening the market for new investment opportunities based on user-defined criteria. Execute this opportunity discovery workflow:

**WORKFLOW: Investment Opportunity Screening & Selection**

1. **Market Screening (Screen Forge)**
   - Use screen-forge agent for systematic equity screening
   - Apply user-specified criteria: value metrics, growth rates, quality factors, momentum signals
   - Consider market conditions and sector rotation opportunities
   - Generate ranked shortlist of 10-15 candidates with key screening metrics
   - Include entry criteria and technical trigger levels

2. **Fundamental Deep Dive (Quill Equity Analyst)**
   - Use quill-equity-analyst agent for detailed analysis of top 3-5 candidates
   - Perform comprehensive fundamental analysis for each candidate
   - Generate investment theses with clear buy/hold/sell recommendations
   - Provide fair value ranges and confidence levels
   - Identify key catalysts and material risks for each opportunity

3. **News & Sentiment Check (News Sentry)**
   - Use news-sentry-market-watch agent to assess recent news flow for candidates
   - Check for any material negative developments or red flags
   - Identify positive catalysts or upcoming events
   - Assess market sentiment and analyst coverage

4. **Portfolio Integration Analysis (Risk Shield)**
   - Use risk-shield-manager agent to evaluate how candidates fit in existing portfolio
   - Assess impact on sector concentration, geographic exposure, and risk metrics
   - Recommend position sizing based on overall portfolio risk parameters
   - Check for correlation with existing holdings

5. **Final Ranking & Selection**
   - Synthesize insights from all agents to create final opportunity ranking
   - Consider: fundamental attractiveness, risk-adjusted return potential, portfolio fit
   - Provide specific entry strategies and position sizing recommendations
   - Include monitoring framework for ongoing evaluation

**Output Format:**
- Opportunity Scorecard: Top 3-5 ranked opportunities with key metrics
- Investment Cases: Summary thesis for each recommended opportunity
- Entry Strategy: Specific price targets, position sizes, and timing recommendations
- Risk Assessment: Portfolio impact and position-level risk considerations
- Action Plan: Immediate next steps and ongoing monitoring requirements

Focus on delivering high-conviction investment opportunities that align with user criteria while maintaining appropriate portfolio diversification and risk management.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.