"""
This type stub file was generated by pyright.
"""

from collections.abc import Mapping
from dataclasses import Field
from dataclasses import dataclass
from typing import TYPE_CHECKING
from typing import Any
from typing import Callable
from typing import ClassVar
from typing import Iterator
from typing import Protocol
from typing import TypeAlias
from typing import TypeVar

"""Base dataclasses for OZI Metadata."""
if TYPE_CHECKING:
    VT = TypeVar('VT', str, int, float, bytes, None, tuple[str, ...])
    _Val: TypeAlias = list['_Key[VT]'] | Mapping['_Key[VT]', VT] | VT
    _Key: TypeAlias = VT | _Val[VT]
    _Lambda: TypeAlias = Callable[[], '_FactoryMethod']
    _FactoryMethod: TypeAlias = Callable[[], _Lambda]

class _FactoryDataclass(Protocol):
    """A dataclass that, when called, returns a factory method."""

    __dataclass_fields__: ClassVar[dict[str, Field[Any]]]
    def asdict(self) -> Mapping[str, _Val[str]]: ...
    def __call__(self) -> Field[_FactoryMethod]: ...
    def __iter__(self: _FactoryDataclass) -> Iterator[tuple[str, _Val[VT]]]: ...

def get_default(obj: _FactoryDataclass, name: str) -> _Val[VT] | Mapping[str, _Val[str]]:
    """Get a field from a Default by name.

    :param obj: a target object
    :type obj: _FactoryDataclass
    :param name: an attribute name
    :type name: str
    :return: attribute value
    :rtype: _Val[VT] | Mapping[str, _Val[str]]
    """

@dataclass(frozen=True, repr=False)
class Default(_FactoryDataclass):
    """A dataclass that, when called, returns it's own default factory field."""

    def __call__(self) -> Field[_FactoryMethod]:
        """Returns this dataclass as a Field.

        :return: A Field initialized with a factory method.
        :rtype: Field[_FactoryMethod]
        """
        ...

    def __iter__(self) -> Iterator[tuple[str, _Val[VT]]]:
        """Iterate through all fields.

        :yield: Fields as a tuple of name and values
        :rtype: Iterator[tuple[str, _Val[VT]]]
        """
        ...

    def asdict(self) -> Mapping[str, _Val[str]]:
        """Return a dictionary of all fields where repr=True.
        Hide a variable from the dict by setting repr to False and using
        a Default subclass as the default_factory.
        Typing is compatible with JSON and Jinja2 global namespace.

        .. seealso::

           :std:ref:`jinja2:global-namespace`
        """
        ...

    def __repr__(self) -> str:
        """Uses reprlib.repr with the default limits."""
        ...

    def __len__(self) -> int:
        """Get the total number of keys, including the class docstring."""
        ...
