from typing import Any

from pydantic import BaseModel, Field


class AgentContext(BaseModel):
    n_input_tokens: int | None = Field(
        default=None, description="The number of input tokens used including cache."
    )
    n_cache_tokens: int | None = Field(
        default=None, description="The number of cache tokens used."
    )
    n_output_tokens: int | None = Field(
        default=None, description="The number of output tokens used."
    )
    cost_usd: float | None = Field(
        default=None, description="The cost in USD for the agent execution."
    )
    output_logprobs: list[list[float]] | None = Field(
        default=None,
        description=(
            "Log probabilities for each assistant message. Each element is a "
            "list of logprobs for tokens in that message."
        ),
    )
    metadata: dict[str, Any] | None = Field(
        default=None, description="Additional metadata about the agent execution."
    )

    def is_empty(self) -> bool:
        return all(value is None for value in self.model_dump().values())
