# IP2Proxy Python Library

![PyPI](https://img.shields.io/pypi/v/IP2Proxy)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/IP2Proxy)
![PyPI - Downloads](https://img.shields.io/pypi/dm/IP2Proxy)

This library allows user to query an IP address if it was being used as VPN servers, open proxies, web proxies, Tor exit nodes, search engine robots, data center ranges, residential proxies, consumer privacy networks, and enterprise private networks. It lookup the proxy IP address from **IP2Proxy BIN Data** file. This data file can be downloaded at

* Free IP2Proxy BIN Data: [https://lite.ip2location.com](https://lite.ip2location.com)
* Commercial IP2Proxy BIN Data: [https://www.ip2location.com/proxy-database](https://www.ip2location.com/proxy-database)

For more details, please visit:
[https://www.ip2location.com/documentation/ip2proxy-libraries/python](https://www.ip2location.com/documentation/ip2proxy-libraries/python)

## Developer Documentation
To learn more about installation, usage, and code examples, please visit the developer documentation at [https://ip2proxy-python.readthedocs.io/en/latest/index.html.](https://ip2proxy-python.readthedocs.io/en/latest/index.html)

## Proxy Type

| Proxy Type | Description                    |
| ---------- | ------------------------------ |
| VPN        | Anonymizing VPN services.      |
| TOR        | Tor Exit Nodes.                |
| PUB        | Public Proxies.                |
| WEB        | Web Proxies.                   |
| DCH        | Hosting Providers/Data Center. |
| SES        | Search Engine Robots.          |
| RES        | Residential Proxies [PX10+]    |
| CPN        | Consumer Privacy Networks. [PX11+] |
| EPN        | Enterprise Private Networks. [PX11+] |

## Usage Type

| Usage Type | Description                     |
| ---------- | ------------------------------- |
| COM        | Commercial                      |
| ORG        | Organization                    |
| GOV        | Government                      |
| MIL        | Military                        |
| EDU        | University/College/School       |
| LIB        | Library                         |
| CDN        | Content Delivery Network        |
| ISP        | Fixed Line ISP                  |
| MOB        | Mobile ISP                      |
| DCH        | Data Center/Web Hosting/Transit |
| SES        | Search Engine Spider            |
| RSV        | Reserved                        |

## Threat Type

| Threat Type | Description                                                    |
| ----------- | -------------------------------------------------------------- |
| SPAM        | Email and forum spammers                                       |
| SCANNER     | Security Scanner or Attack                                     |
| BOTNET      | Spyware or Malware                                             |
| BOGON       | Unassigned or illegitimate IP addresses announced via BGP      |



## Support

Email: support@ip2location.com.
URL: [https://www.ip2location.com](https://www.ip2location.com)
