"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_rules_1 = require("../../nag-rules");
/**
 * Route tables do not have unrestricted routes ('0.0.0.0/0' or '::/0') to IGWs
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_ec2_1.CfnRoute) {
        if (node.gatewayId != undefined) {
            const destinationCidrBlock = nag_rules_1.NagRules.resolveIfPrimitive(node, node.destinationCidrBlock);
            const destinationIpv6CidrBlock = nag_rules_1.NagRules.resolveIfPrimitive(node, node.destinationIpv6CidrBlock);
            if (destinationCidrBlock != undefined &&
                destinationCidrBlock.includes('/0')) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            if (destinationIpv6CidrBlock != undefined &&
                destinationIpv6CidrBlock.includes('/0')) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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