# Copyright 2015-2016 Yelp Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import socket

import mock
import pytest

from paasta_tools import generate_services_yaml
from paasta_tools import utils


MOCK_NAMESPACES = [
    ("foo.main", {"proxy_port": 1024}),
    ("bar.canary", {"proxy_port": 1025}),
]


@pytest.fixture
def mock_namespaces():
    with mock.patch(
        "paasta_tools.generate_services_file.get_all_namespaces",
        autospec=True,
        return_value=MOCK_NAMESPACES,
    ):
        yield


def test_main(tmpdir, mock_namespaces):
    services_yaml = tmpdir.join("services.yaml")

    with mock.patch.object(utils, "datetime") as m, mock.patch.object(
        socket, "getfqdn", return_value="somehost.yelp"
    ):
        m.datetime.now().isoformat.return_value = "$TIME"
        generate_services_yaml.main((services_yaml.strpath,))

    assert services_yaml.read() == (
        "# This file is automatically generated by paasta_tools.\n"
        "# It was automatically generated at $TIME on somehost.yelp.\n"
        "---\n"
        "bar.canary:\n"
        "  host: 169.254.255.254\n"
        "  port: 1025\n"
        "foo.main:\n"
        "  host: 169.254.255.254\n"
        "  port: 1024\n"
    )
