"""add index on original file and update value

Revision ID: 8221053f0e81
Revises: 45fd75e5f16f
Create Date: 2025-08-17 08:05:45.217576

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = '8221053f0e81'
down_revision = '45fd75e5f16f'
branch_labels = None
depends_on = None


def upgrade():
    # For files uploaded before v0.10.0
    op.execute("""
        UPDATE workouts
        SET original_file = gpx
        WHERE workouts.gpx IS NOT NULL
          AND workouts.original_file IS NULL;
    """)

    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('workouts', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_workouts_original_file'), ['original_file'], unique=False)

    # ### end Alembic commands ###



def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('workouts', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_workouts_original_file'))

    # ### end Alembic commands ###
