# BWA dedup config
# This is a default configuration for the BWA dedup pipeline.
bwa_dedup_config = {
    "ref_fasta": None,
    "bed_file": None,
    "at": "bwtsw",
    "out_path": None,
    "r1": None,
    "r2": None,
    "sample_name": None,
    "threads": 40,
    "remove_dups": False,
    "remove_seq_dups": False,
    "use_md": False,
}

# GATK gCNV config
# This is a default configuration for the GATK CNV pipeline.
gatk_gcnv_config = {
    "input_json": None,
    "output_dir": None,
    "exome_loc": None,
    "genome_fasta": None,
    "ref_dict": None,
    "contig_pp": None,
    "class_coherence_length": "10000",
    "cnv_coherence_length": "10000",
    "min_contig_length": "46709983",
    "p_active": "0.01",
    "p_alt": "0.000001",
    "interval_psi_scale": "0.001",
    "sample_psi_scale": "0.0001",
}

# GATK CNV PON config
# This is a default configuration for the GATK CNV PON pipeline.
cnv_pon_config = {
    "output_folder": None,
    "ref_fasta": None,
    "ref_dict": None,
    "interval_list": None,
    "pon_id": None,
    "normal_bams": None,
    "gc_correction": True,
    "bin_length": 10000,
    "blacklist_intervals": None,
    "padding": 250,
    "do_impute_zeros": True,
    "number_of_eigensamples": 20,
    "feature_query_lookahead": 1000000,
    "minimum_interval_median_percentile": 10.0,
    "maximum_zeros_in_sample_percentage": 5.0,
    "maximum_zeros_in_interval_percentage": 5.0,
    "extreme_sample_median_percentile": 2.5,
    "extreme_outlier_truncation_percentile": 0.1,
    "maximum_chunk_size": 16777216,
}

# SNV IND config
# This is a default configuration for the SNV IND pipeline.
snv_ind_config = {
    "algotype": "bwtsw",
    "index_fasta": False,
    "aligner_threads": 40,
    "remove_all_duplicates": True,
    "remove_sequencing_duplicates": False,
    "use_gatk_mark_duplicates": True,
    "use_dragen": False,
    "output_folder": None,
    "run_name": "test_run2",
    "ref_fasta": None,
    "ref_dict": None,
    "interval_list": None,
    "scatter_count": 48,
    "germline_resource": None,
    "index_image": None,
    "downsampling_stride": None,
    "panel_of_normals": None,
    "variants_for_contamination": None,
    "max_reads_per_alignment_start": None,
    "max_suspicious_reads_per_alignment_start": None,
    "max_population_af": None,
    "lrom": True,
    "interval_padding": 100,
    "tumor_samples": None,
    "normal_samples": None,
}


# CNV config
# This is a default configuration for the CNV pipeline.
cnv_config = {
    "algotype": "bwtsw",
    "index_fasta": False,
    "aligner_threads": 40,
    "remove_all_duplicates": True,
    "remove_sequencing_duplicates": False,
    "use_gatk_mark_duplicates": True,
    "use_dragen": False,
    "output_folder": None,
    "run_name": None,
    "ref_fasta": None,
    "ref_dict": None,
    "interval_list": None,
    "common_sites": None,
    "pon": None,
    "blacklist_intervals": None,
    "minimum_base_quality": 30,
    "number_of_eigensamples": None,
    "minimum_total_allele_count_case": None,
    "minimum_total_allele_count_normal": None,
    "genotyping_homozygous_log_ratio_threshold": None,
    "genotyping_base_error_rate": None,
    "maximum_number_of_segments_per_chromosome": None,
    "kernel_variance_copy_ratio": None,
    "kernel_variance_allele_fraction": None,
    "kernel_scaling_allele_fraction": None,
    "kernel_approximation_dimension": None,
    "window_size": [8, 16, 32, 64, 128, 256],
    "number_of_changepoints_penalty_factor": None,
    "minor_allele_fraction_prior_alpha": None,
    "number_of_samples_copy_ratio": None,
    "number_of_burn_in_samples_copy_ratio": None,
    "number_of_samples_allele_fraction": None,
    "number_of_burn_in_samples_allele_fraction": None,
    "smoothing_credible_interval_threshold_copy_ratio": None,
    "smoothing_credible_interval_threshold_allele_fraction": None,
    "maximum_number_of_smoothing_iterations": None,
    "number_of_smoothing_iterations_per_fit": None,
    "neutral_segment_copy_ratio_lower_bound": None,
    "neutral_segment_copy_ratio_upper_bound": None,
    "outlier_neutral_segment_copy_ratio_z_score_threshold": None,
    "calling_copy_ratio_z_score_threshold": None,
    "minimum_contig_length": None,
    "maximum_copy_ratio": None,
    "point_size_copy_ratio": None,
    "point_size_allele_fraction": None,
    "tumor_samples": None,
    "normal_samples": None,
}
