from .encoding import get_type1_encoding
from .win_core import win_core

base14_bbox = {
    "Courier-BoldOblique": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (216, -15, 495, 572),
        "quotedbl": (212, 277, 584, 562),
        "numbersign": (88, -45, 640, 651),
        "dollar": (87, -126, 629, 666),
        "percent": (102, -15, 624, 616),
        "ampersand": (62, -15, 594, 543),
        "quoteright": (230, 277, 542, 562),
        "parenleft": (266, -102, 592, 616),
        "parenright": (117, -102, 443, 616),
        "asterisk": (179, 219, 597, 601),
        "plus": (114, 39, 596, 478),
        "comma": (99, -111, 430, 174),
        "hyphen": (143, 203, 567, 313),
        "period": (207, -15, 426, 171),
        "slash": (91, -77, 626, 626),
        "zero": (137, -15, 591, 616),
        "one": (93, 0, 561, 616),
        "two": (61, 0, 593, 616),
        "three": (72, -15, 570, 616),
        "four": (82, 0, 558, 616),
        "five": (77, -15, 621, 601),
        "six": (136, -15, 652, 616),
        "seven": (147, 0, 622, 601),
        "eight": (116, -15, 603, 616),
        "nine": (76, -15, 591, 616),
        "colon": (206, -15, 479, 425),
        "semicolon": (99, -111, 480, 425),
        "less": (121, 15, 612, 501),
        "equal": (96, 118, 614, 398),
        "greater": (97, 15, 589, 501),
        "question": (183, -14, 591, 580),
        "at": (67, -15, 641, 616),
        "A": (-9, 0, 631, 562),
        "B": (30, 0, 628, 562),
        "C": (75, -18, 674, 580),
        "D": (30, 0, 663, 562),
        "E": (25, 0, 669, 562),
        "F": (39, 0, 683, 562),
        "G": (75, -18, 674, 580),
        "H": (20, 0, 699, 562),
        "I": (77, 0, 642, 562),
        "J": (59, -18, 720, 562),
        "K": (21, 0, 691, 562),
        "L": (39, 0, 635, 562),
        "M": (-2, 0, 721, 562),
        "N": (8, -12, 729, 562),
        "O": (75, -18, 645, 580),
        "P": (48, 0, 642, 562),
        "Q": (84, -138, 635, 580),
        "R": (24, 0, 617, 562),
        "S": (54, -22, 672, 582),
        "T": (86, 0, 678, 562),
        "U": (101, -18, 715, 562),
        "V": (84, 0, 732, 562),
        "W": (84, 0, 737, 562),
        "X": (12, 0, 689, 562),
        "Y": (109, 0, 708, 562),
        "Z": (62, 0, 636, 562),
        "bracketleft": (223, -102, 606, 616),
        "backslash": (223, -77, 496, 626),
        "bracketright": (103, -102, 486, 616),
        "asciicircum": (171, 250, 555, 616),
        "underscore": (-27, -125, 584, -75),
        "quoteleft": (297, 277, 487, 562),
        "a": (62, -15, 592, 454),
        "b": (13, -15, 635, 626),
        "c": (82, -15, 631, 459),
        "d": (61, -15, 644, 626),
        "e": (82, -15, 604, 454),
        "f": (83, 0, 677, 626),
        "g": (41, -146, 673, 454),
        "h": (18, 0, 614, 626),
        "i": (77, 0, 545, 658),
        "j": (37, -146, 580, 658),
        "k": (33, 0, 642, 626),
        "l": (77, 0, 545, 626),
        "m": (-22, 0, 648, 454),
        "n": (18, 0, 614, 454),
        "o": (72, -15, 622, 454),
        "p": (-31, -142, 621, 454),
        "q": (61, -142, 684, 454),
        "r": (47, 0, 654, 454),
        "s": (67, -17, 607, 459),
        "t": (118, -15, 566, 562),
        "u": (70, -15, 591, 439),
        "v": (70, 0, 694, 439),
        "w": (53, 0, 711, 439),
        "x": (6, 0, 670, 439),
        "y": (-20, -142, 694, 439),
        "z": (81, 0, 613, 439),
        "braceleft": (204, -102, 595, 616),
        "bar": (202, -250, 504, 750),
        "braceright": (114, -102, 506, 616),
        "asciitilde": (120, 153, 589, 356),
        "exclamdown": (197, -146, 476, 449),
        "cent": (122, -49, 604, 614),
        "sterling": (107, -28, 650, 611),
        "fraction": (22, -60, 707, 661),
        "yen": (98, 0, 709, 562),
        "florin": (-56, -131, 701, 616),
        "section": (74, -70, 619, 580),
        "currency": (77, 49, 643, 517),
        "quotesingle": (304, 277, 492, 562),
        "quotedblleft": (190, 277, 594, 562),
        "guillemotleft": (63, 70, 638, 446),
        "guilsinglleft": (196, 70, 544, 446),
        "guilsinglright": (166, 70, 514, 446),
        "fi": (12, 0, 643, 626),
        "fl": (12, 0, 643, 626),
        "endash": (108, 203, 602, 313),
        "dagger": (176, -70, 586, 580),
        "daggerdbl": (122, -70, 586, 580),
        "periodcentered": (250, 165, 460, 351),
        "paragraph": (61, -70, 699, 580),
        "bullet": (197, 132, 523, 430),
        "quotesinglbase": (145, -142, 457, 143),
        "quotedblbase": (35, -142, 559, 143),
        "quotedblright": (120, 277, 644, 562),
        "guillemotright": (72, 70, 647, 446),
        "ellipsis": (36, -15, 586, 116),
        "perthousand": (-44, -15, 742, 616),
        "questiondown": (102, -146, 509, 449),
        "grave": (272, 508, 503, 661),
        "acute": (313, 508, 608, 661),
        "circumflex": (212, 483, 606, 657),
        "tilde": (200, 493, 642, 636),
        "macron": (195, 505, 636, 585),
        "breve": (217, 468, 651, 631),
        "dotaccent": (347, 485, 489, 625),
        "dieresis": (245, 485, 591, 625),
        "ring": (319, 481, 527, 678),
        "cedilla": (169, -206, 366, 0),
        "hungarumlaut": (172, 488, 728, 661),
        "ogonek": (144, -199, 350, 0),
        "caron": (238, 493, 632, 667),
        "emdash": (33, 203, 677, 313),
        "AE": (-29, 0, 707, 562),
        "ordfeminine": (189, 196, 526, 580),
        "Lslash": (39, 0, 635, 562),
        "Oslash": (48, -22, 672, 584),
        "OE": (27, 0, 700, 562),
        "ordmasculine": (189, 196, 542, 580),
        "ae": (22, -15, 651, 454),
        "dotlessi": (77, 0, 545, 439),
        "lslash": (77, 0, 578, 626),
        "oslash": (55, -24, 637, 463),
        "oe": (19, -15, 661, 454),
        "germandbls": (22, -15, 628, 626),
        "Scedilla": (54, -206, 672, 582),
        "multiply": (105, 39, 606, 478),
        "logicalnot": (135, 103, 617, 413),
        "format": (-26, -146, 243, 601),
        "tab": (19, 0, 641, 562),
        "overscore": (123, 579, 734, 629),
        "IJ": (-8, -18, 741, 562),
        "trademark": (86, 230, 868, 562),
        "onequarter": (14, -60, 706, 661),
        "mu": (50, -142, 591, 439),
        "minus": (114, 203, 596, 313),
        "brokenbar": (218, -175, 488, 675),
        "arrowleft": (40, 143, 708, 455),
        "LL": (-45, 0, 694, 562),
        "arrowright": (20, 143, 688, 455),
        "thorn": (-31, -142, 621, 626),
        "lira": (107, -28, 650, 611),
        "arrowboth": (40, 143, 688, 455),
        "indent": (99, 45, 579, 372),
        "threesuperior": (193, 222, 525, 616),
        "onehalf": (23, -60, 715, 661),
        "graybox": (76, 0, 652, 599),
        "Idot": (77, 0, 642, 748),
        "ll": (1, 0, 653, 626),
        "Thorn": (48, 0, 619, 562),
        "Ccedilla": (75, -206, 674, 580),
        "notegraphic": (91, -15, 619, 572),
        "arrowup": (244, 3, 556, 626),
        "down": (168, -15, 496, 439),
        "plusminus": (76, 24, 614, 515),
        "threequarters": (8, -60, 698, 661),
        "scedilla": (67, -206, 607, 459),
        "ij": (6, -146, 714, 658),
        "eth": (94, -27, 661, 626),
        "merge": (168, -15, 533, 487),
        "twosuperior": (192, 230, 540, 616),
        "arrowdown": (174, -15, 486, 608),
        "left": (109, 44, 589, 371),
        "return": (79, 0, 700, 562),
        "Eth": (30, 0, 663, 562),
        "up": (196, 0, 523, 447),
        "divide": (114, 16, 596, 500),
        "prescription": (24, -15, 632, 562),
        "square": (19, 0, 700, 562),
        "stop": (19, 0, 700, 562),
        "degree": (174, 243, 569, 616),
        "ccedilla": (82, -206, 631, 459),
        "onesuperior": (213, 230, 514, 616),
        "largebullet": (307, 229, 413, 333),
        "center": (103, 14, 623, 580),
        "registered": (54, -18, 666, 580),
        "copyright": (54, -18, 666, 580),
        "dectab": (8, 0, 615, 320),
        "space": (0, 0, 0, 0),
        "Aacute": (-9, 0, 665, 784),
        "Acircumflex": (-9, 0, 631, 780),
        "Adieresis": (-9, 0, 631, 748),
        "Agrave": (-9, 0, 631, 784),
        "Aring": (-9, 0, 631, 801),
        "Atilde": (-9, 0, 638, 759),
        "Eacute": (25, 0, 669, 784),
        "Ecircumflex": (25, 0, 669, 780),
        "Edieresis": (25, 0, 669, 748),
        "Egrave": (25, 0, 669, 784),
        "Gcaron": (75, -18, 674, 790),
        "Iacute": (77, 0, 642, 784),
        "Icircumflex": (77, 0, 642, 780),
        "Idieresis": (77, 0, 642, 748),
        "Igrave": (77, 0, 642, 784),
        "Ntilde": (8, -12, 729, 759),
        "Oacute": (75, -18, 645, 784),
        "Ocircumflex": (75, -18, 645, 780),
        "Odieresis": (75, -18, 645, 748),
        "Ograve": (75, -18, 645, 784),
        "Otilde": (75, -18, 668, 759),
        "Scaron": (54, -22, 672, 790),
        "Uacute": (101, -18, 715, 784),
        "Ucircumflex": (101, -18, 715, 780),
        "Udieresis": (101, -18, 715, 748),
        "Ugrave": (101, -18, 715, 784),
        "Yacute": (109, 0, 708, 784),
        "Ydieresis": (109, 0, 708, 748),
        "Zcaron": (62, 0, 659, 790),
        "aacute": (62, -15, 608, 661),
        "acircumflex": (62, -15, 592, 657),
        "adieresis": (62, -15, 592, 625),
        "agrave": (62, -15, 592, 661),
        "aring": (62, -15, 592, 678),
        "atilde": (62, -15, 642, 636),
        "eacute": (82, -15, 608, 661),
        "ecircumflex": (82, -15, 606, 657),
        "edieresis": (82, -15, 604, 625),
        "egrave": (82, -15, 604, 661),
        "gcaron": (41, -146, 673, 667),
        "iacute": (77, 0, 608, 661),
        "icircumflex": (77, 0, 566, 657),
        "idieresis": (77, 0, 551, 625),
        "igrave": (77, 0, 545, 661),
        "ntilde": (18, 0, 642, 636),
        "oacute": (72, -15, 622, 661),
        "ocircumflex": (72, -15, 622, 657),
        "odieresis": (72, -15, 622, 625),
        "ograve": (72, -15, 622, 661),
        "otilde": (72, -15, 642, 636),
        "scaron": (67, -17, 632, 667),
        "uacute": (70, -15, 608, 661),
        "ucircumflex": (70, -15, 591, 657),
        "udieresis": (70, -15, 591, 625),
        "ugrave": (70, -15, 591, 661),
        "yacute": (-20, -142, 694, 661),
        "ydieresis": (-20, -142, 694, 625),
        "zcaron": (81, 0, 632, 667),
    },
    "Courier-Bold": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (202, -15, 398, 572),
        "quotedbl": (135, 277, 465, 562),
        "numbersign": (56, -45, 544, 651),
        "dollar": (82, -126, 519, 666),
        "percent": (5, -15, 595, 616),
        "ampersand": (36, -15, 546, 543),
        "quoteright": (171, 277, 423, 562),
        "parenleft": (219, -102, 461, 616),
        "parenright": (139, -102, 381, 616),
        "asterisk": (91, 219, 509, 601),
        "plus": (71, 39, 529, 478),
        "comma": (123, -111, 393, 174),
        "hyphen": (100, 203, 500, 313),
        "period": (192, -15, 408, 171),
        "slash": (98, -77, 502, 626),
        "zero": (87, -15, 513, 616),
        "one": (81, 0, 539, 616),
        "two": (61, 0, 499, 616),
        "three": (63, -15, 501, 616),
        "four": (53, 0, 507, 616),
        "five": (70, -15, 521, 601),
        "six": (90, -15, 521, 616),
        "seven": (55, 0, 494, 601),
        "eight": (83, -15, 517, 616),
        "nine": (79, -15, 510, 616),
        "colon": (191, -15, 407, 425),
        "semicolon": (123, -111, 408, 425),
        "less": (66, 15, 523, 501),
        "equal": (71, 118, 529, 398),
        "greater": (77, 15, 534, 501),
        "question": (98, -14, 501, 580),
        "at": (16, -15, 584, 616),
        "A": (-9, 0, 609, 562),
        "B": (30, 0, 573, 562),
        "C": (22, -18, 560, 580),
        "D": (30, 0, 594, 562),
        "E": (25, 0, 560, 562),
        "F": (39, 0, 570, 562),
        "G": (22, -18, 594, 580),
        "H": (20, 0, 580, 562),
        "I": (77, 0, 523, 562),
        "J": (37, -18, 601, 562),
        "K": (21, 0, 599, 562),
        "L": (39, 0, 578, 562),
        "M": (-2, 0, 602, 562),
        "N": (8, -12, 610, 562),
        "O": (22, -18, 578, 580),
        "P": (48, 0, 559, 562),
        "Q": (32, -138, 578, 580),
        "R": (24, 0, 599, 562),
        "S": (47, -22, 553, 582),
        "T": (21, 0, 579, 562),
        "U": (4, -18, 596, 562),
        "V": (-13, 0, 613, 562),
        "W": (-18, 0, 618, 562),
        "X": (12, 0, 588, 562),
        "Y": (12, 0, 589, 562),
        "Z": (62, 0, 539, 562),
        "bracketleft": (245, -102, 475, 616),
        "backslash": (99, -77, 503, 626),
        "bracketright": (125, -102, 355, 616),
        "asciicircum": (108, 250, 492, 616),
        "underscore": (0, -125, 600, -75),
        "quoteleft": (178, 277, 428, 562),
        "a": (35, -15, 570, 454),
        "b": (0, -15, 584, 626),
        "c": (40, -15, 545, 459),
        "d": (20, -15, 591, 626),
        "e": (40, -15, 563, 454),
        "f": (83, 0, 547, 626),
        "g": (30, -146, 580, 454),
        "h": (5, 0, 592, 626),
        "i": (77, 0, 523, 658),
        "j": (63, -146, 440, 658),
        "k": (20, 0, 585, 626),
        "l": (77, 0, 523, 626),
        "m": (-22, 0, 626, 454),
        "n": (18, 0, 592, 454),
        "o": (30, -15, 570, 454),
        "p": (-1, -142, 570, 454),
        "q": (20, -142, 591, 454),
        "r": (47, 0, 580, 454),
        "s": (68, -17, 535, 459),
        "t": (47, -15, 532, 562),
        "u": (-1, -15, 569, 439),
        "v": (-1, 0, 601, 439),
        "w": (-18, 0, 618, 439),
        "x": (6, 0, 594, 439),
        "y": (-4, -142, 601, 439),
        "z": (81, 0, 520, 439),
        "braceleft": (160, -102, 464, 616),
        "bar": (255, -250, 345, 750),
        "braceright": (136, -102, 440, 616),
        "asciitilde": (71, 153, 530, 356),
        "exclamdown": (202, -146, 398, 449),
        "cent": (66, -49, 518, 614),
        "sterling": (72, -28, 558, 611),
        "fraction": (25, -60, 576, 661),
        "yen": (10, 0, 590, 562),
        "florin": (-30, -131, 572, 616),
        "section": (83, -70, 517, 580),
        "currency": (54, 49, 546, 517),
        "quotesingle": (227, 277, 373, 562),
        "quotedblleft": (71, 277, 535, 562),
        "guillemotleft": (8, 70, 553, 446),
        "guilsinglleft": (141, 70, 459, 446),
        "guilsinglright": (141, 70, 459, 446),
        "fi": (12, 0, 593, 626),
        "fl": (12, 0, 593, 626),
        "endash": (65, 203, 535, 313),
        "dagger": (106, -70, 494, 580),
        "daggerdbl": (106, -70, 494, 580),
        "periodcentered": (196, 165, 404, 351),
        "paragraph": (6, -70, 576, 580),
        "bullet": (140, 132, 460, 430),
        "quotesinglbase": (175, -142, 427, 143),
        "quotedblbase": (65, -142, 529, 143),
        "quotedblright": (61, 277, 525, 562),
        "guillemotright": (47, 70, 592, 446),
        "ellipsis": (26, -15, 574, 116),
        "perthousand": (-113, -15, 713, 616),
        "questiondown": (99, -146, 502, 449),
        "grave": (132, 508, 395, 661),
        "acute": (205, 508, 468, 661),
        "circumflex": (103, 483, 497, 657),
        "tilde": (89, 493, 512, 636),
        "macron": (88, 505, 512, 585),
        "breve": (83, 468, 517, 631),
        "dotaccent": (230, 485, 370, 625),
        "dieresis": (128, 485, 472, 625),
        "ring": (198, 481, 402, 678),
        "cedilla": (205, -206, 387, 0),
        "hungarumlaut": (68, 488, 588, 661),
        "ogonek": (169, -199, 367, 0),
        "caron": (103, 493, 497, 667),
        "emdash": (-10, 203, 610, 313),
        "AE": (-29, 0, 602, 562),
        "ordfeminine": (147, 196, 453, 580),
        "Lslash": (39, 0, 578, 562),
        "Oslash": (22, -22, 578, 584),
        "OE": (-25, 0, 595, 562),
        "ordmasculine": (147, 196, 453, 580),
        "ae": (-4, -15, 601, 454),
        "dotlessi": (77, 0, 523, 439),
        "lslash": (77, 0, 523, 626),
        "oslash": (30, -24, 570, 463),
        "oe": (-18, -15, 611, 454),
        "germandbls": (22, -15, 596, 626),
        "Scedilla": (47, -206, 553, 582),
        "multiply": (81, 39, 520, 478),
        "logicalnot": (71, 103, 529, 413),
        "format": (5, -146, 115, 601),
        "tab": (19, 0, 581, 562),
        "overscore": (0, 579, 600, 629),
        "IJ": (-8, -18, 622, 562),
        "trademark": (-9, 230, 749, 562),
        "onequarter": (-56, -60, 656, 661),
        "mu": (-1, -142, 569, 439),
        "minus": (71, 203, 529, 313),
        "brokenbar": (255, -175, 345, 675),
        "arrowleft": (-24, 143, 634, 455),
        "LL": (-45, 0, 645, 562),
        "arrowright": (-34, 143, 624, 455),
        "thorn": (-14, -142, 570, 626),
        "lira": (72, -28, 558, 611),
        "arrowboth": (-24, 143, 624, 455),
        "indent": (65, 45, 535, 372),
        "threesuperior": (138, 222, 433, 616),
        "onehalf": (-47, -60, 648, 661),
        "graybox": (76, 0, 525, 599),
        "Idot": (77, 0, 523, 748),
        "ll": (-12, 0, 600, 626),
        "Thorn": (48, 0, 557, 562),
        "Ccedilla": (22, -206, 560, 580),
        "notegraphic": (77, -15, 523, 572),
        "arrowup": (144, 3, 456, 626),
        "down": (137, -15, 464, 439),
        "plusminus": (71, 24, 529, 515),
        "threequarters": (-47, -60, 648, 661),
        "scedilla": (68, -206, 535, 459),
        "ij": (6, -146, 574, 658),
        "eth": (58, -27, 543, 626),
        "merge": (137, -15, 464, 487),
        "twosuperior": (143, 230, 436, 616),
        "arrowdown": (144, -15, 456, 608),
        "left": (65, 44, 535, 371),
        "return": (19, 0, 581, 562),
        "Eth": (30, 0, 594, 562),
        "up": (136, 0, 463, 447),
        "divide": (71, 16, 529, 500),
        "prescription": (24, -15, 599, 562),
        "square": (19, 0, 581, 562),
        "stop": (19, 0, 581, 562),
        "degree": (86, 243, 474, 616),
        "ccedilla": (40, -206, 545, 459),
        "onesuperior": (153, 230, 447, 616),
        "largebullet": (248, 229, 352, 333),
        "center": (40, 14, 560, 580),
        "registered": (0, -18, 600, 580),
        "copyright": (0, -18, 600, 580),
        "dectab": (8, 0, 592, 320),
        "space": (0, 0, 0, 0),
        "Aacute": (-9, 0, 609, 784),
        "Acircumflex": (-9, 0, 609, 780),
        "Adieresis": (-9, 0, 609, 748),
        "Agrave": (-9, 0, 609, 784),
        "Aring": (-9, 0, 609, 801),
        "Atilde": (-9, 0, 609, 759),
        "Eacute": (25, 0, 560, 784),
        "Ecircumflex": (25, 0, 560, 780),
        "Edieresis": (25, 0, 560, 748),
        "Egrave": (25, 0, 560, 784),
        "Gcaron": (22, -18, 594, 790),
        "Iacute": (77, 0, 523, 784),
        "Icircumflex": (77, 0, 523, 780),
        "Idieresis": (77, 0, 523, 748),
        "Igrave": (77, 0, 523, 784),
        "Ntilde": (8, -12, 610, 759),
        "Oacute": (22, -18, 578, 784),
        "Ocircumflex": (22, -18, 578, 780),
        "Odieresis": (22, -18, 578, 748),
        "Ograve": (22, -18, 578, 784),
        "Otilde": (22, -18, 578, 759),
        "Scaron": (47, -22, 553, 790),
        "Uacute": (4, -18, 596, 784),
        "Ucircumflex": (4, -18, 596, 780),
        "Udieresis": (4, -18, 596, 748),
        "Ugrave": (4, -18, 596, 784),
        "Yacute": (12, 0, 589, 784),
        "Ydieresis": (12, 0, 589, 748),
        "Zcaron": (62, 0, 539, 790),
        "aacute": (35, -15, 570, 661),
        "acircumflex": (35, -15, 570, 657),
        "adieresis": (35, -15, 570, 625),
        "agrave": (35, -15, 570, 661),
        "aring": (35, -15, 570, 678),
        "atilde": (35, -15, 570, 636),
        "eacute": (40, -15, 563, 661),
        "ecircumflex": (40, -15, 563, 657),
        "edieresis": (40, -15, 563, 625),
        "egrave": (40, -15, 563, 661),
        "gcaron": (30, -146, 580, 667),
        "iacute": (77, 0, 523, 661),
        "icircumflex": (63, 0, 523, 657),
        "idieresis": (77, 0, 523, 625),
        "igrave": (77, 0, 523, 661),
        "ntilde": (18, 0, 592, 636),
        "oacute": (30, -15, 570, 661),
        "ocircumflex": (30, -15, 570, 657),
        "odieresis": (30, -15, 570, 625),
        "ograve": (30, -15, 570, 661),
        "otilde": (30, -15, 570, 636),
        "scaron": (68, -17, 535, 667),
        "uacute": (-1, -15, 569, 661),
        "ucircumflex": (-1, -15, 569, 657),
        "udieresis": (-1, -15, 569, 625),
        "ugrave": (-1, -15, 569, 661),
        "yacute": (-4, -142, 601, 661),
        "ydieresis": (-4, -142, 601, 625),
        "zcaron": (81, 0, 520, 667),
    },
    "Courier": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (236, -15, 364, 572),
        "quotedbl": (187, 328, 413, 562),
        "numbersign": (93, -32, 507, 639),
        "dollar": (105, -126, 496, 662),
        "percent": (81, -15, 518, 622),
        "ampersand": (63, -15, 538, 543),
        "quoteright": (213, 328, 376, 562),
        "parenleft": (269, -108, 440, 622),
        "parenright": (160, -108, 331, 622),
        "asterisk": (116, 257, 484, 607),
        "plus": (80, 44, 520, 470),
        "comma": (181, -112, 344, 122),
        "hyphen": (103, 231, 497, 285),
        "period": (229, -15, 371, 109),
        "slash": (125, -80, 475, 629),
        "zero": (106, -15, 494, 622),
        "one": (96, 0, 505, 622),
        "two": (70, 0, 471, 622),
        "three": (75, -15, 466, 622),
        "four": (78, 0, 500, 622),
        "five": (92, -15, 497, 607),
        "six": (111, -15, 497, 622),
        "seven": (82, 0, 483, 607),
        "eight": (102, -15, 498, 622),
        "nine": (96, -15, 489, 622),
        "colon": (229, -15, 371, 385),
        "semicolon": (181, -112, 371, 385),
        "less": (41, 42, 519, 472),
        "equal": (80, 138, 520, 376),
        "greater": (66, 42, 544, 472),
        "question": (129, -15, 492, 572),
        "at": (77, -15, 533, 622),
        "A": (3, 0, 597, 562),
        "B": (43, 0, 559, 562),
        "C": (41, -18, 540, 580),
        "D": (43, 0, 574, 562),
        "E": (53, 0, 550, 562),
        "F": (53, 0, 545, 562),
        "G": (31, -18, 575, 580),
        "H": (32, 0, 568, 562),
        "I": (96, 0, 504, 562),
        "J": (34, -18, 566, 562),
        "K": (38, 0, 582, 562),
        "L": (47, 0, 554, 562),
        "M": (4, 0, 596, 562),
        "N": (7, -13, 593, 562),
        "O": (43, -18, 557, 580),
        "P": (79, 0, 558, 562),
        "Q": (43, -138, 557, 580),
        "R": (38, 0, 588, 562),
        "S": (72, -20, 529, 580),
        "T": (38, 0, 563, 562),
        "U": (17, -18, 583, 562),
        "V": (-4, -13, 604, 562),
        "W": (-3, -13, 603, 562),
        "X": (23, 0, 577, 562),
        "Y": (24, 0, 576, 562),
        "Z": (86, 0, 514, 562),
        "bracketleft": (269, -108, 442, 622),
        "backslash": (118, -80, 482, 629),
        "bracketright": (158, -108, 331, 622),
        "asciicircum": (94, 354, 506, 622),
        "underscore": (0, -125, 600, -75),
        "quoteleft": (224, 328, 387, 562),
        "a": (53, -15, 559, 441),
        "b": (14, -15, 575, 629),
        "c": (66, -15, 529, 441),
        "d": (45, -15, 591, 629),
        "e": (66, -15, 548, 441),
        "f": (114, 0, 531, 629),
        "g": (45, -157, 566, 441),
        "h": (18, 0, 582, 629),
        "i": (95, 0, 505, 657),
        "j": (82, -157, 410, 657),
        "k": (43, 0, 580, 629),
        "l": (95, 0, 505, 629),
        "m": (-5, 0, 605, 441),
        "n": (26, 0, 575, 441),
        "o": (62, -15, 538, 441),
        "p": (9, -157, 555, 441),
        "q": (45, -157, 591, 441),
        "r": (60, 0, 559, 441),
        "s": (80, -15, 513, 441),
        "t": (87, -15, 530, 561),
        "u": (21, -15, 562, 426),
        "v": (10, -10, 590, 426),
        "w": (-4, -10, 604, 426),
        "x": (20, 0, 580, 426),
        "y": (7, -157, 592, 426),
        "z": (99, 0, 502, 426),
        "braceleft": (182, -108, 437, 622),
        "bar": (275, -250, 326, 750),
        "braceright": (163, -108, 418, 622),
        "asciitilde": (63, 197, 540, 320),
        "exclamdown": (236, -157, 364, 430),
        "cent": (96, -49, 500, 614),
        "sterling": (84, -21, 521, 611),
        "fraction": (92, -57, 509, 665),
        "yen": (26, 0, 574, 562),
        "florin": (4, -143, 539, 622),
        "section": (113, -78, 488, 580),
        "currency": (73, 58, 527, 506),
        "quotesingle": (259, 328, 341, 562),
        "quotedblleft": (143, 328, 471, 562),
        "guillemotleft": (37, 70, 563, 446),
        "guilsinglleft": (149, 70, 451, 446),
        "guilsinglright": (149, 70, 451, 446),
        "fi": (3, 0, 597, 629),
        "fl": (3, 0, 597, 629),
        "endash": (75, 231, 525, 285),
        "dagger": (141, -78, 459, 580),
        "daggerdbl": (141, -78, 459, 580),
        "periodcentered": (222, 189, 378, 327),
        "paragraph": (50, -78, 511, 562),
        "bullet": (172, 130, 428, 383),
        "quotesinglbase": (213, -134, 376, 100),
        "quotedblbase": (143, -134, 457, 100),
        "quotedblright": (143, 328, 457, 562),
        "guillemotright": (37, 70, 563, 446),
        "ellipsis": (37, -15, 563, 111),
        "perthousand": (3, -15, 600, 622),
        "questiondown": (108, -157, 471, 430),
        "grave": (151, 497, 378, 672),
        "acute": (242, 497, 469, 672),
        "circumflex": (124, 477, 476, 654),
        "tilde": (105, 489, 503, 606),
        "macron": (120, 525, 480, 565),
        "breve": (153, 501, 447, 609),
        "dotaccent": (249, 477, 352, 580),
        "dieresis": (148, 492, 453, 595),
        "ring": (218, 463, 382, 627),
        "cedilla": (224, -151, 362, 10),
        "hungarumlaut": (133, 497, 540, 672),
        "ogonek": (227, -151, 370, 0),
        "caron": (124, 492, 476, 669),
        "emdash": (0, 231, 600, 285),
        "AE": (3, 0, 550, 562),
        "ordfeminine": (156, 249, 442, 580),
        "Lslash": (47, 0, 554, 562),
        "Oslash": (43, -80, 557, 629),
        "OE": (7, 0, 567, 562),
        "ordmasculine": (157, 249, 443, 580),
        "ae": (19, -15, 570, 441),
        "dotlessi": (95, 0, 505, 426),
        "lslash": (95, 0, 505, 629),
        "oslash": (62, -80, 538, 506),
        "oe": (19, -15, 559, 441),
        "germandbls": (48, -15, 588, 629),
        "Scedilla": (72, -151, 529, 580),
        "multiply": (87, 43, 515, 470),
        "logicalnot": (87, 108, 513, 369),
        "format": (5, -157, 56, 607),
        "tab": (19, 0, 581, 562),
        "overscore": (0, 579, 600, 629),
        "IJ": (32, -18, 583, 562),
        "trademark": (-23, 263, 623, 562),
        "onequarter": (0, -57, 600, 665),
        "mu": (21, -157, 562, 426),
        "minus": (80, 232, 520, 283),
        "brokenbar": (275, -175, 326, 675),
        "arrowleft": (-24, 115, 624, 483),
        "LL": (8, 0, 592, 562),
        "arrowright": (-24, 115, 624, 483),
        "thorn": (-6, -157, 555, 629),
        "lira": (73, -21, 521, 611),
        "arrowboth": (-28, 115, 628, 483),
        "indent": (70, 68, 530, 348),
        "threesuperior": (155, 240, 406, 622),
        "onehalf": (0, -57, 611, 665),
        "graybox": (76, 0, 525, 599),
        "Idot": (96, 0, 504, 716),
        "ll": (18, 0, 567, 629),
        "Thorn": (79, 0, 538, 562),
        "Ccedilla": (41, -151, 540, 580),
        "notegraphic": (136, -15, 464, 572),
        "arrowup": (116, 0, 484, 623),
        "down": (160, -15, 440, 426),
        "plusminus": (87, 44, 513, 558),
        "threequarters": (8, -56, 593, 666),
        "scedilla": (80, -151, 513, 441),
        "ij": (37, -157, 490, 657),
        "eth": (62, -15, 538, 629),
        "merge": (160, -15, 440, 436),
        "twosuperior": (177, 249, 424, 622),
        "arrowdown": (116, -15, 484, 608),
        "left": (70, 68, 530, 348),
        "return": (19, 0, 581, 562),
        "Eth": (30, 0, 574, 562),
        "up": (160, 0, 440, 437),
        "divide": (87, 48, 513, 467),
        "prescription": (27, -15, 577, 562),
        "square": (19, 0, 581, 562),
        "stop": (19, 0, 581, 562),
        "degree": (123, 269, 477, 622),
        "ccedilla": (66, -151, 529, 441),
        "onesuperior": (172, 249, 428, 622),
        "largebullet": (261, 220, 339, 297),
        "center": (40, 14, 560, 580),
        "registered": (0, -18, 600, 580),
        "copyright": (0, -18, 600, 580),
        "dectab": (18, 0, 582, 227),
        "space": (0, 0, 0, 0),
        "Aacute": (3, 0, 597, 793),
        "Acircumflex": (3, 0, 597, 775),
        "Adieresis": (3, 0, 597, 731),
        "Agrave": (3, 0, 597, 793),
        "Aring": (3, 0, 597, 753),
        "Atilde": (3, 0, 597, 732),
        "Eacute": (53, 0, 550, 793),
        "Ecircumflex": (53, 0, 550, 775),
        "Edieresis": (53, 0, 550, 731),
        "Egrave": (53, 0, 550, 793),
        "Gcaron": (31, -18, 575, 805),
        "Iacute": (96, 0, 504, 793),
        "Icircumflex": (96, 0, 504, 775),
        "Idieresis": (96, 0, 504, 731),
        "Igrave": (96, 0, 504, 793),
        "Ntilde": (7, -13, 593, 732),
        "Oacute": (43, -18, 557, 793),
        "Ocircumflex": (43, -18, 557, 775),
        "Odieresis": (43, -18, 557, 731),
        "Ograve": (43, -18, 557, 793),
        "Otilde": (43, -18, 557, 732),
        "Scaron": (72, -20, 529, 805),
        "Uacute": (17, -18, 583, 793),
        "Ucircumflex": (17, -18, 583, 775),
        "Udieresis": (17, -18, 583, 731),
        "Ugrave": (17, -18, 583, 793),
        "Yacute": (24, 0, 576, 793),
        "Ydieresis": (24, 0, 576, 731),
        "Zcaron": (86, 0, 514, 805),
        "aacute": (53, -15, 559, 672),
        "acircumflex": (53, -15, 559, 654),
        "adieresis": (53, -15, 559, 595),
        "agrave": (53, -15, 559, 672),
        "aring": (53, -15, 559, 627),
        "atilde": (53, -15, 559, 606),
        "eacute": (66, -15, 548, 672),
        "ecircumflex": (66, -15, 548, 654),
        "edieresis": (66, -15, 548, 595),
        "egrave": (66, -15, 548, 672),
        "gcaron": (45, -157, 566, 669),
        "iacute": (95, 0, 505, 672),
        "icircumflex": (94, 0, 505, 654),
        "idieresis": (95, 0, 505, 595),
        "igrave": (95, 0, 505, 672),
        "ntilde": (26, 0, 575, 606),
        "oacute": (62, -15, 538, 672),
        "ocircumflex": (62, -15, 538, 654),
        "odieresis": (62, -15, 538, 595),
        "ograve": (62, -15, 538, 672),
        "otilde": (62, -15, 538, 606),
        "scaron": (80, -15, 513, 669),
        "uacute": (21, -15, 562, 672),
        "ucircumflex": (21, -15, 562, 654),
        "udieresis": (21, -15, 562, 595),
        "ugrave": (21, -15, 562, 672),
        "yacute": (7, -157, 592, 672),
        "ydieresis": (7, -157, 592, 595),
        "zcaron": (99, 0, 502, 669),
    },
    "Courier-Oblique": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (244, -15, 464, 572),
        "quotedbl": (273, 328, 532, 562),
        "numbersign": (133, -32, 596, 639),
        "dollar": (108, -126, 596, 662),
        "percent": (134, -15, 599, 622),
        "ampersand": (87, -15, 580, 543),
        "quoteright": (283, 328, 495, 562),
        "parenleft": (314, -108, 572, 622),
        "parenright": (137, -108, 396, 622),
        "asterisk": (212, 257, 580, 607),
        "plus": (129, 44, 580, 470),
        "comma": (157, -112, 370, 122),
        "hyphen": (152, 231, 558, 285),
        "period": (238, -15, 382, 109),
        "slash": (112, -80, 604, 629),
        "zero": (155, -15, 574, 622),
        "one": (98, 0, 515, 622),
        "two": (70, 0, 568, 622),
        "three": (82, -15, 537, 622),
        "four": (108, 0, 541, 622),
        "five": (99, -15, 589, 607),
        "six": (155, -15, 629, 622),
        "seven": (182, 0, 612, 607),
        "eight": (133, -15, 588, 622),
        "nine": (93, -15, 574, 622),
        "colon": (238, -15, 441, 385),
        "semicolon": (157, -112, 441, 385),
        "less": (96, 42, 610, 472),
        "equal": (109, 138, 600, 376),
        "greater": (85, 42, 599, 472),
        "question": (222, -15, 583, 572),
        "at": (127, -15, 582, 622),
        "A": (3, 0, 607, 562),
        "B": (43, 0, 615, 562),
        "C": (94, -18, 655, 580),
        "D": (43, 0, 645, 562),
        "E": (53, 0, 660, 562),
        "F": (53, 0, 660, 562),
        "G": (84, -18, 645, 580),
        "H": (32, 0, 687, 562),
        "I": (96, 0, 623, 562),
        "J": (52, -18, 685, 562),
        "K": (38, 0, 671, 562),
        "L": (47, 0, 607, 562),
        "M": (4, 0, 715, 562),
        "N": (7, -13, 712, 562),
        "O": (95, -18, 625, 580),
        "P": (79, 0, 643, 562),
        "Q": (95, -138, 625, 580),
        "R": (38, 0, 598, 562),
        "S": (76, -20, 650, 580),
        "T": (108, 0, 665, 562),
        "U": (125, -18, 702, 562),
        "V": (105, -13, 723, 562),
        "W": (106, -13, 722, 562),
        "X": (23, 0, 675, 562),
        "Y": (133, 0, 695, 562),
        "Z": (86, 0, 610, 562),
        "bracketleft": (246, -108, 574, 622),
        "backslash": (249, -80, 468, 629),
        "bracketright": (135, -108, 463, 622),
        "asciicircum": (175, 354, 587, 622),
        "underscore": (-27, -125, 584, -75),
        "quoteleft": (343, 328, 457, 562),
        "a": (77, -15, 569, 441),
        "b": (29, -15, 625, 629),
        "c": (106, -15, 608, 441),
        "d": (86, -15, 640, 629),
        "e": (107, -15, 597, 441),
        "f": (114, 0, 662, 629),
        "g": (61, -157, 657, 441),
        "h": (33, 0, 592, 629),
        "i": (95, 0, 515, 657),
        "j": (52, -157, 550, 657),
        "k": (58, 0, 633, 629),
        "l": (95, 0, 515, 629),
        "m": (-5, 0, 615, 441),
        "n": (26, 0, 585, 441),
        "o": (102, -15, 588, 441),
        "p": (-24, -157, 605, 441),
        "q": (86, -157, 682, 441),
        "r": (60, 0, 636, 441),
        "s": (78, -15, 584, 441),
        "t": (167, -15, 561, 561),
        "u": (101, -15, 572, 426),
        "v": (90, -10, 681, 426),
        "w": (76, -10, 695, 426),
        "x": (20, 0, 655, 426),
        "y": (-4, -157, 683, 426),
        "z": (99, 0, 593, 426),
        "braceleft": (233, -108, 569, 622),
        "bar": (222, -250, 485, 750),
        "braceright": (140, -108, 477, 622),
        "asciitilde": (116, 197, 600, 320),
        "exclamdown": (225, -157, 445, 430),
        "cent": (152, -49, 588, 614),
        "sterling": (124, -21, 621, 611),
        "fraction": (84, -57, 646, 665),
        "yen": (120, 0, 693, 562),
        "florin": (-26, -143, 671, 622),
        "section": (104, -78, 590, 580),
        "currency": (94, 58, 628, 506),
        "quotesingle": (345, 328, 460, 562),
        "quotedblleft": (262, 328, 541, 562),
        "guillemotleft": (92, 70, 652, 446),
        "guilsinglleft": (204, 70, 540, 446),
        "guilsinglright": (170, 70, 506, 446),
        "fi": (3, 0, 619, 629),
        "fl": (3, 0, 619, 629),
        "endash": (124, 231, 586, 285),
        "dagger": (217, -78, 546, 580),
        "daggerdbl": (163, -78, 546, 580),
        "periodcentered": (276, 189, 434, 327),
        "paragraph": (100, -78, 630, 562),
        "bullet": (225, 130, 485, 383),
        "quotesinglbase": (185, -134, 397, 100),
        "quotedblbase": (115, -134, 478, 100),
        "quotedblright": (213, 328, 576, 562),
        "guillemotright": (58, 70, 618, 446),
        "ellipsis": (46, -15, 574, 111),
        "perthousand": (59, -15, 626, 622),
        "questiondown": (106, -157, 466, 430),
        "grave": (294, 497, 484, 672),
        "acute": (348, 497, 612, 672),
        "circumflex": (229, 477, 581, 654),
        "tilde": (212, 489, 629, 606),
        "macron": (232, 525, 600, 565),
        "breve": (279, 501, 576, 609),
        "dotaccent": (360, 477, 465, 580),
        "dieresis": (263, 492, 570, 595),
        "ring": (333, 463, 499, 627),
        "cedilla": (197, -151, 344, 10),
        "hungarumlaut": (239, 497, 683, 672),
        "ogonek": (207, -151, 348, 0),
        "caron": (262, 492, 614, 669),
        "emdash": (49, 231, 661, 285),
        "AE": (3, 0, 655, 562),
        "ordfeminine": (209, 249, 512, 580),
        "Lslash": (47, 0, 607, 562),
        "Oslash": (95, -80, 625, 629),
        "OE": (60, 0, 672, 562),
        "ordmasculine": (210, 249, 534, 580),
        "ae": (42, -15, 626, 441),
        "dotlessi": (95, 0, 515, 426),
        "lslash": (95, 0, 583, 629),
        "oslash": (102, -80, 588, 506),
        "oe": (55, -15, 615, 441),
        "germandbls": (48, -15, 617, 629),
        "Scedilla": (76, -151, 650, 580),
        "multiply": (103, 43, 607, 470),
        "logicalnot": (155, 108, 591, 369),
        "format": (-28, -157, 185, 607),
        "tab": (19, 0, 641, 562),
        "overscore": (123, 579, 734, 629),
        "IJ": (32, -18, 702, 562),
        "trademark": (75, 263, 742, 562),
        "onequarter": (65, -57, 674, 665),
        "mu": (72, -157, 572, 426),
        "minus": (129, 232, 580, 283),
        "brokenbar": (238, -175, 469, 675),
        "arrowleft": (40, 115, 693, 483),
        "LL": (8, 0, 647, 562),
        "arrowright": (34, 115, 688, 483),
        "thorn": (-24, -157, 605, 629),
        "lira": (118, -21, 621, 611),
        "arrowboth": (36, 115, 692, 483),
        "indent": (108, 68, 574, 348),
        "threesuperior": (213, 240, 500, 622),
        "onehalf": (65, -57, 669, 665),
        "graybox": (76, 0, 652, 599),
        "Idot": (96, 0, 623, 716),
        "ll": (33, 0, 616, 629),
        "Thorn": (79, 0, 605, 562),
        "Ccedilla": (94, -151, 658, 580),
        "notegraphic": (144, -15, 564, 572),
        "arrowup": (209, 0, 577, 623),
        "down": (187, -15, 467, 426),
        "plusminus": (96, 44, 594, 558),
        "threequarters": (73, -56, 659, 666),
        "scedilla": (78, -151, 584, 441),
        "ij": (37, -157, 630, 657),
        "eth": (102, -15, 639, 629),
        "merge": (187, -15, 503, 436),
        "twosuperior": (230, 249, 534, 622),
        "arrowdown": (152, -15, 520, 608),
        "left": (114, 68, 580, 348),
        "return": (79, 0, 700, 562),
        "Eth": (43, 0, 645, 562),
        "up": (223, 0, 503, 437),
        "divide": (136, 48, 573, 467),
        "prescription": (27, -15, 617, 562),
        "square": (19, 0, 700, 562),
        "stop": (19, 0, 700, 562),
        "degree": (214, 269, 575, 622),
        "ccedilla": (106, -151, 614, 441),
        "onesuperior": (231, 249, 491, 622),
        "largebullet": (316, 220, 394, 297),
        "center": (103, 14, 623, 580),
        "registered": (54, -18, 666, 580),
        "copyright": (54, -18, 666, 580),
        "dectab": (18, 0, 593, 227),
        "space": (0, 0, 0, 0),
        "Aacute": (3, 0, 658, 793),
        "Acircumflex": (3, 0, 607, 775),
        "Adieresis": (3, 0, 607, 731),
        "Agrave": (3, 0, 607, 793),
        "Aring": (3, 0, 607, 753),
        "Atilde": (3, 0, 656, 732),
        "Eacute": (53, 0, 668, 793),
        "Ecircumflex": (53, 0, 660, 775),
        "Edieresis": (53, 0, 660, 731),
        "Egrave": (53, 0, 660, 793),
        "Gcaron": (84, -18, 645, 805),
        "Iacute": (96, 0, 638, 793),
        "Icircumflex": (96, 0, 623, 775),
        "Idieresis": (96, 0, 623, 731),
        "Igrave": (96, 0, 623, 793),
        "Ntilde": (7, -13, 712, 732),
        "Oacute": (95, -18, 638, 793),
        "Ocircumflex": (95, -18, 625, 775),
        "Odieresis": (95, -18, 625, 731),
        "Ograve": (95, -18, 625, 793),
        "Otilde": (95, -18, 656, 732),
        "Scaron": (76, -20, 673, 805),
        "Uacute": (125, -18, 702, 793),
        "Ucircumflex": (125, -18, 702, 775),
        "Udieresis": (125, -18, 702, 731),
        "Ugrave": (125, -18, 702, 793),
        "Yacute": (133, 0, 695, 793),
        "Ydieresis": (133, 0, 695, 731),
        "Zcaron": (86, 0, 643, 805),
        "aacute": (77, -15, 612, 672),
        "acircumflex": (77, -15, 581, 654),
        "adieresis": (77, -15, 570, 595),
        "agrave": (77, -15, 569, 672),
        "aring": (77, -15, 569, 627),
        "atilde": (77, -15, 629, 606),
        "eacute": (107, -15, 612, 672),
        "ecircumflex": (107, -15, 597, 654),
        "edieresis": (107, -15, 597, 595),
        "egrave": (107, -15, 597, 672),
        "gcaron": (61, -157, 657, 669),
        "iacute": (95, 0, 612, 672),
        "icircumflex": (95, 0, 551, 654),
        "idieresis": (95, 0, 540, 595),
        "igrave": (95, 0, 515, 672),
        "ntilde": (26, 0, 629, 606),
        "oacute": (102, -15, 612, 672),
        "ocircumflex": (102, -15, 588, 654),
        "odieresis": (102, -15, 588, 595),
        "ograve": (102, -15, 588, 672),
        "otilde": (102, -15, 629, 606),
        "scaron": (78, -15, 614, 669),
        "uacute": (101, -15, 602, 672),
        "ucircumflex": (101, -15, 572, 654),
        "udieresis": (101, -15, 572, 595),
        "ugrave": (101, -15, 572, 672),
        "yacute": (-4, -157, 683, 672),
        "ydieresis": (-4, -157, 683, 595),
        "zcaron": (99, 0, 624, 669),
    },
    "Helvetica-BoldOblique": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (94, 0, 397, 718),
        "quotedbl": (193, 447, 529, 718),
        "numbersign": (60, 0, 644, 698),
        "dollar": (67, -115, 621, 775),
        "percent": (137, -19, 900, 710),
        "ampersand": (89, -19, 732, 718),
        "quoteright": (167, 445, 362, 718),
        "parenleft": (76, -208, 470, 734),
        "parenright": (-25, -208, 368, 734),
        "asterisk": (146, 387, 481, 718),
        "plus": (82, 0, 610, 506),
        "comma": (28, -168, 245, 146),
        "hyphen": (73, 215, 379, 345),
        "period": (64, 0, 245, 146),
        "slash": (-37, -19, 468, 737),
        "zero": (87, -19, 617, 710),
        "one": (173, 0, 529, 710),
        "two": (26, 0, 619, 710),
        "three": (66, -19, 608, 710),
        "four": (60, 0, 598, 710),
        "five": (64, -19, 636, 698),
        "six": (86, -19, 619, 710),
        "seven": (125, 0, 676, 698),
        "eight": (70, -19, 615, 710),
        "nine": (78, -19, 615, 710),
        "colon": (92, 0, 351, 512),
        "semicolon": (56, -168, 351, 512),
        "less": (82, -8, 655, 514),
        "equal": (58, 87, 633, 419),
        "greater": (36, -8, 609, 514),
        "question": (165, 0, 670, 727),
        "at": (186, -19, 953, 737),
        "A": (20, 0, 702, 718),
        "B": (76, 0, 763, 718),
        "C": (107, -19, 788, 737),
        "D": (76, 0, 777, 718),
        "E": (76, 0, 757, 718),
        "F": (76, 0, 740, 718),
        "G": (108, -19, 816, 737),
        "H": (71, 0, 804, 718),
        "I": (64, 0, 367, 718),
        "J": (60, -18, 637, 718),
        "K": (87, 0, 858, 718),
        "L": (76, 0, 611, 718),
        "M": (69, 0, 918, 718),
        "N": (69, 0, 807, 718),
        "O": (108, -19, 823, 737),
        "P": (76, 0, 737, 718),
        "Q": (108, -52, 823, 737),
        "R": (76, 0, 778, 718),
        "S": (81, -19, 717, 737),
        "T": (140, 0, 751, 718),
        "U": (116, -19, 804, 718),
        "V": (172, 0, 801, 718),
        "W": (169, 0, 1082, 718),
        "X": (14, 0, 791, 718),
        "Y": (168, 0, 806, 718),
        "Z": (25, 0, 737, 718),
        "bracketleft": (21, -196, 462, 722),
        "backslash": (124, -19, 307, 737),
        "bracketright": (-18, -196, 423, 722),
        "asciicircum": (131, 323, 591, 698),
        "underscore": (-27, -125, 540, -75),
        "quoteleft": (165, 454, 361, 727),
        "a": (55, -14, 582, 546),
        "b": (61, -14, 645, 718),
        "c": (79, -14, 599, 546),
        "d": (83, -14, 704, 718),
        "e": (71, -14, 592, 546),
        "f": (87, 0, 469, 727),
        "g": (39, -217, 666, 546),
        "h": (65, 0, 629, 718),
        "i": (69, 0, 363, 725),
        "j": (-42, -214, 363, 725),
        "k": (69, 0, 670, 718),
        "l": (69, 0, 362, 718),
        "m": (64, 0, 909, 546),
        "n": (65, 0, 629, 546),
        "o": (83, -14, 643, 546),
        "p": (18, -207, 645, 546),
        "q": (81, -207, 665, 546),
        "r": (64, 0, 489, 546),
        "s": (63, -14, 584, 546),
        "t": (101, -6, 422, 676),
        "u": (99, -14, 658, 532),
        "v": (126, 0, 656, 532),
        "w": (123, 0, 882, 532),
        "x": (15, 0, 648, 532),
        "y": (42, -214, 652, 532),
        "z": (20, 0, 583, 532),
        "braceleft": (94, -196, 518, 722),
        "bar": (80, -19, 353, 737),
        "braceright": (-18, -196, 407, 722),
        "asciitilde": (115, 163, 577, 343),
        "exclamdown": (50, -186, 353, 532),
        "cent": (79, -118, 599, 628),
        "sterling": (50, -16, 635, 718),
        "fraction": (-174, -19, 487, 710),
        "yen": (60, 0, 713, 698),
        "florin": (-50, -210, 669, 737),
        "section": (61, -184, 598, 727),
        "currency": (27, 76, 680, 636),
        "quotesingle": (165, 447, 321, 718),
        "quotedblleft": (160, 454, 588, 727),
        "guillemotleft": (135, 76, 571, 484),
        "guilsinglleft": (130, 76, 353, 484),
        "guilsinglright": (99, 76, 322, 484),
        "fi": (87, 0, 696, 727),
        "fl": (87, 0, 695, 727),
        "endash": (48, 227, 627, 333),
        "dagger": (118, -171, 626, 718),
        "daggerdbl": (46, -171, 628, 718),
        "periodcentered": (111, 172, 275, 334),
        "paragraph": (99, -191, 688, 700),
        "bullet": (84, 194, 420, 524),
        "quotesinglbase": (41, -146, 236, 127),
        "quotedblbase": (36, -146, 463, 127),
        "quotedblright": (162, 445, 589, 718),
        "guillemotright": (104, 76, 540, 484),
        "ellipsis": (92, 0, 939, 146),
        "perthousand": (76, -19, 1038, 710),
        "questiondown": (54, -195, 559, 532),
        "grave": (136, 604, 353, 750),
        "acute": (236, 604, 515, 750),
        "circumflex": (118, 604, 471, 750),
        "tilde": (113, 610, 507, 737),
        "macron": (122, 604, 483, 678),
        "breve": (156, 604, 494, 750),
        "dotaccent": (235, 614, 385, 729),
        "dieresis": (137, 614, 482, 729),
        "ring": (200, 568, 420, 776),
        "cedilla": (-37, -228, 219, 0),
        "hungarumlaut": (137, 604, 645, 750),
        "ogonek": (41, -228, 264, 0),
        "caron": (149, 604, 502, 750),
        "emdash": (48, 227, 1071, 333),
        "AE": (5, 0, 1100, 718),
        "ordfeminine": (92, 276, 464, 737),
        "Lslash": (34, 0, 611, 718),
        "Oslash": (35, -27, 894, 745),
        "OE": (99, -19, 1114, 737),
        "ordmasculine": (92, 276, 484, 737),
        "ae": (56, -14, 922, 546),
        "dotlessi": (69, 0, 322, 532),
        "lslash": (40, 0, 407, 718),
        "oslash": (22, -29, 701, 560),
        "oe": (83, -14, 976, 546),
        "germandbls": (69, -14, 657, 731),
        "onesuperior": (148, 283, 388, 710),
        "logicalnot": (105, 108, 633, 419),
        "mu": (22, -207, 658, 532),
        "trademark": (179, 306, 1109, 718),
        "Eth": (62, 0, 777, 718),
        "onehalf": (132, -19, 858, 710),
        "plusminus": (40, 0, 625, 506),
        "Thorn": (76, 0, 715, 718),
        "onequarter": (132, -19, 806, 710),
        "divide": (82, -42, 610, 548),
        "brokenbar": (80, -19, 353, 737),
        "degree": (175, 426, 467, 712),
        "thorn": (18, -208, 645, 718),
        "threequarters": (100, -19, 839, 710),
        "twosuperior": (69, 283, 448, 710),
        "registered": (56, -19, 834, 737),
        "minus": (82, 197, 610, 309),
        "eth": (82, -14, 670, 737),
        "multiply": (57, 1, 635, 505),
        "threesuperior": (92, 271, 440, 710),
        "copyright": (57, -19, 835, 737),
        "space": (0, 0, 0, 0),
        "Aacute": (20, 0, 750, 936),
        "Acircumflex": (20, 0, 706, 936),
        "Adieresis": (20, 0, 716, 915),
        "Agrave": (20, 0, 702, 936),
        "Aring": (20, 0, 702, 962),
        "Atilde": (20, 0, 741, 923),
        "Ccedilla": (107, -228, 788, 737),
        "Eacute": (76, 0, 757, 936),
        "Ecircumflex": (76, 0, 757, 936),
        "Edieresis": (76, 0, 757, 915),
        "Egrave": (76, 0, 757, 936),
        "Iacute": (64, 0, 528, 936),
        "Icircumflex": (64, 0, 484, 936),
        "Idieresis": (64, 0, 494, 915),
        "Igrave": (64, 0, 367, 936),
        "Ntilde": (69, 0, 807, 923),
        "Oacute": (108, -19, 823, 936),
        "Ocircumflex": (108, -19, 823, 936),
        "Odieresis": (108, -19, 823, 915),
        "Ograve": (108, -19, 823, 936),
        "Otilde": (108, -19, 823, 923),
        "Scaron": (81, -19, 717, 936),
        "Uacute": (116, -19, 804, 936),
        "Ucircumflex": (116, -19, 804, 936),
        "Udieresis": (116, -19, 804, 915),
        "Ugrave": (116, -19, 804, 936),
        "Yacute": (168, 0, 806, 936),
        "Ydieresis": (168, 0, 806, 915),
        "Zcaron": (25, 0, 737, 936),
        "aacute": (55, -14, 627, 750),
        "acircumflex": (55, -14, 583, 750),
        "adieresis": (55, -14, 594, 729),
        "agrave": (55, -14, 582, 750),
        "aring": (55, -14, 582, 776),
        "atilde": (55, -14, 619, 737),
        "ccedilla": (79, -228, 599, 546),
        "eacute": (71, -14, 627, 750),
        "ecircumflex": (71, -14, 592, 750),
        "edieresis": (71, -14, 594, 729),
        "egrave": (71, -14, 592, 750),
        "iacute": (69, 0, 488, 750),
        "icircumflex": (69, 0, 444, 750),
        "idieresis": (69, 0, 455, 729),
        "igrave": (69, 0, 326, 750),
        "ntilde": (65, 0, 646, 737),
        "oacute": (83, -14, 654, 750),
        "ocircumflex": (83, -14, 643, 750),
        "odieresis": (83, -14, 643, 729),
        "ograve": (83, -14, 643, 750),
        "otilde": (83, -14, 646, 737),
        "scaron": (63, -14, 614, 750),
        "uacute": (99, -14, 658, 750),
        "ucircumflex": (99, -14, 658, 750),
        "udieresis": (99, -14, 658, 729),
        "ugrave": (99, -14, 658, 750),
        "yacute": (42, -214, 652, 750),
        "ydieresis": (42, -214, 652, 729),
        "zcaron": (20, 0, 586, 750),
    },
    "Helvetica-Bold": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (90, 0, 244, 718),
        "quotedbl": (98, 447, 376, 718),
        "numbersign": (18, 0, 538, 698),
        "dollar": (30, -115, 523, 775),
        "percent": (28, -19, 861, 710),
        "ampersand": (54, -19, 701, 718),
        "quoteright": (69, 445, 209, 718),
        "parenleft": (35, -208, 314, 734),
        "parenright": (19, -208, 298, 734),
        "asterisk": (27, 387, 362, 718),
        "plus": (40, 0, 544, 506),
        "comma": (64, -168, 214, 146),
        "hyphen": (27, 215, 306, 345),
        "period": (64, 0, 214, 146),
        "slash": (-33, -19, 311, 737),
        "zero": (32, -19, 524, 710),
        "one": (69, 0, 378, 710),
        "two": (26, 0, 511, 710),
        "three": (27, -19, 516, 710),
        "four": (27, 0, 526, 710),
        "five": (27, -19, 516, 698),
        "six": (31, -19, 520, 710),
        "seven": (25, 0, 528, 698),
        "eight": (32, -19, 524, 710),
        "nine": (30, -19, 522, 710),
        "colon": (92, 0, 242, 512),
        "semicolon": (92, -168, 242, 512),
        "less": (38, -8, 546, 514),
        "equal": (40, 87, 544, 419),
        "greater": (38, -8, 546, 514),
        "question": (60, 0, 556, 727),
        "at": (118, -19, 856, 737),
        "A": (20, 0, 702, 718),
        "B": (76, 0, 669, 718),
        "C": (44, -19, 684, 737),
        "D": (76, 0, 685, 718),
        "E": (76, 0, 621, 718),
        "F": (76, 0, 587, 718),
        "G": (44, -19, 713, 737),
        "H": (71, 0, 651, 718),
        "I": (64, 0, 214, 718),
        "J": (22, -18, 484, 718),
        "K": (87, 0, 722, 718),
        "L": (76, 0, 583, 718),
        "M": (69, 0, 765, 718),
        "N": (69, 0, 654, 718),
        "O": (44, -19, 734, 737),
        "P": (76, 0, 627, 718),
        "Q": (44, -52, 737, 737),
        "R": (76, 0, 677, 718),
        "S": (39, -19, 629, 737),
        "T": (14, 0, 598, 718),
        "U": (72, -19, 651, 718),
        "V": (19, 0, 648, 718),
        "W": (16, 0, 929, 718),
        "X": (14, 0, 653, 718),
        "Y": (15, 0, 653, 718),
        "Z": (25, 0, 586, 718),
        "bracketleft": (63, -196, 309, 722),
        "backslash": (-33, -19, 311, 737),
        "bracketright": (24, -196, 270, 722),
        "asciicircum": (62, 323, 522, 698),
        "underscore": (0, -125, 556, -75),
        "quoteleft": (69, 454, 209, 727),
        "a": (29, -14, 527, 546),
        "b": (61, -14, 578, 718),
        "c": (34, -14, 524, 546),
        "d": (34, -14, 551, 718),
        "e": (23, -14, 528, 546),
        "f": (10, 0, 318, 727),
        "g": (40, -217, 553, 546),
        "h": (65, 0, 546, 718),
        "i": (69, 0, 209, 725),
        "j": (3, -214, 209, 725),
        "k": (69, 0, 562, 718),
        "l": (69, 0, 209, 718),
        "m": (64, 0, 826, 546),
        "n": (65, 0, 546, 546),
        "o": (34, -14, 578, 546),
        "p": (62, -207, 578, 546),
        "q": (34, -207, 552, 546),
        "r": (64, 0, 373, 546),
        "s": (30, -14, 519, 546),
        "t": (10, -6, 309, 676),
        "u": (66, -14, 545, 532),
        "v": (13, 0, 543, 532),
        "w": (10, 0, 769, 532),
        "x": (15, 0, 541, 532),
        "y": (10, -214, 539, 532),
        "z": (20, 0, 480, 532),
        "braceleft": (48, -196, 365, 722),
        "bar": (84, -19, 196, 737),
        "braceright": (24, -196, 341, 722),
        "asciitilde": (61, 163, 523, 343),
        "exclamdown": (90, -186, 244, 532),
        "cent": (34, -118, 524, 628),
        "sterling": (28, -16, 541, 718),
        "fraction": (-170, -19, 336, 710),
        "yen": (-9, 0, 565, 698),
        "florin": (-10, -210, 516, 737),
        "section": (34, -184, 522, 727),
        "currency": (-3, 76, 559, 636),
        "quotesingle": (70, 447, 168, 718),
        "quotedblleft": (64, 454, 436, 727),
        "guillemotleft": (88, 76, 468, 484),
        "guilsinglleft": (83, 76, 250, 484),
        "guilsinglright": (83, 76, 250, 484),
        "fi": (10, 0, 542, 727),
        "fl": (10, 0, 542, 727),
        "endash": (0, 227, 556, 333),
        "dagger": (36, -171, 520, 718),
        "daggerdbl": (36, -171, 520, 718),
        "periodcentered": (58, 172, 220, 334),
        "paragraph": (-8, -191, 539, 700),
        "bullet": (10, 194, 340, 524),
        "quotesinglbase": (69, -146, 209, 127),
        "quotedblbase": (64, -146, 436, 127),
        "quotedblright": (64, 445, 436, 718),
        "guillemotright": (88, 76, 468, 484),
        "ellipsis": (92, 0, 908, 146),
        "perthousand": (-3, -19, 1003, 710),
        "questiondown": (55, -195, 551, 532),
        "grave": (-23, 604, 225, 750),
        "acute": (108, 604, 356, 750),
        "circumflex": (-10, 604, 343, 750),
        "tilde": (-17, 610, 350, 737),
        "macron": (-6, 604, 339, 678),
        "breve": (-2, 604, 335, 750),
        "dotaccent": (104, 614, 230, 729),
        "dieresis": (6, 614, 327, 729),
        "ring": (59, 568, 275, 776),
        "cedilla": (6, -228, 245, 0),
        "hungarumlaut": (9, 604, 486, 750),
        "ogonek": (71, -228, 304, 0),
        "caron": (-10, 604, 343, 750),
        "emdash": (0, 227, 1000, 333),
        "AE": (5, 0, 954, 718),
        "ordfeminine": (22, 276, 347, 737),
        "Lslash": (-20, 0, 583, 718),
        "Oslash": (33, -27, 744, 745),
        "OE": (37, -19, 961, 737),
        "ordmasculine": (6, 276, 360, 737),
        "ae": (29, -14, 858, 546),
        "dotlessi": (69, 0, 209, 532),
        "lslash": (-18, 0, 296, 718),
        "oslash": (22, -29, 589, 560),
        "oe": (34, -14, 912, 546),
        "germandbls": (69, -14, 579, 731),
        "onesuperior": (26, 283, 237, 710),
        "logicalnot": (40, 108, 544, 419),
        "mu": (66, -207, 545, 532),
        "trademark": (44, 306, 956, 718),
        "Eth": (-5, 0, 685, 718),
        "onehalf": (26, -19, 794, 710),
        "plusminus": (40, 0, 544, 506),
        "Thorn": (76, 0, 627, 718),
        "onequarter": (26, -19, 766, 710),
        "divide": (40, -42, 544, 548),
        "brokenbar": (84, -19, 196, 737),
        "degree": (57, 426, 343, 712),
        "thorn": (62, -208, 578, 718),
        "threequarters": (16, -19, 799, 710),
        "twosuperior": (9, 283, 324, 710),
        "registered": (-11, -19, 748, 737),
        "minus": (40, 197, 544, 309),
        "eth": (34, -14, 578, 737),
        "multiply": (40, 1, 545, 505),
        "threesuperior": (8, 271, 326, 710),
        "copyright": (-11, -19, 749, 737),
        "space": (0, 0, 0, 0),
        "Aacute": (20, 0, 702, 936),
        "Acircumflex": (20, 0, 702, 936),
        "Adieresis": (20, 0, 702, 915),
        "Agrave": (20, 0, 702, 936),
        "Aring": (20, 0, 702, 962),
        "Atilde": (20, 0, 702, 923),
        "Ccedilla": (44, -228, 684, 737),
        "Eacute": (76, 0, 621, 936),
        "Ecircumflex": (76, 0, 621, 936),
        "Edieresis": (76, 0, 621, 915),
        "Egrave": (76, 0, 621, 936),
        "Iacute": (64, 0, 329, 936),
        "Icircumflex": (-37, 0, 316, 936),
        "Idieresis": (-21, 0, 300, 915),
        "Igrave": (-50, 0, 214, 936),
        "Ntilde": (69, 0, 654, 923),
        "Oacute": (44, -19, 734, 936),
        "Ocircumflex": (44, -19, 734, 936),
        "Odieresis": (44, -19, 734, 915),
        "Ograve": (44, -19, 734, 936),
        "Otilde": (44, -19, 734, 923),
        "Scaron": (39, -19, 629, 936),
        "Uacute": (72, -19, 651, 936),
        "Ucircumflex": (72, -19, 651, 936),
        "Udieresis": (72, -19, 651, 915),
        "Ugrave": (72, -19, 651, 936),
        "Yacute": (15, 0, 653, 936),
        "Ydieresis": (15, 0, 653, 915),
        "Zcaron": (25, 0, 586, 936),
        "aacute": (29, -14, 527, 750),
        "acircumflex": (29, -14, 527, 750),
        "adieresis": (29, -14, 527, 729),
        "agrave": (29, -14, 527, 750),
        "aring": (29, -14, 527, 776),
        "atilde": (29, -14, 527, 737),
        "ccedilla": (34, -228, 524, 546),
        "eacute": (23, -14, 528, 750),
        "ecircumflex": (23, -14, 528, 750),
        "edieresis": (23, -14, 528, 729),
        "egrave": (23, -14, 528, 750),
        "iacute": (69, 0, 329, 750),
        "icircumflex": (-37, 0, 316, 750),
        "idieresis": (-21, 0, 300, 729),
        "igrave": (-50, 0, 209, 750),
        "ntilde": (65, 0, 546, 737),
        "oacute": (34, -14, 578, 750),
        "ocircumflex": (34, -14, 578, 750),
        "odieresis": (34, -14, 578, 729),
        "ograve": (34, -14, 578, 750),
        "otilde": (34, -14, 578, 737),
        "scaron": (30, -14, 519, 750),
        "uacute": (66, -14, 545, 750),
        "ucircumflex": (66, -14, 545, 750),
        "udieresis": (66, -14, 545, 729),
        "ugrave": (66, -14, 545, 750),
        "yacute": (10, -214, 539, 750),
        "ydieresis": (10, -214, 539, 729),
        "zcaron": (20, 0, 480, 750),
    },
    "Helvetica-Oblique": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (90, 0, 340, 718),
        "quotedbl": (168, 463, 438, 718),
        "numbersign": (73, 0, 631, 688),
        "dollar": (69, -115, 617, 775),
        "percent": (147, -19, 888, 703),
        "ampersand": (78, -15, 647, 718),
        "quoteright": (151, 463, 310, 718),
        "parenleft": (108, -207, 454, 733),
        "parenright": (-9, -207, 336, 733),
        "asterisk": (165, 431, 475, 718),
        "plus": (85, 0, 606, 505),
        "comma": (56, -147, 214, 106),
        "hyphen": (93, 232, 357, 322),
        "period": (87, 0, 214, 106),
        "slash": (-21, -19, 452, 737),
        "zero": (94, -19, 607, 703),
        "one": (207, 0, 508, 703),
        "two": (26, 0, 617, 703),
        "three": (75, -19, 609, 703),
        "four": (61, 0, 576, 703),
        "five": (68, -19, 621, 688),
        "six": (91, -19, 615, 703),
        "seven": (137, 0, 669, 688),
        "eight": (74, -19, 606, 703),
        "nine": (83, -19, 608, 703),
        "colon": (87, 0, 301, 516),
        "semicolon": (56, -147, 301, 516),
        "less": (94, 11, 641, 495),
        "equal": (63, 115, 628, 390),
        "greater": (50, 11, 597, 495),
        "question": (161, 0, 610, 727),
        "at": (215, -19, 964, 737),
        "A": (14, 0, 654, 718),
        "B": (74, 0, 711, 718),
        "C": (108, -19, 781, 737),
        "D": (81, 0, 763, 718),
        "E": (86, 0, 762, 718),
        "F": (86, 0, 736, 718),
        "G": (111, -19, 798, 737),
        "H": (77, 0, 799, 718),
        "I": (91, 0, 341, 718),
        "J": (47, -19, 581, 718),
        "K": (76, 0, 808, 718),
        "L": (76, 0, 555, 718),
        "M": (73, 0, 914, 718),
        "N": (76, 0, 799, 718),
        "O": (105, -19, 825, 737),
        "P": (86, 0, 736, 718),
        "Q": (105, -56, 825, 737),
        "R": (88, 0, 773, 718),
        "S": (90, -19, 712, 737),
        "T": (148, 0, 750, 718),
        "U": (124, -19, 797, 718),
        "V": (173, 0, 800, 718),
        "W": (169, 0, 1081, 718),
        "X": (19, 0, 790, 718),
        "Y": (167, 0, 806, 718),
        "Z": (23, 0, 741, 718),
        "bracketleft": (21, -196, 403, 722),
        "backslash": (140, -19, 291, 737),
        "bracketright": (-14, -196, 368, 722),
        "asciicircum": (42, 264, 539, 688),
        "underscore": (-27, -125, 540, -75),
        "quoteleft": (165, 470, 323, 725),
        "a": (62, -15, 558, 538),
        "b": (58, -15, 584, 718),
        "c": (75, -15, 553, 538),
        "d": (84, -15, 652, 718),
        "e": (85, -15, 578, 538),
        "f": (86, 0, 416, 728),
        "g": (42, -220, 610, 538),
        "h": (65, 0, 572, 718),
        "i": (67, 0, 308, 718),
        "j": (-60, -210, 308, 718),
        "k": (67, 0, 600, 718),
        "l": (67, 0, 308, 718),
        "m": (65, 0, 851, 538),
        "n": (65, 0, 572, 538),
        "o": (84, -14, 584, 538),
        "p": (14, -207, 584, 538),
        "q": (84, -207, 605, 538),
        "r": (77, 0, 446, 538),
        "s": (64, -15, 529, 538),
        "t": (103, -7, 368, 669),
        "u": (95, -15, 600, 523),
        "v": (119, 0, 603, 523),
        "w": (125, 0, 820, 523),
        "x": (11, 0, 594, 523),
        "y": (15, -214, 600, 523),
        "z": (31, 0, 571, 523),
        "braceleft": (92, -196, 445, 722),
        "bar": (90, -19, 324, 737),
        "braceright": (0, -196, 354, 722),
        "asciitilde": (111, 180, 580, 326),
        "exclamdown": (77, -195, 326, 523),
        "cent": (96, -115, 583, 623),
        "sterling": (49, -16, 633, 718),
        "fraction": (-170, -19, 482, 703),
        "yen": (81, 0, 699, 688),
        "florin": (-52, -207, 654, 737),
        "section": (77, -191, 583, 737),
        "currency": (60, 99, 646, 603),
        "quotesingle": (157, 463, 285, 718),
        "quotedblleft": (138, 470, 461, 725),
        "guillemotleft": (146, 108, 554, 446),
        "guilsinglleft": (137, 108, 340, 446),
        "guilsinglright": (111, 108, 314, 446),
        "fi": (86, 0, 587, 728),
        "fl": (86, 0, 585, 728),
        "endash": (51, 240, 623, 313),
        "dagger": (135, -159, 622, 718),
        "daggerdbl": (52, -159, 623, 718),
        "periodcentered": (130, 190, 257, 315),
        "paragraph": (126, -173, 650, 718),
        "bullet": (91, 202, 412, 517),
        "quotesinglbase": (21, -149, 180, 106),
        "quotedblbase": (-6, -149, 318, 106),
        "quotedblright": (124, 463, 448, 718),
        "guillemotright": (120, 108, 528, 446),
        "ellipsis": (115, 0, 908, 106),
        "perthousand": (88, -19, 1029, 703),
        "questiondown": (85, -201, 534, 525),
        "grave": (170, 593, 337, 734),
        "acute": (248, 593, 475, 734),
        "circumflex": (147, 593, 438, 734),
        "tilde": (125, 606, 490, 722),
        "macron": (143, 627, 468, 684),
        "breve": (167, 595, 476, 731),
        "dotaccent": (249, 604, 362, 706),
        "dieresis": (168, 604, 443, 706),
        "ring": (214, 572, 402, 756),
        "cedilla": (2, -225, 232, 0),
        "hungarumlaut": (157, 593, 565, 734),
        "ogonek": (44, -225, 249, 0),
        "caron": (177, 593, 468, 734),
        "emdash": (51, 240, 1067, 313),
        "AE": (8, 0, 1097, 718),
        "ordfeminine": (100, 304, 448, 737),
        "Lslash": (41, 0, 555, 718),
        "Oslash": (43, -19, 890, 737),
        "OE": (99, -19, 1116, 737),
        "ordmasculine": (100, 304, 467, 737),
        "ae": (62, -15, 909, 538),
        "dotlessi": (95, 0, 294, 523),
        "lslash": (41, 0, 347, 718),
        "oslash": (29, -22, 647, 545),
        "oe": (84, -15, 964, 538),
        "germandbls": (67, -15, 657, 728),
        "onesuperior": (166, 281, 371, 703),
        "logicalnot": (106, 108, 628, 390),
        "mu": (24, -207, 600, 523),
        "trademark": (186, 306, 1056, 718),
        "Eth": (69, 0, 763, 718),
        "onehalf": (114, -19, 838, 703),
        "plusminus": (39, 0, 618, 506),
        "Thorn": (86, 0, 711, 718),
        "onequarter": (150, -19, 802, 703),
        "divide": (85, -19, 606, 524),
        "brokenbar": (90, -19, 324, 737),
        "degree": (169, 411, 467, 703),
        "thorn": (14, -207, 584, 718),
        "threequarters": (130, -19, 861, 703),
        "twosuperior": (64, 281, 448, 703),
        "registered": (55, -19, 837, 737),
        "minus": (85, 216, 606, 289),
        "eth": (82, -15, 617, 737),
        "multiply": (50, 0, 642, 506),
        "threesuperior": (90, 270, 436, 703),
        "copyright": (55, -19, 837, 737),
        "space": (0, 0, 0, 0),
        "Aacute": (14, 0, 683, 929),
        "Acircumflex": (14, 0, 654, 929),
        "Adieresis": (14, 0, 654, 901),
        "Agrave": (14, 0, 654, 929),
        "Aring": (14, 0, 654, 931),
        "Atilde": (14, 0, 699, 917),
        "Ccedilla": (108, -225, 781, 737),
        "Eacute": (86, 0, 762, 929),
        "Ecircumflex": (86, 0, 762, 929),
        "Edieresis": (86, 0, 762, 901),
        "Egrave": (86, 0, 762, 929),
        "Iacute": (91, 0, 489, 929),
        "Icircumflex": (91, 0, 452, 929),
        "Idieresis": (91, 0, 458, 901),
        "Igrave": (91, 0, 351, 929),
        "Ntilde": (76, 0, 799, 917),
        "Oacute": (105, -19, 825, 929),
        "Ocircumflex": (105, -19, 825, 929),
        "Odieresis": (105, -19, 825, 901),
        "Ograve": (105, -19, 825, 929),
        "Otilde": (105, -19, 825, 917),
        "Scaron": (90, -19, 712, 929),
        "Uacute": (124, -19, 797, 929),
        "Ucircumflex": (124, -19, 797, 929),
        "Udieresis": (124, -19, 797, 901),
        "Ugrave": (124, -19, 797, 929),
        "Yacute": (167, 0, 806, 929),
        "Ydieresis": (167, 0, 806, 901),
        "Zcaron": (23, 0, 741, 929),
        "aacute": (62, -15, 587, 734),
        "acircumflex": (62, -15, 558, 734),
        "adieresis": (62, -15, 558, 706),
        "agrave": (62, -15, 558, 734),
        "aring": (62, -15, 558, 756),
        "atilde": (62, -15, 592, 722),
        "ccedilla": (75, -225, 553, 538),
        "eacute": (85, -15, 587, 734),
        "ecircumflex": (85, -15, 578, 734),
        "edieresis": (85, -15, 578, 706),
        "egrave": (85, -15, 578, 734),
        "iacute": (95, 0, 448, 734),
        "icircumflex": (95, 0, 411, 734),
        "idieresis": (95, 0, 416, 706),
        "igrave": (95, 0, 310, 734),
        "ntilde": (65, 0, 592, 722),
        "oacute": (84, -14, 587, 734),
        "ocircumflex": (84, -14, 584, 734),
        "odieresis": (84, -14, 584, 706),
        "ograve": (84, -14, 584, 734),
        "otilde": (84, -14, 602, 722),
        "scaron": (64, -15, 552, 734),
        "uacute": (95, -15, 600, 734),
        "ucircumflex": (95, -15, 600, 734),
        "udieresis": (95, -15, 600, 706),
        "ugrave": (95, -15, 600, 734),
        "yacute": (15, -214, 600, 734),
        "ydieresis": (15, -214, 600, 706),
        "zcaron": (31, 0, 571, 734),
    },
    "Helvetica": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (90, 0, 187, 718),
        "quotedbl": (70, 463, 285, 718),
        "numbersign": (28, 0, 529, 688),
        "dollar": (32, -115, 520, 775),
        "percent": (39, -19, 850, 703),
        "ampersand": (44, -15, 645, 718),
        "quoteright": (53, 463, 157, 718),
        "parenleft": (68, -207, 299, 733),
        "parenright": (34, -207, 265, 733),
        "asterisk": (39, 431, 349, 718),
        "plus": (39, 0, 545, 505),
        "comma": (87, -147, 191, 106),
        "hyphen": (44, 232, 289, 322),
        "period": (87, 0, 191, 106),
        "slash": (-17, -19, 295, 737),
        "zero": (37, -19, 519, 703),
        "one": (101, 0, 359, 703),
        "two": (26, 0, 507, 703),
        "three": (34, -19, 522, 703),
        "four": (25, 0, 523, 703),
        "five": (32, -19, 514, 688),
        "six": (38, -19, 518, 703),
        "seven": (37, 0, 523, 688),
        "eight": (38, -19, 517, 703),
        "nine": (42, -19, 514, 703),
        "colon": (87, 0, 191, 516),
        "semicolon": (87, -147, 191, 516),
        "less": (48, 11, 536, 495),
        "equal": (39, 115, 545, 390),
        "greater": (48, 11, 536, 495),
        "question": (56, 0, 492, 727),
        "at": (147, -19, 868, 737),
        "A": (14, 0, 654, 718),
        "B": (74, 0, 627, 718),
        "C": (44, -19, 681, 737),
        "D": (81, 0, 674, 718),
        "E": (86, 0, 616, 718),
        "F": (86, 0, 583, 718),
        "G": (48, -19, 704, 737),
        "H": (77, 0, 646, 718),
        "I": (91, 0, 188, 718),
        "J": (17, -19, 428, 718),
        "K": (76, 0, 663, 718),
        "L": (76, 0, 537, 718),
        "M": (73, 0, 761, 718),
        "N": (76, 0, 646, 718),
        "O": (39, -19, 739, 737),
        "P": (86, 0, 622, 718),
        "Q": (39, -56, 739, 737),
        "R": (88, 0, 684, 718),
        "S": (49, -19, 620, 737),
        "T": (14, 0, 597, 718),
        "U": (79, -19, 644, 718),
        "V": (20, 0, 647, 718),
        "W": (16, 0, 928, 718),
        "X": (19, 0, 648, 718),
        "Y": (14, 0, 653, 718),
        "Z": (23, 0, 588, 718),
        "bracketleft": (63, -196, 250, 722),
        "backslash": (-17, -19, 295, 737),
        "bracketright": (28, -196, 215, 722),
        "asciicircum": (-14, 264, 483, 688),
        "underscore": (0, -125, 556, -75),
        "quoteleft": (65, 470, 169, 725),
        "a": (36, -15, 530, 538),
        "b": (58, -15, 517, 718),
        "c": (30, -15, 477, 538),
        "d": (35, -15, 499, 718),
        "e": (40, -15, 516, 538),
        "f": (14, 0, 262, 728),
        "g": (40, -220, 499, 538),
        "h": (65, 0, 491, 718),
        "i": (67, 0, 155, 718),
        "j": (-16, -210, 155, 718),
        "k": (67, 0, 501, 718),
        "l": (67, 0, 155, 718),
        "m": (65, 0, 769, 538),
        "n": (65, 0, 491, 538),
        "o": (35, -14, 521, 538),
        "p": (58, -207, 517, 538),
        "q": (35, -207, 494, 538),
        "r": (77, 0, 332, 538),
        "s": (32, -15, 464, 538),
        "t": (14, -7, 257, 669),
        "u": (68, -15, 489, 523),
        "v": (8, 0, 492, 523),
        "w": (14, 0, 709, 523),
        "x": (11, 0, 490, 523),
        "y": (11, -214, 489, 523),
        "z": (31, 0, 469, 523),
        "braceleft": (42, -196, 292, 722),
        "bar": (94, -19, 167, 737),
        "braceright": (42, -196, 292, 722),
        "asciitilde": (61, 180, 523, 326),
        "exclamdown": (118, -195, 215, 523),
        "cent": (51, -115, 513, 623),
        "sterling": (33, -16, 539, 718),
        "fraction": (-166, -19, 333, 703),
        "yen": (3, 0, 553, 688),
        "florin": (-11, -207, 501, 737),
        "section": (43, -191, 512, 737),
        "currency": (28, 99, 528, 603),
        "quotesingle": (59, 463, 132, 718),
        "quotedblleft": (38, 470, 307, 725),
        "guillemotleft": (97, 108, 459, 446),
        "guilsinglleft": (88, 108, 245, 446),
        "guilsinglright": (88, 108, 245, 446),
        "fi": (14, 0, 434, 728),
        "fl": (14, 0, 432, 728),
        "endash": (0, 240, 556, 313),
        "dagger": (43, -159, 514, 718),
        "daggerdbl": (43, -159, 514, 718),
        "periodcentered": (77, 190, 202, 315),
        "paragraph": (18, -173, 497, 718),
        "bullet": (18, 202, 333, 517),
        "quotesinglbase": (53, -149, 157, 106),
        "quotedblbase": (26, -149, 295, 106),
        "quotedblright": (26, 463, 295, 718),
        "guillemotright": (97, 108, 459, 446),
        "ellipsis": (115, 0, 885, 106),
        "perthousand": (7, -19, 994, 703),
        "questiondown": (91, -201, 527, 525),
        "grave": (14, 593, 211, 734),
        "acute": (122, 593, 319, 734),
        "circumflex": (21, 593, 312, 734),
        "tilde": (-4, 606, 337, 722),
        "macron": (10, 627, 323, 684),
        "breve": (13, 595, 321, 731),
        "dotaccent": (121, 604, 212, 706),
        "dieresis": (40, 604, 293, 706),
        "ring": (75, 572, 259, 756),
        "cedilla": (45, -225, 259, 0),
        "hungarumlaut": (31, 593, 409, 734),
        "ogonek": (73, -225, 287, 0),
        "caron": (21, 593, 312, 734),
        "emdash": (0, 240, 1000, 313),
        "AE": (8, 0, 951, 718),
        "ordfeminine": (24, 304, 346, 737),
        "Lslash": (-20, 0, 537, 718),
        "Oslash": (39, -19, 740, 737),
        "OE": (36, -19, 965, 737),
        "ordmasculine": (25, 304, 341, 737),
        "ae": (36, -15, 847, 538),
        "dotlessi": (95, 0, 183, 523),
        "lslash": (-20, 0, 242, 718),
        "oslash": (28, -22, 537, 545),
        "oe": (35, -15, 902, 538),
        "germandbls": (67, -15, 571, 728),
        "onesuperior": (43, 281, 222, 703),
        "logicalnot": (39, 108, 545, 390),
        "mu": (68, -207, 489, 523),
        "trademark": (46, 306, 903, 718),
        "Eth": (0, 0, 674, 718),
        "onehalf": (43, -19, 773, 703),
        "plusminus": (39, 0, 545, 506),
        "Thorn": (86, 0, 622, 718),
        "onequarter": (73, -19, 756, 703),
        "divide": (39, -19, 545, 524),
        "brokenbar": (94, -19, 167, 737),
        "degree": (54, 411, 346, 703),
        "thorn": (58, -207, 517, 718),
        "threequarters": (45, -19, 810, 703),
        "twosuperior": (4, 281, 323, 703),
        "registered": (-14, -19, 752, 737),
        "minus": (39, 216, 545, 289),
        "eth": (35, -15, 522, 737),
        "multiply": (39, 0, 545, 506),
        "threesuperior": (5, 270, 325, 703),
        "copyright": (-14, -19, 752, 737),
        "space": (0, 0, 0, 0),
        "Aacute": (14, 0, 654, 929),
        "Acircumflex": (14, 0, 654, 929),
        "Adieresis": (14, 0, 654, 901),
        "Agrave": (14, 0, 654, 929),
        "Aring": (14, 0, 654, 931),
        "Atilde": (14, 0, 654, 917),
        "Ccedilla": (44, -225, 681, 737),
        "Eacute": (86, 0, 616, 929),
        "Ecircumflex": (86, 0, 616, 929),
        "Edieresis": (86, 0, 616, 901),
        "Egrave": (86, 0, 616, 929),
        "Iacute": (91, 0, 292, 929),
        "Icircumflex": (-6, 0, 285, 929),
        "Idieresis": (13, 0, 266, 901),
        "Igrave": (-13, 0, 188, 929),
        "Ntilde": (76, 0, 646, 917),
        "Oacute": (39, -19, 739, 929),
        "Ocircumflex": (39, -19, 739, 929),
        "Odieresis": (39, -19, 739, 901),
        "Ograve": (39, -19, 739, 929),
        "Otilde": (39, -19, 739, 917),
        "Scaron": (49, -19, 620, 929),
        "Uacute": (79, -19, 644, 929),
        "Ucircumflex": (79, -19, 644, 929),
        "Udieresis": (79, -19, 644, 901),
        "Ugrave": (79, -19, 644, 929),
        "Yacute": (14, 0, 653, 929),
        "Ydieresis": (14, 0, 653, 901),
        "Zcaron": (23, 0, 588, 929),
        "aacute": (36, -15, 530, 734),
        "acircumflex": (36, -15, 530, 734),
        "adieresis": (36, -15, 530, 706),
        "agrave": (36, -15, 530, 734),
        "aring": (36, -15, 530, 756),
        "atilde": (36, -15, 530, 722),
        "ccedilla": (30, -225, 477, 538),
        "eacute": (40, -15, 516, 734),
        "ecircumflex": (40, -15, 516, 734),
        "edieresis": (40, -15, 516, 706),
        "egrave": (40, -15, 516, 734),
        "iacute": (95, 0, 292, 734),
        "icircumflex": (-6, 0, 285, 734),
        "idieresis": (13, 0, 266, 706),
        "igrave": (-13, 0, 184, 734),
        "ntilde": (65, 0, 491, 722),
        "oacute": (35, -14, 521, 734),
        "ocircumflex": (35, -14, 521, 734),
        "odieresis": (35, -14, 521, 706),
        "ograve": (35, -14, 521, 734),
        "otilde": (35, -14, 521, 722),
        "scaron": (32, -15, 464, 734),
        "uacute": (68, -15, 489, 734),
        "ucircumflex": (68, -15, 489, 734),
        "udieresis": (68, -15, 489, 706),
        "ugrave": (68, -15, 489, 734),
        "yacute": (11, -214, 489, 734),
        "ydieresis": (11, -214, 489, 706),
        "zcaron": (31, 0, 469, 734),
    },
    "Symbol": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (128, -17, 240, 672),
        "universal": (31, 0, 681, 705),
        "numbersign": (20, -16, 481, 673),
        "existential": (25, 0, 478, 707),
        "percent": (64, -35, 771, 655),
        "ampersand": (42, -17, 750, 661),
        "suchthat": (48, -17, 414, 499),
        "parenleft": (53, -191, 300, 673),
        "parenright": (30, -191, 277, 673),
        "asteriskmath": (65, 134, 427, 551),
        "plus": (10, 0, 539, 533),
        "comma": (56, -152, 194, 104),
        "minus": (11, 233, 535, 288),
        "period": (69, -17, 181, 95),
        "slash": (0, -18, 254, 646),
        "zero": (24, -17, 470, 685),
        "one": (117, 0, 390, 673),
        "two": (25, 0, 475, 685),
        "three": (39, -17, 435, 685),
        "four": (16, 0, 469, 685),
        "five": (29, -17, 443, 685),
        "six": (36, -17, 467, 685),
        "seven": (24, -16, 448, 673),
        "eight": (55, -17, 440, 684),
        "nine": (32, -18, 459, 684),
        "colon": (81, -17, 193, 460),
        "semicolon": (83, -152, 221, 460),
        "less": (26, 0, 523, 522),
        "equal": (11, 141, 537, 390),
        "greater": (26, 0, 523, 522),
        "question": (71, -17, 411, 686),
        "congruent": (11, 0, 537, 475),
        "Alpha": (4, 0, 684, 673),
        "Beta": (29, 0, 592, 673),
        "Chi": (-9, 0, 704, 673),
        "Delta": (6, 0, 608, 688),
        "Epsilon": (32, 0, 617, 673),
        "Phi": (26, 0, 741, 673),
        "Gamma": (24, 0, 609, 673),
        "Eta": (39, 0, 729, 673),
        "Iota": (32, 0, 316, 673),
        "theta1": (18, -17, 623, 689),
        "Kappa": (35, 0, 722, 673),
        "Lambda": (6, 0, 680, 688),
        "Mu": (28, 0, 887, 673),
        "Nu": (29, -8, 720, 673),
        "Omicron": (41, -17, 715, 685),
        "Pi": (25, 0, 745, 673),
        "Theta": (41, -17, 715, 685),
        "Rho": (28, 0, 562, 673),
        "Sigma": (5, 0, 589, 673),
        "Tau": (33, 0, 607, 673),
        "Upsilon": (-8, 0, 694, 673),
        "sigma1": (40, -233, 436, 500),
        "Omega": (34, 0, 736, 688),
        "Xi": (40, 0, 599, 673),
        "Psi": (15, 0, 781, 684),
        "Zeta": (44, 0, 636, 673),
        "bracketleft": (86, -155, 299, 674),
        "therefore": (163, 0, 701, 478),
        "bracketright": (33, -155, 246, 674),
        "perpendicular": (15, 0, 652, 674),
        "underscore": (-2, -252, 502, -206),
        "radicalex": (480, 881, 1090, 917),
        "alpha": (41, -18, 622, 500),
        "beta": (61, -223, 515, 740),
        "chi": (12, -231, 522, 499),
        "delta": (40, -18, 481, 739),
        "epsilon": (22, -19, 427, 501),
        "phi": (28, -224, 490, 671),
        "gamma": (6, -225, 484, 498),
        "eta": (0, -202, 527, 513),
        "iota": (0, -17, 301, 503),
        "phi1": (37, -224, 587, 499),
        "kappa": (33, 0, 558, 501),
        "lambda": (24, -17, 548, 739),
        "mu": (33, -223, 567, 500),
        "nu": (-9, -16, 474, 507),
        "omicron": (35, -18, 501, 498),
        "pi": (10, -19, 530, 487),
        "theta": (43, -17, 485, 690),
        "rho": (50, -230, 490, 498),
        "sigma": (31, -21, 588, 500),
        "tau": (10, -18, 418, 500),
        "upsilon": (7, -18, 535, 507),
        "omega1": (12, -17, 671, 583),
        "omega": (43, -17, 683, 500),
        "xi": (28, -224, 469, 765),
        "psi": (12, -228, 701, 500),
        "zeta": (60, -225, 467, 756),
        "braceleft": (58, -183, 397, 673),
        "bar": (65, -177, 135, 673),
        "braceright": (79, -183, 418, 673),
        "similar": (17, 203, 529, 307),
        "Upsilon1": (-1, 0, 610, 685),
        "minute": (27, 459, 228, 734),
        "lessequal": (29, 0, 526, 639),
        "fraction": (-180, -12, 340, 677),
        "infinity": (26, 125, 688, 404),
        "florin": (2, -193, 494, 686),
        "club": (86, -26, 660, 533),
        "diamond": (142, -36, 600, 550),
        "heart": (117, -33, 631, 532),
        "spade": (114, -36, 628, 548),
        "arrowboth": (24, -15, 1024, 511),
        "arrowleft": (32, -15, 942, 511),
        "arrowup": (45, 0, 571, 910),
        "arrowright": (49, -15, 959, 511),
        "arrowdown": (45, -22, 571, 888),
        "degree": (50, 385, 350, 685),
        "plusminus": (10, 0, 539, 645),
        "second": (20, 459, 413, 736),
        "greaterequal": (29, 0, 526, 639),
        "multiply": (17, 8, 533, 524),
        "proportional": (27, 124, 639, 404),
        "partialdiff": (27, -20, 462, 745),
        "bullet": (50, 113, 410, 473),
        "divide": (10, 71, 536, 456),
        "notequal": (15, -25, 540, 549),
        "equivalence": (14, 82, 538, 443),
        "approxequal": (14, 135, 527, 394),
        "ellipsis": (111, -17, 889, 95),
        "arrowvertex": (280, -120, 336, 1010),
        "arrowhorizex": (-60, 220, 1050, 276),
        "carriagereturn": (15, -16, 602, 629),
        "aleph": (175, -18, 661, 658),
        "Ifraktur": (10, -53, 578, 740),
        "Rfraktur": (26, -15, 759, 733),
        "weierstrass": (159, -211, 870, 573),
        "circlemultiply": (43, -17, 733, 673),
        "circleplus": (43, -15, 733, 675),
        "emptyset": (39, -24, 781, 719),
        "intersection": (40, 0, 732, 509),
        "union": (40, -17, 732, 492),
        "propersuperset": (20, 0, 673, 470),
        "reflexsuperset": (20, -125, 673, 470),
        "notsubset": (36, -70, 690, 540),
        "propersubset": (37, 0, 690, 470),
        "reflexsubset": (37, -125, 690, 470),
        "element": (45, 0, 505, 468),
        "notelement": (45, -58, 505, 555),
        "angle": (26, 0, 738, 673),
        "gradient": (36, -19, 681, 718),
        "registerserif": (50, -17, 740, 673),
        "copyrightserif": (51, -15, 741, 675),
        "trademarkserif": (18, 293, 855, 673),
        "product": (25, -101, 803, 751),
        "radical": (10, -38, 515, 917),
        "dotmath": (69, 210, 169, 310),
        "logicalnot": (15, 0, 680, 288),
        "logicaland": (23, 0, 583, 454),
        "logicalor": (30, 0, 578, 477),
        "arrowdblboth": (27, -20, 1023, 510),
        "arrowdblleft": (30, -15, 939, 513),
        "arrowdblup": (39, 2, 567, 911),
        "arrowdblright": (45, -20, 954, 508),
        "arrowdbldown": (44, -19, 572, 890),
        "lozenge": (18, 0, 466, 745),
        "angleleft": (25, -198, 306, 746),
        "registersans": (50, -20, 740, 670),
        "copyrightsans": (49, -15, 739, 675),
        "trademarksans": (5, 293, 725, 673),
        "summation": (14, -108, 695, 752),
        "parenlefttp": (40, -293, 436, 926),
        "parenleftex": (40, -85, 92, 925),
        "parenleftbt": (40, -293, 436, 926),
        "bracketlefttp": (0, -80, 341, 926),
        "bracketleftex": (0, -79, 55, 925),
        "bracketleftbt": (0, -80, 340, 926),
        "bracelefttp": (201, -75, 439, 926),
        "braceleftmid": (14, -85, 255, 935),
        "braceleftbt": (201, -70, 439, 926),
        "braceex": (201, -80, 255, 935),
        "angleright": (21, -198, 302, 746),
        "integral": (2, -107, 290, 915),
        "integraltp": (332, -83, 715, 921),
        "integralex": (332, -88, 415, 975),
        "integralbt": (39, -81, 415, 921),
        "parenrighttp": (54, -293, 450, 926),
        "parenrightex": (398, -85, 450, 925),
        "parenrightbt": (54, -293, 450, 926),
        "bracketrighttp": (22, -80, 360, 926),
        "bracketrightex": (305, -79, 360, 925),
        "bracketrightbt": (20, -80, 360, 926),
        "bracerighttp": (17, -75, 255, 926),
        "bracerightmid": (201, -85, 442, 935),
        "bracerightbt": (17, -70, 255, 926),
        "apple": (56, -2, 733, 808),
        "space": (0, 0, 0, 0),
    },
    "Times-BoldItalic": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (67, -13, 370, 684),
        "quotedbl": (136, 398, 536, 685),
        "numbersign": (-33, 0, 533, 700),
        "dollar": (-20, -100, 497, 733),
        "percent": (39, -10, 793, 692),
        "ampersand": (5, -19, 699, 682),
        "quoteright": (98, 369, 302, 685),
        "parenleft": (28, -179, 344, 685),
        "parenright": (-44, -179, 271, 685),
        "asterisk": (65, 249, 456, 685),
        "plus": (33, 0, 537, 506),
        "comma": (-60, -182, 144, 134),
        "hyphen": (2, 166, 271, 282),
        "period": (-9, -13, 139, 135),
        "slash": (-64, -18, 342, 685),
        "zero": (17, -14, 477, 683),
        "one": (5, 0, 419, 683),
        "two": (-27, 0, 446, 683),
        "three": (-15, -13, 450, 683),
        "four": (-15, 0, 503, 683),
        "five": (-11, -13, 487, 669),
        "six": (23, -15, 509, 679),
        "seven": (52, 0, 525, 669),
        "eight": (3, -13, 476, 683),
        "nine": (-12, -10, 475, 683),
        "colon": (23, -13, 264, 459),
        "semicolon": (-25, -183, 264, 459),
        "less": (31, -8, 539, 514),
        "equal": (33, 107, 537, 399),
        "greater": (31, -8, 539, 514),
        "question": (79, -13, 470, 684),
        "at": (63, -18, 770, 685),
        "A": (-67, 0, 593, 683),
        "B": (-24, 0, 624, 669),
        "C": (32, -18, 677, 685),
        "D": (-46, 0, 685, 669),
        "E": (-27, 0, 653, 669),
        "F": (-13, 0, 660, 669),
        "G": (21, -18, 706, 685),
        "H": (-24, 0, 799, 669),
        "I": (-32, 0, 406, 669),
        "J": (-46, -99, 524, 669),
        "K": (-21, 0, 702, 669),
        "L": (-22, 0, 590, 669),
        "M": (-29, -12, 917, 669),
        "N": (-27, -15, 748, 669),
        "O": (27, -18, 691, 685),
        "P": (-27, 0, 613, 669),
        "Q": (27, -208, 691, 685),
        "R": (-29, 0, 623, 669),
        "S": (2, -18, 526, 685),
        "T": (50, 0, 650, 669),
        "U": (67, -18, 744, 669),
        "V": (65, -18, 715, 669),
        "W": (65, -18, 940, 669),
        "X": (-24, 0, 694, 669),
        "Y": (73, 0, 659, 669),
        "Z": (-11, 0, 590, 669),
        "bracketleft": (-37, -159, 362, 674),
        "backslash": (-1, -18, 279, 685),
        "bracketright": (-56, -157, 343, 674),
        "asciicircum": (67, 304, 503, 669),
        "underscore": (0, -125, 500, -75),
        "quoteleft": (128, 369, 332, 685),
        "a": (-21, -14, 455, 462),
        "b": (-14, -13, 444, 699),
        "c": (-5, -13, 392, 462),
        "d": (-21, -13, 517, 699),
        "e": (5, -13, 398, 462),
        "f": (-169, -205, 446, 698),
        "g": (-52, -203, 478, 462),
        "h": (-13, -9, 498, 699),
        "i": (2, -9, 263, 684),
        "j": (-189, -207, 279, 684),
        "k": (-23, -8, 483, 699),
        "l": (2, -9, 290, 699),
        "m": (-14, -9, 722, 462),
        "n": (-6, -9, 493, 462),
        "o": (-3, -13, 441, 462),
        "p": (-120, -205, 446, 462),
        "q": (1, -205, 471, 462),
        "r": (-21, 0, 389, 462),
        "s": (-19, -13, 333, 462),
        "t": (-11, -9, 281, 594),
        "u": (15, -9, 492, 462),
        "v": (16, -13, 401, 462),
        "w": (16, -13, 614, 462),
        "x": (-46, -13, 469, 462),
        "y": (-94, -205, 392, 462),
        "z": (-43, -78, 368, 449),
        "braceleft": (5, -187, 436, 686),
        "bar": (66, -18, 154, 685),
        "braceright": (-129, -187, 302, 686),
        "asciitilde": (54, 173, 516, 333),
        "exclamdown": (19, -205, 322, 492),
        "cent": (42, -143, 439, 576),
        "sterling": (-32, -12, 510, 683),
        "fraction": (-169, -14, 324, 683),
        "yen": (33, 0, 628, 669),
        "florin": (-87, -156, 537, 707),
        "section": (36, -143, 459, 685),
        "currency": (-26, 34, 526, 586),
        "quotesingle": (128, 398, 268, 685),
        "quotedblleft": (53, 369, 513, 685),
        "guillemotleft": (12, 32, 468, 415),
        "guilsinglleft": (32, 32, 303, 415),
        "guilsinglright": (10, 32, 281, 415),
        "fi": (-188, -205, 514, 703),
        "fl": (-186, -205, 553, 704),
        "endash": (-40, 178, 477, 269),
        "dagger": (91, -145, 494, 685),
        "daggerdbl": (10, -139, 493, 685),
        "periodcentered": (51, 257, 199, 405),
        "paragraph": (-57, -193, 562, 669),
        "bullet": (0, 175, 350, 525),
        "quotesinglbase": (-5, -182, 199, 134),
        "quotedblbase": (-57, -182, 403, 134),
        "quotedblright": (53, 369, 513, 685),
        "guillemotright": (12, 32, 468, 415),
        "ellipsis": (40, -13, 852, 135),
        "perthousand": (7, -29, 996, 706),
        "questiondown": (30, -205, 421, 492),
        "grave": (85, 516, 297, 697),
        "acute": (139, 516, 379, 697),
        "circumflex": (40, 516, 367, 690),
        "tilde": (48, 536, 407, 655),
        "macron": (51, 553, 393, 623),
        "breve": (71, 516, 387, 678),
        "dotaccent": (163, 525, 293, 655),
        "dieresis": (55, 525, 397, 655),
        "ring": (127, 516, 340, 729),
        "cedilla": (-80, -218, 156, 5),
        "hungarumlaut": (69, 516, 498, 697),
        "ogonek": (-40, -173, 189, 44),
        "caron": (79, 516, 411, 690),
        "emdash": (-40, 178, 977, 269),
        "AE": (-64, 0, 918, 669),
        "ordfeminine": (16, 399, 330, 685),
        "Lslash": (-22, 0, 590, 669),
        "Oslash": (27, -125, 691, 764),
        "OE": (23, -8, 946, 677),
        "ordmasculine": (56, 400, 347, 685),
        "ae": (-5, -13, 673, 462),
        "dotlessi": (2, -9, 238, 462),
        "lslash": (-13, -9, 301, 699),
        "oslash": (-3, -119, 441, 560),
        "oe": (6, -13, 674, 462),
        "germandbls": (-200, -200, 473, 705),
        "onesuperior": (30, 274, 301, 683),
        "logicalnot": (51, 108, 555, 399),
        "mu": (-60, -207, 516, 449),
        "trademark": (32, 263, 968, 669),
        "Eth": (-31, 0, 700, 669),
        "onehalf": (-9, -14, 723, 683),
        "plusminus": (33, 0, 537, 506),
        "Thorn": (-27, 0, 573, 669),
        "onequarter": (7, -14, 721, 683),
        "divide": (33, -29, 537, 535),
        "brokenbar": (66, -18, 154, 685),
        "degree": (83, 397, 369, 683),
        "thorn": (-120, -205, 446, 699),
        "threequarters": (7, -14, 726, 683),
        "twosuperior": (2, 274, 313, 683),
        "registered": (30, -18, 718, 685),
        "minus": (51, 209, 555, 297),
        "eth": (-3, -13, 454, 699),
        "multiply": (48, 16, 522, 490),
        "threesuperior": (17, 265, 321, 683),
        "copyright": (30, -18, 718, 685),
        "space": (0, 0, 0, 0),
        "Aacute": (-67, 0, 593, 904),
        "Acircumflex": (-67, 0, 593, 897),
        "Adieresis": (-67, 0, 593, 862),
        "Agrave": (-67, 0, 593, 904),
        "Aring": (-67, 0, 593, 921),
        "Atilde": (-67, 0, 593, 862),
        "Ccedilla": (32, -218, 677, 685),
        "Eacute": (-27, 0, 653, 904),
        "Ecircumflex": (-27, 0, 653, 897),
        "Edieresis": (-27, 0, 653, 862),
        "Egrave": (-27, 0, 653, 904),
        "Iacute": (-32, 0, 412, 904),
        "Icircumflex": (-32, 0, 420, 897),
        "Idieresis": (-32, 0, 445, 862),
        "Igrave": (-32, 0, 406, 904),
        "Ntilde": (-27, -15, 748, 862),
        "Oacute": (27, -18, 691, 904),
        "Ocircumflex": (27, -18, 691, 897),
        "Odieresis": (27, -18, 691, 862),
        "Ograve": (27, -18, 691, 904),
        "Otilde": (27, -18, 691, 862),
        "Scaron": (2, -18, 526, 897),
        "Uacute": (67, -18, 744, 904),
        "Ucircumflex": (67, -18, 744, 897),
        "Udieresis": (67, -18, 744, 862),
        "Ugrave": (67, -18, 744, 904),
        "Yacute": (73, 0, 659, 904),
        "Ydieresis": (73, 0, 659, 862),
        "Zcaron": (-11, 0, 590, 897),
        "aacute": (-21, -14, 463, 697),
        "acircumflex": (-21, -14, 455, 690),
        "adieresis": (-21, -14, 471, 655),
        "agrave": (-21, -14, 455, 697),
        "aring": (-21, -14, 455, 729),
        "atilde": (-21, -14, 491, 655),
        "ccedilla": (-24, -218, 392, 462),
        "eacute": (5, -13, 435, 697),
        "ecircumflex": (5, -13, 423, 690),
        "edieresis": (5, -13, 443, 655),
        "egrave": (5, -13, 398, 697),
        "iacute": (2, -9, 352, 697),
        "icircumflex": (-2, -9, 325, 690),
        "idieresis": (2, -9, 360, 655),
        "igrave": (2, -9, 260, 697),
        "ntilde": (-6, -9, 504, 655),
        "oacute": (-3, -13, 463, 697),
        "ocircumflex": (-3, -13, 451, 690),
        "odieresis": (-3, -13, 466, 655),
        "ograve": (-3, -13, 441, 697),
        "otilde": (-3, -13, 491, 655),
        "scaron": (-19, -13, 439, 690),
        "uacute": (15, -9, 492, 697),
        "ucircumflex": (15, -9, 492, 690),
        "udieresis": (15, -9, 494, 655),
        "ugrave": (15, -9, 492, 697),
        "yacute": (-94, -205, 435, 697),
        "ydieresis": (-94, -205, 438, 655),
        "zcaron": (-43, -78, 424, 690),
    },
    "Times-Bold": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (81, -13, 251, 691),
        "quotedbl": (83, 404, 472, 691),
        "numbersign": (4, 0, 496, 700),
        "dollar": (29, -99, 472, 750),
        "percent": (124, -14, 877, 692),
        "ampersand": (62, -16, 787, 691),
        "quoteright": (79, 356, 263, 691),
        "parenleft": (46, -168, 306, 694),
        "parenright": (27, -168, 287, 694),
        "asterisk": (56, 255, 447, 691),
        "plus": (33, 0, 537, 506),
        "comma": (39, -180, 223, 155),
        "hyphen": (44, 171, 287, 287),
        "period": (41, -13, 210, 156),
        "slash": (-24, -19, 302, 691),
        "zero": (24, -13, 476, 688),
        "one": (65, 0, 442, 688),
        "two": (17, 0, 478, 688),
        "three": (16, -14, 468, 688),
        "four": (19, 0, 475, 688),
        "five": (22, -8, 470, 676),
        "six": (28, -13, 475, 688),
        "seven": (17, 0, 477, 676),
        "eight": (28, -13, 472, 688),
        "nine": (26, -13, 473, 688),
        "colon": (82, -13, 251, 472),
        "semicolon": (82, -180, 266, 472),
        "less": (31, -8, 539, 514),
        "equal": (33, 107, 537, 399),
        "greater": (31, -8, 539, 514),
        "question": (57, -13, 445, 689),
        "at": (108, -19, 822, 691),
        "A": (9, 0, 689, 690),
        "B": (16, 0, 619, 676),
        "C": (49, -19, 687, 691),
        "D": (14, 0, 690, 676),
        "E": (16, 0, 641, 676),
        "F": (16, 0, 583, 676),
        "G": (37, -19, 755, 691),
        "H": (21, 0, 759, 676),
        "I": (20, 0, 370, 676),
        "J": (3, -96, 479, 676),
        "K": (30, 0, 769, 676),
        "L": (19, 0, 638, 676),
        "M": (14, 0, 921, 676),
        "N": (16, -18, 701, 676),
        "O": (35, -19, 743, 691),
        "P": (16, 0, 600, 676),
        "Q": (35, -176, 743, 691),
        "R": (26, 0, 715, 676),
        "S": (35, -19, 513, 692),
        "T": (31, 0, 636, 676),
        "U": (16, -19, 701, 676),
        "V": (16, -18, 701, 676),
        "W": (19, -15, 981, 676),
        "X": (16, 0, 699, 676),
        "Y": (15, 0, 699, 676),
        "Z": (28, 0, 634, 676),
        "bracketleft": (67, -149, 301, 678),
        "backslash": (-25, -19, 303, 691),
        "bracketright": (32, -149, 266, 678),
        "asciicircum": (73, 311, 509, 676),
        "underscore": (0, -125, 500, -75),
        "quoteleft": (70, 356, 254, 691),
        "a": (25, -14, 488, 473),
        "b": (17, -14, 521, 676),
        "c": (25, -14, 430, 473),
        "d": (25, -14, 534, 676),
        "e": (25, -14, 426, 473),
        "f": (14, 0, 389, 691),
        "g": (28, -206, 483, 473),
        "h": (16, 0, 534, 676),
        "i": (16, 0, 255, 691),
        "j": (-57, -203, 263, 691),
        "k": (22, 0, 543, 676),
        "l": (16, 0, 255, 676),
        "m": (16, 0, 814, 473),
        "n": (21, 0, 539, 473),
        "o": (25, -14, 476, 473),
        "p": (19, -205, 524, 473),
        "q": (34, -205, 536, 473),
        "r": (29, 0, 434, 473),
        "s": (25, -14, 361, 473),
        "t": (20, -12, 332, 630),
        "u": (16, -14, 537, 461),
        "v": (21, -14, 485, 461),
        "w": (23, -14, 707, 461),
        "x": (12, 0, 484, 461),
        "y": (16, -205, 480, 461),
        "z": (21, 0, 420, 461),
        "braceleft": (22, -175, 340, 698),
        "bar": (66, -19, 154, 691),
        "braceright": (54, -175, 372, 698),
        "asciitilde": (29, 173, 491, 333),
        "exclamdown": (82, -203, 252, 501),
        "cent": (53, -140, 458, 588),
        "sterling": (21, -14, 477, 684),
        "fraction": (-168, -12, 329, 688),
        "yen": (-64, 0, 547, 676),
        "florin": (0, -155, 498, 706),
        "section": (57, -132, 443, 691),
        "currency": (-26, 61, 526, 613),
        "quotesingle": (75, 404, 204, 691),
        "quotedblleft": (32, 356, 486, 691),
        "guillemotleft": (23, 36, 473, 415),
        "guilsinglleft": (51, 36, 305, 415),
        "guilsinglright": (28, 36, 282, 415),
        "fi": (14, 0, 536, 691),
        "fl": (14, 0, 536, 691),
        "endash": (0, 181, 500, 271),
        "dagger": (47, -134, 453, 691),
        "daggerdbl": (45, -132, 456, 691),
        "periodcentered": (41, 248, 210, 417),
        "paragraph": (0, -186, 519, 676),
        "bullet": (35, 198, 315, 478),
        "quotesinglbase": (79, -180, 263, 155),
        "quotedblbase": (14, -180, 468, 155),
        "quotedblright": (14, 356, 468, 691),
        "guillemotright": (27, 36, 477, 415),
        "ellipsis": (82, -13, 917, 156),
        "perthousand": (7, -29, 995, 706),
        "questiondown": (55, -201, 443, 501),
        "grave": (8, 528, 246, 713),
        "acute": (86, 528, 324, 713),
        "circumflex": (-2, 528, 335, 704),
        "tilde": (-16, 547, 349, 674),
        "macron": (1, 565, 331, 637),
        "breve": (15, 528, 318, 691),
        "dotaccent": (103, 537, 230, 667),
        "dieresis": (-2, 537, 335, 667),
        "ring": (60, 527, 273, 740),
        "cedilla": (68, -218, 294, 0),
        "hungarumlaut": (-13, 528, 425, 713),
        "ogonek": (90, -173, 319, 44),
        "caron": (-2, 528, 335, 704),
        "emdash": (0, 181, 1000, 271),
        "AE": (4, 0, 951, 676),
        "ordfeminine": (-1, 397, 301, 688),
        "Lslash": (19, 0, 638, 676),
        "Oslash": (35, -74, 743, 737),
        "OE": (22, -5, 981, 684),
        "ordmasculine": (18, 397, 312, 688),
        "ae": (33, -14, 693, 473),
        "dotlessi": (16, 0, 255, 461),
        "lslash": (-22, 0, 303, 676),
        "oslash": (25, -92, 476, 549),
        "oe": (22, -14, 696, 473),
        "germandbls": (19, -12, 517, 691),
        "onesuperior": (28, 275, 273, 688),
        "logicalnot": (33, 108, 537, 399),
        "mu": (33, -206, 536, 461),
        "trademark": (24, 271, 977, 676),
        "Eth": (6, 0, 690, 676),
        "onehalf": (-7, -12, 775, 688),
        "plusminus": (33, 0, 537, 506),
        "Thorn": (16, 0, 600, 676),
        "onequarter": (28, -12, 743, 688),
        "divide": (33, -31, 537, 537),
        "brokenbar": (66, -19, 154, 691),
        "degree": (57, 402, 343, 688),
        "thorn": (19, -205, 524, 676),
        "threequarters": (23, -12, 733, 688),
        "twosuperior": (0, 275, 300, 688),
        "registered": (26, -19, 721, 691),
        "minus": (33, 209, 537, 297),
        "eth": (25, -14, 476, 691),
        "multiply": (48, 16, 522, 490),
        "threesuperior": (3, 268, 297, 688),
        "copyright": (26, -19, 721, 691),
        "space": (0, 0, 0, 0),
        "Aacute": (9, 0, 689, 923),
        "Acircumflex": (9, 0, 689, 914),
        "Adieresis": (9, 0, 689, 877),
        "Agrave": (9, 0, 689, 923),
        "Aring": (9, 0, 689, 935),
        "Atilde": (9, 0, 689, 884),
        "Ccedilla": (49, -218, 687, 691),
        "Eacute": (16, 0, 641, 923),
        "Ecircumflex": (16, 0, 641, 914),
        "Edieresis": (16, 0, 641, 877),
        "Egrave": (16, 0, 641, 923),
        "Iacute": (20, 0, 370, 923),
        "Icircumflex": (20, 0, 370, 914),
        "Idieresis": (20, 0, 370, 877),
        "Igrave": (20, 0, 370, 923),
        "Ntilde": (16, -18, 701, 884),
        "Oacute": (35, -19, 743, 923),
        "Ocircumflex": (35, -19, 743, 914),
        "Odieresis": (35, -19, 743, 877),
        "Ograve": (35, -19, 743, 923),
        "Otilde": (35, -19, 743, 884),
        "Scaron": (35, -19, 513, 914),
        "Uacute": (16, -19, 701, 923),
        "Ucircumflex": (16, -19, 701, 914),
        "Udieresis": (16, -19, 701, 877),
        "Ugrave": (16, -19, 701, 923),
        "Yacute": (15, 0, 699, 928),
        "Ydieresis": (15, 0, 699, 877),
        "Zcaron": (28, 0, 634, 914),
        "aacute": (25, -14, 488, 713),
        "acircumflex": (25, -14, 488, 704),
        "adieresis": (25, -14, 488, 667),
        "agrave": (25, -14, 488, 713),
        "aring": (25, -14, 488, 740),
        "atilde": (25, -14, 488, 674),
        "ccedilla": (25, -218, 430, 473),
        "eacute": (25, -14, 426, 713),
        "ecircumflex": (25, -14, 426, 704),
        "edieresis": (25, -14, 426, 667),
        "egrave": (25, -14, 426, 713),
        "iacute": (16, 0, 290, 713),
        "icircumflex": (-36, 0, 301, 704),
        "idieresis": (-36, 0, 301, 667),
        "igrave": (-26, 0, 255, 713),
        "ntilde": (21, 0, 539, 674),
        "oacute": (25, -14, 476, 713),
        "ocircumflex": (25, -14, 476, 704),
        "odieresis": (25, -14, 476, 667),
        "ograve": (25, -14, 476, 713),
        "otilde": (25, -14, 476, 674),
        "scaron": (25, -14, 363, 704),
        "uacute": (16, -14, 537, 713),
        "ucircumflex": (16, -14, 537, 704),
        "udieresis": (16, -14, 537, 667),
        "ugrave": (16, -14, 537, 713),
        "yacute": (16, -205, 480, 713),
        "ydieresis": (16, -205, 480, 667),
        "zcaron": (21, 0, 420, 704),
    },
    "Times-Italic": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (39, -11, 302, 667),
        "quotedbl": (144, 421, 432, 666),
        "numbersign": (2, 0, 540, 676),
        "dollar": (31, -89, 497, 731),
        "percent": (79, -13, 790, 676),
        "ampersand": (76, -18, 723, 666),
        "quoteright": (151, 436, 290, 666),
        "parenleft": (42, -181, 315, 669),
        "parenright": (16, -180, 289, 669),
        "asterisk": (128, 255, 492, 666),
        "plus": (86, 0, 590, 506),
        "comma": (-4, -129, 135, 101),
        "hyphen": (49, 192, 282, 255),
        "period": (27, -11, 138, 100),
        "slash": (-65, -18, 386, 666),
        "zero": (32, -7, 497, 676),
        "one": (49, 0, 409, 676),
        "two": (12, 0, 452, 676),
        "three": (15, -7, 465, 676),
        "four": (1, 0, 479, 676),
        "five": (15, -7, 491, 666),
        "six": (30, -7, 521, 686),
        "seven": (75, -8, 537, 666),
        "eight": (30, -7, 493, 676),
        "nine": (23, -17, 492, 676),
        "colon": (50, -11, 261, 441),
        "semicolon": (27, -129, 261, 441),
        "less": (84, -8, 592, 514),
        "equal": (86, 120, 590, 386),
        "greater": (84, -8, 592, 514),
        "question": (132, -12, 472, 664),
        "at": (118, -18, 806, 666),
        "A": (-51, 0, 564, 668),
        "B": (-8, 0, 588, 653),
        "C": (66, -18, 689, 666),
        "D": (-8, 0, 700, 653),
        "E": (-1, 0, 634, 653),
        "F": (8, 0, 645, 653),
        "G": (52, -18, 722, 666),
        "H": (-8, 0, 767, 653),
        "I": (-8, 0, 384, 653),
        "J": (-6, -18, 491, 653),
        "K": (7, 0, 722, 653),
        "L": (-8, 0, 559, 653),
        "M": (-18, 0, 873, 653),
        "N": (-20, -15, 727, 653),
        "O": (60, -18, 699, 666),
        "P": (0, 0, 605, 653),
        "Q": (59, -182, 699, 666),
        "R": (-13, 0, 588, 653),
        "S": (17, -18, 508, 667),
        "T": (59, 0, 633, 653),
        "U": (102, -18, 765, 653),
        "V": (76, -18, 688, 653),
        "W": (71, -18, 906, 653),
        "X": (-29, 0, 655, 653),
        "Y": (78, 0, 633, 653),
        "Z": (-6, 0, 606, 653),
        "bracketleft": (21, -153, 391, 663),
        "backslash": (-41, -18, 319, 666),
        "bracketright": (12, -153, 382, 663),
        "asciicircum": (0, 301, 422, 666),
        "underscore": (0, -125, 500, -75),
        "quoteleft": (171, 436, 310, 666),
        "a": (17, -11, 476, 441),
        "b": (23, -11, 473, 683),
        "c": (30, -11, 425, 441),
        "d": (15, -13, 527, 683),
        "e": (31, -11, 412, 441),
        "f": (-147, -207, 424, 678),
        "g": (8, -206, 472, 441),
        "h": (19, -9, 478, 683),
        "i": (49, -11, 264, 654),
        "j": (-124, -207, 276, 654),
        "k": (14, -11, 461, 683),
        "l": (41, -11, 279, 683),
        "m": (12, -9, 704, 441),
        "n": (14, -9, 474, 441),
        "o": (27, -11, 468, 441),
        "p": (-75, -205, 469, 441),
        "q": (25, -209, 483, 441),
        "r": (45, 0, 412, 441),
        "s": (16, -13, 366, 442),
        "t": (37, -11, 296, 546),
        "u": (42, -11, 475, 441),
        "v": (21, -18, 426, 441),
        "w": (16, -18, 648, 441),
        "x": (-27, -11, 447, 441),
        "y": (-24, -206, 426, 441),
        "z": (-2, -81, 380, 428),
        "braceleft": (51, -177, 407, 687),
        "bar": (105, -18, 171, 666),
        "braceright": (-7, -177, 349, 687),
        "asciitilde": (40, 183, 502, 323),
        "exclamdown": (59, -205, 322, 473),
        "cent": (77, -143, 472, 560),
        "sterling": (10, -6, 517, 670),
        "fraction": (-169, -10, 337, 676),
        "yen": (27, 0, 603, 653),
        "florin": (25, -182, 507, 682),
        "section": (53, -162, 461, 666),
        "currency": (-22, 53, 522, 597),
        "quotesingle": (132, 421, 241, 666),
        "quotedblleft": (166, 436, 514, 666),
        "guillemotleft": (53, 37, 445, 403),
        "guilsinglleft": (51, 37, 281, 403),
        "guilsinglright": (52, 37, 282, 403),
        "fi": (-141, -207, 481, 681),
        "fl": (-141, -204, 517, 682),
        "endash": (-6, 197, 505, 243),
        "dagger": (101, -159, 488, 666),
        "daggerdbl": (22, -143, 491, 666),
        "periodcentered": (70, 199, 181, 310),
        "paragraph": (55, -123, 616, 653),
        "bullet": (40, 191, 310, 461),
        "quotesinglbase": (44, -129, 183, 101),
        "quotedblbase": (57, -129, 405, 101),
        "quotedblright": (151, 436, 499, 666),
        "guillemotright": (55, 37, 447, 403),
        "ellipsis": (57, -11, 762, 100),
        "perthousand": (25, -19, 1010, 706),
        "questiondown": (28, -205, 368, 471),
        "grave": (121, 492, 311, 664),
        "acute": (180, 494, 403, 664),
        "circumflex": (91, 492, 385, 661),
        "tilde": (100, 517, 427, 624),
        "macron": (99, 532, 411, 583),
        "breve": (117, 492, 418, 650),
        "dotaccent": (207, 508, 305, 606),
        "dieresis": (107, 508, 405, 606),
        "ring": (155, 492, 355, 691),
        "cedilla": (-30, -217, 182, 0),
        "hungarumlaut": (93, 494, 486, 664),
        "ogonek": (-20, -169, 200, 40),
        "caron": (121, 492, 426, 661),
        "emdash": (-6, 197, 894, 243),
        "AE": (-27, 0, 911, 653),
        "ordfeminine": (42, 406, 352, 676),
        "Lslash": (-8, 0, 559, 653),
        "Oslash": (60, -105, 699, 722),
        "OE": (49, -8, 964, 666),
        "ordmasculine": (67, 406, 362, 676),
        "ae": (23, -11, 640, 441),
        "dotlessi": (49, -11, 235, 441),
        "lslash": (37, -11, 307, 683),
        "oslash": (28, -135, 469, 554),
        "oe": (20, -12, 646, 441),
        "germandbls": (-168, -207, 493, 679),
        "onesuperior": (43, 271, 283, 676),
        "logicalnot": (86, 108, 590, 386),
        "mu": (-30, -209, 497, 428),
        "trademark": (30, 247, 957, 653),
        "Eth": (-8, 0, 700, 653),
        "onehalf": (34, -10, 749, 676),
        "plusminus": (86, 0, 590, 506),
        "Thorn": (0, 0, 569, 653),
        "onequarter": (33, -10, 736, 676),
        "divide": (86, -11, 590, 517),
        "brokenbar": (105, -18, 171, 666),
        "degree": (101, 390, 387, 676),
        "thorn": (-75, -205, 469, 683),
        "threequarters": (23, -10, 736, 676),
        "twosuperior": (33, 271, 324, 676),
        "registered": (41, -18, 719, 666),
        "minus": (86, 220, 590, 286),
        "eth": (27, -11, 482, 683),
        "multiply": (93, 8, 582, 497),
        "threesuperior": (43, 268, 339, 676),
        "copyright": (41, -18, 719, 666),
        "space": (0, 0, 0, 0),
        "Aacute": (-51, 0, 564, 876),
        "Acircumflex": (-51, 0, 564, 873),
        "Adieresis": (-51, 0, 564, 818),
        "Agrave": (-51, 0, 564, 876),
        "Aring": (-51, 0, 564, 883),
        "Atilde": (-51, 0, 566, 836),
        "Ccedilla": (66, -217, 689, 666),
        "Eacute": (-1, 0, 634, 876),
        "Ecircumflex": (-1, 0, 634, 873),
        "Edieresis": (-1, 0, 634, 818),
        "Egrave": (-1, 0, 634, 876),
        "Iacute": (-8, 0, 413, 876),
        "Icircumflex": (-8, 0, 425, 873),
        "Idieresis": (-8, 0, 435, 818),
        "Igrave": (-8, 0, 384, 876),
        "Ntilde": (-20, -15, 727, 836),
        "Oacute": (60, -18, 699, 876),
        "Ocircumflex": (60, -18, 699, 873),
        "Odieresis": (60, -18, 699, 818),
        "Ograve": (60, -18, 699, 876),
        "Otilde": (60, -18, 699, 836),
        "Scaron": (17, -18, 520, 873),
        "Uacute": (102, -18, 765, 876),
        "Ucircumflex": (102, -18, 765, 873),
        "Udieresis": (102, -18, 765, 818),
        "Ugrave": (102, -18, 765, 876),
        "Yacute": (78, 0, 633, 876),
        "Ydieresis": (78, 0, 633, 818),
        "Zcaron": (-6, 0, 606, 873),
        "aacute": (17, -11, 487, 664),
        "acircumflex": (17, -11, 476, 661),
        "adieresis": (17, -11, 489, 606),
        "agrave": (17, -11, 476, 664),
        "aring": (17, -11, 476, 691),
        "atilde": (17, -11, 511, 624),
        "ccedilla": (26, -217, 425, 441),
        "eacute": (31, -11, 459, 664),
        "ecircumflex": (31, -11, 441, 661),
        "edieresis": (31, -11, 451, 606),
        "egrave": (31, -11, 412, 664),
        "iacute": (49, -11, 356, 664),
        "icircumflex": (34, -11, 328, 661),
        "idieresis": (49, -11, 353, 606),
        "igrave": (49, -11, 284, 664),
        "ntilde": (14, -9, 476, 624),
        "oacute": (27, -11, 487, 664),
        "ocircumflex": (27, -11, 468, 661),
        "odieresis": (27, -11, 489, 606),
        "ograve": (27, -11, 468, 664),
        "otilde": (27, -11, 496, 624),
        "scaron": (16, -13, 454, 661),
        "uacute": (42, -11, 477, 664),
        "ucircumflex": (42, -11, 475, 661),
        "udieresis": (42, -11, 479, 606),
        "ugrave": (42, -11, 475, 664),
        "yacute": (-24, -206, 459, 664),
        "ydieresis": (-24, -206, 441, 606),
        "zcaron": (-2, -81, 434, 661),
    },
    "Times-Roman": {
        ".notdef": (0, 0, 0, 0),
        "exclam": (130, -9, 238, 676),
        "quotedbl": (77, 431, 331, 676),
        "numbersign": (5, 0, 496, 662),
        "dollar": (44, -87, 457, 727),
        "percent": (61, -13, 772, 676),
        "ampersand": (42, -13, 750, 676),
        "quoteright": (79, 433, 218, 676),
        "parenleft": (48, -177, 304, 676),
        "parenright": (29, -177, 285, 676),
        "asterisk": (69, 265, 432, 676),
        "plus": (30, 0, 534, 506),
        "comma": (56, -141, 195, 102),
        "hyphen": (39, 194, 285, 257),
        "period": (70, -11, 181, 100),
        "slash": (-9, -14, 287, 676),
        "zero": (24, -14, 476, 676),
        "one": (111, 0, 394, 676),
        "two": (30, 0, 475, 676),
        "three": (43, -14, 431, 676),
        "four": (12, 0, 472, 676),
        "five": (32, -14, 438, 688),
        "six": (34, -14, 468, 684),
        "seven": (20, -8, 449, 662),
        "eight": (56, -14, 445, 676),
        "nine": (30, -22, 459, 676),
        "colon": (81, -11, 192, 459),
        "semicolon": (80, -141, 219, 459),
        "less": (28, -8, 536, 514),
        "equal": (30, 120, 534, 386),
        "greater": (28, -8, 536, 514),
        "question": (68, -8, 414, 676),
        "at": (116, -14, 809, 676),
        "A": (15, 0, 706, 674),
        "B": (17, 0, 593, 662),
        "C": (28, -14, 633, 676),
        "D": (16, 0, 685, 662),
        "E": (12, 0, 597, 662),
        "F": (12, 0, 546, 662),
        "G": (32, -14, 709, 676),
        "H": (19, 0, 702, 662),
        "I": (18, 0, 315, 662),
        "J": (10, -14, 370, 662),
        "K": (34, 0, 723, 662),
        "L": (12, 0, 598, 662),
        "M": (12, 0, 863, 662),
        "N": (12, -11, 707, 662),
        "O": (34, -14, 688, 676),
        "P": (16, 0, 542, 662),
        "Q": (34, -178, 701, 676),
        "R": (17, 0, 659, 662),
        "S": (42, -14, 491, 676),
        "T": (17, 0, 593, 662),
        "U": (14, -14, 705, 662),
        "V": (16, -11, 697, 662),
        "W": (5, -11, 932, 662),
        "X": (10, 0, 704, 662),
        "Y": (22, 0, 703, 662),
        "Z": (9, 0, 597, 662),
        "bracketleft": (88, -156, 299, 662),
        "backslash": (-9, -14, 287, 676),
        "bracketright": (34, -156, 245, 662),
        "asciicircum": (24, 297, 446, 662),
        "underscore": (0, -125, 500, -75),
        "quoteleft": (115, 433, 254, 676),
        "a": (37, -10, 442, 460),
        "b": (3, -10, 468, 683),
        "c": (25, -10, 412, 460),
        "d": (27, -10, 491, 683),
        "e": (25, -10, 424, 460),
        "f": (20, 0, 383, 683),
        "g": (28, -218, 470, 460),
        "h": (9, 0, 487, 683),
        "i": (16, 0, 253, 683),
        "j": (-70, -218, 194, 683),
        "k": (7, 0, 505, 683),
        "l": (19, 0, 257, 683),
        "m": (16, 0, 775, 460),
        "n": (16, 0, 485, 460),
        "o": (29, -10, 470, 460),
        "p": (5, -217, 470, 460),
        "q": (24, -217, 488, 460),
        "r": (5, 0, 335, 460),
        "s": (51, -10, 348, 460),
        "t": (13, -10, 279, 579),
        "u": (9, -10, 479, 450),
        "v": (19, -14, 477, 450),
        "w": (21, -14, 694, 450),
        "x": (17, 0, 479, 450),
        "y": (14, -218, 475, 450),
        "z": (27, 0, 418, 450),
        "braceleft": (100, -181, 350, 680),
        "bar": (67, -14, 133, 676),
        "braceright": (130, -181, 380, 680),
        "asciitilde": (40, 183, 502, 323),
        "exclamdown": (97, -218, 205, 467),
        "cent": (53, -138, 448, 579),
        "sterling": (12, -8, 490, 676),
        "fraction": (-168, -14, 331, 676),
        "yen": (-53, 0, 512, 662),
        "florin": (7, -189, 490, 676),
        "section": (70, -148, 426, 676),
        "currency": (-22, 58, 522, 602),
        "quotesingle": (48, 431, 133, 676),
        "quotedblleft": (43, 433, 414, 676),
        "guillemotleft": (42, 33, 456, 416),
        "guilsinglleft": (63, 33, 285, 416),
        "guilsinglright": (48, 33, 270, 416),
        "fi": (31, 0, 521, 683),
        "fl": (32, 0, 521, 683),
        "endash": (0, 201, 500, 250),
        "dagger": (59, -149, 442, 676),
        "daggerdbl": (58, -153, 442, 676),
        "periodcentered": (70, 199, 181, 310),
        "paragraph": (-22, -154, 450, 662),
        "bullet": (40, 196, 310, 466),
        "quotesinglbase": (79, -141, 218, 102),
        "quotedblbase": (45, -141, 416, 102),
        "quotedblright": (30, 433, 401, 676),
        "guillemotright": (44, 33, 458, 416),
        "ellipsis": (111, -11, 888, 100),
        "perthousand": (7, -19, 994, 706),
        "questiondown": (30, -218, 376, 466),
        "grave": (19, 507, 242, 678),
        "acute": (93, 507, 317, 678),
        "circumflex": (11, 507, 322, 674),
        "tilde": (1, 532, 331, 638),
        "macron": (11, 547, 322, 601),
        "breve": (26, 507, 307, 664),
        "dotaccent": (118, 523, 216, 623),
        "dieresis": (18, 523, 315, 623),
        "ring": (67, 512, 266, 711),
        "cedilla": (52, -215, 261, 0),
        "hungarumlaut": (-3, 507, 377, 678),
        "ogonek": (64, -165, 249, 0),
        "caron": (11, 507, 322, 674),
        "emdash": (0, 201, 1000, 250),
        "AE": (0, 0, 863, 662),
        "ordfeminine": (4, 394, 270, 676),
        "Lslash": (12, 0, 598, 662),
        "Oslash": (34, -80, 688, 734),
        "OE": (30, -6, 885, 668),
        "ordmasculine": (6, 394, 304, 676),
        "ae": (38, -10, 632, 460),
        "dotlessi": (16, 0, 253, 460),
        "lslash": (19, 0, 259, 683),
        "oslash": (29, -112, 470, 551),
        "oe": (30, -10, 690, 460),
        "germandbls": (12, -9, 468, 683),
        "onesuperior": (57, 270, 248, 676),
        "logicalnot": (30, 108, 534, 386),
        "mu": (36, -218, 512, 450),
        "trademark": (30, 256, 957, 662),
        "Eth": (16, 0, 685, 662),
        "onehalf": (31, -14, 746, 676),
        "plusminus": (30, 0, 534, 506),
        "Thorn": (16, 0, 542, 662),
        "onequarter": (37, -14, 718, 676),
        "divide": (30, -10, 534, 516),
        "brokenbar": (67, -14, 133, 676),
        "degree": (57, 390, 343, 676),
        "thorn": (5, -217, 470, 683),
        "threequarters": (15, -14, 718, 676),
        "twosuperior": (1, 270, 296, 676),
        "registered": (38, -14, 722, 676),
        "minus": (30, 220, 534, 286),
        "eth": (29, -10, 471, 686),
        "multiply": (38, 8, 527, 497),
        "threesuperior": (15, 262, 291, 676),
        "copyright": (38, -14, 722, 676),
        "space": (0, 0, 0, 0),
        "Aacute": (15, 0, 706, 890),
        "Acircumflex": (15, 0, 706, 886),
        "Adieresis": (15, 0, 706, 835),
        "Agrave": (15, 0, 706, 890),
        "Aring": (15, 0, 706, 898),
        "Atilde": (15, 0, 706, 850),
        "Ccedilla": (28, -215, 633, 676),
        "Eacute": (12, 0, 597, 890),
        "Ecircumflex": (12, 0, 597, 886),
        "Edieresis": (12, 0, 597, 835),
        "Egrave": (12, 0, 597, 890),
        "Iacute": (18, 0, 317, 890),
        "Icircumflex": (11, 0, 322, 886),
        "Idieresis": (18, 0, 315, 835),
        "Igrave": (18, 0, 315, 890),
        "Ntilde": (12, -11, 707, 850),
        "Oacute": (34, -14, 688, 890),
        "Ocircumflex": (34, -14, 688, 886),
        "Odieresis": (34, -14, 688, 835),
        "Ograve": (34, -14, 688, 890),
        "Otilde": (34, -14, 688, 850),
        "Scaron": (42, -14, 491, 886),
        "Uacute": (14, -14, 705, 890),
        "Ucircumflex": (14, -14, 705, 886),
        "Udieresis": (14, -14, 705, 835),
        "Ugrave": (14, -14, 705, 890),
        "Yacute": (22, 0, 703, 890),
        "Ydieresis": (22, 0, 703, 835),
        "Zcaron": (9, 0, 597, 886),
        "aacute": (37, -10, 442, 678),
        "acircumflex": (37, -10, 442, 674),
        "adieresis": (37, -10, 442, 623),
        "agrave": (37, -10, 442, 678),
        "aring": (37, -10, 442, 711),
        "atilde": (37, -10, 442, 638),
        "ccedilla": (25, -215, 412, 460),
        "eacute": (25, -10, 424, 678),
        "ecircumflex": (25, -10, 424, 674),
        "edieresis": (25, -10, 424, 623),
        "egrave": (25, -10, 424, 678),
        "iacute": (16, 0, 290, 678),
        "icircumflex": (-16, 0, 295, 674),
        "idieresis": (-9, 0, 288, 623),
        "igrave": (-8, 0, 253, 678),
        "ntilde": (16, 0, 485, 638),
        "oacute": (29, -10, 470, 678),
        "ocircumflex": (29, -10, 470, 674),
        "odieresis": (29, -10, 470, 623),
        "ograve": (29, -10, 470, 678),
        "otilde": (29, -10, 470, 638),
        "scaron": (39, -10, 350, 674),
        "uacute": (9, -10, 479, 678),
        "ucircumflex": (9, -10, 479, 674),
        "udieresis": (9, -10, 479, 623),
        "ugrave": (9, -10, 479, 678),
        "yacute": (14, -218, 475, 678),
        "ydieresis": (14, -218, 475, 623),
        "zcaron": (27, 0, 418, 674),
    },
    "ZapfDingbats": {
        ".notdef": (0, 0, 0, 0),
        "a1": (35, 72, 939, 621),
        "a2": (35, 81, 927, 611),
        "a202": (35, 72, 939, 621),
        "a3": (35, 0, 945, 692),
        "a4": (34, 139, 685, 566),
        "a5": (35, -14, 755, 705),
        "a119": (35, -14, 755, 705),
        "a118": (35, -13, 761, 705),
        "a117": (35, 138, 655, 553),
        "a11": (35, 123, 925, 568),
        "a12": (35, 134, 904, 559),
        "a13": (29, -11, 516, 705),
        "a14": (34, 59, 820, 632),
        "a15": (35, 50, 876, 642),
        "a16": (35, 139, 899, 550),
        "a105": (35, 50, 876, 642),
        "a17": (35, 139, 909, 553),
        "a18": (35, 104, 938, 587),
        "a19": (34, -13, 721, 705),
        "a20": (36, -14, 811, 705),
        "a21": (35, 0, 727, 692),
        "a22": (35, 0, 727, 692),
        "a23": (-1, -68, 571, 661),
        "a24": (36, -13, 642, 705),
        "a25": (35, 0, 728, 692),
        "a26": (35, 0, 726, 692),
        "a27": (35, 0, 725, 692),
        "a28": (35, 0, 720, 692),
        "a6": (35, 0, 460, 692),
        "a7": (35, 0, 517, 692),
        "a8": (35, 0, 503, 692),
        "a9": (35, 96, 542, 596),
        "a10": (35, -14, 657, 705),
        "a29": (35, -14, 751, 705),
        "a30": (35, -14, 752, 705),
        "a31": (35, -14, 753, 705),
        "a32": (35, -14, 756, 705),
        "a33": (35, -13, 759, 705),
        "a34": (35, -13, 759, 705),
        "a35": (35, -14, 782, 705),
        "a36": (35, -14, 787, 705),
        "a37": (35, -14, 754, 705),
        "a38": (35, -14, 807, 705),
        "a39": (35, -14, 789, 705),
        "a40": (35, -14, 798, 705),
        "a41": (35, -13, 782, 705),
        "a42": (35, -14, 796, 705),
        "a43": (35, -14, 888, 705),
        "a44": (35, 0, 710, 692),
        "a45": (35, 0, 688, 692),
        "a46": (35, 0, 714, 692),
        "a47": (34, -14, 756, 705),
        "a48": (35, -14, 758, 705),
        "a49": (35, -14, 661, 706),
        "a50": (35, -6, 741, 699),
        "a51": (35, -7, 734, 699),
        "a52": (35, -14, 757, 705),
        "a53": (35, 0, 725, 692),
        "a54": (35, -13, 672, 704),
        "a55": (35, -14, 672, 705),
        "a56": (35, -14, 647, 705),
        "a57": (35, -14, 666, 705),
        "a58": (35, -14, 791, 705),
        "a59": (35, -14, 780, 705),
        "a60": (35, -14, 754, 705),
        "a61": (35, -14, 754, 705),
        "a62": (34, -14, 673, 705),
        "a63": (36, 0, 651, 692),
        "a64": (35, 1, 661, 690),
        "a65": (35, 0, 655, 692),
        "a66": (34, -14, 751, 705),
        "a67": (35, -14, 752, 705),
        "a68": (35, -14, 678, 705),
        "a69": (35, -14, 756, 705),
        "a70": (36, -14, 751, 705),
        "a71": (35, -14, 757, 705),
        "a72": (35, -14, 838, 705),
        "a73": (35, 0, 726, 692),
        "a74": (35, 0, 727, 692),
        "a203": (35, 0, 727, 692),
        "a75": (35, 0, 725, 692),
        "a204": (35, 0, 725, 692),
        "a76": (35, 0, 858, 705),
        "a77": (35, -14, 858, 692),
        "a78": (35, -14, 754, 705),
        "a79": (35, -14, 749, 705),
        "a81": (35, -14, 403, 705),
        "a82": (35, 0, 104, 692),
        "a83": (35, 0, 242, 692),
        "a84": (35, 0, 380, 692),
        "a97": (35, 263, 357, 705),
        "a98": (34, 263, 357, 705),
        "a99": (35, 263, 633, 705),
        "a100": (36, 263, 634, 705),
        "a101": (35, -143, 697, 806),
        "a102": (56, -14, 488, 706),
        "a103": (34, -14, 508, 705),
        "a104": (35, 40, 875, 651),
        "a106": (35, -14, 633, 705),
        "a107": (35, -14, 726, 705),
        "a108": (0, 121, 758, 569),
        "a112": (35, 0, 741, 705),
        "a111": (34, -14, 560, 705),
        "a110": (35, -14, 659, 705),
        "a109": (34, 0, 591, 705),
        "a120": (35, -14, 754, 705),
        "a121": (35, -14, 754, 705),
        "a122": (35, -14, 754, 705),
        "a123": (35, -14, 754, 705),
        "a124": (35, -14, 754, 705),
        "a125": (35, -14, 754, 705),
        "a126": (35, -14, 754, 705),
        "a127": (35, -14, 754, 705),
        "a128": (35, -14, 754, 705),
        "a129": (35, -14, 754, 705),
        "a130": (35, -14, 754, 705),
        "a131": (35, -14, 754, 705),
        "a132": (35, -14, 754, 705),
        "a133": (35, -14, 754, 705),
        "a134": (35, -14, 754, 705),
        "a135": (35, -14, 754, 705),
        "a136": (35, -14, 754, 705),
        "a137": (35, -14, 754, 705),
        "a138": (35, -14, 754, 705),
        "a139": (35, -14, 754, 705),
        "a140": (35, -14, 754, 705),
        "a141": (35, -14, 754, 705),
        "a142": (35, -14, 754, 705),
        "a143": (35, -14, 754, 705),
        "a144": (35, -14, 754, 705),
        "a145": (35, -14, 754, 705),
        "a146": (35, -14, 754, 705),
        "a147": (35, -14, 754, 705),
        "a148": (35, -14, 754, 705),
        "a149": (35, -14, 754, 705),
        "a150": (35, -14, 754, 705),
        "a151": (35, -14, 754, 705),
        "a152": (35, -14, 754, 705),
        "a153": (35, -14, 754, 705),
        "a154": (35, -14, 754, 705),
        "a155": (35, -14, 754, 705),
        "a156": (35, -14, 754, 705),
        "a157": (35, -14, 754, 705),
        "a158": (35, -14, 754, 705),
        "a159": (35, -14, 754, 705),
        "a160": (35, 58, 860, 634),
        "a161": (35, 152, 803, 540),
        "a163": (34, 152, 981, 540),
        "a164": (35, -127, 422, 820),
        "a196": (35, 94, 698, 597),
        "a165": (35, 140, 890, 552),
        "a192": (35, 94, 698, 597),
        "a166": (35, 166, 884, 526),
        "a167": (35, 32, 892, 660),
        "a168": (35, 129, 891, 562),
        "a169": (35, 128, 893, 563),
        "a170": (35, 155, 799, 537),
        "a171": (35, 93, 838, 599),
        "a172": (35, 104, 791, 588),
        "a173": (35, 98, 889, 594),
        "a162": (35, 98, 889, 594),
        "a174": (35, 0, 882, 692),
        "a175": (35, 84, 896, 608),
        "a176": (35, 84, 896, 608),
        "a177": (35, -99, 429, 791),
        "a178": (35, 71, 848, 623),
        "a179": (35, 44, 802, 648),
        "a193": (35, 44, 802, 648),
        "a180": (35, 101, 832, 591),
        "a199": (35, 101, 832, 591),
        "a181": (35, 44, 661, 648),
        "a200": (35, 44, 661, 648),
        "a182": (35, 77, 840, 619),
        "a201": (35, 73, 840, 615),
        "a183": (35, 0, 725, 692),
        "a184": (35, 160, 911, 533),
        "a197": (34, 37, 736, 655),
        "a185": (35, 207, 830, 481),
        "a194": (34, 37, 736, 655),
        "a198": (34, -19, 853, 712),
        "a186": (35, 124, 932, 568),
        "a195": (34, -19, 853, 712),
        "a187": (35, 113, 796, 579),
        "a188": (36, 118, 838, 578),
        "a189": (35, 150, 891, 542),
        "a190": (35, 76, 931, 616),
        "a191": (34, 99, 884, 593),
        "a86": (35, 0, 375, 692),
        "a85": (35, 0, 475, 692),
        "a95": (35, 0, 299, 692),
        "a205": (35, 0, 475, 692),
        "a89": (35, -14, 356, 705),
        "a87": (35, -14, 199, 705),
        "a91": (35, 0, 242, 692),
        "a90": (35, -14, 355, 705),
        "a206": (35, 0, 375, 692),
        "a94": (35, 0, 283, 692),
        "a93": (35, 0, 283, 692),
        "a92": (35, 0, 242, 692),
        "a96": (35, 0, 299, 692),
        "a88": (35, -14, 199, 705),
        "space": (0, 0, 0, 0),
    },
}

base14_alias = {
    "Times New Roman": "Times-Roman",
    "Times New Roman,Bold": "Times-Bold",
    "Times New Roman,Italic": "Times-Italic",
}


def get_cached_bbox(database, family, encoding):
    bbox = [(0, 0, 0, 0)] * 256
    base_font = database[family]
    for index, name in enumerate(encoding):
        if name:
            if cur_bbox := base_font.get(name, None):
                bbox[index] = cur_bbox
    return bbox


def get_base14_bbox(family, encoding_name="WinAnsiEncoding"):
    bbox = [(0, 0, 0, 0)] * 256
    encoding = get_type1_encoding(encoding_name)
    if not encoding:
        return [(0, 0, 0, 0)] * 256

    if family in base14_alias:
        family = base14_alias[family]

    if family in base14_bbox:
        bbox = get_cached_bbox(base14_bbox, family, encoding)

    if family in win_core:
        bbox = get_cached_bbox(win_core, family, encoding)

    return bbox
