import { aws_events as events } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface OnDeployProps {
    /**
     * The number of minutes to add to the current time when generating the expression.
     * Should exceed the expected time for the appropriate resources to converge.
     *
     *
     * @default 10
     */
    readonly offsetMinutes?: number;
}
export interface AtProps {
    /**
     * The future date to use for one time event.
     */
    readonly date: Date;
}
export declare function dateToCron(date: Date): string;
export declare class OnDeploy extends Construct {
    readonly schedule: events.Schedule;
    constructor(scope: Construct, id: string, props: OnDeployProps);
}
export declare class At extends Construct {
    readonly schedule: events.Schedule;
    constructor(scope: Construct, id: string, props: AtProps);
}
//# sourceMappingURL=index.d.ts.map