"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.At = exports.OnDeploy = exports.dateToCron = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function dateToCron(date) {
    const minutes = date.getUTCMinutes();
    const hours = date.getUTCHours();
    const days = date.getUTCDay();
    const months = date.getUTCMonth() + 1;
    const years = date.getUTCFullYear();
    return `${minutes} ${hours} ${days} ${months} ? ${years}`;
}
exports.dateToCron = dateToCron;
;
class OnDeploy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const date = new Date();
        const minutesToAdd = props.offsetMinutes || 10;
        const future = new Date(date.getTime() + minutesToAdd * 60000);
        this.schedule = aws_cdk_lib_1.aws_events.Schedule.expression('cron(' + dateToCron(future) + ')');
    }
}
exports.OnDeploy = OnDeploy;
_a = JSII_RTTI_SYMBOL_1;
OnDeploy[_a] = { fqn: "@renovosolutions/cdk-library-one-time-event.OnDeploy", version: "2.0.139" };
class At extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.schedule = aws_cdk_lib_1.aws_events.Schedule.expression('cron(' + dateToCron(props.date) + ')');
    }
}
exports.At = At;
_b = JSII_RTTI_SYMBOL_1;
At[_b] = { fqn: "@renovosolutions/cdk-library-one-time-event.At", version: "2.0.139" };
//# sourceMappingURL=data:application/json;base64,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