# pyarabify

<div dir="rtl">

## مكتبة قوية لتحويل Python كاملة للعربية

![Version](https://img.shields.io/badge/version-2.0.0-blue.svg)
![Python](https://img.shields.io/badge/python-2.7%2B%20%7C%203.x-green.svg)
![License](https://img.shields.io/badge/license-MIT-orange.svg)

### المطور: MERO
- **Telegram**: [@QP4RM](https://t.me/QP4RM)
- **GitHub**: [6x-u](https://github.com/6x-u)

---

## المحتويات

1. [نظرة عامة](#نظرة-عامة)
2. [المميزات](#المميزات)
3. [التثبيت](#التثبيت)
4. [البدء السريع](#البدء-السريع)
5. [الاستخدام التفصيلي](#الاستخدام-التفصيلي)
6. [اللهجات المدعومة](#اللهجات-المدعومة)
7. [معالجة الأخطاء](#معالجة-الأخطاء)
8. [الأمثلة](#الأمثلة)
9. [API المرجعي](#api-المرجعي)
10. [المساهمة](#المساهمة)

---

## نظرة عامة

**pyarabify** هي مكتبة Python ثورية وقوية تتيح لك كتابة وتنفيذ أكواد Python بالكامل باللغة العربية. تدعم المكتبة جميع إصدارات Python من 2.7 وحتى أحدث إصدار، وتوفر ترجمة شاملة لجميع الكلمات المحجوزة، الدوال المدمجة، أنواع الأخطاء، والوحدات الشائعة.

### لماذا pyarabify؟

- **تعليم البرمجة بالعربية**: مثالية للمبتدئين الذين يفضلون التعلم بلغتهم الأم
- **قاموس شامل**: أكثر من 12,000+ كلمة مترجمة تغطي كامل لغة Python
- **دعم اللهجات**: أربع لهجات عربية مختلفة (فصحى، مختصر، مصري، خليجي)
- **قابلة للتوسع**: أضف كلماتك المخصصة بسهولة
- **أخطاء بالعربية**: رسائل خطأ مفهومة ومترجمة بالكامل
- **ترجمة عكسية**: حول أكوادك العربية لإنجليزية والعكس
- **متوافقة 100%**: تعمل مع جميع مكتبات Python القياسية
- **دعم Git**: 57 دالة لإدارة المستودعات بالعربية
- **دعم الويب**: افتح الروابط، احصل على المحتوى، حمل الملفات

---

## المميزات

### ترجمة كاملة للكلمات المحجوزة

```python
import → استرداد
from → من
def → دالة
class → صنف
if → اذا
for → لكل
while → طالما
try → حاول
except → ماعدا
return → ارجع
```

### دعم جميع الدوال المدمجة

```python
print() → اطبع()
input() → ادخال()
len() → طول()
range() → نطاق()
open() → افتح()
sum() → مجموع()
max() → اكبر()
min() → اصغر()
```

### ترجمة الأخطاء والاستثناءات

```python
ValueError → خطأ_قيمة
TypeError → خطأ_نوع
SyntaxError → خطأ_صيغة
NameError → خطأ_اسم
IndexError → خطأ_فهرس
KeyError → خطأ_مفتاح
```

### أربع لهجات مختلفة

1. **الفصحى** (formal): اللغة العربية الفصيحة
2. **مختصر** (short): كلمات مختصرة للكتابة السريعة
3. **مصري** (egyptian): اللهجة المصرية
4. **خليجي** (gulf): اللهجة الخليجية

---

## التثبيت

### من PyPI

```bash
pip install pyarabify
```

### من المصدر

```bash
git clone https://github.com/6x-u/pyarabify.git
cd pyarabify
pip install -e .
```

### التحقق من التثبيت

```bash
pyarabify --help
```

---

## البدء السريع

### 1. أول برنامج لك بالعربية

```python
from pyarabify import execute

code = '''
اطبع("اهلين دوددد")
'''

execute(code)
```

**النتيجة:**
```
اهلين دوددد
```

### 2. استخدام المتغيرات والعمليات

```python
from pyarabify import execute

code = '''
العدد_الأول = 10
العدد_الثاني = 20
المجموع = العدد_الأول + العدد_الثاني
اطبع("المجموع =", المجموع)
'''

execute(code)
```

**النتيجة:**
```
المجموع = 30
```

### 3. تنفيذ ملف

أنشئ ملف `test.py`:
```python
اطبع("مرحباً من الملف!")

دالة جمع(أ, ب):
    ارجع أ + ب

النتيجة = جمع(5, 3)
اطبع("5 + 3 =", النتيجة)
```

نفذ الملف:
```python
from pyarabify import execute_file

execute_file('test.py')
```

---

## الاستخدام التفصيلي

### استخدام الدوال

```python
from pyarabify import execute

code = '''
دالة حساب_المساحة(الطول, العرض):
    المساحة = الطول * العرض
    ارجع المساحة

دالة طباعة_معلومات(الاسم, العمر):
    اطبع("الاسم:", الاسم)
    اطبع("العمر:", العمر)

مساحة_المستطيل = حساب_المساحة(10, 5)
اطبع("المساحة =", مساحة_المستطيل)

طباعة_معلومات("أحمد", 25)
'''

execute(code)
```

### استخدام الأصناف (Classes)

```python
from pyarabify import execute

code = '''
صنف طالب:
    دالة __init__(الذات, الاسم, الدرجة):
        الذات.الاسم = الاسم
        الذات.الدرجة = الدرجة
    
    دالة عرض_المعلومات(الذات):
        اطبع("الطالب:", الذات.الاسم)
        اطبع("الدرجة:", الذات.الدرجة)
    
    دالة نجح(الذات):
        اذا الذات.الدرجة >= 50:
            ارجع صحيح
        والا:
            ارجع خطأ

طالب1 = طالب("محمد", 85)

طالب1.عرض_المعلومات()
اذا طالب1.نجح():
    اطبع("ناجح!")
'''

execute(code)
```

### دعم Git بالعربية

```python
from pyarabify import git

git.احصل_على_الحالة()
git.اضف_للتتبع(".")
git.احفظ_التغييرات("تحديث المشروع")
git.ادفع_إلى_المستودع()
```

### فتح الروابط والتحميل

```python
from pyarabify import web

web.افتح_رابط("https://github.com")

المحتوى = web.الحصول("https://api.github.com")
اطبع(المحتوى)

web.تحميل("https://example.com/file.pdf", "ملف.pdf")
```

---

## اللهجات المدعومة

### 1. الفصحى (formal)

```python
from pyarabify import execute

code = '''
دالة اهلا():
    اطبع("مرحباً بالعربية الفصحى")

اهلا()
'''

execute(code, dialect='formal')
```

### 2. المختصر (short)

```python
from pyarabify import execute

code = '''
دل اهلا():
    قول("مرحباً بالاختصارات")

اهلا()
'''

execute(code, dialect='short')
```

### 3. المصري (egyptian)

```python
from pyarabify import execute

code = '''
وظيفة اهلا():
    اطبع("أهلاً باللهجة المصرية")

اهلا()
'''

execute(code, dialect='egyptian')
```

### 4. الخليجي (gulf)

```python
from pyarabify import execute

code = '''
دالة اهلا():
    اطبع("هلا باللهجة الخليجية")

اهلا()
'''

execute(code, dialect='gulf')
```

---

## معالجة الأخطاء

### أخطاء بالعربية

```python
from pyarabify import execute

code = '''
حاول:
    النتيجة = 10 / 0
ماعدا خطأ_صفر:
    اطبع("خطأ: لا يمكن القسمة على صفر!")
'''

execute(code)
```

### معالجة أنواع مختلفة من الأخطاء

```python
from pyarabify import execute

code = '''
حاول:
    القائمة = [1, 2, 3]
    اطبع(القائمة[10])
ماعدا خطأ_فهرس:
    اطبع("الفهرس خارج النطاق")

حاول:
    الرقم = عدد_صحيح("نص")
ماعدا خطأ_قيمة:
    اطبع("القيمة غير صالحة للتحويل")
'''

execute(code)
```

---

## الأمثلة

### مثال 1: حاسبة متقدمة

```python
from pyarabify import execute

code = '''
صنف حاسبة:
    دالة جمع(الذات, أ, ب):
        ارجع أ + ب
    
    دالة طرح(الذات, أ, ب):
        ارجع أ - ب
    
    دالة ضرب(الذات, أ, ب):
        ارجع أ * ب
    
    دالة قسمة(الذات, أ, ب):
        حاول:
            ارجع أ / ب
        ماعدا خطأ_صفر:
            ارجع "خطأ: قسمة على صفر"

الآلة = حاسبة()
اطبع("10 + 5 =", الآلة.جمع(10, 5))
اطبع("10 - 5 =", الآلة.طرح(10, 5))
'''

execute(code)
```

### مثال 2: إدارة قائمة مهام

```python
from pyarabify import execute

code = '''
صنف قائمة_المهام:
    دالة __init__(الذات):
        الذات.المهام = []
    
    دالة اضف_مهمة(الذات, المهمة):
        الذات.المهام.append(المهمة)
        اطبع("تمت إضافة:", المهمة)
    
    دالة عرض_المهام(الذات):
        اذا طول(الذات.المهام) == 0:
            اطبع("لا توجد مهام")
        والا:
            اطبع("قائمة المهام:")
            لكل عدد في نطاق(طول(الذات.المهام)):
                اطبع(عدد + 1, "-", الذات.المهام[عدد])

المهام = قائمة_المهام()
المهام.اضف_مهمة("دراسة البرمجة")
المهام.اضف_مهمة("قراءة كتاب")
المهام.عرض_المهام()
'''

execute(code)
```

### مثال 3: استخدام المكتبات

```python
from pyarabify import execute

code = '''
استرداد رياضيات كـ ر
استرداد عشوائي كـ ع

دالة حساب_الدائرة(نصف_القطر):
    المساحة = ر.pi * ر.pow(نصف_القطر, 2)
    المحيط = 2 * ر.pi * نصف_القطر
    ارجع المساحة, المحيط

مساحة, محيط = حساب_الدائرة(5)
اطبع("مساحة الدائرة:", مساحة)
اطبع("محيط الدائرة:", محيط)

رقم_عشوائي = ع.randint(1, 100)
اطبع("رقم عشوائي:", رقم_عشوائي)
'''

execute(code)
```

---

## API المرجعي

### execute

تنفيذ كود Python مكتوب بالعربية.

```python
from pyarabify import execute

result = execute(
    code='اطبع("اهلين دوددد")',
    dialect='formal',
    show_english=False,
    globals_dict=None,
    locals_dict=None
)
```

**المعاملات:**
- `code` (str): الكود العربي المراد تنفيذه
- `dialect` (str): اللهجة المستخدمة (formal/short/egyptian/gulf)
- `show_english` (bool): عرض الكود المترجم للإنجليزية
- `globals_dict` (dict): المتغيرات العامة
- `locals_dict` (dict): المتغيرات المحلية

**القيمة المرجعة:**
- dict: {'status': 'success/error', 'english_code': '...'}

---

### execute_file

تنفيذ ملف Python مكتوب بالعربية.

```python
from pyarabify import execute_file

execute_file('program.py', dialect='formal', show_english=False)
```

**المعاملات:**
- `filepath` (str): مسار الملف
- `dialect` (str): اللهجة المستخدمة
- `show_english` (bool): عرض الكود المترجم

---

### to_english

تحويل كود عربي إلى إنجليزي.

```python
from pyarabify import to_english

arabic = 'اطبع("اهلين دوددد")'
english = to_english(arabic)
print(english)
```

**المعاملات:**
- `arabic_code` (str): الكود العربي
- `dialect` (str): اللهجة

**القيمة المرجعة:**
- str: الكود بالإنجليزية

---

### to_arabic

تحويل كود إنجليزي إلى عربي.

```python
from pyarabify import to_arabic

english = 'print("Hello")'
arabic = to_arabic(english)
print(arabic)
```

**المعاملات:**
- `english_code` (str): الكود الإنجليزي
- `dialect` (str): اللهجة

**القيمة المرجعة:**
- str: الكود بالعربية

---

### ArabicParser

فئة المحلل اللغوي الرئيسية.

```python
from pyarabify import ArabicParser

parser = ArabicParser(dialect='formal')
parser.add_custom_word('اعرض', 'display')
code = parser.to_english('اعرض("اهلين دوددد")')
```

**الدوال:**
- `parse(code)`: تحليل وترجمة الكود
- `add_custom_word(arabic, english, category)`: إضافة كلمة مخصصة
- `set_dialect(dialect)`: تغيير اللهجة
- `get_available_dialects()`: الحصول على اللهجات المتاحة

---

### git

دوال إدارة Git بالعربية.

```python
from pyarabify import git

git.احصل_على_الحالة()
git.اضف_للتتبع(".")
git.احفظ_التغييرات("رسالة الحفظ")
git.ادفع_إلى_المستودع()
git.اسحب_التحديثات()
git.استنسخ_مستودع("https://github.com/user/repo.git")
```

**الدوال المتاحة (57 دالة):**
- `احصل_على_الحالة()`: git status
- `اضف_للتتبع(ملفات)`: git add
- `احفظ_التغييرات(رسالة)`: git commit
- `ادفع_إلى_المستودع()`: git push
- `اسحب_التحديثات()`: git pull
- `استنسخ_مستودع(رابط)`: git clone
- `انشئ_فرع(اسم)`: git branch
- `بدل_الفرع(اسم)`: git checkout
- `ادمج_الفرع(اسم)`: git merge
- وأكثر من 45 دالة أخرى

---

### web

دوال التعامل مع الويب والروابط.

```python
from pyarabify import web

web.افتح_رابط("https://github.com")

المحتوى = web.الحصول("https://api.github.com/users/6x-u")
print(المحتوى)

web.تحميل("https://example.com/file.pdf", "ملف.pdf")
```

**الدوال المتاحة:**
- `افتح_رابط(url)`: فتح رابط في المتصفح
- `الحصول(url)`: الحصول على محتوى صفحة
- `تحميل(url, filename)`: تحميل ملف من رابط
- `افتح_في_تبويب_جديد(url)`: فتح في تبويب جديد
- `افتح_في_نافذة_جديدة(url)`: فتح في نافذة جديدة

---

## إضافة كلمات مخصصة

```python
from pyarabify import ArabicParser

parser = ArabicParser()

parser.add_custom_word('اعرض', 'show', category='builtins')
parser.add_custom_word('سجل', 'log', category='builtins')

code = '''
دالة اعرض(رسالة):
    اطبع("عرض:", رسالة)

اعرض("مرحباً بالكلمات المخصصة")
'''

from pyarabify import execute
execute(code)
```

---

## الوضع التفاعلي (REPL)

```bash
pyarabify
```

أو من Python:

```python
from pyarabify.src.exe import run_repl

run_repl(dialect='formal')
```

**مثال على الاستخدام:**
```
>>> اطبع("اهلين دوددد")
اهلين دوددد
>>> س = 10
>>> ص = 20
>>> اطبع(س + ص)
30
>>> خروج()
وداعاً!
```

---

## القاموس الكامل

### إحصائيات القاموس

- **إجمالي الكلمات**: 12,238+
- **الكلمات المحجوزة**: 60+
- **الدوال المدمجة**: 100+
- **دوال القوائم والنصوص**: 50+
- **الاستثناءات**: 30+
- **المكتبات**: 25+
- **دوال Git**: 57
- **دوال الويب**: 15+

---

## المتطلبات

- Python 2.7 أو أعلى
- Python 3.x (جميع الإصدارات)

لا توجد متطلبات خارجية!

---

## الأسئلة الشائعة

### هل يمكنني مزج الكود العربي والإنجليزي؟

نعم، يمكنك استخدام الكود الإنجليزي الأصلي مع الكود العربي.

### هل تعمل المكتبة مع Python 2؟

نعم، المكتبة متوافقة مع Python 2.7 وجميع إصدارات Python 3.

### كيف أضيف كلمات جديدة؟

```python
from pyarabify import ArabicParser

parser = ArabicParser()
parser.add_custom_word('كلمتك_العربية', 'english_word')
```

---

## الترخيص

MIT License - انظر ملف [LICENSE](LICENSE) للتفاصيل.

---

## المساهمة

نرحب بمساهماتك!

1. Fork المشروع
2. أنشئ branch جديد
3. Commit تغييراتك
4. Push للـ branch
5. افتح Pull Request

---

## الدعم

- **المشاكل التقنية**: [GitHub Issues](https://github.com/6x-u/pyarabify/issues)
- **التواصل**: [@QP4RM](https://t.me/QP4RM) على Telegram
- **التوثيق**: [GitHub Repository](https://github.com/6x-u/pyarabify)

---

## الشكر والتقدير

شكراً لاستخدامك pyarabify! نأمل أن تساعد هذه المكتبة في نشر البرمجة بالعربية.

إذا أعجبتك المكتبة، لا تنسى إعطائها نجمة على GitHub!

---

**تم التطوير بواسطة MERO**

Telegram: [@QP4RM](https://t.me/QP4RM)  
GitHub: [6x-u](https://github.com/6x-u)

</div>
