"""
open_deep_research_agent

Research manager agent that decomposes the user task, delegates focused subtasks to domain sub‑ag...
"""

from typing import Any, Optional, Callable
from ._shared_client import get_shared_client


def open_deep_research_agent(
    task: str,
    *,
    stream_callback: Optional[Callable[[str], None]] = None,
    use_cache: bool = False,
    validate: bool = True,
) -> Any:
    """
    Research manager agent that decomposes the user task, delegates focused subtasks to domain sub‑ag...

    Parameters
    ----------
    task : str
        Research query/task to execute
    stream_callback : Callable, optional
        Callback for streaming output
    use_cache : bool, default False
        Enable caching
    validate : bool, default True
        Validate parameters

    Returns
    -------
    Any
    """
    # Handle mutable defaults to avoid B006 linting error

    return get_shared_client().run_one_function(
        {"name": "open_deep_research_agent", "arguments": {"task": task}},
        stream_callback=stream_callback,
        use_cache=use_cache,
        validate=validate,
    )


__all__ = ["open_deep_research_agent"]
